/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.beans.Transient;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWCheckboxPeer
extends LWComponentPeer<Checkbox, CheckboxDelegate>
implements CheckboxPeer,
ItemListener {
    LWCheckboxPeer(Checkbox checkbox, PlatformComponent platformComponent) {
        super(checkbox, platformComponent);
    }

    @Override
    CheckboxDelegate createDelegate() {
        return new CheckboxDelegate();
    }

    @Override
    Component getDelegateFocusOwner() {
        return ((CheckboxDelegate)this.getDelegate()).getCurrentButton();
    }

    @Override
    void initializeImpl() {
        super.initializeImpl();
        this.setLabel(((Checkbox)this.getTarget()).getLabel());
        this.setState(((Checkbox)this.getTarget()).getState());
        this.setCheckboxGroup(((Checkbox)this.getTarget()).getCheckboxGroup());
    }

    @Override
    public void itemStateChanged(final ItemEvent itemEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = true;
                CheckboxGroup checkboxGroup = ((Checkbox)LWCheckboxPeer.this.getTarget()).getCheckboxGroup();
                if (checkboxGroup != null) {
                    if (itemEvent.getStateChange() == 1) {
                        if (checkboxGroup.getSelectedCheckbox() != LWCheckboxPeer.this.getTarget()) {
                            checkboxGroup.setSelectedCheckbox((Checkbox)LWCheckboxPeer.this.getTarget());
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                        if (checkboxGroup.getSelectedCheckbox() == LWCheckboxPeer.this.getTarget()) {
                            ((Checkbox)LWCheckboxPeer.this.getTarget()).setState(true);
                        }
                    }
                } else {
                    ((Checkbox)LWCheckboxPeer.this.getTarget()).setState(itemEvent.getStateChange() == 1);
                }
                if (bl) {
                    LWCheckboxPeer.this.postEvent(new ItemEvent((ItemSelectable)LWCheckboxPeer.this.getTarget(), 701, ((Checkbox)LWCheckboxPeer.this.getTarget()).getLabel(), itemEvent.getStateChange()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((CheckboxDelegate)this.getDelegate()).getCurrentButton().removeItemListener(this);
            ((CheckboxDelegate)this.getDelegate()).setRadioButton(checkboxGroup != null);
            ((CheckboxDelegate)this.getDelegate()).getCurrentButton().addItemListener(this);
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabel(String string) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((CheckboxDelegate)this.getDelegate()).setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(boolean bl) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((CheckboxDelegate)this.getDelegate()).setSelected(bl);
        }
        this.repaintPeer();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    final class CheckboxDelegate
    extends JComponent {
        private final JCheckBox cb;
        private final JRadioButton rb;

        CheckboxDelegate() {
            this.cb = new JCheckBox(){

                @Override
                public boolean hasFocus() {
                    return ((Checkbox)LWCheckboxPeer.this.getTarget()).hasFocus();
                }
            };
            this.rb = new JRadioButton(){

                @Override
                public boolean hasFocus() {
                    return ((Checkbox)LWCheckboxPeer.this.getTarget()).hasFocus();
                }
            };
            this.setLayout(null);
            this.setRadioButton(false);
            this.add(this.rb);
            this.add(this.cb);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.rb.setEnabled(bl);
            this.cb.setEnabled(bl);
        }

        @Override
        public void setOpaque(boolean bl) {
            super.setOpaque(bl);
            this.rb.setOpaque(bl);
            this.cb.setOpaque(bl);
        }

        @Override
        @Deprecated
        public void reshape(int n, int n2, int n3, int n4) {
            super.reshape(n, n2, n3, n4);
            this.cb.setBounds(0, 0, n3, n4);
            this.rb.setBounds(0, 0, n3, n4);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getCurrentButton().getPreferredSize();
        }

        @Override
        @Transient
        public Dimension getMinimumSize() {
            return this.getCurrentButton().getMinimumSize();
        }

        void setRadioButton(boolean bl) {
            this.rb.setVisible(bl);
            this.cb.setVisible(!bl);
        }

        @Transient
        JToggleButton getCurrentButton() {
            return this.cb.isVisible() ? this.cb : this.rb;
        }

        void setText(String string) {
            this.cb.setText(string);
            this.rb.setText(string);
        }

        void setSelected(boolean bl) {
            this.cb.setSelected(bl);
            this.rb.setSelected(bl);
        }
    }
}

