/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javafx.print;

/**
 * Class to decribe printing quality setting.
 * @since JavaFX 8.0
 */

public enum PrintQuality {

    /**
     * Specify DRAFT quality printing.
     */
    DRAFT,

    /**
     * Specify LOW quality printing.
     */
    LOW,

    /**
     * Specify NORMAL quality printing.
     * This is typically medium quality and/or the printer default.
     */
    NORMAL,

    /**
     * Specify HIGH quality printing.
     */
    HIGH
}
