/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package javafx.scene.input;

/**
 * The enum that contains the input method text highlights.
 * @since JavaFX 2.0
 */
public enum InputMethodHighlight {
    /**
     * Highlight used for the unselected raw input method text
     */
    UNSELECTED_RAW,

    /**
     * Highlight used for the selected raw input method text
     */
    SELECTED_RAW,

    /**
     * Highlight used for the unselected converted input method text
     */
    UNSELECTED_CONVERTED,

    /**
     * Highlight used for the selected converted input method text
     */
    SELECTED_CONVERTED
}
