/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import java.security.AccessControlContext;
import java.security.AccessController;

public abstract class Task {
    private Object result;
    private Throwable throwable;
    private boolean completed;
    private AccessControlContext securityContext = AccessController.getContext();

    protected Task() {
    }

    public abstract Object run() throws Exception;

    final synchronized Object getResultOrThrow() throws Exception {
        Throwable t = this.getThrowable();
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
        return this.getResult();
    }

    private final synchronized Object getResult() {
        return this.result;
    }

    final synchronized void setResult(Object result) {
        this.result = result;
    }

    final synchronized Throwable getThrowable() {
        return this.throwable;
    }

    final synchronized void setThrowable(Throwable x) {
        this.throwable = x;
    }

    public final synchronized boolean isCompleted() {
        return this.completed;
    }

    final synchronized void setCompleted(boolean value) {
        this.completed = value;
        if (value) {
            this.notifyAll();
        }
    }

    final synchronized AccessControlContext getSecurityContext() {
        return this.securityContext;
    }

    final synchronized void reset() {
        this.setResult(null);
        this.setThrowable(null);
        this.setCompleted(false);
    }
}

