/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf;

import ca.uvic.cs.chisel.cajun.graph.DefaultGraphModel;
import ca.uvic.cs.chisel.cajun.graph.arc.DefaultGraphArc;
import ca.uvic.cs.chisel.cajun.graph.arc.GraphArc;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportsGraphModel
extends DefaultGraphModel {
    private static final String IMPORTS = "imports";
    private static final String ONTOLOGY = "ontology";
    private OWLEditorKit owlEditorKit;

    public ImportsGraphModel(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.loadData(owlEditorKit.getOWLWorkspace().getOWLModelManager().getActiveOntology());
    }

    private void loadData(OWLOntology owlOntology) {
        GraphNode parentNode = this.addNode(this.owlEditorKit.getOWLWorkspace().getOWLModelManager().getRendering((OWLObject)owlOntology));
        for (OWLOntology importedOntology : owlOntology.getDirectImports()) {
            GraphNode childNode = this.addNode(this.owlEditorKit.getOWLWorkspace().getOWLModelManager().getRendering((OWLObject)importedOntology));
            this.addArc(parentNode, childNode);
            this.loadData(importedOntology);
        }
    }

    private GraphNode addNode(String name) {
        Icon icon = this.owlEditorKit.getOWLWorkspace().getOWLIconProvider().getIcon((OWLObject)this.owlEditorKit.getOWLWorkspace().getOWLModelManager().getActiveOntology());
        return this.addNode(name, name, icon, ONTOLOGY);
    }

    public Collection<Object> getNodeTypes() {
        ArrayList<Object> types = new ArrayList<Object>(2);
        types.add(ONTOLOGY);
        return types;
    }

    private GraphArc addArc(GraphNode src, GraphNode dest) {
        String arcId = src.getText() + "->" + dest.getText();
        DefaultGraphArc arc = (DefaultGraphArc)this.addArc(arcId, src, dest, IMPORTS);
        arc.setInverted(false);
        return arc;
    }

    public Collection<Object> getArcTypes() {
        ArrayList<Object> types = new ArrayList<Object>(3);
        types.add(IMPORTS);
        return types;
    }
}

