/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf;

import ca.uvic.cs.chisel.cajun.graph.AbstractGraph;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNodeCollectionEvent;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNodeCollectionListener;
import ca.uvic.cs.chisel.cajun.util.GradientPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.ui.view.cls.AbstractOWLClassViewComponent;
import org.protege.ontograf.actions.ConfigTooltipsAction;
import org.protege.ontograf.actions.ExportAsDotAction;
import org.protege.ontograf.actions.ExportImageAction;
import org.protege.ontograf.actions.OpenGraphAction;
import org.protege.ontograf.actions.PinTooltipsAction;
import org.protege.ontograf.actions.SaveGraphAction;
import org.protege.ontograf.common.GraphController;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class OntoGrafView
extends AbstractOWLClassViewComponent {
    private static final long serialVersionUID = -6969495880634875570L;
    private static final Color BACKGROUND_COLOR = new Color(0, 46, 123);
    private static final String[] MODES = new String[]{"contains", "starts with", "ends with", "exact match", "regexp"};
    private GraphController graphController;
    private JComboBox searchTypeBox;
    private JTextField searchField;
    private JLabel searchResults;
    private boolean cancelSelectionUpdate;

    private JPanel getSearchPanel() {
        GradientPanel searchPanel = new GradientPanel(GradientPanel.BG_START, BACKGROUND_COLOR.darker(), 1);
        JLabel searchLabel = new JLabel("Search:");
        searchLabel.setFont(searchLabel.getFont().deriveFont(1));
        searchLabel.setForeground(Color.white);
        this.searchField = new JTextField();
        this.searchField.setMinimumSize(new Dimension(300, 22));
        this.searchField.setSize(new Dimension(300, 22));
        this.searchField.setPreferredSize(new Dimension(300, 22));
        this.searchField.setFocusable(true);
        this.searchField.requestFocus();
        this.searchTypeBox = new JComboBox<String>(MODES);
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OntoGrafView.this.performSearch();
            }
        });
        searchButton.setMinimumSize(new Dimension(80, 22));
        searchButton.setSize(new Dimension(80, 22));
        searchButton.setPreferredSize(new Dimension(80, 22));
        this.searchField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OntoGrafView.this.performSearch();
                }
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OntoGrafView.this.graphController.clear();
                OntoGrafView.this.searchResults.setText("");
            }
        });
        clearButton.setMinimumSize(new Dimension(80, 22));
        clearButton.setSize(new Dimension(80, 22));
        clearButton.setPreferredSize(new Dimension(80, 22));
        this.searchResults = new JLabel();
        this.searchResults.setFont(this.searchResults.getFont().deriveFont(1));
        this.searchResults.setForeground(Color.white);
        this.searchResults.setOpaque(false);
        searchPanel.add(searchLabel);
        searchPanel.add(this.searchField);
        searchPanel.add(this.searchTypeBox);
        searchPanel.add(searchButton);
        searchPanel.add(clearButton);
        searchPanel.add(this.searchResults);
        return searchPanel;
    }

    private void performSearch() {
        if (this.searchField.getText().length() > 0) {
            this.setCursor(new Cursor(3));
            int numOfResults = this.graphController.search(this.searchField.getText(), this.getSearchMode());
            this.searchResults.setText(numOfResults + " result(s) found.");
            this.setCursor(new Cursor(0));
            this.syncNodeSelection();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a valid search term", "Invalid search term", 1);
        }
    }

    private void syncNodeSelection() {
        GraphNode node = ((AbstractGraph)this.graphController.getGraph()).getFirstSelectedNode();
        if (node != null) {
            this.cancelSelectionUpdate = true;
            this.setGlobalSelection((OWLEntity)node.getUserObject());
        }
    }

    private String getSearchMode() {
        return MODES[this.searchTypeBox.getSelectedIndex()];
    }

    public void initialiseClassView() throws Exception {
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
            }
        });
        this.graphController = new GraphController((Container)((Object)this), this.getOWLEditorKit());
        this.graphController.getGraph().addNodeSelectionListener(new GraphNodeCollectionListener(){

            public void collectionChanged(GraphNodeCollectionEvent arg0) {
                OntoGrafView.this.syncNodeSelection();
            }
        });
        this.add(this.getSearchPanel(), "North");
        this.initToolbar();
        Dimension d = new Dimension(800, 600);
        this.setPreferredSize(d);
        this.setSize(d);
        this.setLocation(100, 50);
        this.setVisible(true);
    }

    private void initToolbar() {
        JToolBar toolBar = this.graphController.getToolBar();
        JFrame mainWindow = (JFrame)SwingUtilities.windowForComponent((Component)((Object)this));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)new ExportImageAction(mainWindow, this.graphController.getGraph().getCanvas())));
        toolBar.add((Action)((Object)new ConfigTooltipsAction(mainWindow, this.graphController.getGraph().getCanvas())));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)new SaveGraphAction(mainWindow, this.graphController)));
        toolBar.add((Action)((Object)new OpenGraphAction(mainWindow, this.graphController)));
        toolBar.addSeparator();
        toolBar.add((Action)((Object)new ExportAsDotAction(mainWindow, this.graphController)));
        PinTooltipsAction action = new PinTooltipsAction(mainWindow, this.graphController);
        JToggleButton btn = new JToggleButton((Action)((Object)action));
        btn.setText(null);
        btn.setToolTipText((String)action.getValue("Name"));
        toolBar.add(btn);
    }

    protected OWLClass updateView(OWLClass owlClass) {
        if (owlClass != null && !this.cancelSelectionUpdate) {
            this.graphController.showOWLClass(owlClass);
        }
        this.cancelSelectionUpdate = false;
        return null;
    }

    public void disposeView() {
    }
}

