/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.actions;

import ca.uvic.cs.chisel.cajun.actions.CajunAction;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.filechooser.FileFilter;
import org.protege.ontograf.common.util.IconConstants;
import org.protege.ontograf.ui.OntoGrafFileFilter;

public class ExportImageAction
extends CajunAction {
    private static final long serialVersionUID = 7241297162054742885L;
    private static final String ACTION_NAME = "Export Graph as Image";
    private JFileChooser fileChooser;
    private Component parent;
    private PCanvas canvas;
    private boolean jpegAvailable;
    private boolean pngAvailable;
    private boolean gifAvailable;
    private OntoGrafFileFilter pngFileFilter;
    private OntoGrafFileFilter gifFileFilter;
    private OntoGrafFileFilter jpegFileFilter;

    public ExportImageAction(Component parent, PCanvas canvas) {
        super(ACTION_NAME, IconConstants.ICON_EXPORT_IMAGE);
        this.putValue("ShortDescription", ACTION_NAME);
        this.parent = parent;
        this.canvas = canvas;
        this.fileChooser = new JFileChooser();
        String[] formats = ImageIO.getWriterFormatNames();
        String allFormats = "";
        for (int i = 0; i < formats.length; ++i) {
            String format = formats[i];
            if (!this.jpegAvailable && (format.toLowerCase().equals("jpeg") || format.toLowerCase().equals("jpg"))) {
                this.jpegAvailable = true;
                allFormats = allFormats + "JPG ";
                continue;
            }
            if (!this.pngAvailable && format.toLowerCase().equals("png")) {
                this.pngAvailable = true;
                allFormats = allFormats + "PNG ";
                continue;
            }
            if (this.gifAvailable || !format.toLowerCase().equals("gif")) continue;
            this.gifAvailable = true;
            allFormats = allFormats + "GIF";
        }
        this.fileChooser.setDialogTitle("Export to Image File (" + allFormats + ")");
        if (this.pngAvailable) {
            this.pngFileFilter = new OntoGrafFileFilter(new String[]{"png"}, "PNG Images");
            this.fileChooser.addChoosableFileFilter(this.pngFileFilter);
        }
        if (this.gifAvailable) {
            this.gifFileFilter = new OntoGrafFileFilter(new String[]{"gif"}, "GIF Images");
            this.fileChooser.addChoosableFileFilter(this.gifFileFilter);
        }
        if (this.jpegAvailable) {
            this.jpegFileFilter = new OntoGrafFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Images");
            this.fileChooser.addChoosableFileFilter(this.jpegFileFilter);
        }
    }

    public void doAction() {
        int result = this.fileChooser.showSaveDialog(this.parent);
        if (result == 1) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        FileFilter fileFilter = this.fileChooser.getFileFilter();
        String filePath = file.toString();
        String formatName = "";
        if (this.jpegFileFilter != null && this.jpegFileFilter.equals(fileFilter)) {
            formatName = "jpg";
            if (!filePath.toLowerCase().endsWith(".jpg") && !filePath.toLowerCase().endsWith(".jpeg")) {
                filePath = filePath + ".jpg";
                file = new File(filePath);
            }
        }
        if (this.pngFileFilter != null && this.pngFileFilter.equals(fileFilter)) {
            formatName = "png";
            if (!filePath.toLowerCase().endsWith(".png")) {
                filePath = filePath + ".png";
                file = new File(filePath);
            }
        }
        if (this.gifFileFilter != null && this.gifFileFilter.equals(fileFilter)) {
            formatName = "gif";
            if (!filePath.toLowerCase().endsWith(".gif")) {
                filePath = filePath + ".gif";
                file = new File(filePath);
            }
        }
        boolean saveImage = false;
        if (file.exists()) {
            String msg = "The file " + file.toString() + " already exists.\nDo you want to overwrite this existing file?";
            int opt = JOptionPane.showConfirmDialog(this.parent, msg, "Export Warning", 0, 2);
            saveImage = opt == 0;
        } else {
            try {
                file.createNewFile();
                saveImage = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                String msg = "There was a problem creating " + file.toString() + ". The image has not been exported.";
                JOptionPane.showMessageDialog(this.parent, msg, "Export Error", 0);
            }
        }
        if (saveImage) {
            this.exportGraphAsImage(file, formatName);
        }
    }

    private void exportGraphAsImage(File file, String formatName) {
        boolean saved = false;
        saved = this.canvas.getParent() instanceof JViewport ? this.saveViewport(file, formatName, this.canvas, (JViewport)this.canvas.getParent()) : this.paintComponent((JComponent)this.canvas, file, formatName);
        if (saved) {
            JOptionPane.showMessageDialog(this.parent, file.toString() + " has been saved successfully.");
        }
    }

    private boolean saveViewport(File file, String formatName, PCanvas canvas, JViewport viewport) {
        boolean saved = false;
        Dimension fullSize = viewport.getViewSize();
        Point viewPosition = viewport.getViewPosition();
        if (fullSize.width > canvas.getWidth() || fullSize.height > canvas.getHeight()) {
            Object[] options;
            String msg = "Do you want to save the visible region of the canvas " + ExportImageAction.dimToString(canvas.getSize()) + " or the entire canvas " + ExportImageAction.dimToString(fullSize) + "?\n" + "Warning: saving the entire canvas can cause an out of memory error if it is too large.";
            int choice = JOptionPane.showOptionDialog(viewport, msg, "Confirm", 1, 3, null, options = new String[]{" Just The Visible Region ", " The Entire Canvas ", " Cancel "}, options[0]);
            if (choice != 2) {
                if (choice == 0) {
                    saved = this.paintComponent((JComponent)canvas, file, formatName);
                } else if (choice == 1) {
                    viewport.setViewPosition(new Point(0, 0));
                    JPanel fullPanel = new JPanel(new BorderLayout());
                    fullPanel.add((Component)canvas, "Center");
                    Rectangle oldBounds = canvas.getBounds();
                    fullPanel.setBounds(0, 0, fullSize.width, fullSize.height);
                    canvas.setBounds(0, 0, fullSize.width, fullSize.height);
                    saved = this.paintComponent(fullPanel, file, formatName);
                    viewport.setView((Component)canvas);
                    viewport.setViewPosition(viewPosition);
                    canvas.setBounds(oldBounds);
                }
            }
        } else {
            saved = this.paintComponent((JComponent)canvas, file, formatName);
        }
        return saved;
    }

    private boolean paintComponent(JComponent comp, File file, String formatName) {
        try {
            BufferedImage bufferedImage = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
            Graphics g = bufferedImage.getGraphics();
            comp.paint(g);
            ImageIO.write((RenderedImage)bufferedImage, formatName, file);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.parent, "There was a problem saving " + file.toString() + ". The image has not been exported.\nReason: " + t.getMessage(), "Export Error", 0);
            t.printStackTrace();
            return false;
        }
        return true;
    }

    private static String dimToString(Dimension d) {
        return "(" + d.width + "x" + d.height + ")";
    }
}

