/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.actions;

import ca.uvic.cs.chisel.cajun.actions.CajunAction;
import ca.uvic.cs.chisel.cajun.graph.AbstractGraph;
import ca.uvic.cs.chisel.cajun.graph.GraphModelAdapter;
import ca.uvic.cs.chisel.cajun.graph.GraphModelListener;
import ca.uvic.cs.chisel.cajun.graph.node.DefaultGraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.ontograf.common.GraphController;
import org.protege.ontograf.common.util.IconConstants;
import org.protege.ontograf.ui.FrameTooltipNode;
import org.semanticweb.owlapi.model.OWLEntity;

public class PinTooltipsAction
extends CajunAction {
    private static final long serialVersionUID = 7241297162054742885L;
    private static final String ACTION_NAME = "Pin Node Tooltips";
    private GraphController graphController;
    private boolean show = true;
    private Map<PNode, PNode> existingTooltipsMap;
    private Map<PNode, ChangeListener> changeListenerMap;

    public PinTooltipsAction(Component parent, GraphController graphController) {
        super(ACTION_NAME, IconConstants.ICON_PIN_TOOLTIPS);
        this.putValue("ShortDescription", ACTION_NAME);
        this.existingTooltipsMap = new HashMap<PNode, PNode>();
        this.changeListenerMap = new HashMap<PNode, ChangeListener>();
        this.graphController = graphController;
        graphController.getModel().addGraphModelListener((GraphModelListener)new GraphModelAdapter(){

            public void graphNodeAdded(GraphNode arg0) {
                if (!PinTooltipsAction.this.show) {
                    PinTooltipsAction.this.showAllTooltips();
                }
            }
        });
    }

    public void doAction() {
        if (this.show) {
            this.showAllTooltips();
            this.show = false;
        } else {
            this.hideAllTooltips();
            this.show = true;
        }
    }

    private void hideAllTooltips() {
        for (Map.Entry<PNode, PNode> entry : this.existingTooltipsMap.entrySet()) {
            entry.getKey().removeChild(entry.getValue());
            ChangeListener changeListener = this.changeListenerMap.get(entry.getValue());
            ((DefaultGraphNode)entry.getKey()).removeChangeListener(changeListener);
            entry.getKey().repaint();
        }
        this.existingTooltipsMap.clear();
        this.changeListenerMap.clear();
    }

    private void showAllTooltips() {
        for (GraphNode node : this.graphController.getModel().getAllNodes()) {
            if (this.existingTooltipsMap.get((PNode)node) != null) continue;
            FrameTooltipNode toolTip = new FrameTooltipNode(this.graphController.getModel().getOwlModelManager(), (AbstractGraph)this.graphController.getGraph(), (PNode)node, (OWLEntity)node.getUserObject());
            ((PNode)node).addChild((PNode)toolTip);
            this.existingTooltipsMap.put((PNode)node, toolTip);
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PNode targetNode = (PNode)PinTooltipsAction.this.existingTooltipsMap.get((PNode)e.getSource());
                    if (targetNode != null) {
                        FrameTooltipNode toolTip = (FrameTooltipNode)targetNode;
                        toolTip.updateLocation((AbstractGraph)PinTooltipsAction.this.graphController.getGraph(), toolTip.getParent());
                    }
                }
            };
            ((DefaultGraphNode)node).addChangeListener(changeListener);
            this.changeListenerMap.put(toolTip, changeListener);
        }
    }
}

