/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.common;

import ca.uvic.cs.chisel.cajun.actions.CajunAction;
import ca.uvic.cs.chisel.cajun.actions.LayoutAction;
import ca.uvic.cs.chisel.cajun.filter.FilterChangedEvent;
import ca.uvic.cs.chisel.cajun.filter.FilterChangedListener;
import ca.uvic.cs.chisel.cajun.graph.AbstractGraph;
import ca.uvic.cs.chisel.cajun.graph.FlatGraph;
import ca.uvic.cs.chisel.cajun.graph.Graph;
import ca.uvic.cs.chisel.cajun.graph.GraphModel;
import ca.uvic.cs.chisel.cajun.graph.arc.DefaultGraphArcStyle;
import ca.uvic.cs.chisel.cajun.graph.arc.GraphArc;
import ca.uvic.cs.chisel.cajun.graph.arc.GraphArcStyle;
import ca.uvic.cs.chisel.cajun.graph.node.DefaultGraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.DefaultGraphNodeStyle;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNodeStyle;
import ca.uvic.cs.chisel.cajun.graph.ui.DefaultFlatGraphView;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Component;
import java.awt.Container;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalDirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.progress.ProgressEvent;
import org.eclipse.zest.layouts.progress.ProgressListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.ontograf.common.ProtegeGraphModel;
import org.protege.ontograf.common.ProtegeInputEventHandler;
import org.protege.ontograf.common.util.IconConstants;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class GraphController {
    private static final int ANIMATION_DURATION = 700;
    private FlatGraph graph;
    private ProtegeGraphModel model;
    private DefaultFlatGraphView view;
    private Action expandAction;
    private Action collapseAction;
    private Set<Action> expandBasedOnActions;
    public static final String REGEXP = "regexp";
    public static final String EXACT_MATCH = "exact match";
    public static final String ENDS_WITH = "ends with";
    public static final String STARTS_WITH = "starts with";
    public static final String CONTAINS = "contains";
    private OWLEntity owlClass;

    public GraphController(Container parentContainer, OWLEditorKit owlEditorKit) {
        this.model = new ProtegeGraphModel(owlEditorKit);
        this.graph = new FlatGraph((GraphModel)this.model);
        this.graph.setShowNodeTooltips(false);
        DefaultGraphNodeStyle nodeStyle = new DefaultGraphNodeStyle(){

            public Collection<Icon> getOverlayIcons(GraphNode graphNode) {
                if (GraphController.this.model.isExpandable(graphNode) && !GraphController.this.model.isExpanded(graphNode)) {
                    ArrayList<Icon> icons = new ArrayList<Icon>();
                    icons.add(IconConstants.ICON_PLUS);
                    return icons;
                }
                return null;
            }
        };
        nodeStyle.setNodeTypes(this.model.getNodeTypes());
        this.graph.setGraphNodeStyle((GraphNodeStyle)nodeStyle);
        DefaultGraphArcStyle arcStyle = new DefaultGraphArcStyle(){

            public Stroke getStroke(GraphArc arc) {
                if (arc.getType().toString().contains("has subclass") || arc.getType().toString().contains("has individual")) {
                    this.setDashed(false);
                } else {
                    this.setDashed(true);
                    if (arc.getType().toString().contains("Equivalent")) {
                        this.setDashedCapSquare(1);
                        this.setDashWidth(2.0f);
                    } else {
                        this.setDashedCapSquare(2);
                        this.setDashWidth(10.0f);
                    }
                }
                return super.getStroke(arc);
            }
        };
        arcStyle.setArcTypes(this.model.getArcTypes());
        this.graph.setGraphArcStyle((GraphArcStyle)arcStyle);
        this.initialize(parentContainer);
        this.graph.addLayoutListener(new ProgressListener(){

            public void progressEnded(ProgressEvent arg0) {
                DefaultGraphNode node = (DefaultGraphNode)GraphController.this.model.getNode(GraphController.this.owlClass);
                GraphController.this.panTo(node);
            }

            public void progressStarted(ProgressEvent arg0) {
            }

            public void progressUpdated(ProgressEvent arg0) {
            }
        });
        this.graph.getFilterManager().addFilterChangedListener(new FilterChangedListener(){

            public void filtersChanged(FilterChangedEvent fce) {
                GraphController.this.model.resetNodeToArcCount();
            }
        });
    }

    public ProtegeGraphModel getModel() {
        return this.model;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void refresh() {
        this.graph.repaint();
    }

    public void clear() {
        this.graph.clear();
        this.model.clear();
        this.model.restrictToArcType = "";
    }

    public void display(OWLClass cls) {
        this.model.showNeighborhood((OWLEntity)cls, true);
        this.graph.performLayout();
    }

    public void displayAsSingleNode(OWLEntity entity) {
        this.model.show(entity, this.graph.getFilterManager());
        this.graph.performLayout();
    }

    public JToolBar getToolBar() {
        return this.view.getToolBar();
    }

    public int search(String searchString, String searchMode) {
        searchString = this.prepareSearchString(searchString, searchMode);
        for (GraphNode node : this.model.getAllNodes()) {
            node.setSelected(false);
        }
        ArrayList<GraphNode> matchingNodes = new ArrayList<GraphNode>();
        Collection<? extends OWLEntity> searchResults = this.model.search(searchString, this.graph.getFilterManager());
        for (OWLEntity oWLEntity : searchResults) {
            GraphNode node = this.model.getNode(oWLEntity);
            if (node == null) continue;
            matchingNodes.add(this.model.getNode(oWLEntity));
        }
        this.graph.setSelectedNodes(matchingNodes);
        this.graph.setMatchingNodes(matchingNodes);
        this.graph.performLayout();
        return searchResults.size();
    }

    public void showOWLClass(OWLClass owlClass) {
        for (GraphNode node : this.model.getAllNodes()) {
            node.setFixedLocation(true);
        }
        boolean panToNode = true;
        if (this.model.getNode(owlClass) == null) {
            panToNode = false;
        }
        this.model.restrictToArcType = "";
        this.model.show((OWLEntity)owlClass, this.graph.getFilterManager());
        ArrayList<GraphNode> matchingNodes = new ArrayList<GraphNode>();
        matchingNodes.add(this.model.getNode(owlClass));
        this.graph.setMatchingNodes(matchingNodes);
        this.graph.performLayout();
        for (GraphNode node : this.model.getAllNodes()) {
            node.setFixedLocation(false);
        }
        this.owlClass = owlClass;
        if (panToNode) {
            DefaultGraphNode node = (DefaultGraphNode)this.model.getNode(owlClass);
            this.panTo(node);
        }
    }

    private void panTo(DefaultGraphNode node) {
        if (node != null) {
            double x = node.getFullBoundsReference().getX();
            double y = node.getFullBoundsReference().getY();
            double w = node.getFullBoundsReference().getWidth();
            double h = node.getFullBoundsReference().getHeight();
            PBounds bounds = new PBounds(x - w * 0.01, y - h * 0.02, w + w * 0.02, h + h * 0.04);
            if (!this.graph.getCamera().getViewBounds().contains(bounds.getBounds2D())) {
                this.graph.getRoot().getActivityScheduler().addActivity((PActivity)this.graph.getCamera().animateViewToCenterBounds(bounds.getBounds2D(), false, 700L));
            }
        }
    }

    private String prepareSearchString(String searchString, String searchMode) {
        if (searchMode.equals(CONTAINS)) {
            return searchString;
        }
        if (searchMode.equals(STARTS_WITH)) {
            return "^" + searchString;
        }
        if (searchMode.equals(ENDS_WITH)) {
            return searchString + "$";
        }
        if (searchMode.equals(EXACT_MATCH)) {
            return "^" + searchString + "$";
        }
        return searchString;
    }

    private void initialize(Container parentContainer) {
        ArrayList<String> layoutRelTypes = new ArrayList<String>();
        layoutRelTypes.add("has subclass");
        layoutRelTypes.add("has individual");
        for (LayoutAction layoutAction : this.graph.getLayouts()) {
            if (layoutAction.getName().equals("Tree - Horizontal")) {
                layoutAction.setLayout((LayoutAlgorithm)new HorizontalDirectedGraphLayoutAlgorithm());
                this.graph.setLastLayout(layoutAction);
                layoutAction.setLayoutRelTypes(layoutRelTypes);
                continue;
            }
            if (!layoutAction.getName().equals("Tree - Vertical")) continue;
            layoutAction.setLayout((LayoutAlgorithm)new DirectedGraphLayoutAlgorithm());
            layoutAction.setLayoutRelTypes(layoutRelTypes);
        }
        this.view = new DefaultFlatGraphView(this.graph);
        parentContainer.add((Component)this.view, "Center");
        this.initNodeMenu(this.graph.getNodeContextMenu());
        this.graph.addInputEventListener((PInputEventListener)new ProtegeInputEventHandler(this.model, (AbstractGraph)this.graph));
    }

    private void initNodeMenu(JPopupMenu graphMenu) {
        graphMenu.add((Action)new CajunAction("Show neighborhood", "Show neighborhood"){
            private static final long serialVersionUID = 4234994986788687910L;

            public void actionPerformed(ActionEvent e) {
                GraphController.this.owlClass = (OWLEntity)((OWLClass)GraphController.this.graph.getFirstSelectedNode().getUserObject());
                GraphController.this.model.showNeighborhood(GraphController.this.owlClass, true);
                GraphController.this.graph.performLayout();
            }
        });
        graphMenu.add((Action)new CajunAction("Set as focus", "Set as focus"){
            private static final long serialVersionUID = -68720636770886830L;

            public void actionPerformed(ActionEvent e) {
                GraphController.this.owlClass = (OWLEntity)GraphController.this.graph.getFirstSelectedNode().getUserObject();
                GraphController.this.model.hideAscendants(GraphController.this.graph.getFirstSelectedNode());
                GraphController.this.graph.performLayout();
            }
        });
        graphMenu.addSeparator();
        this.expandAction = new CajunAction("Expand", "Expand"){
            private static final long serialVersionUID = -8044342001264176639L;

            public void actionPerformed(ActionEvent e) {
                GraphController.this.owlClass = (OWLEntity)GraphController.this.graph.getFirstSelectedNode().getUserObject();
                GraphController.this.model.expandNode(GraphController.this.graph.getFirstSelectedNode());
                GraphController.this.graph.performLayout();
            }
        };
        this.collapseAction = new CajunAction("Collapse", "Collapse"){
            private static final long serialVersionUID = 815274665395852446L;

            public void actionPerformed(ActionEvent e) {
                GraphController.this.owlClass = (OWLEntity)GraphController.this.graph.getFirstSelectedNode().getUserObject();
                GraphController.this.model.collapseNode(GraphController.this.graph.getFirstSelectedNode());
                GraphController.this.graph.performLayout();
            }
        };
        graphMenu.add(this.expandAction);
        graphMenu.add(this.collapseAction);
        graphMenu.addSeparator();
        final JMenu expandBasedOnMenu = new JMenu("Expand on");
        graphMenu.add(expandBasedOnMenu);
        this.expandBasedOnActions = new HashSet<Action>();
        graphMenu.add(expandBasedOnMenu);
        graphMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                GraphNode node = GraphController.this.graph.getFirstSelectedNode();
                if (node != null) {
                    GraphController.this.prepareNodeSpecificActions(node, expandBasedOnMenu);
                    GraphController.this.initNodeActionConditions(node);
                }
            }
        });
    }

    private void initNodeActionConditions(GraphNode node) {
        if (this.model.isExpanded(node)) {
            this.expandAction.setEnabled(false);
            for (Action action : this.expandBasedOnActions) {
                action.setEnabled(false);
            }
        } else {
            this.expandAction.setEnabled(true);
            for (Action action : this.expandBasedOnActions) {
                if (this.graph.getFilterManager().isArcTypeVisible((Object)((CajunAction)action).getName())) {
                    action.setEnabled(true);
                    continue;
                }
                action.setEnabled(false);
            }
        }
    }

    private void prepareNodeSpecificActions(GraphNode node, JMenu expandBasedOnMenu) {
        this.expandBasedOnActions.clear();
        expandBasedOnMenu.removeAll();
        for (GraphArc arc : this.model.getCachedArcsForEntity((OWLEntity)node.getUserObject())) {
            CajunAction action = this.getNodeExpansionAction(arc.getType().toString());
            if (this.expandBasedOnActions.contains(action)) continue;
            this.expandBasedOnActions.add((Action)action);
            expandBasedOnMenu.add((Action)action);
        }
    }

    private CajunAction getNodeExpansionAction(String arcType) {
        return new CajunAction(arcType, arcType){
            private static final long serialVersionUID = -4658385618425759291L;

            public void actionPerformed(ActionEvent e) {
                GraphController.this.model.expandNode(GraphController.this.graph.getFirstSelectedNode(), e.getActionCommand());
                GraphController.this.graph.performLayout();
            }
        };
    }
}

