/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.common;

import ca.uvic.cs.chisel.cajun.filter.FilterManager;
import ca.uvic.cs.chisel.cajun.graph.DefaultGraphModel;
import ca.uvic.cs.chisel.cajun.graph.arc.DefaultGraphArc;
import ca.uvic.cs.chisel.cajun.graph.arc.GraphArc;
import ca.uvic.cs.chisel.cajun.graph.node.DefaultGraphNode;
import ca.uvic.cs.chisel.cajun.graph.node.GraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtegeGraphModel
extends DefaultGraphModel {
    protected static final String DIRECT_SUBCLASS_SLOT_TYPE = "has subclass";
    protected static final String DIRECT_INDIVIDUAL_SLOT_TYPE = "has individual";
    protected static final String SUFFIX_DOMAIN_RANGE = " (Domain>Range)";
    protected static final String SUB_CLASS_SOME_VALUE_OF = "(Subclass some)";
    protected static final String SUB_CLASS_ALL_VALUES = "(Subclass all)";
    protected static final String EQUIVALENT_CLASS_SOME_VALUE_OF = "(Equivalent class some)";
    protected static final String EQUIVALENT_CLASS_ALL_VALUES = "(Equivalent class all)";
    protected static final String UNKNOWN_ART_TYPE = "unknown";
    protected static final String CLASS_ART_TYPE = "class";
    protected static final String INDIVIDUAL_ART_TYPE = "individual";
    protected String restrictToArcType;
    private Map<OWLEntity, Set<GraphArc>> frameToArcCount;
    private Map<OWLNamedIndividual, Set<GraphArc>> artifactToUnreifiedRels;
    private Set<GraphArc> domainRangeRelsBuffer;
    private Collection<Object> arcTypes;
    private OWLOntology owlOntology;
    private OWLModelManager owlModelManager;
    private OWLEditorKit owlEditorKit;
    private FilterManager filterManager;

    public ProtegeGraphModel(OWLEditorKit owlEditorKit) {
        this.owlModelManager = owlEditorKit.getModelManager();
        this.owlEditorKit = owlEditorKit;
        this.owlOntology = this.owlModelManager.getActiveOntology();
        this.frameToArcCount = new HashMap<OWLEntity, Set<GraphArc>>();
    }

    public OWLModelManager getOwlModelManager() {
        return this.owlModelManager;
    }

    public void show(OWLEntity entity, FilterManager filterManager) {
        this.filterManager = filterManager;
        ArrayList<GraphArc> arcs = new ArrayList<GraphArc>();
        this.addNode(entity);
        arcs.addAll(this.createIncomingRelationships(entity, true));
        arcs.addAll(this.createOutgoingRelationships(entity, true));
        this.addArcsToModel(arcs, false);
        this.recalculateArcStyles();
    }

    public void showNeighborhood(OWLEntity entity, boolean removeOldNodes) {
        ArrayList<OWLEntity> singleItemList = new ArrayList<OWLEntity>(1);
        singleItemList.add(entity);
        this.showNeighborhood(singleItemList, removeOldNodes);
    }

    public void showNeighborhood(Collection<? extends OWLEntity> nodes, boolean removeOldNodes) {
        ArrayList<GraphArc> arcs = new ArrayList<GraphArc>();
        for (OWLEntity oWLEntity : nodes) {
            arcs.addAll(this.createIncomingRelationships(oWLEntity, false));
            arcs.addAll(this.createOutgoingRelationships(oWLEntity, false));
        }
        this.addArcsToModel(arcs, removeOldNodes);
        this.recalculateArcStyles();
    }

    private void addArcsToModel(Collection<GraphArc> arcs, boolean removeOldNodes) {
        HashSet<GraphNode> newGraphNodes = new HashSet<GraphNode>();
        for (GraphArc arc : arcs) {
            GraphArc createdArc = this.addArc((OWLEntity)arc.getSource().getUserObject(), (OWLEntity)arc.getDestination().getUserObject(), arc.getType().toString(), arc.getIcon());
            if (createdArc == null) continue;
            newGraphNodes.add(createdArc.getSource());
            newGraphNodes.add(createdArc.getDestination());
            createdArc.setInverted(arc.isInverted());
        }
        if (removeOldNodes) {
            GraphNode[] allNodes;
            for (GraphNode node : allNodes = this.getAllNodes().toArray(new GraphNode[this.getAllNodes().size()])) {
                if (newGraphNodes.contains(node)) continue;
                this.removeNode(node.getUserObject());
            }
        }
    }

    protected GraphNode addNode(OWLEntity entity) {
        return this.addNode(entity, this.owlModelManager.getRendering((OWLObject)entity), this.owlEditorKit.getOWLWorkspace().getOWLIconProvider().getIcon((OWLObject)entity), this.getNodeType(entity));
    }

    protected String getNodeType(OWLEntity entity) {
        if (entity instanceof OWLClass) {
            return CLASS_ART_TYPE;
        }
        if (entity instanceof OWLIndividual) {
            return INDIVIDUAL_ART_TYPE;
        }
        return UNKNOWN_ART_TYPE;
    }

    protected GraphArc addArc(OWLEntity srcEntity, OWLEntity destEntity, String relType, Icon icon) {
        if (!relType.contains(this.restrictToArcType)) {
            return null;
        }
        boolean newNode = true;
        if (this.getNode(destEntity) != null) {
            newNode = false;
        }
        GraphNode srcNode = this.addNode(srcEntity);
        GraphNode destNode = this.addNode(destEntity);
        if (newNode) {
            destNode.setLocation(srcNode.getBounds().getX(), srcNode.getBounds().getY());
        }
        String key = srcEntity.toString() + relType + destEntity.toString();
        DefaultGraphArc arc = (DefaultGraphArc)this.addArc(key, srcNode, destNode, relType, icon);
        arc.setInverted(true);
        return arc;
    }

    protected boolean isDisplayableNode(OWLEntity entity, boolean mustBeVisible) {
        return !mustBeVisible || mustBeVisible && this.getNode(entity) != null;
    }

    protected Set<GraphArc> createIncomingRelationships(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> incomingArcs = new HashSet<GraphArc>();
        incomingArcs.addAll(this.loadParents(entityOfInterest, mustBeVisible));
        incomingArcs.addAll(this.loadDomainRangeRels(entityOfInterest, false, mustBeVisible));
        incomingArcs.addAll(this.findIncomingIndividualRelationships(entityOfInterest, mustBeVisible));
        incomingArcs.addAll(this.loadUnreifiedRelations(entityOfInterest, mustBeVisible));
        incomingArcs.addAll(this.findIncomingConditionsRelationships(entityOfInterest, mustBeVisible));
        return incomingArcs;
    }

    protected Set<GraphArc> createOutgoingRelationships(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> outgoingRels = new HashSet<GraphArc>();
        outgoingRels.addAll(this.loadChildren(entityOfInterest, mustBeVisible));
        outgoingRels.addAll(this.loadDomainRangeRels(entityOfInterest, true, mustBeVisible));
        outgoingRels.addAll(this.findOutgoingIndividualRelationships(entityOfInterest, mustBeVisible));
        outgoingRels.addAll(this.findOutgoingConditionsRelationships(entityOfInterest, mustBeVisible));
        return outgoingRels;
    }

    private Set<GraphArc> loadDomainRangeRels(OWLEntity entityOfInterest, boolean outgoing, boolean mustBeVisible) {
        HashSet<GraphArc> domainRangeArcs = new HashSet<GraphArc>();
        this.getDomainRangeRelationships();
        for (GraphArc relationship : this.domainRangeRelsBuffer) {
            if (!this.filterManager.isArcTypeVisible(relationship.getType())) continue;
            OWLEntity sourceObject = (OWLEntity)relationship.getSource().getUserObject();
            OWLEntity destObject = (OWLEntity)relationship.getDestination().getUserObject();
            if (!this.isDisplayableNode(sourceObject, mustBeVisible) || !this.isDisplayableNode(destObject, mustBeVisible) || (!outgoing || !sourceObject.equals(entityOfInterest)) && !destObject.equals(entityOfInterest)) continue;
            if (outgoing) {
                relationship.setInverted(false);
            }
            domainRangeArcs.add(relationship);
        }
        return domainRangeArcs;
    }

    private Set<GraphArc> loadUnreifiedRelations(OWLEntity entityOfInterest, boolean mustBeVisible) {
        this.unreifyRelationInstances();
        HashSet unreifiedRels = this.artifactToUnreifiedRels.get(entityOfInterest);
        if (unreifiedRels != null) {
            for (GraphArc arc : unreifiedRels) {
                if (!this.filterManager.isArcTypeVisible(arc.getType())) {
                    unreifiedRels.remove(arc);
                    continue;
                }
                if (this.isDisplayableNode((OWLEntity)arc.getDestination().getUserObject(), mustBeVisible)) continue;
                unreifiedRels.remove(arc);
            }
        }
        return unreifiedRels == null ? new HashSet() : unreifiedRels;
    }

    private void unreifyRelationInstances() {
        if (this.artifactToUnreifiedRels != null) {
            return;
        }
        this.artifactToUnreifiedRels = new HashMap<OWLNamedIndividual, Set<GraphArc>>();
        for (OWLNamedIndividual individual : this.owlOntology.getIndividualsInSignature()) {
            for (Map.Entry entry : individual.getObjectPropertyValues(this.owlOntology).entrySet()) {
                for (OWLIndividual refIndividual : (Set)entry.getValue()) {
                    GraphArc arc = this.createArc((OWLEntity)individual, (OWLEntity)((OWLNamedIndividual)refIndividual), this.owlModelManager.getRendering((OWLObject)entry.getKey()));
                    Set<GraphArc> outgoingUnreifiedRels = this.artifactToUnreifiedRels.get(individual);
                    if (outgoingUnreifiedRels == null) {
                        outgoingUnreifiedRels = new HashSet<GraphArc>();
                        this.artifactToUnreifiedRels.put(individual, outgoingUnreifiedRels);
                    }
                    outgoingUnreifiedRels.add(arc);
                    Set<GraphArc> incomingUnreifiedRels = this.artifactToUnreifiedRels.get(refIndividual);
                    if (incomingUnreifiedRels == null) {
                        incomingUnreifiedRels = new HashSet<GraphArc>();
                        this.artifactToUnreifiedRels.put((OWLNamedIndividual)refIndividual, incomingUnreifiedRels);
                    }
                    incomingUnreifiedRels.add(arc);
                }
            }
        }
    }

    private Set<GraphArc> findIncomingIndividualRelationships(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> arcs = new HashSet<GraphArc>();
        if (!(entityOfInterest instanceof OWLNamedIndividual)) {
            return arcs;
        }
        if (!this.filterManager.isArcTypeVisible((Object)DIRECT_INDIVIDUAL_SLOT_TYPE)) {
            return arcs;
        }
        OWLNamedIndividual destIndiv = (OWLNamedIndividual)entityOfInterest;
        for (OWLClassExpression refNode : destIndiv.getTypes(this.owlOntology)) {
            OWLClass clsOwner;
            if (!(refNode instanceof OWLClass) || !this.isDisplayableNode((OWLEntity)(clsOwner = (OWLClass)refNode), mustBeVisible)) continue;
            String relType = DIRECT_INDIVIDUAL_SLOT_TYPE;
            arcs.add(this.createArc((OWLEntity)clsOwner, (OWLEntity)destIndiv, relType));
        }
        return arcs;
    }

    private Set<GraphArc> findIncomingConditionsRelationships(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> arcs = new HashSet<GraphArc>();
        if (!(entityOfInterest instanceof OWLClass)) {
            return arcs;
        }
        OWLClass owlClass = (OWLClass)entityOfInterest;
        Set axioms = owlClass.getReferencingAxioms(this.owlOntology);
        for (OWLAxiom axiom : axioms) {
            OWLQuantifiedRestriction restriction;
            OWLClassExpression superClassExpression;
            OWLSubClassOfAxiom subClassAxiom;
            OWLClassExpression subClassExpression;
            if (!axiom.getAxiomType().equals(AxiomType.SUBCLASS_OF) || !((subClassExpression = (subClassAxiom = (OWLSubClassOfAxiom)axiom).getSubClass()) instanceof OWLClass) || !((superClassExpression = subClassAxiom.getSuperClass()) instanceof OWLQuantifiedRestriction) || !((restriction = (OWLQuantifiedRestriction)superClassExpression).getFiller() instanceof OWLClass)) continue;
            String relType = this.owlModelManager.getRendering((OWLObject)restriction.getProperty());
            relType = restriction instanceof OWLObjectSomeValuesFrom ? relType + SUB_CLASS_SOME_VALUE_OF : relType + SUB_CLASS_ALL_VALUES;
            if (!this.filterManager.isArcTypeVisible((Object)relType)) continue;
            OWLClass source = (OWLClass)subClassExpression;
            OWLClass target = (OWLClass)restriction.getFiller();
            if (!this.isDisplayableNode((OWLEntity)source, mustBeVisible) || !this.isDisplayableNode((OWLEntity)target, mustBeVisible)) continue;
            arcs.add(this.createArc((OWLEntity)source, (OWLEntity)target, relType));
        }
        return arcs;
    }

    private Set<GraphArc> findOutgoingConditionsRelationships(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> arcs = new HashSet<GraphArc>();
        if (!(entityOfInterest instanceof OWLClass)) {
            return arcs;
        }
        OWLClass owlClass = (OWLClass)entityOfInterest;
        this.convertOWLClassExpressionsToArcs(owlClass, owlClass.getSuperClasses(this.owlOntology), arcs, null, mustBeVisible);
        this.convertOWLClassExpressionsToArcs(owlClass, owlClass.getEquivalentClasses(this.owlOntology), arcs, this.owlEditorKit.getOWLWorkspace().getOWLIconProvider().getIcon((OWLObject)owlClass), mustBeVisible);
        return arcs;
    }

    private void convertOWLClassExpressionsToArcs(OWLClass owlClass, Set<OWLClassExpression> expressions, Set<GraphArc> arcs, Icon icon, boolean mustBeVisible) {
        for (OWLClassExpression expression : expressions) {
            if (expression.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_SOME_VALUES_FROM) || expression.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ALL_VALUES_FROM)) {
                this.convertOWLClassExpressionToArcs(owlClass, expression, arcs, icon, mustBeVisible);
                continue;
            }
            if (!expression.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) continue;
            for (OWLClassExpression e : expression.asConjunctSet()) {
                this.convertOWLClassExpressionToArcs(owlClass, e, arcs, icon, mustBeVisible);
            }
        }
    }

    private void convertOWLClassExpressionToArcs(OWLClass owlClass, OWLClassExpression expression, Set<GraphArc> arcs, Icon icon, boolean mustBeVisible) {
        boolean isSubClass = true;
        if (icon != null) {
            isSubClass = false;
        }
        for (OWLClassExpression e : expression.asConjunctSet()) {
            OWLQuantifiedRestriction restriction;
            if (!(e instanceof OWLQuantifiedRestriction) || !((restriction = (OWLQuantifiedRestriction)e).getFiller() instanceof OWLClass)) continue;
            String relType = this.owlModelManager.getRendering((OWLObject)restriction.getProperty());
            relType = isSubClass ? (restriction instanceof OWLObjectSomeValuesFrom ? relType + SUB_CLASS_SOME_VALUE_OF : relType + SUB_CLASS_ALL_VALUES) : (restriction instanceof OWLObjectSomeValuesFrom ? relType + EQUIVALENT_CLASS_SOME_VALUE_OF : relType + EQUIVALENT_CLASS_ALL_VALUES);
            if (!this.filterManager.isArcTypeVisible((Object)relType) || !this.isDisplayableNode((OWLEntity)((OWLClass)restriction.getFiller()), mustBeVisible)) continue;
            arcs.add(this.createArc((OWLEntity)owlClass, (OWLEntity)((OWLClass)restriction.getFiller()), relType, icon));
        }
    }

    protected Set<GraphArc> loadParents(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> parents = new HashSet<GraphArc>();
        if (!(entityOfInterest instanceof OWLClass)) {
            return parents;
        }
        if (!this.filterManager.isArcTypeVisible((Object)DIRECT_SUBCLASS_SLOT_TYPE)) {
            return parents;
        }
        OWLClass clsOfInterest = (OWLClass)entityOfInterest;
        for (OWLClass parentCls : this.owlEditorKit.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getParents((OWLObject)clsOfInterest)) {
            if (!this.isDisplayableNode((OWLEntity)parentCls, mustBeVisible)) continue;
            GraphArc arc = this.createArc((OWLEntity)parentCls, (OWLEntity)clsOfInterest, DIRECT_SUBCLASS_SLOT_TYPE);
            arc.setInverted(false);
            parents.add(arc);
        }
        return parents;
    }

    protected Set<GraphArc> loadChildren(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> children = new HashSet<GraphArc>();
        if (!(entityOfInterest instanceof OWLClass)) {
            return children;
        }
        if (!this.filterManager.isArcTypeVisible((Object)DIRECT_SUBCLASS_SLOT_TYPE)) {
            return children;
        }
        OWLClass clsOfInterest = (OWLClass)entityOfInterest;
        for (OWLClass childCls : this.owlEditorKit.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getChildren((OWLObject)clsOfInterest)) {
            if (!this.isDisplayableNode((OWLEntity)childCls, mustBeVisible)) continue;
            GraphArc arc = this.createArc((OWLEntity)clsOfInterest, (OWLEntity)childCls, DIRECT_SUBCLASS_SLOT_TYPE);
            children.add(arc);
        }
        return children;
    }

    private Set<GraphArc> findOutgoingIndividualRelationships(OWLEntity entityOfInterest, boolean mustBeVisible) {
        HashSet<GraphArc> incomingInstanceRels = new HashSet<GraphArc>();
        if (!(entityOfInterest instanceof OWLClass)) {
            return incomingInstanceRels;
        }
        if (!this.filterManager.isArcTypeVisible((Object)DIRECT_INDIVIDUAL_SLOT_TYPE)) {
            return incomingInstanceRels;
        }
        OWLClass owlClass = (OWLClass)entityOfInterest;
        for (OWLIndividual individual : owlClass.getIndividuals(this.owlOntology)) {
            OWLNamedIndividual namedIndividual;
            if (!(individual instanceof OWLNamedIndividual) || !this.isDisplayableNode((OWLEntity)(namedIndividual = (OWLNamedIndividual)individual), mustBeVisible)) continue;
            String relType = DIRECT_INDIVIDUAL_SLOT_TYPE;
            GraphArc arc = this.createArc((OWLEntity)owlClass, (OWLEntity)namedIndividual, relType);
            incomingInstanceRels.add(arc);
        }
        return incomingInstanceRels;
    }

    private Set<OWLEntity> getOWLClasses(Set<OWLClassExpression> owlExpressions) {
        HashSet<OWLEntity> domains = new HashSet<OWLEntity>();
        for (OWLClassExpression expression : owlExpressions) {
            if (!(expression instanceof OWLClass)) continue;
            domains.add((OWLEntity)((OWLClass)expression));
        }
        return domains;
    }

    private void createDomainRangeRels(Set<OWLEntity> domains, Set<OWLEntity> ranges, OWLObjectProperty property) {
        for (OWLEntity domainClass : domains) {
            DefaultGraphNode srcNode = new DefaultGraphNode((Object)domainClass);
            for (OWLEntity rangeClass : ranges) {
                String relType;
                DefaultGraphNode destNode = new DefaultGraphNode((Object)rangeClass);
                GraphArc arc = this.createArc((GraphNode)srcNode, (GraphNode)destNode, relType = this.owlModelManager.getRendering((OWLObject)property) + SUFFIX_DOMAIN_RANGE, null);
                if (this.domainRangeRelsBuffer.contains(arc)) continue;
                this.domainRangeRelsBuffer.add(arc);
            }
        }
    }

    private void createDomainRangeRels() {
        this.domainRangeRelsBuffer = new HashSet<GraphArc>();
        Set properties = this.owlOntology.getObjectPropertiesInSignature();
        for (OWLObjectProperty property : properties) {
            for (OWLObjectProperty owlObjectProperty : property.getObjectPropertiesInSignature()) {
                Set domainVals = owlObjectProperty.getDomains(this.owlOntology);
                Set rangeVals = owlObjectProperty.getRanges(this.owlOntology);
                if (domainVals.isEmpty() && !rangeVals.isEmpty()) {
                    domainVals.add(this.owlModelManager.getOWLEntityFinder().getOWLClass("Thing"));
                } else if (rangeVals.isEmpty() && !domainVals.isEmpty()) {
                    rangeVals.add(this.owlModelManager.getOWLEntityFinder().getOWLClass("Thing"));
                }
                Set<OWLEntity> domains = this.getOWLClasses(domainVals);
                Set<OWLEntity> ranges = this.getOWLClasses(rangeVals);
                this.createDomainRangeRels(domains, ranges, owlObjectProperty);
            }
        }
    }

    private Collection<GraphArc> getDomainRangeRelationships() {
        if (this.domainRangeRelsBuffer == null) {
            this.createDomainRangeRels();
        }
        return this.domainRangeRelsBuffer;
    }

    protected GraphArc createArc(OWLEntity srcCls, OWLEntity targetCls, String relType) {
        return this.createArc(srcCls, targetCls, relType, null);
    }

    protected GraphArc createArc(OWLEntity srcCls, OWLEntity targetCls, String relType, Icon icon) {
        DefaultGraphNode srcNode = new DefaultGraphNode((Object)srcCls);
        DefaultGraphNode destNode = new DefaultGraphNode((Object)targetCls);
        return this.createArc((GraphNode)srcNode, (GraphNode)destNode, relType, icon);
    }

    protected GraphArc createArc(GraphNode srcNode, GraphNode destNode, String relType, Icon icon) {
        String key = srcNode.getUserObject().toString() + relType + destNode.getUserObject().toString();
        return new DefaultGraphArc((Object)key, srcNode, destNode, icon, (Object)relType);
    }

    public Collection<? extends OWLEntity> search(String searchString, FilterManager filterManager) {
        this.restrictToArcType = "";
        this.filterManager = filterManager;
        HashSet searchResults = new HashSet();
        Set matchingClasses = this.owlModelManager.getOWLEntityFinder().getMatchingOWLClasses(searchString, true, 2);
        Set matchingIndividuals = this.owlModelManager.getOWLEntityFinder().getMatchingOWLIndividuals(searchString, true, 2);
        searchResults.addAll(matchingClasses);
        searchResults.addAll(matchingIndividuals);
        if (searchResults != null) {
            this.showNeighborhood(searchResults, true);
        }
        return searchResults;
    }

    public void hideAscendants(GraphNode graphNode) {
        HashSet<IRI> seen = new HashSet<IRI>();
        this.hideAscendants(graphNode, seen);
    }

    private void hideAscendants(GraphNode graphNode, Set<IRI> seen) {
        GraphArc[] arcs = graphNode.getArcs().toArray(new GraphArc[graphNode.getArcs().size()]);
        seen.add(((OWLEntity)graphNode.getUserObject()).getIRI());
        for (GraphArc arc : arcs) {
            Object userObject = arc.getSource().getUserObject();
            GraphNode node = this.getNode(userObject);
            if (node != null && !node.equals(graphNode)) {
                this.removeArc(arc.getUserObject());
                if (!seen.contains(((OWLEntity)userObject).getIRI())) {
                    this.hideAll(node, seen);
                }
                if (!this.isRemovable(node)) continue;
                this.removeNode(userObject);
                continue;
            }
            userObject = arc.getDestination().getUserObject();
            seen.add(((OWLEntity)userObject).getIRI());
        }
    }

    private void hideAll(GraphNode graphNode, Set<IRI> seen) {
        GraphArc[] arcs = graphNode.getArcs().toArray(new GraphArc[graphNode.getArcs().size()]);
        seen.add(((OWLEntity)graphNode.getUserObject()).getIRI());
        for (GraphArc arc : arcs) {
            Object userObject = arc.getDestination().getUserObject();
            GraphNode node = this.getNode(userObject);
            if (node == null || node.equals(graphNode)) continue;
            this.removeArc(arc.getUserObject());
            if (!seen.contains(((OWLEntity)userObject).getIRI())) {
                this.hideAll(node, seen);
            }
            if (node == null || !this.isRemovable(node)) continue;
            this.removeNode(userObject);
        }
    }

    private Collection<Object> generateArcTypes() {
        HashSet<Object> types = new HashSet<Object>();
        types.add(DIRECT_SUBCLASS_SLOT_TYPE);
        types.add(DIRECT_INDIVIDUAL_SLOT_TYPE);
        types.addAll(super.getArcTypes());
        return types;
    }

    public Collection<Object> getArcTypes() {
        if (this.arcTypes == null) {
            this.arcTypes = this.generateArcTypes();
        } else {
            Collection<Object> types = this.generateArcTypes();
            if (types.size() != this.arcTypes.size()) {
                this.arcTypes.addAll(types);
            }
        }
        return this.arcTypes;
    }

    public void expandNode(GraphNode graphNode) {
        this.showNeighborhood((OWLEntity)graphNode.getUserObject(), false);
    }

    public void expandNode(GraphNode graphNode, String arcType) {
        graphNode.setHighlighted(false);
        this.restrictToArcType = arcType;
        this.showNeighborhood((OWLEntity)graphNode.getUserObject(), false);
        this.restrictToArcType = "";
    }

    public void collapseNode(GraphNode graphNode) {
        HashSet<IRI> seen = new HashSet<IRI>();
        graphNode.setHighlighted(false);
        this.collapseNode(graphNode, seen);
    }

    private Collection<GraphArc> getArcsForEntity(OWLEntity entity) {
        HashSet<GraphArc> arcs = new HashSet<GraphArc>();
        arcs.addAll(this.createIncomingRelationships(entity, false));
        arcs.addAll(this.createOutgoingRelationships(entity, false));
        return arcs;
    }

    public void resetNodeToArcCount() {
        for (OWLEntity owlEntity : this.frameToArcCount.keySet()) {
            this.frameToArcCount.put(owlEntity, (Set)this.getArcsForEntity(owlEntity));
        }
    }

    private Integer getNodeToArcCount(OWLEntity entity) {
        Set<GraphArc> arcs = this.getCachedArcsForEntity(entity);
        return arcs.size();
    }

    public Set<GraphArc> getCachedArcsForEntity(OWLEntity entity) {
        Set arcs = this.frameToArcCount.get(entity);
        if (arcs == null) {
            arcs = (Set)this.getArcsForEntity(entity);
            this.frameToArcCount.put(entity, arcs);
        }
        return arcs;
    }

    private void collapseNode(GraphNode graphNode, Set<IRI> seen) {
        GraphArc[] arcs = graphNode.getArcs().toArray(new GraphArc[graphNode.getArcs().size()]);
        seen.add(((OWLEntity)graphNode.getUserObject()).getIRI());
        for (GraphArc arc : arcs) {
            Object userObject = arc.getDestination().getUserObject();
            GraphNode node = this.getNode(userObject);
            if (node == null || node.equals(graphNode)) continue;
            this.removeArc(arc.getUserObject());
            if (this.isRecursableArc(seen, userObject, arc)) {
                this.collapseNode(node, seen);
            }
            if (!this.isRemovable(node)) continue;
            this.removeNode(userObject);
        }
    }

    private boolean isRemovable(GraphNode node) {
        for (GraphArc arc : node.getArcs()) {
            if (arc.getDestination().equals(arc.getSource())) continue;
            return false;
        }
        return true;
    }

    private boolean isRecursableArc(Set<IRI> seen, Object userObject, GraphArc arc) {
        return !seen.contains(((OWLEntity)userObject).getIRI()) && (arc.getType().equals(DIRECT_SUBCLASS_SLOT_TYPE) || arc.getType().equals(DIRECT_INDIVIDUAL_SLOT_TYPE));
    }

    public boolean isExpandable(GraphNode graphNode) {
        return this.getNodeToArcCount((OWLEntity)graphNode.getUserObject()) > 0;
    }

    public boolean isExpanded(GraphNode graphNode) {
        int frameArcsSize;
        int modelArcsSize = graphNode.getArcs().size();
        return modelArcsSize >= (frameArcsSize = this.getNodeToArcCount((OWLEntity)graphNode.getUserObject()).intValue());
    }
}

