/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.ui;

import ca.uvic.cs.chisel.cajun.graph.AbstractGraph;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.ontograf.common.util.NodeOWLClassTooltipType;
import org.protege.ontograf.common.util.NodeOWLIndividualTooltipType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameTooltipNode
extends PNode {
    private static final long serialVersionUID = 1171088034485980559L;
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 203);
    private static final int PADDING_X = 12;
    private static final int PADDING_Y = 6;
    protected static final int MAX_TEXT_CHARS = 75;
    protected static final int MAX_LINES = 3;
    private List<GraphTextNode> textNodes;
    protected Stroke borderStroke = new PFixedWidthStroke(1.0f);
    private OWLModelManager owlModelManager;
    private OWLEntity owlEntity;
    private boolean isCameraNode;

    public FrameTooltipNode(OWLModelManager owlModelManager, AbstractGraph graph, PNode owner, OWLEntity owlEntity) {
        this.owlModelManager = owlModelManager;
        this.owlEntity = owlEntity;
        this.isCameraNode = true;
        this.initLocation(graph, owner);
        this.initText();
        this.adjustX(graph, owner);
        this.repaint();
    }

    public void updateLocation(AbstractGraph graph, PNode owner) {
        this.removeAllChildren();
        this.isCameraNode = false;
        this.initLocation(graph, owner);
        this.initText();
        this.adjustX(graph, owner);
        this.repaint();
    }

    public void setText(GraphTextNode textNode, String s) {
        if (s == null) {
            s = "";
        }
        textNode.setText(this.splitTextIntoLines(s, 3, 75));
    }

    private void adjustX(AbstractGraph graph, PNode owner) {
        Object rect = owner.getBounds();
        if (this.isCameraNode) {
            rect = graph.getCamera().viewToLocal((Rectangle2D)owner.getBounds());
        }
        double maxX = graph.getWidth() / 3;
        maxX *= 2.0;
        if (this.getX() > maxX) {
            this.translate(-1.0 * (this.getWidth() + ((RectangularShape)rect).getWidth()), 0.0);
        }
    }

    private void initText() {
        double x = this.getX() + 5.0;
        double y = this.getY() + 5.0;
        this.textNodes = new ArrayList<GraphTextNode>();
        Font font = PText.DEFAULT_FONT.deriveFont(10.0f);
        Point2D currentPos = new Point2D.Double(x, y);
        if (this.owlEntity instanceof OWLClass) {
            currentPos = this.initClassTooltips(currentPos, font);
        } else if (this.owlEntity instanceof OWLIndividual) {
            currentPos = this.initIndividualTooltips(currentPos, font);
        }
        this.updateBounds();
    }

    private Point2D createTitleText(Point2D currentPos, Font font) {
        this.textNodes.add(this.createTextNode(currentPos.getX(), currentPos.getY(), this.owlModelManager.getRendering((OWLObject)this.owlEntity), font));
        double y = currentPos.getY() + this.textNodes.get(this.textNodes.size() - 1).getHeight() + 2.0;
        return new Point2D.Double(currentPos.getX(), y);
    }

    private Point2D createURIText(Point2D currentPos, Font font) {
        double x = currentPos.getX();
        double y = currentPos.getY();
        this.textNodes.add(this.createTextNode(x, y, "URI:", font.deriveFont(1)));
        this.textNodes.add(this.createTextNode(x += this.textNodes.get(this.textNodes.size() - 1).getWidth() + 5.0, y, this.owlEntity.getIRI().toString(), font));
        x = this.textNodes.get(0).getX();
        return new Point2D.Double(x, y += this.textNodes.get(this.textNodes.size() - 1).getHeight() + 2.0);
    }

    private Point2D initIndividualTooltips(Point2D currentPos, Font font) {
        Set annotations;
        String property;
        Set dataProperties;
        Set properties;
        Set individuals;
        OWLIndividual individual = (OWLIndividual)this.owlEntity;
        if (NodeOWLIndividualTooltipType.TITLE.isEnabled()) {
            currentPos = this.createTitleText(currentPos, font);
        }
        if (NodeOWLIndividualTooltipType.URI.isEnabled()) {
            currentPos = this.createURIText(currentPos, font);
        }
        if (NodeOWLIndividualTooltipType.DIFFERENT_INDIVIDUALS.isEnabled() && (individuals = individual.getDifferentIndividuals(this.owlModelManager.getActiveOntology())).size() > 0) {
            currentPos = this.addCollectionTextValues(individuals, "Different individuals:", font, currentPos);
        }
        if (NodeOWLIndividualTooltipType.SAME_INDIVIDUALS.isEnabled() && (individuals = individual.getSameIndividuals(this.owlModelManager.getActiveOntology())).size() > 0) {
            currentPos = this.addCollectionTextValues(individuals, "Same individuals:", font, currentPos);
        }
        if (NodeOWLIndividualTooltipType.OBJECT_PROPERTY_ASSERTIONS.isEnabled() && (properties = this.owlModelManager.getActiveOntology().getObjectPropertyAssertionAxioms(individual)).size() > 0) {
            currentPos = this.addCollectionTextValues(properties, "Object property assertions:", font, currentPos);
        }
        if (NodeOWLIndividualTooltipType.DATA_PROPERTY_ASSERTIONS.isEnabled() && (dataProperties = this.owlModelManager.getActiveOntology().getDataPropertyAssertionAxioms(individual)).size() > 0) {
            currentPos = this.addCollectionTextValues(dataProperties, "Data property assertions:", font, currentPos);
        }
        if (NodeOWLIndividualTooltipType.NEGATIVE_DATA_PROPERTY_ASSERTIONS.isEnabled()) {
            Map map = individual.getNegativeDataPropertyValues(this.owlModelManager.getActiveOntology());
            HashSet<String> negativeDataProperties = new HashSet<String>();
            for (Map.Entry entry : map.entrySet()) {
                property = this.owlModelManager.getRendering((OWLObject)entry.getKey());
                for (OWLLiteral literal : (Set)entry.getValue()) {
                    property = property + " " + this.owlModelManager.getRendering((OWLObject)literal);
                }
                negativeDataProperties.add(property);
            }
            if (negativeDataProperties.size() > 0) {
                currentPos = this.addStringValues(negativeDataProperties, "Negative data property assertions:", font, currentPos);
            }
        }
        if (NodeOWLIndividualTooltipType.NEGATIVE_OBJECT_PROPERTY_ASSERTIONS.isEnabled()) {
            Map negativeObjectPropertiesMap = individual.getNegativeObjectPropertyValues(this.owlModelManager.getActiveOntology());
            HashSet<String> negativeObjectProperties = new HashSet<String>();
            for (Map.Entry entry : negativeObjectPropertiesMap.entrySet()) {
                property = this.owlModelManager.getRendering((OWLObject)entry.getKey());
                for (OWLIndividual owlIndividual : (Set)entry.getValue()) {
                    property = property + " " + this.owlModelManager.getRendering((OWLObject)owlIndividual);
                }
                negativeObjectProperties.add(property);
            }
            if (negativeObjectProperties.size() > 0) {
                currentPos = this.addStringValues(negativeObjectProperties, "Negative object property assertions:", font, currentPos);
            }
        }
        if (NodeOWLIndividualTooltipType.ANNOTATIONS.isEnabled() && (annotations = this.owlEntity.getAnnotations(this.owlModelManager.getActiveOntology())).size() > 0) {
            currentPos = this.addCollectionTextValues(annotations, "Annotations:", font, currentPos);
        }
        return currentPos;
    }

    private Point2D initClassTooltips(Point2D currentPos, Font font) {
        Set annotations;
        Set disjointAxioms;
        Set equivalentAxioms;
        Set superClasses;
        if (NodeOWLClassTooltipType.TITLE.isEnabled()) {
            currentPos = this.createTitleText(currentPos, font);
        }
        if (NodeOWLClassTooltipType.URI.isEnabled()) {
            currentPos = this.createURIText(currentPos, font);
        }
        if (NodeOWLClassTooltipType.SUPERCLASSES.isEnabled() && (superClasses = this.owlModelManager.getActiveOntology().getSubClassAxiomsForSubClass((OWLClass)this.owlEntity)).size() > 0) {
            currentPos = this.addCollectionTextValues(superClasses, "Superclasses:", font, currentPos);
        }
        if (NodeOWLClassTooltipType.EQUIVALENT_CLASSES.isEnabled() && (equivalentAxioms = this.owlModelManager.getActiveOntology().getEquivalentClassesAxioms((OWLClass)this.owlEntity)).size() > 0) {
            currentPos = this.addCollectionTextValues(equivalentAxioms, "Equivalent classes:", font, currentPos);
        }
        if (NodeOWLClassTooltipType.DISJOINT_CLASSES.isEnabled() && (disjointAxioms = this.owlModelManager.getActiveOntology().getDisjointClassesAxioms((OWLClass)this.owlEntity)).size() > 0) {
            currentPos = this.addCollectionTextValues(disjointAxioms, "Disjoint classes:", font, currentPos);
        }
        if (NodeOWLClassTooltipType.ANNOTATIONS.isEnabled() && (annotations = this.owlEntity.getAnnotations(this.owlModelManager.getActiveOntology())).size() > 0) {
            currentPos = this.addCollectionTextValues(annotations, "Annotations:", font, currentPos);
        }
        return currentPos;
    }

    private Point2D addStringValues(Set<String> entities, String title, Font font, Point2D point) {
        double x = point.getX();
        double y = point.getY();
        this.textNodes.add(this.createTextNode(x, y, title, font.deriveFont(1)));
        y += this.textNodes.get(this.textNodes.size() - 1).getHeight() + 2.0;
        x += 10.0;
        for (String entry : entities) {
            this.textNodes.add(this.createTextNode(x, y, entry, font));
            y += this.textNodes.get(this.textNodes.size() - 1).getHeight() + 2.0;
        }
        return new Point2D.Double(x - 10.0, y);
    }

    private Point2D addCollectionTextValues(Set<? extends OWLObject> entities, String title, Font font, Point2D point) {
        double x = point.getX();
        double y = point.getY();
        this.textNodes.add(this.createTextNode(x, y, title, font.deriveFont(1)));
        y += this.textNodes.get(this.textNodes.size() - 1).getHeight() + 2.0;
        x += 10.0;
        for (OWLObject oWLObject : entities) {
            this.textNodes.add(this.createTextNode(x, y, this.owlModelManager.getRendering(oWLObject), font));
            y += this.textNodes.get(this.textNodes.size() - 1).getHeight() + 2.0;
        }
        return new Point2D.Double(x - 10.0, y);
    }

    private GraphTextNode createTextNode(double x, double y, String text, Font font) {
        GraphTextNode textNode = new GraphTextNode();
        textNode.setConstrainWidthToTextWidth(true);
        textNode.setConstrainHeightToTextHeight(true);
        textNode.setPickable(false);
        textNode.setFont(font);
        this.addChild((PNode)textNode);
        this.setText(textNode, text);
        textNode.setX(x);
        textNode.setY(y);
        return textNode;
    }

    private void initLocation(AbstractGraph graph, PNode owner) {
        PCamera camera = graph.getCanvas().getCamera();
        Rectangle bounds = graph.getCanvas().getBounds();
        Object rect = owner.getBounds();
        if (this.isCameraNode) {
            rect = camera.viewToLocal((Rectangle2D)owner.getBounds());
        }
        double x = ((RectangularShape)rect).getX();
        double y = ((RectangularShape)rect).getY();
        x += ((RectangularShape)rect).getWidth();
        x = Math.min(x, bounds.getWidth() - this.getWidth());
        y = Math.max(y, 0.0);
        this.setX(x);
        this.setY(y);
    }

    protected String elideText(String text, int maxCharsPerLine) {
        if (text.length() > maxCharsPerLine) {
            return new String(text.substring(0, maxCharsPerLine).trim() + "...");
        }
        return text;
    }

    protected String splitTextIntoLines(String text, int maxLines, int maxCharsPerLine) {
        text = text.trim();
        StringBuffer buffer = new StringBuffer(text.length() + 10);
        if (text.length() > maxCharsPerLine) {
            for (int lines = 0; text.length() > 0 && lines < maxLines; ++lines) {
                String line;
                if (text.length() < maxCharsPerLine) {
                    buffer.append(text);
                    break;
                }
                if (lines + 1 == maxLines) {
                    buffer.append(this.elideText(text, maxCharsPerLine));
                    break;
                }
                int end = this.findWhiteSpace(text, maxCharsPerLine);
                if (end == -1) {
                    end = Math.min(text.length(), maxCharsPerLine);
                }
                if ((line = text.substring(0, end).trim()).length() == 0) break;
                buffer.append(line);
                buffer.append('\n');
                text = text.substring(end).trim();
            }
            return buffer.toString().trim();
        }
        return text;
    }

    private int findWhiteSpace(String s, int end) {
        int ws = -1;
        for (int i = Math.min(s.length() - 1, end + 2); i >= 0; --i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            ws = i;
            break;
        }
        return ws;
    }

    private void updateBounds() {
        double w = 0.0;
        double minY = Double.MAX_VALUE;
        double maxY = 0.0;
        double h = 0.0;
        for (GraphTextNode textNode : this.textNodes) {
            PBounds textBounds = textNode.getBounds();
            w = Math.max(w, 36.0 + textBounds.getWidth());
            minY = Math.min(minY, textBounds.getY());
            if (maxY < textBounds.getY()) {
                maxY = textBounds.getY();
                h = textBounds.getHeight();
            }
            maxY = Math.max(maxY, textBounds.getY());
        }
        this.setBounds(this.getX(), this.getY(), w, h += maxY - minY + 6.0);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        boolean changed = super.setBounds(x, y, width, height);
        if (changed) {
            this.invalidatePaint();
        }
        return changed;
    }

    private static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        for (int i = 0; i < clr1.length; ++i) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    private void paintBorderShadow(Graphics2D g2, int shadowWidth, Shape shape) {
        int sw;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = sw = shadowWidth * 2; i >= 2; i -= 2) {
            float pct = (float)(sw - i) / (float)(sw - 1);
            g2.setColor(FrameTooltipNode.getMixedColor(Color.LIGHT_GRAY, pct, Color.WHITE, 1.0f - pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(shape);
        }
    }

    protected void paint(PPaintContext paintContext) {
        Graphics2D g2 = paintContext.getGraphics();
        PBounds shape = this.getBounds();
        g2.setPaint(BACKGROUND_COLOR);
        Rectangle r = shape.getBounds();
        g2.fillRect(r.x, r.y, r.width, r.height);
        this.paintBorderShadow(g2, 2, (Shape)shape);
        g2.setPaint(Color.black);
        g2.setStroke(this.borderStroke);
        g2.draw((Shape)shape);
    }

    class GraphTextNode
    extends PText {
        private static final long serialVersionUID = -871571524212274580L;
        private boolean ignoreInvalidatePaint = false;

        GraphTextNode() {
        }

        public Paint getTextPaint() {
            Color paint = Color.black;
            if (paint == null) {
                paint = Color.black;
            }
            return paint;
        }

        protected void paint(PPaintContext paintContext) {
            Paint p = this.getTextPaint();
            if (!p.equals(super.getTextPaint())) {
                this.ignoreInvalidatePaint = true;
                this.setTextPaint(this.getTextPaint());
                this.ignoreInvalidatePaint = false;
            }
            paintContext.getGraphics().setFont(this.getFont());
            super.paint(paintContext);
        }

        public void invalidatePaint() {
            if (!this.ignoreInvalidatePaint) {
                super.invalidatePaint();
            }
        }
    }
}

