/*
 * Decompiled with CFR 0.152.
 */
package org.protege.ontograf.ui;

import ca.uvic.cs.chisel.cajun.graph.ui.FilterCheckBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import org.protege.ontograf.common.util.NodeOWLClassTooltipType;
import org.protege.ontograf.common.util.NodeOWLIndividualTooltipType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooltipConfigurationDialog
extends JDialog {
    private static final long serialVersionUID = -5081919405096749260L;
    private Map<String, Boolean> owlClassTooltipTypes;
    private Map<String, Boolean> owlIndividualTooltipTypes;

    public TooltipConfigurationDialog() {
        this.setSize(600, 300);
        this.owlClassTooltipTypes = new HashMap<String, Boolean>();
        for (NodeOWLClassTooltipType nodeOWLClassTooltipType : NodeOWLClassTooltipType.values()) {
            this.owlClassTooltipTypes.put(nodeOWLClassTooltipType.toString(), nodeOWLClassTooltipType.isEnabled());
        }
        this.owlIndividualTooltipTypes = new HashMap<String, Boolean>();
        for (Enum enum_ : NodeOWLIndividualTooltipType.values()) {
            this.owlIndividualTooltipTypes.put(((NodeOWLIndividualTooltipType)enum_).toString(), ((NodeOWLIndividualTooltipType)enum_).isEnabled());
        }
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setTitle("Node tooltip configuration");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(this.getTypeScrollPanel(this.getTypesPanel("Class Tooltip Options:"), this.owlClassTooltipTypes));
        splitPane.add(this.getTypeScrollPanel(this.getTypesPanel("Individual Tooltip Options:"), this.owlIndividualTooltipTypes));
        splitPane.setDividerLocation(300);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JScrollPane getTypeScrollPanel(JPanel typesPanel, Map<String, Boolean> types) {
        JPanel holder = new JPanel(new BorderLayout());
        holder.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        holder.add((Component)typesPanel, "North");
        holder.setBackground(Color.white);
        JScrollPane scroll = new JScrollPane(holder, 20, 30);
        this.loadTypes(typesPanel, types);
        return scroll;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TooltipConfigurationDialog.this.setVisible(false);
            }
        });
        JPanel buttonContainerPanel = new JPanel();
        buttonContainerPanel.add(closeButton);
        panel.add((Component)buttonContainerPanel, "East");
        return panel;
    }

    private void typeVisibilityChanged(Object type, boolean visible) {
        for (NodeOWLClassTooltipType tooltipType : NodeOWLClassTooltipType.values()) {
            if (!tooltipType.toString().equals(type.toString())) continue;
            tooltipType.setEnabled(visible);
            break;
        }
    }

    private void typeIndividualVisibilityChanged(Object type, boolean visible) {
        for (NodeOWLIndividualTooltipType tooltipType : NodeOWLIndividualTooltipType.values()) {
            if (!tooltipType.toString().equals(type.toString())) continue;
            tooltipType.setEnabled(visible);
            break;
        }
    }

    public void loadTypes(final JPanel panel, Map<String, Boolean> items) {
        panel.removeAll();
        if (items.size() > 0) {
            TreeSet<String> sortedTypes = new TreeSet<String>();
            sortedTypes.addAll(items.keySet());
            for (String type : sortedTypes) {
                boolean selected = items.get(type);
                FilterCheckBox checkbox = new FilterCheckBox(type, null, selected){
                    private static final long serialVersionUID = -861175558062891232L;

                    public void typeVisibilityChanged(Object type, boolean visible) {
                        String title = ((TitledBorder)panel.getBorder()).getTitle();
                        if (title.equals("Class Tooltip Options:")) {
                            TooltipConfigurationDialog.this.typeVisibilityChanged(type, visible);
                        } else {
                            TooltipConfigurationDialog.this.typeIndividualVisibilityChanged(type, visible);
                        }
                    }
                };
                panel.add((Component)checkbox);
            }
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private JPanel getTypesPanel(String title) {
        JPanel typesPanel = new JPanel(new GridLayout(0, 1, 0, 1));
        typesPanel.setBorder(BorderFactory.createTitledBorder(title));
        typesPanel.setOpaque(false);
        return typesPanel;
    }
}

