/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.protege.osgi.framework.DirectoryWithBundles;
import org.protege.osgi.framework.Parser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    public static final String ARG_PROPERTY = "command.line.arg.";
    public static final String LAUNCH_LOCATION_PROPERTY = "org.protege.launch.config";
    public static final String PROTEGE_DIR_PROPERTY = "protege.dir";
    public static String PROTEGE_DIR = System.getProperty("protege.dir");
    private Properties frameworkProperties;
    private List<DirectoryWithBundles> directories;
    private String factoryClass;
    private Framework framework;

    public Launcher(File config) throws IOException, ParserConfigurationException, SAXException {
        this.parseConfig(config);
        this.locateOSGi();
        File frameworkDir = new File(System.getProperty("java.io.tmpdir"), "ProtegeCache-" + UUID.randomUUID().toString());
        this.frameworkProperties.setProperty("org.osgi.framework.storage", frameworkDir.getCanonicalPath());
        frameworkDir.deleteOnExit();
    }

    public Framework getFramework() {
        return this.framework;
    }

    private void parseConfig(File config) throws ParserConfigurationException, SAXException, IOException {
        Parser p = new Parser();
        p.parse(config);
        this.setSystemProperties(p);
        this.directories = p.getDirectories();
        this.frameworkProperties = p.getFrameworkProperties();
    }

    private void locateOSGi() throws IOException {
        BufferedReader factoryReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("META-INF/services/org.osgi.framework.launch.FrameworkFactory")));
        this.factoryClass = factoryReader.readLine();
        this.factoryClass = this.factoryClass.trim();
        factoryReader.close();
    }

    private void setSystemProperties(Parser p) {
        Properties systemProperties = p.getSystemProperties();
        System.setProperty("org.protege.plugin.dir", p.getPluginDirectory());
        for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void start() throws InstantiationException, IllegalAccessException, ClassNotFoundException, BundleException, IOException {
        FrameworkFactory factory = (FrameworkFactory)Class.forName(this.factoryClass).newInstance();
        this.framework = factory.newFramework((Map)this.frameworkProperties);
        this.framework.start();
        BundleContext context = this.framework.getBundleContext();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (DirectoryWithBundles directory : this.directories) {
            bundles.addAll(this.installBundles(context, directory.getDirectory(), directory.getBundles()));
        }
        this.startBundles(context, bundles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Bundle> installBundles(BundleContext context, String dir, List<String> bundles) throws BundleException {
        File directory = PROTEGE_DIR != null ? new File(PROTEGE_DIR, dir) : new File(dir);
        ArrayList<Bundle> core = new ArrayList<Bundle>();
        for (String bundleName : bundles) {
            boolean success = false;
            try {
                core.add(context.installBundle(new File(directory, bundleName).toURI().toString()));
                success = true;
            }
            finally {
                if (success) continue;
                System.out.println("Core Bundle " + bundleName + " failed to install.");
            }
        }
        return core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBundles(BundleContext context, List<Bundle> bundles) throws BundleException {
        for (Bundle b : bundles) {
            boolean success = false;
            try {
                b.start();
                success = true;
            }
            finally {
                if (success) continue;
                System.out.println("Core Bundle " + b.getBundleId() + " failed to start.");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Launcher.setArguments(args);
        String config = System.getProperty(LAUNCH_LOCATION_PROPERTY, "config.xml");
        File configFile = PROTEGE_DIR != null ? new File(PROTEGE_DIR, config) : new File(config);
        new Launcher(configFile).start();
    }

    public static void setArguments(String ... args) {
        if (args != null) {
            int counter = 0;
            for (String arg : args) {
                System.setProperty(ARG_PROPERTY + counter++, arg);
            }
        }
    }
}

