/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.protege.osgi.framework.DirectoryWithBundles;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String DIRECTORY = "dir";
    public static final String DEFAULT_PLUGIN_DIRECTORY = "plugins";
    private DocumentBuilderFactory factory;
    private String pluginDirectory;
    private Properties frameworkProperties = null;
    private Properties systemProperties = null;
    private List<DirectoryWithBundles> directories = new ArrayList<DirectoryWithBundles>();

    public Parser() {
        this.factory = DocumentBuilderFactory.newInstance();
    }

    public String getPluginDirectory() {
        return this.pluginDirectory;
    }

    public Properties getFrameworkProperties() {
        return this.frameworkProperties;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public List<DirectoryWithBundles> getDirectories() {
        return this.directories;
    }

    public void reset() {
        this.pluginDirectory = null;
        this.frameworkProperties = null;
        this.systemProperties = null;
        this.directories.clear();
    }

    public void parse(File f) throws ParserConfigurationException, SAXException, IOException {
        this.reset();
        DocumentBuilder builder = this.factory.newDocumentBuilder();
        Document doc = builder.parse(f);
        Node topNode = doc.getChildNodes().item(0);
        NodeList nodes = topNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            DirectoryWithBundles directory;
            Node job = nodes.item(i);
            if (job instanceof Element && job.getNodeName().equals("pluginDirectory")) {
                this.setPluginDirectory(job);
            }
            if (job instanceof Element && job.getNodeName().equals("systemProperties")) {
                this.systemProperties = this.readProperties(job.getChildNodes());
                continue;
            }
            if (job instanceof Element && job.getNodeName().equals("frameworkProperties")) {
                this.frameworkProperties = this.readProperties(job.getChildNodes());
                continue;
            }
            if (!(job instanceof Element) || !job.getNodeName().equals("bundles") || (directory = this.readDirectories(job)) == null) continue;
            this.directories.add(directory);
        }
    }

    private void setPluginDirectory(Node node) {
        String value;
        NamedNodeMap attributes = node.getAttributes();
        Node dir = attributes.getNamedItem(DIRECTORY);
        if (dir != null && (value = dir.getNodeValue()) != null) {
            this.pluginDirectory = value;
        }
    }

    private Properties readProperties(NodeList nodes) {
        Properties properties = new Properties();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node propertyNode = nodes.item(i);
            if (!(propertyNode instanceof Element) || !propertyNode.getNodeName().equals(PROPERTY)) continue;
            NamedNodeMap attributes = propertyNode.getAttributes();
            Node nameNode = attributes.getNamedItem(NAME);
            Node valueNode = attributes.getNamedItem(VALUE);
            if (nameNode == null || valueNode == null) continue;
            properties.put(nameNode.getNodeValue(), valueNode.getNodeValue());
        }
        return properties;
    }

    private DirectoryWithBundles readDirectories(Node node) {
        Node dirNameNode = node.getAttributes().getNamedItem(DIRECTORY);
        if (dirNameNode == null) {
            return null;
        }
        DirectoryWithBundles directories = new DirectoryWithBundles(dirNameNode.getNodeValue());
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node bundleNameNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || !child.getNodeName().equals("bundle") || (bundleNameNode = child.getAttributes().getNamedItem(NAME)) == null) continue;
            directories.addBundle(bundleNameNode.getNodeValue());
        }
        return directories;
    }

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException {
        File example = new File("osgi/felix/launch.xml");
        Parser parser = new Parser();
        parser.parse(example);
    }
}

