/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.command;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import org.protege.editor.owl.ui.view.OWLSelectionViewAction;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizIcons;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizViewI;
import uk.ac.man.cs.mig.coode.owlviz.ui.exportwizard.SelectFormatPage;
import uk.ac.man.cs.mig.coode.owlviz.ui.exportwizard.SpecifyFileNamePage;
import uk.ac.man.cs.mig.coode.owlviz.ui.exportwizard.SpecifyHierarchyPage;
import uk.ac.man.cs.mig.util.graph.export.ExportFormat;
import uk.ac.man.cs.mig.util.graph.ui.GraphComponent;
import uk.ac.man.cs.mig.util.wizard.Wizard;
import uk.ac.man.cs.mig.util.wizard.WizardPage;

public class ExportCommand
extends OWLSelectionViewAction {
    private static final long serialVersionUID = 8752470748480407232L;
    private Wizard wizard;
    private SelectFormatPage formatPage;
    private SpecifyFileNamePage fileNamePage;
    private SpecifyHierarchyPage hierarchyPage;
    private OWLVizViewI view;

    public ExportCommand(OWLVizViewI view) {
        super("Export", (Icon)OWLVizIcons.getIcon("ExportIcon.gif"));
        this.view = view;
        this.putValue("ShortDescription", "Export To Image");
    }

    private void createWizard() {
        this.wizard = new Wizard("Export Image");
        this.hierarchyPage = new SpecifyHierarchyPage(this.view);
        this.formatPage = new SelectFormatPage();
        this.fileNamePage = new SpecifyFileNamePage();
        this.wizard.setPages(new WizardPage[]{this.hierarchyPage, this.formatPage, this.fileNamePage});
    }

    public void actionPerformed(ActionEvent e) {
        this.export();
    }

    protected void export() {
        this.createWizard();
        if (this.wizard.showWizard() == 1) {
            ExportFormat format = this.formatPage.getSelectedExportFormat();
            String fileName = this.fileNamePage.getFileName();
            OutputStream os = this.createOutputStream(fileName);
            if (os != null && format != null) {
                this.doExport(os, format);
                try {
                    os.close();
                }
                catch (IOException ioEx) {
                    ioEx.printStackTrace();
                }
            }
        }
    }

    protected OutputStream createOutputStream(String fileName) {
        File file = new File(fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException fnfEx) {
            fnfEx.printStackTrace();
        }
        return fos;
    }

    protected void doExport(OutputStream os, ExportFormat format) {
        ExportFormat exportFormat = this.formatPage.getSelectedExportFormat();
        GraphComponent graphComponent = this.hierarchyPage.getSelectedGraphComponent();
        exportFormat.export(graphComponent.getController(), os);
    }

    public void updateState() {
        this.setEnabled(true);
    }

    public void dispose() {
    }
}

