/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.command;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.view.OWLSelectionViewAction;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizIcons;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizViewI;
import uk.ac.man.cs.mig.util.graph.ui.GraphComponent;

public class ShowAllClassesCommand
extends OWLSelectionViewAction {
    private static final long serialVersionUID = 2462262315449283945L;
    private OWLModelManager model;
    private OWLVizViewI view;
    private static final int WARNING_LEVEL = 200;

    public ShowAllClassesCommand(OWLVizViewI view, OWLModelManager owlModelManager) {
        super("Show all classes", (Icon)OWLVizIcons.getIcon("ShowAllClassesIcon.png"));
        this.view = view;
        this.model = owlModelManager;
    }

    public void updateState() {
        this.setEnabled(true);
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent e) {
        int ret;
        Object[] clses = this.getClses();
        if (clses.length > 200 && (ret = JOptionPane.showConfirmDialog(null, "Warning: Over 200 classes will be added to the display.  Are you sure that you wish to continue?", "Warning!", 0, 2)) == 1) {
            return;
        }
        for (GraphComponent graphComponent : this.view.getGraphComponents()) {
            graphComponent.getVisualisedObjectManager().showObjects(clses);
        }
    }

    public Object[] getClses() {
        Set clses = this.model.getActiveOntology().getClassesInSignature();
        return clses.toArray();
    }
}

