/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import uk.ac.man.cs.mig.util.graph.model.impl.AbstractGraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLVizAxiomGraphModel
extends AbstractGraphModel
implements OWLAxiomVisitor,
OWLClassExpressionVisitor {
    private Set<OWLObject> nodes;
    private Map<OWLObject, Set<OWLObject>> child2ParentMap = new HashMap<OWLObject, Set<OWLObject>>();
    private Map<OWLObject, Set<OWLObject>> parent2ChildMap = new HashMap<OWLObject, Set<OWLObject>>();
    private Map<AxiomEdge, OWLObject> edgeMap;
    private EdgeNameGenerator edgeNameGenerator;

    public OWLVizAxiomGraphModel(Set<OWLAxiom> axioms) {
        this.nodes = new HashSet<OWLObject>();
        this.edgeMap = new HashMap<AxiomEdge, OWLObject>();
        this.edgeNameGenerator = new EdgeNameGenerator();
        this.addAndClearAxioms(axioms);
    }

    public void addAndClearAxioms(Set<OWLAxiom> axioms) {
        this.clearMaps();
        for (OWLAxiom ax : axioms) {
            ax.accept((OWLAxiomVisitor)this);
        }
    }

    protected void clearMaps() {
        this.child2ParentMap.clear();
        this.parent2ChildMap.clear();
        this.nodes.clear();
        this.edgeMap.clear();
    }

    protected OWLObject getEdgeObject(Object parent, Object child) {
        return this.edgeMap.get(new AxiomEdge(parent, child));
    }

    private Set<OWLObject> getIndexedSet(OWLObject key, Map<OWLObject, Set<OWLObject>> map, boolean create) {
        Set<OWLObject> vals = map.get(key);
        if (vals == null) {
            vals = new HashSet<OWLObject>();
            if (create) {
                map.put(key, vals);
            }
        }
        return vals;
    }

    @Override
    public boolean contains(Object obj) {
        return this.nodes.contains(obj);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getChildCount(Object obj) {
        return this.getIndexedSet((OWLObject)obj, this.parent2ChildMap, false).size();
    }

    @Override
    public Iterator getChildren(Object obj) {
        return this.getIndexedSet((OWLObject)obj, this.parent2ChildMap, false).iterator();
    }

    @Override
    public int getParentCount(Object obj) {
        return this.getIndexedSet((OWLObject)obj, this.child2ParentMap, false).size();
    }

    @Override
    public Iterator getParents(Object obj) {
        return this.getIndexedSet((OWLObject)obj, this.child2ParentMap, false).iterator();
    }

    @Override
    public Iterator getRelatedObjectsToAdd(Object obj) {
        return Collections.emptySet().iterator();
    }

    @Override
    public Iterator getRelatedObjectsToRemove(Object obj) {
        return Collections.emptySet().iterator();
    }

    @Override
    public int getRelationshipDirection(Object parentObject, Object childObject) {
        AxiomEdge edge = new AxiomEdge(childObject, parentObject);
        OWLObject edgeObject = this.edgeMap.get(edge);
        if (edgeObject != null) {
            this.edgeNameGenerator.reset();
            if (edgeObject instanceof OWLAxiom) {
                ((OWLAxiom)edgeObject).accept((OWLAxiomVisitor)this.edgeNameGenerator);
            } else {
                ((OWLClassExpression)edgeObject).accept((OWLClassExpressionVisitor)this.edgeNameGenerator);
            }
            return this.edgeNameGenerator.direction;
        }
        return -1;
    }

    @Override
    public Object getRelationshipType(Object parentObject, Object childObject) {
        AxiomEdge edge = new AxiomEdge(childObject, parentObject);
        OWLObject edgeObject = this.edgeMap.get(edge);
        if (edgeObject != null) {
            this.edgeNameGenerator.reset();
            if (edgeObject instanceof OWLClassExpression) {
                ((OWLClassExpression)edgeObject).accept((OWLClassExpressionVisitor)this.edgeNameGenerator);
            } else {
                ((OWLAxiom)edgeObject).accept((OWLAxiomVisitor)this.edgeNameGenerator);
            }
            return this.edgeNameGenerator.edgeName;
        }
        return null;
    }

    private void addChildParent(OWLObject child, OWLObject parent, OWLObject ax) {
        this.getIndexedSet(child, this.child2ParentMap, true).add(parent);
        this.getIndexedSet(parent, this.parent2ChildMap, true).add(parent);
        this.nodes.add(child);
        this.nodes.add(parent);
        this.edgeMap.put(new AxiomEdge(child, parent), ax);
        this.edgeMap.put(new AxiomEdge(parent, child), ax);
    }

    public Set<OWLObject> getAllNodes() {
        return this.nodes;
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.addChildParent((OWLObject)axiom.getIndividual(), (OWLObject)axiom.getClassExpression(), (OWLObject)axiom);
        axiom.getClassExpression().accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.addChildParent((OWLObject)axiom.getSubject(), (OWLObject)axiom.getObject(), (OWLObject)axiom);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.addChildParent((OWLObject)axiom.getSubProperty(), (OWLObject)axiom.getSuperProperty(), (OWLObject)axiom);
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        HashSet<OWLClassExpression> added = new HashSet<OWLClassExpression>();
        for (OWLClassExpression descA : axiom.getClassExpressions()) {
            for (OWLClassExpression descB : axiom.getClassExpressions()) {
                if (descA.equals(descB) || added.contains(descA) || added.contains(descB)) continue;
                this.addChildParent((OWLObject)descA, (OWLObject)descB, (OWLObject)axiom);
                added.add(descA);
                added.add(descB);
                descA.accept((OWLClassExpressionVisitor)this);
                descB.accept((OWLClassExpressionVisitor)this);
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression propA : axiom.getProperties()) {
            for (OWLDataPropertyExpression propB : axiom.getProperties()) {
                if (propA.equals(propB)) continue;
                this.addChildParent((OWLObject)propA, (OWLObject)propB, (OWLObject)axiom);
            }
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression propA : axiom.getProperties()) {
            for (OWLObjectPropertyExpression propB : axiom.getProperties()) {
                if (propA.equals(propB)) continue;
                this.addChildParent((OWLObject)propA, (OWLObject)propB, (OWLObject)axiom);
            }
        }
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLClassExpression> added = new HashSet<OWLClassExpression>();
        for (OWLClassExpression descA : axiom.getClassExpressions()) {
            descA.accept((OWLClassExpressionVisitor)this);
            for (OWLClassExpression descB : axiom.getClassExpressions()) {
                if (descA.equals(descB) || added.contains(descA) || added.contains(descB)) continue;
                this.addChildParent((OWLObject)descA, (OWLObject)descB, (OWLObject)axiom);
                descA.accept((OWLClassExpressionVisitor)this);
                descB.accept((OWLClassExpressionVisitor)this);
                added.add(descA);
                added.add(descB);
            }
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression propA : axiom.getProperties()) {
            for (OWLObjectPropertyExpression propB : axiom.getProperties()) {
                if (propA.equals(propB)) continue;
                this.addChildParent((OWLObject)propA, (OWLObject)propB, (OWLObject)axiom);
            }
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    public void visit(OWLImportsDeclaration axiom) {
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    public void visit(OWLHasKeyAxiom owlHasKeyAxiom) {
    }

    public void visit(OWLDatatypeDefinitionAxiom owlDatatypeDefinitionAxiom) {
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.addChildParent((OWLObject)axiom.getSubject(), (OWLObject)axiom.getObject(), (OWLObject)axiom);
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.addChildParent((OWLObject)axiom.getSubProperty(), (OWLObject)axiom.getSuperProperty(), (OWLObject)axiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    public void visit(OWLSameIndividualAxiom axiom) {
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.addChildParent((OWLObject)axiom.getSubClass(), (OWLObject)axiom.getSuperClass(), (OWLObject)axiom);
        axiom.getSubClass().accept((OWLClassExpressionVisitor)this);
        axiom.getSuperClass().accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    public void visit(SWRLRule rule) {
    }

    public void visit(OWLClass desc) {
    }

    public void visit(OWLDataAllValuesFrom desc) {
    }

    public void visit(OWLDataExactCardinality desc) {
    }

    public void visit(OWLDataMaxCardinality desc) {
    }

    public void visit(OWLDataMinCardinality desc) {
    }

    public void visit(OWLDataSomeValuesFrom desc) {
    }

    public void visit(OWLDataHasValue desc) {
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.addChildParent((OWLObject)desc, (OWLObject)desc.getFiller(), (OWLObject)desc);
        ((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectComplementOf desc) {
        this.addChildParent((OWLObject)desc.getOperand(), (OWLObject)desc, (OWLObject)desc);
        desc.getOperand().accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectExactCardinality desc) {
    }

    public void visit(OWLObjectIntersectionOf desc) {
        for (OWLClassExpression op : desc.getOperands()) {
            this.addChildParent((OWLObject)desc, (OWLObject)op, (OWLObject)desc);
            op.accept((OWLClassExpressionVisitor)this);
        }
    }

    public void visit(OWLObjectMaxCardinality desc) {
    }

    public void visit(OWLObjectMinCardinality desc) {
        this.addChildParent((OWLObject)desc, (OWLObject)desc.getFiller(), (OWLObject)desc);
        ((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectOneOf desc) {
        for (OWLIndividual ind : desc.getIndividuals()) {
            this.addChildParent((OWLObject)desc, (OWLObject)ind, (OWLObject)desc);
        }
    }

    public void visit(OWLObjectHasSelf desc) {
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.addChildParent((OWLObject)desc, (OWLObject)desc.getFiller(), (OWLObject)desc);
    }

    public void visit(OWLObjectUnionOf desc) {
        for (OWLClassExpression op : desc.getOperands()) {
            this.addChildParent((OWLObject)desc, (OWLObject)op, (OWLObject)desc);
        }
    }

    public void visit(OWLObjectHasValue desc) {
    }

    public void visit(OWLAnnotationAssertionAxiom owlAnnotationAssertionAxiom) {
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
    }

    public void visit(OWLAnnotationPropertyDomainAxiom owlAnnotationPropertyDomainAxiom) {
    }

    public void visit(OWLAnnotationPropertyRangeAxiom owlAnnotationPropertyRangeAxiom) {
    }

    private class EdgeNameGenerator
    extends OWLAxiomVisitorAdapter
    implements OWLClassExpressionVisitor {
        private String edgeName;
        private int direction;

        private EdgeNameGenerator() {
        }

        public void reset() {
            this.edgeName = "<Don't know>";
            this.direction = 3;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.direction = 3;
            this.edgeName = "is-a";
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.direction = 4;
            this.edgeName = "disjoint-with";
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            this.direction = 3;
            this.edgeName = "instance-of";
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.direction = 4;
            this.edgeName = "equivalent-to";
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualAxiom axiom) {
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLClass desc) {
        }

        public void visit(OWLObjectIntersectionOf desc) {
            this.edgeName = "intesection";
            this.direction = 3;
        }

        public void visit(OWLObjectUnionOf desc) {
            this.edgeName = "union";
            this.direction = 3;
        }

        public void visit(OWLObjectComplementOf desc) {
            this.edgeName = "complementOf";
            this.direction = 2;
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.edgeName = ((OWLObjectPropertyExpression)desc.getProperty()).toString();
        }

        public void visit(OWLObjectAllValuesFrom desc) {
        }

        public void visit(OWLObjectHasValue desc) {
        }

        public void visit(OWLObjectMinCardinality desc) {
        }

        public void visit(OWLObjectExactCardinality desc) {
        }

        public void visit(OWLObjectMaxCardinality desc) {
        }

        public void visit(OWLObjectHasSelf desc) {
        }

        public void visit(OWLObjectOneOf desc) {
        }

        public void visit(OWLDataSomeValuesFrom desc) {
        }

        public void visit(OWLDataAllValuesFrom desc) {
        }

        public void visit(OWLDataHasValue desc) {
        }

        public void visit(OWLDataMinCardinality desc) {
        }

        public void visit(OWLDataExactCardinality desc) {
        }

        public void visit(OWLDataMaxCardinality desc) {
        }
    }

    private class AxiomEdge {
        private Object child;
        private Object parent;

        public AxiomEdge(Object child, Object parent) {
            this.child = child;
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AxiomEdge)) {
                return false;
            }
            AxiomEdge other = (AxiomEdge)obj;
            return other.child.equals(this.child) && other.parent.equals(this.parent);
        }

        public int hashCode() {
            return 19 * this.child.hashCode() + 31 * this.parent.hashCode();
        }
    }
}

