/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import uk.ac.man.cs.mig.coode.owlviz.command.HideAllClassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.HideClassCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.HideSubclassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowClassCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowSubclassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.command.ShowSuperclassesCommand;
import uk.ac.man.cs.mig.coode.owlviz.ui.ConfigurableOWLVizView;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizPreferences;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizSelectionListener;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizSelectionModel;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizViewI;
import uk.ac.man.cs.mig.coode.owlviz.ui.popup.OWLObjectPopupProvider;
import uk.ac.man.cs.mig.coode.owlviz.ui.renderer.OWLClsEdgeRenderer;
import uk.ac.man.cs.mig.coode.owlviz.ui.renderer.OWLClsNodeLabelRenderer;
import uk.ac.man.cs.mig.coode.owlviz.ui.renderer.OWLClsNodeRenderer;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelListener;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedEvent;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedListener;
import uk.ac.man.cs.mig.util.graph.model.GraphModel;
import uk.ac.man.cs.mig.util.graph.ui.GraphComponent;

public class OWLVizGraphPanel
extends JPanel {
    private static final long serialVersionUID = -2768708431965401557L;
    private GraphComponent graphComponent;
    private OWLVizViewI view;
    private JPopupMenu popupMenu;
    private OWLEditorKit owlEditorKit;
    private OWLVizSelectionListener owlVizSelectionListener;

    public OWLVizGraphPanel(OWLVizViewI view, OWLEditorKit owlEditorKit, GraphModel graphModel) {
        this("Unnamed", view, owlEditorKit, graphModel);
    }

    public OWLVizGraphPanel(String name, OWLVizViewI view, OWLEditorKit owlEditorKit, GraphModel graphModel) {
        this.view = view;
        this.owlEditorKit = owlEditorKit;
        this.graphComponent = new GraphComponent(name);
        this.graphComponent.setGraphModel(graphModel);
        this.graphComponent.setNodeLabelRenderer(new OWLClsNodeLabelRenderer(this.getOWLModelManager()));
        this.graphComponent.setNodeRenderer(new OWLClsNodeRenderer(this.graphComponent.getController(), this.graphComponent.getVisualisedObjectManager(), new OWLClsNodeLabelRenderer(this.getOWLModelManager()), this.getOWLModelManager()));
        this.graphComponent.setEdgeRenderer(new OWLClsEdgeRenderer(this.graphComponent.getController()));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.graphComponent);
        OWLObjectPopupProvider popupProvider = new OWLObjectPopupProvider(name, owlEditorKit);
        this.graphComponent.setPopupProvider(popupProvider);
        this.createPopupMenu();
        this.setupListeners();
        this.setLayout(new BorderLayout());
        this.add(panel);
    }

    protected void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add((Action)((Object)new ShowClassCommand(this.view, this.getOWLModelManager(), (Frame)SwingUtilities.getRoot(this))));
        this.popupMenu.add((Action)((Object)new ShowSubclassesCommand(this.view)));
        this.popupMenu.add((Action)((Object)new ShowSuperclassesCommand(this.view)));
        this.popupMenu.add((Action)((Object)new HideClassCommand(this.view)));
        this.popupMenu.add((Action)((Object)new HideSubclassesCommand(this.view)));
        this.popupMenu.add((Action)((Object)new HideAllClassesCommand(this.view)));
        this.popupMenu.addSeparator();
    }

    public String getName() {
        return this.graphComponent.getName();
    }

    public GraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    protected void setupListeners() {
        this.graphComponent.getGraphView().addNodeClickedListener(new NodeClickedListener(){

            public void nodeClicked(NodeClickedEvent evt) {
                Object selObj;
                if (evt.getMouseEvent().getClickCount() != 2 || (selObj = OWLVizGraphPanel.this.graphComponent.getSelectedObject()) == null || selObj instanceof OWLEntity) {
                    // empty if block
                }
            }
        });
        this.graphComponent.addGraphSelectionModelListener(new GraphSelectionModelListener(){

            public void selectionChanged(GraphSelectionModelEvent event) {
                OWLVizGraphPanel.this.view.getSelectionModel().setSelectedClass((OWLClass)event.getSource().getSelectedObject());
            }
        });
        this.owlVizSelectionListener = new OWLVizSelectionListener(){

            public void selectionChanged(OWLVizSelectionModel model) {
                if (model.getSelectedClass() != null) {
                    if (OWLVizGraphPanel.this.isTracker()) {
                        OWLVizGraphPanel.this.getGraphComponent().getVisualisedObjectManager().hideAll();
                        OWLVizGraphPanel.this.getGraphComponent().getVisualisedObjectManager().showObject(model.getSelectedClass(), OWLVizGraphPanel.this.getTrackerRadius(), OWLClass.class);
                    }
                    OWLVizGraphPanel.this.getGraphComponent().getGraphSelectionModel().setSelectedObject(model.getSelectedClass());
                }
            }
        };
        this.view.getSelectionModel().addSelectionListener(this.owlVizSelectionListener);
        this.getGraphComponent().getGraphView().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            private void showPopupMenu(MouseEvent e) {
                OWLVizGraphPanel.this.popupMenu.show(OWLVizGraphPanel.this.getGraphComponent().getGraphView(), e.getPoint().x, e.getPoint().y);
            }
        });
    }

    private boolean isTracker() {
        if (this.view instanceof ConfigurableOWLVizView) {
            return ((ConfigurableOWLVizView)((Object)this.view)).getOptions().isTrackerMode();
        }
        return OWLVizPreferences.getInstance().isTrackingModeDefault();
    }

    private int getTrackerRadius() {
        if (this.view instanceof ConfigurableOWLVizView) {
            return ((ConfigurableOWLVizView)((Object)this.view)).getOptions().getTrackerRadius();
        }
        return OWLVizPreferences.getInstance().getDefaultTrackerRadius();
    }

    public void dispose() {
        this.view.getSelectionModel().removeSelectionListener(this.owlVizSelectionListener);
    }

    protected OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }
}

