/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.FilteringOWLOntologyChangeListener;
import uk.ac.man.cs.mig.coode.owlviz.model.OWLOntologyImportsGraphModel;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.impl.DefaultController;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedEvent;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedListener;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultNodeRenderer;
import uk.ac.man.cs.mig.util.graph.ui.GraphView;

public class OWLVizImportsViewComponent
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = -5980617789951116427L;
    private Controller controller;
    private OWLModelManagerListener owlModelManagerListener;
    private OWLOntologyChangeListener changeListener;
    private boolean dirty;

    protected void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        this.controller = new DefaultController(new OWLOntologyImportsGraphModel(this.getOWLModelManager()));
        this.setupRenderers();
        this.setupListeners();
        this.setLayout(new BorderLayout());
        this.add(ComponentFactory.createScrollPane((JComponent)this.controller.getGraphView()), "Center");
        this.controller.getVisualisedObjectManager().showObjects(this.getOWLModelManager().getOntologies().toArray());
        this.dirty = true;
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (OWLVizImportsViewComponent.this.isShowing() && OWLVizImportsViewComponent.this.dirty) {
                    OWLVizImportsViewComponent.this.rebuild();
                }
            }
        });
    }

    private void setupRenderers() {
        this.controller.setNodeLabelRenderer(new NodeLabelRenderer(){

            public String getLabel(Node node) {
                OWLOntology ont = (OWLOntology)node.getUserObject();
                String label = ont.getOntologyID().getDefaultDocumentIRI().toString();
                label = label.substring(label.lastIndexOf("/") + 1);
                return label;
            }
        });
        this.controller.setNodeRenderer(new DefaultNodeRenderer(this.controller){
            private Color lineColor;
            private Color activeOntologyFillColor;
            public Color activeOntologiesLineColor;
            {
                this.lineColor = Color.LIGHT_GRAY;
                this.activeOntologyFillColor = new Color(205, 220, 243);
                this.activeOntologiesLineColor = OWLSystemColors.getOWLOntologyColor();
            }

            protected Color getFillColor(Node node) {
                if (node.getUserObject().equals(OWLVizImportsViewComponent.this.getOWLModelManager().getActiveOntology())) {
                    return this.activeOntologyFillColor;
                }
                return Color.WHITE;
            }

            protected Color getLineColor(Node node) {
                if (OWLVizImportsViewComponent.this.getOWLModelManager().getActiveOntologies().contains(node.getUserObject())) {
                    return this.activeOntologiesLineColor;
                }
                return this.lineColor;
            }
        });
    }

    private void setupListeners() {
        GraphView graphView = this.controller.getGraphView();
        graphView.addNodeClickedListener(new NodeClickedListener(){

            public void nodeClicked(NodeClickedEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt.getMouseEvent())) {
                    OWLVizImportsViewComponent.this.showPopupMenu(evt);
                } else if (evt.getMouseEvent().getClickCount() == 2) {
                    OWLOntology ont = (OWLOntology)evt.getNode().getUserObject();
                    OWLVizImportsViewComponent.this.getOWLModelManager().setActiveOntology(ont);
                }
            }
        });
        this.changeListener = new FilteringOWLOntologyChangeListener(){

            public void visit(OWLImportsDeclaration axiom) {
                OWLVizImportsViewComponent.this.rebuild();
            }
        };
        this.getOWLModelManager().addOntologyChangeListener(this.changeListener);
        this.owlModelManagerListener = new OWLModelManagerListener(){

            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                    OWLVizImportsViewComponent.this.rebuild();
                }
            }
        };
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
    }

    private void rebuild() {
        if (this.isShowing()) {
            ((OWLOntologyImportsGraphModel)this.controller.getGraphModel()).rebuild();
            this.controller.getVisualisedObjectManager().hideAll();
            this.controller.getVisualisedObjectManager().showObjects(this.getOWLModelManager().getOntologies().toArray());
            this.dirty = false;
        } else {
            this.dirty = true;
        }
    }

    private void showPopupMenu(final NodeClickedEvent evt) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction("Set as active ontology"){
            private static final long serialVersionUID = -4667228625396255625L;

            public void actionPerformed(ActionEvent e) {
                OWLOntology ont = (OWLOntology)evt.getNode().getUserObject();
                OWLVizImportsViewComponent.this.getOWLModelManager().setActiveOntology(ont);
            }
        });
        popupMenu.show(this.controller.getGraphView(), evt.getMouseEvent().getX(), evt.getMouseEvent().getY());
    }

    protected void disposeOWLView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.changeListener);
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
    }
}

