/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.exportwizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import uk.ac.man.cs.mig.coode.owlviz.ui.exportwizard.SelectFormatPage;
import uk.ac.man.cs.mig.util.wizard.Wizard;
import uk.ac.man.cs.mig.util.wizard.WizardPage;

public class SpecifyFileNamePage
extends WizardPage {
    private static final long serialVersionUID = 9039429372022547256L;
    private JTextField pathNameField;
    private JFileChooser chooser;
    private FileFilter prevFileFilter;

    public SpecifyFileNamePage() {
        super("SpecifyFileNamePage");
        this.add(this.createUI());
        this.chooser = new JFileChooser();
    }

    protected JComponent createUI() {
        JPanel component = new JPanel(new BorderLayout(12, 12));
        JPanel panel = new JPanel(new BorderLayout(12, 12));
        JLabel label = new JLabel("Please specify the location and name of the file to export to.");
        panel.add((Component)label, "North");
        JPanel entryPanel = new JPanel(new BorderLayout(12, 12));
        this.pathNameField = new JTextField();
        this.pathNameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                SpecifyFileNamePage.this.setWizardButtonState();
            }
        });
        entryPanel.add((Component)this.pathNameField, "Center");
        JButton browseButton = new JButton(new AbstractAction("Browse"){
            private static final long serialVersionUID = 5129314412137596015L;

            public void actionPerformed(ActionEvent e) {
                SpecifyFileNamePage.this.browseForFileName();
                SpecifyFileNamePage.this.setWizardButtonState();
            }
        });
        entryPanel.add((Component)browseButton, "East");
        panel.add((Component)entryPanel, "South");
        component.add((Component)panel, "North");
        return component;
    }

    public String getFileName() {
        return this.pathNameField.getText();
    }

    public void pageSelected(Wizard w) {
        this.setWizardButtonState();
    }

    protected void browseForFileName() {
        String formatDescription;
        String fileExtension;
        SelectFormatPage formatPage = (SelectFormatPage)this.getWizard().getPage("SelectFormatPage");
        if (formatPage != null) {
            fileExtension = formatPage.getSelectedExportFormat().getFormatFileExtension();
            formatDescription = formatPage.getSelectedExportFormat().getFormatDescription();
        } else {
            fileExtension = "";
            formatDescription = "";
        }
        if (this.prevFileFilter != null) {
            this.chooser.removeChoosableFileFilter(this.prevFileFilter);
        }
        this.prevFileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith("." + fileExtension);
            }

            public String getDescription() {
                return formatDescription;
            }
        };
        this.chooser.setFileFilter(this.prevFileFilter);
        if (this.chooser.showSaveDialog(this.getWizard()) == 0) {
            int ret;
            File file = this.chooser.getSelectedFile();
            if (file.exists() && (ret = JOptionPane.showConfirmDialog(this.getWizard(), "Warning: The selected file already exists.  Do you wish to overwrite it?", "File Exists", 0, 2)) == 1) {
                return;
            }
            String pathName = this.chooser.getSelectedFile().getPath();
            if (!pathName.endsWith("." + fileExtension)) {
                pathName = pathName + "." + fileExtension;
            }
            this.pathNameField.setText(pathName);
            this.setWizardButtonState();
        }
    }

    protected void setWizardButtonState() {
        String pathName = this.pathNameField.getText();
        if ((pathName = pathName.trim()).length() > 0) {
            this.getWizard().setNextButtonEnabled(true);
        } else {
            this.getWizard().setNextButtonEnabled(false);
        }
    }
}

