/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizPreferences;

public class ModeOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 7579720925137626641L;
    private JRadioButton trackerMode;
    private JRadioButton configureMode;
    private JSpinner trackerRadiusSpinner;
    ActionListener l = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            ModeOptionsPanel.this.trackerRadiusSpinner.setEnabled(ModeOptionsPanel.this.trackerMode.isSelected());
        }
    };

    public ModeOptionsPanel() {
        this.setLayout(new BorderLayout());
        int radius = OWLVizPreferences.getInstance().getDefaultTrackerRadius();
        boolean isTrackerMode = OWLVizPreferences.getInstance().isTrackingModeDefault();
        this.trackerRadiusSpinner = new JSpinner(new SpinnerNumberModel(radius, 1, 100, 1));
        this.trackerRadiusSpinner.setEnabled(isTrackerMode);
        this.trackerMode = new JRadioButton("track selection", isTrackerMode);
        this.configureMode = new JRadioButton("create graph manually", !isTrackerMode);
        this.configureMode.setAlignmentX(0.0f);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.trackerMode);
        bg.add(this.configureMode);
        Box trackerPanel = new Box(2);
        trackerPanel.add(this.trackerMode);
        trackerPanel.add(Box.createHorizontalStrut(20));
        trackerPanel.add(new JLabel("radius"));
        trackerPanel.add(this.trackerRadiusSpinner);
        trackerPanel.setAlignmentX(0.0f);
        Box box = new Box(3);
        box.add(trackerPanel);
        box.add(this.configureMode);
        this.add((Component)box, "North");
        this.trackerMode.addActionListener(this.l);
        this.configureMode.addActionListener(this.l);
    }

    public void setTrackerMode(boolean tracker) {
        this.trackerMode.setSelected(tracker);
        this.configureMode.setSelected(!tracker);
    }

    public void setTrackerRadius(int trackerRadius) {
        this.trackerRadiusSpinner.setValue(trackerRadius);
    }

    public boolean isTrackerMode() {
        return this.trackerMode.isSelected();
    }

    public int getTrackerRadius() {
        return (Integer)this.trackerRadiusSpinner.getValue();
    }
}

