/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class OWLVizProperties {
    public static final String FILE_ROOT = "plugins/uk.ac.man.cs.mig.coode.owlviz";
    public static final String PROPERTY_FILE_PATH_NAME = "plugins/uk.ac.man.cs.mig.coode.owlviz/OWLVizProperties";
    public static final String DOT_PATH = "OWLViz.DOT.DotPath";
    public static final String RANK_SPACING = "OWLViz.DOT.RankSpacing";
    public static final String SIBLING_SPACING = "OWLViz.DOT.SiblingSpacing";
    public static final String LAYOUT_DIRECTION = "OWLViz.DOT.LayoutDirection";
    public static final String DISPLAY_DISJOINT_INDICATOR = "OWLViz.DisplayDisjointClassIndicator";
    public static final String DISPLAY_INDIVIDUALS = "OWLViz.DisplayIndividuals";
    public static final String DISPLAY_ANONYMOUS_CLASSES = "OWLViz.DisplayAnonymousClasses";
    public static final String POPUP_DISPLAY_PAGE = "OWLViz.PopupDisplayPage";
    public static final String EDGE_BRIGHTNESS = "OWLViz.EdgeBrightness";
    public static final String GROUP_CLASSES_BY_NAMESPACE = "OWLViz.GroupClassesByNamespace";
    public static final String DISPLAY_IS_A_LABELS = "OWLViz.DisplayIsALabels";
    private static OWLVizProperties owlVizProperties = null;
    private Properties properties = new Properties();
    private ArrayList<WeakReference<PropertyChangeListener>> listeners;

    private OWLVizProperties() {
        this.properties.setProperty(DISPLAY_ANONYMOUS_CLASSES, Boolean.FALSE.toString());
        this.properties.setProperty(DISPLAY_DISJOINT_INDICATOR, Boolean.TRUE.toString());
        this.properties.setProperty(DISPLAY_INDIVIDUALS, Boolean.FALSE.toString());
        this.properties.setProperty(EDGE_BRIGHTNESS, Double.toString(0.5));
        this.properties.setProperty(POPUP_DISPLAY_PAGE, "Conditions");
        this.properties.setProperty(GROUP_CLASSES_BY_NAMESPACE, Boolean.FALSE.toString());
        this.properties.setProperty(LAYOUT_DIRECTION, Integer.toString(1));
        this.properties.setProperty(RANK_SPACING, Double.toString(1.0));
        this.properties.setProperty(SIBLING_SPACING, Double.toString(0.2));
        this.listeners = new ArrayList();
    }

    public static OWLVizProperties getProperties() {
        if (owlVizProperties == null) {
            owlVizProperties = new OWLVizProperties();
        }
        return owlVizProperties;
    }

    public String getProperty(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public void setProperty(String propertyName, String newValue) {
        this.properties.put(propertyName, newValue);
    }

    public boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        String value = this.getProperty(propertyName, null);
        if (value == null) {
            return defaultValue;
        }
        boolean booleanValue = Boolean.getBoolean(value);
        return booleanValue;
    }

    public void setBooleanProperty(String propertyName, boolean newValue) {
        this.setProperty(propertyName, Boolean.toString(newValue));
    }

    public int getIntProperty(String propertyName, int defaultValue) {
        String value = this.getProperty(propertyName, null);
        if (value == null) {
            return defaultValue;
        }
        int intValue = Integer.parseInt(value);
        return intValue;
    }

    public void setIntProperty(String propertyName, int newValue) {
        this.setProperty(propertyName, Integer.toString(newValue));
    }

    public double getDoubleProperty(String propertyName, double defaultValue) {
        String value = this.getProperty(propertyName, null);
        if (value == null) {
            return defaultValue;
        }
        double doubleValue = Double.parseDouble(value);
        return doubleValue;
    }

    public void setDoubleProperty(String propertyName, double newValue) {
        this.setProperty(propertyName, Double.toString(newValue));
    }

    public void loadProperties() {
        try {
            FileInputStream fis = new FileInputStream(PROPERTY_FILE_PATH_NAME);
            this.properties.load(fis);
        }
        catch (FileNotFoundException fnfEx) {
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public void saveProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(PROPERTY_FILE_PATH_NAME);
            this.properties.store(fos, "OWLViz Properties");
        }
        catch (FileNotFoundException fnfEx) {
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener lsnr) {
        this.listeners.add(new WeakReference<PropertyChangeListener>(lsnr));
    }

    public void removePropertyChangeListener(PropertyChangeListener lsnr) {
        Iterator<WeakReference<PropertyChangeListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference<PropertyChangeListener> ref = it.next();
            if (ref.get() != lsnr) continue;
            it.remove();
            break;
        }
    }

    protected void firePropertyChangeEvent(String propertyName, String oldValue, String newValue) {
        Iterator<WeakReference<PropertyChangeListener>> it = this.listeners.iterator();
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        while (it.hasNext()) {
            WeakReference<PropertyChangeListener> ref = it.next();
            if (ref.get() != null) {
                ((PropertyChangeListener)ref.get()).propertyChange(evt);
                continue;
            }
            it.remove();
        }
    }
}

