/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.util.ArrayList;
import java.util.Iterator;
import uk.ac.man.cs.mig.coode.owlviz.ui.OWLVizPreferences;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OptionsChangedListener;

public class OWLVizViewOptions {
    private boolean displayAnonymousClasses = false;
    private boolean displayIndividuals = false;
    private boolean groupClassesByNameSpace = false;
    private boolean displayDisjointClassIndicator = true;
    private boolean displayIsALabels = false;
    private double edgeBrightness = 0.5;
    private boolean trackerMode;
    private ArrayList<OptionsChangedListener> listeners = new ArrayList();
    private int trackerRadius = OWLVizPreferences.getInstance().getDefaultTrackerRadius();

    public OWLVizViewOptions() {
        this.trackerMode = OWLVizPreferences.getInstance().isTrackingModeDefault();
    }

    public boolean isDisplayAnonymousClasses() {
        return this.displayAnonymousClasses;
    }

    public void setDisplayAnonymousClasses(boolean displayAnonymousClasses) {
        this.displayAnonymousClasses = displayAnonymousClasses;
        if (displayAnonymousClasses) {
            this.displayIndividuals = true;
        }
        this.fireOptionsChangedEvent();
    }

    public boolean isDisplayIndividuals() {
        return this.displayIndividuals;
    }

    public void setDisplayIndividuals(boolean displayIndividuals) {
        if (this.displayAnonymousClasses) {
            displayIndividuals = true;
        } else {
            this.displayIndividuals = displayIndividuals;
        }
        this.fireOptionsChangedEvent();
    }

    public boolean isGroupClassesByNameSpace() {
        return this.groupClassesByNameSpace;
    }

    public void setGroupClassesByNameSpace(boolean groupClassesByNameSpace) {
        this.groupClassesByNameSpace = groupClassesByNameSpace;
        this.fireOptionsChangedEvent();
    }

    public boolean isDisplayDisjointClassIndicator() {
        return this.displayDisjointClassIndicator;
    }

    public void setDisplayDisjointClassIndicator(boolean displayDisjointClassIndicator) {
        this.displayDisjointClassIndicator = displayDisjointClassIndicator;
        this.fireOptionsChangedEvent();
    }

    public double getEdgeBrightness() {
        return this.edgeBrightness;
    }

    public void setEdgeBrightness(double edgeBrightness) {
        this.edgeBrightness = edgeBrightness;
        this.fireOptionsChangedEvent();
    }

    public boolean isDisplayIsALabels() {
        return this.displayIsALabels;
    }

    public void setDisplayIsALabels(boolean displayIsALabels) {
        this.displayIsALabels = displayIsALabels;
    }

    public void addOptionsChangedListener(OptionsChangedListener lsnr) {
        if (!this.listeners.contains(lsnr)) {
            this.listeners.add(lsnr);
        }
    }

    public void removeOptionsChangedListener(OptionsChangedListener lsnr) {
        this.listeners.remove(lsnr);
    }

    protected void fireOptionsChangedEvent() {
        Iterator<OptionsChangedListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().optionsChanged();
        }
    }

    public boolean isTrackerMode() {
        return this.trackerMode;
    }

    public void setTrackerMode(boolean trackerMode) {
        this.trackerMode = trackerMode;
        this.fireOptionsChangedEvent();
    }

    public int getTrackerRadius() {
        return this.trackerRadius;
    }

    public void setTrackerRadius(int trackerRadius) {
        this.trackerRadius = trackerRadius;
        this.fireOptionsChangedEvent();
    }
}

