/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.coode.owlviz.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OWLVizProperties;
import uk.ac.man.cs.mig.coode.owlviz.ui.options.OptionsPage;

public class UIOptionsPage
extends OptionsPage {
    private static final long serialVersionUID = 4037503268140748846L;
    JCheckBox displayPopupCheckBox;
    JComboBox popupCombo;
    JSlider edgeBrightness;

    public UIOptionsPage() {
        this.setLayout(new BorderLayout());
        this.add(this.createUI());
    }

    protected JComponent createUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(7, 7, 7, 7), 0, 0);
        panel.setBorder(BorderFactory.createTitledBorder("Popup"));
        this.displayPopupCheckBox = new JCheckBox("Display popup information");
        this.displayPopupCheckBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                UIOptionsPage.this.setComponentState();
            }
        });
        panel.add((Component)this.displayPopupCheckBox, gbc);
        this.popupCombo = new JComboBox();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)this.popupCombo, gbc);
        JPanel component = new JPanel();
        component.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        component.add((Component)panel, gbc);
        this.edgeBrightness = new JSlider(0, 100);
        this.edgeBrightness.setBorder(BorderFactory.createTitledBorder("Edge brightness"));
        this.edgeBrightness.setMajorTickSpacing(50);
        this.edgeBrightness.setMinorTickSpacing(10);
        this.edgeBrightness.setPaintTicks(true);
        this.edgeBrightness.setPaintTrack(true);
        this.edgeBrightness.setPaintLabels(true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        component.add((Component)this.edgeBrightness, gbc);
        return component;
    }

    public void setComponentState() {
        if (this.displayPopupCheckBox.isSelected()) {
            this.popupCombo.setEnabled(true);
        } else {
            this.popupCombo.setEnabled(false);
        }
    }

    public void applyOptions() {
    }

    public void updateInterface() {
        Object curPopupPage = null;
        if (curPopupPage == null) {
            this.displayPopupCheckBox.setSelected(false);
            this.popupCombo.setEnabled(false);
        } else {
            this.displayPopupCheckBox.setSelected(true);
            this.popupCombo.setEnabled(true);
            this.popupCombo.setSelectedItem(curPopupPage);
        }
        this.edgeBrightness.setValue((int)(100.0 * OWLVizProperties.getProperties().getDoubleProperty("OWLViz.EdgeBrightness", 0.5)));
        this.setComponentState();
    }

    public void validateOptions() {
    }
}

