/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.controller.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.GraphGenerator;
import uk.ac.man.cs.mig.util.graph.controller.GraphSelectionModel;
import uk.ac.man.cs.mig.util.graph.controller.VisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.controller.impl.DefaultGraphGenerator;
import uk.ac.man.cs.mig.util.graph.controller.impl.DefaultGraphSelectionModel;
import uk.ac.man.cs.mig.util.graph.controller.impl.DefaultVisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorListener;
import uk.ac.man.cs.mig.util.graph.event.GraphModelListener;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelListener;
import uk.ac.man.cs.mig.util.graph.event.VisualisedObjectManagerListener;
import uk.ac.man.cs.mig.util.graph.factory.EdgeFactory;
import uk.ac.man.cs.mig.util.graph.factory.GraphFactory;
import uk.ac.man.cs.mig.util.graph.factory.NodeFactory;
import uk.ac.man.cs.mig.util.graph.factory.impl.DefaultEdgeFactory;
import uk.ac.man.cs.mig.util.graph.factory.impl.DefaultGraphFactory;
import uk.ac.man.cs.mig.util.graph.factory.impl.DefaultNodeFactory;
import uk.ac.man.cs.mig.util.graph.layout.GraphLayoutEngine;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.DotGraphLayoutEngine;
import uk.ac.man.cs.mig.util.graph.model.GraphModel;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultEdgeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultEdgeRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultNodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.impl.DefaultNodeRenderer;
import uk.ac.man.cs.mig.util.graph.ui.GraphView;
import uk.ac.man.cs.mig.util.graph.ui.impl.DefaultGraphView;

public class DefaultController
implements Controller {
    private GraphModel graphModel;
    private VisualisedObjectManager visualisedObjectManager;
    private GraphSelectionModel graphSelectionModel;
    private GraphGenerator graphGenerator;
    private GraphLayoutEngine graphLayoutEngine;
    private GraphView graphView;
    private EdgeFactory edgeFactory;
    private NodeFactory nodeFactory;
    private GraphFactory graphFactory;
    private NodeRenderer nodeRenderer;
    private NodeLabelRenderer nodeLabelRenderer;
    private EdgeRenderer edgeRenderer;
    private EdgeLabelRenderer edgeLabelRenderer;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();

    public DefaultController(GraphModel model) {
        this.graphModel = model;
        this.visualisedObjectManager = new DefaultVisualisedObjectManager(model);
        this.graphFactory = new DefaultGraphFactory();
        this.nodeFactory = new DefaultNodeFactory();
        this.edgeFactory = new DefaultEdgeFactory(this);
        this.graphLayoutEngine = new DotGraphLayoutEngine();
        this.nodeLabelRenderer = new DefaultNodeLabelRenderer();
        this.nodeRenderer = new DefaultNodeRenderer(this);
        this.edgeRenderer = new DefaultEdgeRenderer(this);
        this.edgeLabelRenderer = new DefaultEdgeLabelRenderer();
        this.graphGenerator = new DefaultGraphGenerator(this, this.visualisedObjectManager, this.graphFactory, this.nodeFactory, this.edgeFactory, this.nodeRenderer);
        this.graphSelectionModel = new DefaultGraphSelectionModel();
        this.graphView = new DefaultGraphView(this, this.nodeRenderer, this.edgeRenderer);
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public void setGraphModel(GraphModel model) {
        if (model == null) {
            throw new NullPointerException("GraphModel must not be null");
        }
        GraphModel oldValue = this.graphModel;
        Iterator<GraphModelListener> it = this.graphModel.getListeners();
        while (it.hasNext()) {
            GraphModelListener lsnr = it.next();
            model.addGraphModelListener(lsnr);
            it.remove();
        }
        this.graphModel = model;
        this.visualisedObjectManager.setGraphModel(this.graphModel);
        this.firePropertyChangeEvent("graphModel", oldValue, this.graphModel);
    }

    public GraphLayoutEngine getGraphLayoutEngine() {
        return this.graphLayoutEngine;
    }

    public void setGraphLayoutEngine(GraphLayoutEngine layoutEngine) {
        if (layoutEngine == null) {
            throw new NullPointerException("GraphLayoutEngine must not be null");
        }
        GraphLayoutEngine oldValue = this.graphLayoutEngine;
        this.graphLayoutEngine = layoutEngine;
        this.firePropertyChangeEvent("graphLayoutEngine", oldValue, this.graphLayoutEngine);
    }

    public GraphSelectionModel getGraphSelectionModel() {
        return this.graphSelectionModel;
    }

    public void setGraphSelectionModel(GraphSelectionModel model) {
        if (model == null) {
            throw new NullPointerException("GraphSelectionModel must not be null");
        }
        GraphSelectionModel oldGraphSelectionModel = this.graphSelectionModel;
        this.graphSelectionModel = model;
        Object[] selObjs = oldGraphSelectionModel.getSelectedObjects();
        Iterator it = oldGraphSelectionModel.getListeners();
        while (it.hasNext()) {
            GraphSelectionModelListener lsnr = (GraphSelectionModelListener)it.next();
            this.graphSelectionModel.addGraphSelectionModelListener(lsnr);
            it.remove();
        }
        for (int i = 0; i < selObjs.length; ++i) {
            this.graphSelectionModel.setSelectedObject(selObjs[i]);
        }
        this.firePropertyChangeEvent("graphSelectionModel", oldGraphSelectionModel, this.graphSelectionModel);
    }

    public VisualisedObjectManager getVisualisedObjectManager() {
        return this.visualisedObjectManager;
    }

    public void setVisualisedObjectManager(VisualisedObjectManager manager) {
        if (manager == null) {
            throw new NullPointerException("VisualisedObjectManager must not be null");
        }
        VisualisedObjectManager oldVisualisedObjectManager = this.visualisedObjectManager;
        Iterator it = oldVisualisedObjectManager.getVisualisedObjectManagerListeners();
        this.visualisedObjectManager = manager;
        while (it.hasNext()) {
            VisualisedObjectManagerListener lsnr = (VisualisedObjectManagerListener)it.next();
            this.visualisedObjectManager.addVisualisedObjectManagerListener(lsnr);
            it.remove();
        }
        this.visualisedObjectManager.setGraphModel(this.graphModel);
        this.firePropertyChangeEvent("visualisedObjectManager", oldVisualisedObjectManager, this.visualisedObjectManager);
    }

    public GraphGenerator getGraphGenerator() {
        return this.graphGenerator;
    }

    public void setGraphGenerator(GraphGenerator generator) {
        if (generator == null) {
            throw new NullPointerException("GraphGenerator must not be null");
        }
        GraphGenerator oldGraphGenerator = this.graphGenerator;
        this.graphGenerator = generator;
        Iterator it = oldGraphGenerator.getGraphGeneratorListeners();
        while (it.hasNext()) {
            GraphGeneratorListener lsnr = (GraphGeneratorListener)it.next();
            this.graphGenerator.addGraphGeneratorListener(lsnr);
            it.remove();
        }
        this.firePropertyChangeEvent("graphGenerator", oldGraphGenerator, this.graphGenerator);
    }

    public GraphView getGraphView() {
        return this.graphView;
    }

    public void setGraphView(GraphView view) {
        if (view == null) {
            throw new NullPointerException("GraphView must not be null");
        }
        GraphView oldGraphView = this.graphView;
        this.graphView = view;
        this.firePropertyChangeEvent("graphView", oldGraphView, this.graphView);
    }

    public void setGraphFactory(GraphFactory factory) {
        if (factory == null) {
            throw new NullPointerException("GraphFactory must not be null");
        }
        GraphFactory oldGraphFactory = this.graphFactory;
        this.graphFactory = factory;
        this.firePropertyChangeEvent("graphFactory", oldGraphFactory, this.graphFactory);
    }

    public GraphFactory getGraphFactory() {
        return this.graphFactory;
    }

    public void setEdgeFactory(EdgeFactory factory) {
        if (factory == null) {
            throw new NullPointerException("EdgeFactory must not be null");
        }
        EdgeFactory oldValue = this.edgeFactory;
        this.edgeFactory = factory;
        this.firePropertyChangeEvent("edgeFactory", oldValue, this.edgeFactory);
    }

    public EdgeFactory getEdgeFactory() {
        return this.edgeFactory;
    }

    public void setNodeFactory(NodeFactory factory) {
        if (factory == null) {
            throw new NullPointerException("NodeFactory must not be null");
        }
        NodeFactory oldValue = this.nodeFactory;
        this.nodeFactory = factory;
        this.firePropertyChangeEvent("nodeFactory", oldValue, this.nodeFactory);
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeRenderer(NodeRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException("NodeRenderer must not be null");
        }
        NodeRenderer oldValue = this.nodeRenderer;
        this.nodeRenderer = renderer;
        this.graphView.setNodeRenderer(this.nodeRenderer);
        this.firePropertyChangeEvent("nodeRenderer", oldValue, this.nodeRenderer);
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeLabelRenderer(NodeLabelRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException("NodeLabelRenderer must not be null");
        }
        NodeLabelRenderer oldValue = this.nodeLabelRenderer;
        this.nodeLabelRenderer = renderer;
        this.firePropertyChangeEvent("nodeLabelRenderer", oldValue, this.nodeLabelRenderer);
    }

    public NodeLabelRenderer getNodeLabelRenderer() {
        return this.nodeLabelRenderer;
    }

    public EdgeLabelRenderer getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    public void setEdgeLabelRenderer(EdgeLabelRenderer edgeLabelRenderer) {
        if (edgeLabelRenderer == null) {
            throw new NullPointerException("EdgeLabelRenderer must not be null");
        }
        EdgeLabelRenderer oldValue = this.edgeLabelRenderer;
        this.edgeLabelRenderer = edgeLabelRenderer;
        this.firePropertyChangeEvent("edgeLabelRenderer", oldValue, this.edgeLabelRenderer);
    }

    public void setEdgeRenderer(EdgeRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException("EdgeRenderer must not be null");
        }
        EdgeRenderer oldValue = this.edgeRenderer;
        this.edgeRenderer = renderer;
        this.graphView.setEdgeRenderer(this.edgeRenderer);
        this.firePropertyChangeEvent("edgeRenderer", oldValue, this.edgeRenderer);
    }

    public EdgeRenderer getEdgeRenderer() {
        return this.edgeRenderer;
    }

    public void addPropertyChangeListener(PropertyChangeListener lsnr) {
        this.listeners.add(lsnr);
    }

    public void removePropertyChangeListener(PropertyChangeListener lsnr) {
        this.listeners.remove(lsnr);
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        Iterator<PropertyChangeListener> it = new ArrayList<PropertyChangeListener>(this.listeners).iterator();
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        while (it.hasNext()) {
            PropertyChangeListener pcl = it.next();
            pcl.propertyChange(evt);
        }
    }
}

