/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.controller.impl;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.GraphGenerator;
import uk.ac.man.cs.mig.util.graph.controller.VisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorListener;
import uk.ac.man.cs.mig.util.graph.event.VisualisedObjectManagerEvent;
import uk.ac.man.cs.mig.util.graph.event.VisualisedObjectManagerListener;
import uk.ac.man.cs.mig.util.graph.factory.EdgeFactory;
import uk.ac.man.cs.mig.util.graph.factory.GraphFactory;
import uk.ac.man.cs.mig.util.graph.factory.NodeFactory;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.model.GraphModel;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;

public class DefaultGraphGenerator
implements GraphGenerator {
    private static Logger log = Logger.getLogger(DefaultGraphGenerator.class);
    private Graph graph;
    private VisualisedObjectManager visualisedObjectManager;
    private VisualisedObjectManagerListener visualisedObjectManagerListener;
    private GraphFactory graphFactory;
    private NodeFactory nodeFactory;
    private EdgeFactory edgeFactory;
    private NodeRenderer nodeRenderer;
    private Controller controller;
    private boolean rebuildGraph = true;
    private boolean recreateNodes = false;
    private Map<Object, Node> nodeMap;
    private ArrayList listeners;
    private GraphGeneratorEvent graphChangedEvent;

    public DefaultGraphGenerator(Controller controller, VisualisedObjectManager visualisedObjectManager, GraphFactory graphFactory, NodeFactory nodeFactory, EdgeFactory edgeFactory, NodeRenderer nodeRenderer) {
        if (controller == null) {
            throw new NullPointerException("Controller must not be null");
        }
        if (visualisedObjectManager == null) {
            throw new NullPointerException("VisualisedObjectManager must not be null");
        }
        if (graphFactory == null) {
            throw new NullPointerException("GraphFactory must not be null");
        }
        if (nodeFactory == null) {
            throw new NullPointerException("NodeFactory must not be null");
        }
        if (edgeFactory == null) {
            throw new NullPointerException("EdgeFactory must not be null");
        }
        if (nodeRenderer == null) {
            throw new NullPointerException("NodeRenderer must not be null");
        }
        this.controller = controller;
        this.visualisedObjectManager = visualisedObjectManager;
        this.graphFactory = graphFactory;
        this.nodeFactory = nodeFactory;
        this.edgeFactory = edgeFactory;
        this.nodeRenderer = nodeRenderer;
        controller.addPropertyChangeListener(this);
        this.nodeMap = new HashMap<Object, Node>();
        this.listeners = new ArrayList();
        this.graphChangedEvent = new GraphGeneratorEvent(this);
        this.graph = graphFactory.createGraph();
        this.visualisedObjectManagerListener = new VisualisedObjectManagerListener(){

            public void objectsAdded(VisualisedObjectManagerEvent evt) {
                int i;
                ArrayList list = evt.getObjects();
                Dimension size = new Dimension();
                for (i = 0; i < list.size(); ++i) {
                    Node node = DefaultGraphGenerator.this.addNode(list.get(i));
                    DefaultGraphGenerator.this.nodeRenderer.getPreferredSize(node, size);
                    node.setSize(size.width, size.height);
                }
                for (i = 0; i < list.size(); ++i) {
                    DefaultGraphGenerator.this.addChildEdges(list.get(i));
                    DefaultGraphGenerator.this.addParentEdges(list.get(i));
                }
                DefaultGraphGenerator.this.fireGraphChangedEvent();
            }

            public void objectsRemoved(VisualisedObjectManagerEvent evt) {
                ArrayList list = evt.getObjects();
                for (int i = 0; i < list.size(); ++i) {
                    DefaultGraphGenerator.this.removeNode(list.get(i));
                }
                DefaultGraphGenerator.this.fireGraphChangedEvent();
            }

            public void objectsChanged(VisualisedObjectManagerEvent evt) {
                ArrayList list = evt.getObjects();
                Iterator it = list.iterator();
                Dimension size = new Dimension();
                while (it.hasNext()) {
                    Object obj = it.next();
                    Node node = (Node)DefaultGraphGenerator.this.nodeMap.get(obj);
                    Dimension oldSize = (Dimension)node.getSize().clone();
                    DefaultGraphGenerator.this.nodeRenderer.getPreferredSize(node, size);
                    if (oldSize.equals(size)) continue;
                    node.setSize(size.width, size.height);
                    DefaultGraphGenerator.this.fireGraphChangedEvent();
                }
                DefaultGraphGenerator.this.fireGraphChangedEvent();
            }

            public void parentObjectAdded(VisualisedObjectManagerEvent evt) {
                Node parentNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(1));
                Node childNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(0));
                int dir = DefaultGraphGenerator.this.controller.getGraphModel().getRelationshipDirection(parentNode.getUserObject(), childNode.getUserObject());
                if (dir > -1) {
                    Edge edge = DefaultGraphGenerator.this.edgeFactory.createEdge(parentNode, childNode, dir);
                    DefaultGraphGenerator.this.graph.add(edge);
                    DefaultGraphGenerator.this.fireGraphChangedEvent();
                }
            }

            public void parentObjectRemoved(VisualisedObjectManagerEvent evt) {
                Node tailNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(1));
                Node headNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(0));
                DefaultGraphGenerator.this.graph.remove(tailNode, headNode);
                DefaultGraphGenerator.this.fireGraphChangedEvent();
            }

            public void childObjectAdded(VisualisedObjectManagerEvent evt) {
                Node parentNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(0));
                Node childNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(1));
                int dir = DefaultGraphGenerator.this.controller.getGraphModel().getRelationshipDirection(parentNode.getUserObject(), childNode.getUserObject());
                if (dir > -1) {
                    Edge edge = DefaultGraphGenerator.this.edgeFactory.createEdge(parentNode, childNode, dir);
                    DefaultGraphGenerator.this.graph.add(edge);
                    DefaultGraphGenerator.this.fireGraphChangedEvent();
                }
            }

            public void childObjectRemoved(VisualisedObjectManagerEvent evt) {
                Node tailNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(0));
                Node headNode = (Node)DefaultGraphGenerator.this.nodeMap.get(evt.getObjects().get(1));
                DefaultGraphGenerator.this.graph.remove(tailNode, headNode);
                DefaultGraphGenerator.this.fireGraphChangedEvent();
            }
        };
        visualisedObjectManager.addVisualisedObjectManagerListener(this.visualisedObjectManagerListener);
    }

    public Graph getGraph() {
        if (this.rebuildGraph) {
            this.generateGraph();
        }
        return this.graph;
    }

    public VisualisedObjectManager getVisualisedObjectManager() {
        return this.visualisedObjectManager;
    }

    public void setVisualisedObjectManager(VisualisedObjectManager manager) {
        this.visualisedObjectManager = manager;
        this.invalidateGraph();
    }

    protected void generateGraph() {
        Object obj;
        if (this.graph == null) {
            this.graph = this.graphFactory.createGraph();
        } else {
            this.graph.removeAll();
        }
        this.cleanNodeMap();
        Iterator objIt = this.visualisedObjectManager.iterator();
        while (objIt.hasNext()) {
            obj = objIt.next();
            this.addNode(obj);
        }
        this.recreateNodes = false;
        objIt = this.visualisedObjectManager.iterator();
        while (objIt.hasNext()) {
            obj = objIt.next();
            this.addChildEdges(obj);
            this.addParentEdges(obj);
        }
        this.rebuildGraph = false;
    }

    protected Node addNode(Object obj) {
        Node node = null;
        if (!this.recreateNodes) {
            node = this.nodeMap.get(obj);
        }
        if (node == null) {
            node = this.nodeFactory.createNode(obj);
            this.nodeMap.put(obj, node);
        }
        this.graph.add(node);
        return node;
    }

    protected void removeNode(Object obj) {
        this.graph.remove(this.nodeMap.get(obj));
        this.nodeMap.remove(obj);
    }

    protected void addParentEdges(Object obj) {
        GraphModel model = this.visualisedObjectManager.getGraphModel();
        Iterator parIt = model.getParents(obj);
        Node node = this.nodeMap.get(obj);
        while (parIt.hasNext()) {
            int dir;
            Object par = parIt.next();
            Node parNode = this.nodeMap.get(par);
            if (parNode == null || (dir = this.controller.getGraphModel().getRelationshipDirection(parNode.getUserObject(), node.getUserObject())) <= -1) continue;
            Edge edge = this.edgeFactory.createEdge(parNode, node, dir);
            this.graph.add(edge);
        }
    }

    protected void addChildEdges(Object obj) {
        GraphModel model = this.visualisedObjectManager.getGraphModel();
        Iterator childIt = model.getChildren(obj);
        Node node = this.nodeMap.get(obj);
        while (childIt.hasNext()) {
            int dir;
            Object child = childIt.next();
            Node childNode = this.nodeMap.get(child);
            if (childNode == null || (dir = this.controller.getGraphModel().getRelationshipDirection(node.getUserObject(), childNode.getUserObject())) <= -1) continue;
            Edge edge = this.edgeFactory.createEdge(node, childNode, dir);
            this.graph.add(edge);
        }
    }

    protected void cleanNodeMap() {
        for (Object obj : this.nodeMap.keySet()) {
            if (this.visualisedObjectManager.isShown(obj)) continue;
            this.nodeMap.remove(obj);
        }
    }

    public void invalidateGraph() {
        this.rebuildGraph = true;
        this.doChangeBroadcast();
    }

    public Node getNodeForObject(Object obj) {
        return this.nodeMap.get(obj);
    }

    public void addGraphGeneratorListener(GraphGeneratorListener lsnr) {
        this.listeners.add(lsnr);
    }

    public void removeGraphGeneratorListener(GraphGeneratorListener lsnr) {
        this.listeners.remove(lsnr);
    }

    public Iterator getGraphGeneratorListeners() {
        return this.listeners.iterator();
    }

    private void doChangeBroadcast() {
        this.fireGraphChangedEvent();
    }

    protected void fireGraphChangedEvent() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultGraphGenerator) firing graph changed event");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphGeneratorListener)this.listeners.get(i)).graphChanged(this.graphChangedEvent);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("graphFactory")) {
            this.graphFactory = (GraphFactory)evt.getNewValue();
        } else if (evt.getPropertyName().equals("nodeFactory")) {
            this.nodeFactory = (NodeFactory)evt.getNewValue();
        } else if (evt.getPropertyName().equals("edgeFactory")) {
            this.edgeFactory = (EdgeFactory)evt.getNewValue();
        } else if (evt.getPropertyName().equals("visualisedObjectManager")) {
            this.visualisedObjectManager.removeVisualisedObjectManagerListener(this.visualisedObjectManagerListener);
            this.visualisedObjectManager = (VisualisedObjectManager)evt.getNewValue();
            this.visualisedObjectManager.addVisualisedObjectManagerListener(this.visualisedObjectManagerListener);
        } else if (evt.getPropertyName().equals("nodeRenderer")) {
            this.nodeRenderer = (NodeRenderer)evt.getNewValue();
        }
    }
}

