/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.controller.impl;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.controller.VisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.event.GraphModelEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphModelListener;
import uk.ac.man.cs.mig.util.graph.event.VisualisedObjectManagerEvent;
import uk.ac.man.cs.mig.util.graph.event.VisualisedObjectManagerListener;
import uk.ac.man.cs.mig.util.graph.model.GraphModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVisualisedObjectManager
implements VisualisedObjectManager {
    private static Logger log = Logger.getLogger(DefaultVisualisedObjectManager.class);
    private GraphModel model;
    private VisualisedObjectCache visualisedObjects;
    private ArrayList<VisualisedObjectManagerListener> listeners;

    public DefaultVisualisedObjectManager(GraphModel model) {
        if (model == null) {
            throw new NullPointerException("GraphModel must not be null");
        }
        this.visualisedObjects = new VisualisedObjectCache();
        this.listeners = new ArrayList();
        this.model = model;
        this.model.addGraphModelListener(new GraphModelListener(){

            public void objectAdded(GraphModelEvent evt) {
            }

            public void objectRemoved(GraphModelEvent evt) {
                ArrayList list = evt.getObjects();
                for (Object obj : list) {
                    if (!DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(obj)) continue;
                    DefaultVisualisedObjectManager.this.hideObject(obj);
                }
            }

            public void objectChanged(GraphModelEvent evt) {
                for (Object obj : evt.getObjects()) {
                    if (!DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(obj)) continue;
                    DefaultVisualisedObjectManager.this.fireObjectChangedEvent(evt.getObjects());
                }
            }

            public void parentAdded(GraphModelEvent evt) {
                Object obj = evt.getObjects().get(0);
                Object parentObj = evt.getObjects().get(1);
                if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(obj)) {
                    DefaultVisualisedObjectManager.this.visualisedObjects.updateInfo();
                    if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(parentObj)) {
                        DefaultVisualisedObjectManager.this.fireParentObjectAddedEvent(obj, parentObj);
                    } else {
                        ArrayList list = new ArrayList(1);
                        list.add(obj);
                        DefaultVisualisedObjectManager.this.fireObjectChangedEvent(list);
                    }
                }
            }

            public void parentRemoved(GraphModelEvent evt) {
                Object obj = evt.getObjects().get(0);
                Object parentObj = evt.getObjects().get(1);
                if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(obj)) {
                    DefaultVisualisedObjectManager.this.visualisedObjects.updateInfo();
                    if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(parentObj)) {
                        DefaultVisualisedObjectManager.this.fireParentObjectRemovedEvent(obj, parentObj);
                    } else {
                        ArrayList list = new ArrayList(1);
                        list.add(obj);
                        DefaultVisualisedObjectManager.this.fireObjectChangedEvent(list);
                    }
                }
            }

            public void childAdded(GraphModelEvent evt) {
                Object obj = evt.getObjects().get(0);
                Object childObj = evt.getObjects().get(1);
                if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(obj)) {
                    DefaultVisualisedObjectManager.this.visualisedObjects.updateInfo();
                    if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(childObj)) {
                        DefaultVisualisedObjectManager.this.fireChildObjectAddedEvent(obj, childObj);
                    } else {
                        ArrayList list = new ArrayList(1);
                        list.add(obj);
                        DefaultVisualisedObjectManager.this.fireObjectChangedEvent(list);
                    }
                }
            }

            public void childRemoved(GraphModelEvent evt) {
                Object obj = evt.getObjects().get(0);
                Object childObj = evt.getObjects().get(1);
                if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(obj)) {
                    DefaultVisualisedObjectManager.this.visualisedObjects.updateInfo();
                    if (DefaultVisualisedObjectManager.this.visualisedObjects.containsObject(childObj)) {
                        DefaultVisualisedObjectManager.this.fireChildObjectRemovedEvent(obj, childObj);
                    } else {
                        ArrayList list = new ArrayList(1);
                        list.add(obj);
                    }
                }
            }

            public void modelChanged(GraphModelEvent evt) {
                ArrayList list = new ArrayList();
                DefaultVisualisedObjectManager.this.visualisedObjects.removeDanglingObjects(list);
                DefaultVisualisedObjectManager.this.visualisedObjects.updateInfo();
                DefaultVisualisedObjectManager.this.fireObjectRemovedEvent(list);
            }
        });
    }

    @Override
    public GraphModel getGraphModel() {
        return this.model;
    }

    @Override
    public void setGraphModel(GraphModel model) {
        this.model = model;
        ArrayList list = new ArrayList();
        this.visualisedObjects.removeDanglingObjects(list);
        this.fireObjectRemovedEvent(list);
    }

    @Override
    public void showObject(Object obj) {
        if (this.visualisedObjects.addObject(obj)) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(obj);
            this.fireObjectAddedEvent(list);
        }
    }

    @Override
    public void showObject(Object obj, int parentChildRadius, Class objClass) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.visualisedObjects.addObject(obj)) {
            list.add(obj);
        }
        this.visualisedObjects.addChildren(obj, list, parentChildRadius, objClass);
        this.visualisedObjects.addParents(obj, list, parentChildRadius, objClass);
        if (list.size() > 0) {
            this.fireObjectAddedEvent(list);
        }
    }

    @Override
    public void showObjects(Object[] objs) {
        ArrayList<Object> list = new ArrayList<Object>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (!this.visualisedObjects.addObject(objs[i])) continue;
            list.add(objs[i]);
        }
        if (list.size() > 0) {
            this.fireObjectAddedEvent(list);
        }
    }

    @Override
    public void hideObject(Object obj) {
        if (this.visualisedObjects.removeObject(obj)) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(obj);
            this.fireObjectRemovedEvent(list);
        }
    }

    @Override
    public void hideObjects(Object obj, int radius, Class objClass) {
        ArrayList<Object> list = new ArrayList<Object>(this.visualisedObjects.getNumberOfObjects());
        ArrayList remList = new ArrayList(this.visualisedObjects.getNumberOfObjects());
        this.visualisedObjects.removeAll(remList);
        this.visualisedObjects.addObject(obj);
        list.add(obj);
        this.visualisedObjects.addChildren(obj, list, radius, objClass);
        this.visualisedObjects.addParents(obj, list, radius, objClass);
        remList.removeAll(list);
        this.fireObjectRemovedEvent(remList);
    }

    @Override
    public void hideObjects(Object[] objs) {
        ArrayList<Object> list = new ArrayList<Object>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (!this.visualisedObjects.removeObject(objs[i])) continue;
            list.add(objs[i]);
        }
        if (list.size() > 0) {
            this.fireObjectRemovedEvent(list);
        }
    }

    @Override
    public void showChildren(Object obj, Class objClass) {
        this.showChildren(obj, 1, objClass);
    }

    @Override
    public void showChildren(Object obj, int levels, Class objClass) {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = 0;
        if (this.visualisedObjects.addObject(obj)) {
            list.add(obj);
        }
        this.visualisedObjects.addChildren(obj, list, levels, objClass);
        if (list.size() != size) {
            this.fireObjectAddedEvent(list);
        }
    }

    @Override
    public void hideChildren(Object obj) {
        ArrayList list = new ArrayList();
        this.visualisedObjects.removeChildren(obj, list);
        if (list.size() > 0) {
            this.fireObjectRemovedEvent(list);
        }
    }

    @Override
    public void showParents(Object obj, Class objClass) {
        this.showParents(obj, 1, objClass);
    }

    @Override
    public void showParents(Object obj, int levels, Class objClass) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.visualisedObjects.addObject(obj)) {
            list.add(obj);
        }
        int size = 0;
        this.visualisedObjects.addParents(obj, list, levels, objClass);
        if (list.size() != size) {
            this.fireObjectAddedEvent(list);
        }
    }

    @Override
    public void hideParents(Object obj) {
        ArrayList list = new ArrayList();
        this.visualisedObjects.removeParents(obj, list);
        if (list.size() > 0) {
            this.fireObjectRemovedEvent(list);
        }
    }

    @Override
    public void hideAll() {
        ArrayList list = new ArrayList();
        this.visualisedObjects.removeAll(list);
        if (list.size() > 0) {
            this.fireObjectRemovedEvent(list);
        }
    }

    @Override
    public int getNumberOfVisualisedObjects() {
        return this.visualisedObjects.getNumberOfObjects();
    }

    @Override
    public Object[] getVisualisedObjects() {
        return this.visualisedObjects.getAllObjects().toArray();
    }

    @Override
    public boolean isShown(Object obj) {
        return this.visualisedObjects.containsObject(obj);
    }

    @Override
    public Iterator iterator() {
        return this.visualisedObjects.iterator();
    }

    @Override
    public int getChildrenShownCount(Object obj) {
        int val = -1;
        VisualisedObjectWrapper wrapper = this.visualisedObjects.getObjectInfo(obj);
        if (wrapper != null) {
            val = wrapper.getNumberOfChildrenShown();
        }
        return val;
    }

    @Override
    public int getChildrenHiddenCount(Object obj) {
        int val = -1;
        VisualisedObjectWrapper wrapper = this.visualisedObjects.getObjectInfo(obj);
        if (wrapper != null) {
            val = wrapper.getNumberOfChildrenHidden();
        }
        return val;
    }

    @Override
    public int getParentsShownCount(Object obj) {
        int val = -1;
        VisualisedObjectWrapper wrapper = this.visualisedObjects.getObjectInfo(obj);
        if (wrapper != null) {
            val = wrapper.getNumberOfParentsShown();
        }
        return val;
    }

    @Override
    public int getParentsHiddenCount(Object obj) {
        int val = -1;
        VisualisedObjectWrapper wrapper = this.visualisedObjects.getObjectInfo(obj);
        if (wrapper != null) {
            val = wrapper.getNumberOfParentsHidden();
        }
        return val;
    }

    @Override
    public void updateInfo() {
        this.visualisedObjects.updateInfo();
    }

    @Override
    public void addVisualisedObjectManagerListener(VisualisedObjectManagerListener lsnr) {
        this.listeners.add(lsnr);
    }

    @Override
    public void removeVisualisedObjectManagerListener(VisualisedObjectManagerListener lsnr) {
        this.listeners.remove(lsnr);
    }

    @Override
    public Iterator<VisualisedObjectManagerListener> getVisualisedObjectManagerListeners() {
        return this.listeners.iterator();
    }

    protected void fireObjectAddedEvent(ArrayList list) {
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing object added event");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objectsAdded(evt);
        }
    }

    protected void fireObjectRemovedEvent(ArrayList list) {
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing object removed event.");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objectsRemoved(evt);
        }
    }

    protected void fireObjectChangedEvent(ArrayList list) {
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing object changed event");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).objectsChanged(evt);
        }
    }

    protected void fireParentObjectAddedEvent(Object object, Object parentObject) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(object);
        list.add(parentObject);
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing parent object added event");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).parentObjectAdded(evt);
        }
    }

    protected void fireParentObjectRemovedEvent(Object object, Object parentObject) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(object);
        list.add(parentObject);
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing parent object removed event");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).parentObjectRemoved(evt);
        }
    }

    protected void fireChildObjectAddedEvent(Object object, Object childObject) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(object);
        list.add(childObject);
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing child object added event");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).childObjectAdded(evt);
        }
    }

    protected void fireChildObjectRemovedEvent(Object object, Object childObject) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(object);
        list.add(childObject);
        VisualisedObjectManagerEvent evt = new VisualisedObjectManagerEvent(this, list);
        if (log.isDebugEnabled()) {
            log.debug((Object)"TRACE(DefaultVisualisedObjectManager) firing child object removed event");
            log.debug((Object)evt.getObjects());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).childObjectRemoved(evt);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class VisualisedObjectCache {
        Map objects = new HashMap();

        public boolean addObject(Object obj) {
            if (!this.objects.containsKey(obj)) {
                this.objects.put(obj, new VisualisedObjectWrapper(obj));
                this.addRelatedObjects(obj, new ArrayList());
                this.updateInfo();
                return true;
            }
            return false;
        }

        public VisualisedObjectWrapper getObjectInfo(Object obj) {
            return (VisualisedObjectWrapper)this.objects.get(obj);
        }

        public boolean containsObject(Object obj) {
            return this.objects.containsKey(obj);
        }

        public int getNumberOfObjects() {
            return this.objects.keySet().size();
        }

        public Iterator iterator() {
            return this.objects.keySet().iterator();
        }

        public boolean removeObject(Object obj) {
            if (this.containsObject(obj)) {
                this.objects.remove(obj);
                this.removeRelatedObjects(obj, new ArrayList());
                this.updateInfo();
                return true;
            }
            return false;
        }

        public void addChildren(Object obj, ArrayList list, int levels, Class objClass) {
            int size = list.size();
            this.addChildrenRecursively(obj, list, levels, objClass);
            if (list.size() != size) {
                this.updateInfo();
            }
        }

        public void addParents(Object obj, ArrayList list, int levels, Class objClass) {
            int size = list.size();
            this.addParentsRecursively(obj, list, levels, objClass);
            if (list.size() != size) {
                this.updateInfo();
            }
        }

        private void addChildrenRecursively(Object obj, ArrayList list, int levels, Class objClass) {
            if (levels > 0) {
                list.ensureCapacity(list.size() + DefaultVisualisedObjectManager.this.model.getChildCount(obj));
                Iterator childIt = DefaultVisualisedObjectManager.this.model.getChildren(obj);
                while (childIt.hasNext()) {
                    Object childObject = childIt.next();
                    if (this.objects.containsKey(childObject) || !objClass.isInstance(childObject)) continue;
                    this.objects.put(childObject, new VisualisedObjectWrapper(childObject));
                    list.add(childObject);
                    this.addRelatedObjects(childObject, list);
                    this.addChildrenRecursively(childObject, list, levels - 1, objClass);
                }
            }
        }

        public void removeChildren(Object obj, ArrayList list) {
            int size = list.size();
            this.removeChildrenRecursively(obj, list);
            if (list.size() != size) {
                this.updateInfo();
            }
        }

        private void removeChildrenRecursively(Object obj, ArrayList list) {
            list.ensureCapacity(list.size() + DefaultVisualisedObjectManager.this.model.getChildCount(obj));
            Iterator childIt = DefaultVisualisedObjectManager.this.model.getChildren(obj);
            while (childIt.hasNext()) {
                Object childObject = childIt.next();
                if (!this.objects.containsKey(childObject)) continue;
                this.objects.remove(childObject);
                list.add(childObject);
                this.removeRelatedObjects(childObject, list);
                this.removeChildrenRecursively(childObject, list);
            }
        }

        private void addParentsRecursively(Object obj, ArrayList list, int levels, Class objClass) {
            if (levels > 0) {
                list.ensureCapacity(list.size() + DefaultVisualisedObjectManager.this.model.getParentCount(obj));
                Iterator parIt = DefaultVisualisedObjectManager.this.model.getParents(obj);
                while (parIt.hasNext()) {
                    Object parObject = parIt.next();
                    if (this.objects.containsKey(parObject) || !objClass.isInstance(parObject)) continue;
                    this.objects.put(parObject, new VisualisedObjectWrapper(parObject));
                    list.add(parObject);
                    this.addRelatedObjects(parObject, list);
                    this.addParentsRecursively(parObject, list, levels - 1, objClass);
                }
            }
        }

        public void removeParents(Object obj, ArrayList list) {
            boolean update = false;
            list.ensureCapacity(list.size() + DefaultVisualisedObjectManager.this.model.getParentCount(obj));
            Iterator parIt = DefaultVisualisedObjectManager.this.model.getParents(obj);
            while (parIt.hasNext()) {
                Object parObject = parIt.next();
                if (!this.objects.containsKey(parObject)) continue;
                this.objects.remove(parObject);
                list.add(parObject);
                this.removeRelatedObjects(parObject, list);
                update = true;
            }
            if (update) {
                this.updateInfo();
            }
        }

        public void removeAll(ArrayList list) {
            list.ensureCapacity(this.objects.keySet().size());
            Iterator it = this.objects.keySet().iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
            this.objects.keySet().removeAll(this.objects.keySet());
            this.updateInfo();
        }

        public void removeDanglingObjects(ArrayList list) {
            list.ensureCapacity(this.objects.keySet().size());
            for (Object obj : this.objects.keySet()) {
                if (DefaultVisualisedObjectManager.this.model.contains(obj)) continue;
                list.add(obj);
            }
            this.objects.keySet().removeAll(list);
            this.updateInfo();
        }

        private void updateInfo() {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                VisualisedObjectWrapper wrapper = this.getObjectInfo(obj);
                int counter = 0;
                Iterator parIt = DefaultVisualisedObjectManager.this.model.getParents(obj);
                while (parIt.hasNext()) {
                    if (!this.containsObject(parIt.next())) continue;
                    ++counter;
                }
                wrapper.setNumberOfParentsShown(counter);
                counter = 0;
                Iterator childIt = DefaultVisualisedObjectManager.this.model.getChildren(obj);
                while (childIt.hasNext()) {
                    if (!this.containsObject(childIt.next())) continue;
                    ++counter;
                }
                wrapper.setNumberOfChildrenShown(counter);
            }
        }

        public void addRelatedObjects(Object obj, ArrayList list) {
            Iterator it = DefaultVisualisedObjectManager.this.model.getRelatedObjectsToAdd(obj);
            while (it.hasNext()) {
                Object objRel = it.next();
                if (this.objects.containsKey(objRel)) continue;
                this.objects.put(objRel, new VisualisedObjectWrapper(objRel));
                list.add(objRel);
                this.addRelatedObjects(objRel, list);
            }
        }

        public void removeRelatedObjects(Object obj, ArrayList list) {
            Iterator it = DefaultVisualisedObjectManager.this.model.getRelatedObjectsToRemove(obj);
            while (it.hasNext()) {
                Object objRel = it.next();
                if (!this.objects.containsKey(objRel)) continue;
                this.objects.remove(objRel);
                list.add(objRel);
                this.removeRelatedObjects(objRel, list);
            }
        }

        public Collection getAllObjects() {
            return this.objects.keySet();
        }
    }

    private class VisualisedObjectWrapper {
        private Object obj;
        private int numberOfParentsShown;
        private int numberOfChildrenShown;
        private int numberOfChildrenHidden;
        private int numberOfParentsHidden;

        public VisualisedObjectWrapper(Object obj) {
            this.obj = obj;
        }

        public int getNumberOfParentsShown() {
            return this.numberOfParentsShown;
        }

        public void setNumberOfParentsShown(int numberOfParentsShown) {
            this.numberOfParentsShown = numberOfParentsShown;
            this.numberOfParentsHidden = DefaultVisualisedObjectManager.this.model.getParentCount(this.obj) - numberOfParentsShown;
        }

        public int getNumberOfChildrenShown() {
            return this.numberOfChildrenShown;
        }

        public void setNumberOfChildrenShown(int numberOfChildrenShown) {
            this.numberOfChildrenShown = numberOfChildrenShown;
            this.numberOfChildrenHidden = DefaultVisualisedObjectManager.this.model.getChildCount(this.obj) - numberOfChildrenShown;
        }

        public int getNumberOfChildrenHidden() {
            return this.numberOfChildrenHidden;
        }

        public int getNumberOfParentsHidden() {
            return this.numberOfParentsHidden;
        }
    }
}

