/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.graph.impl;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Node;

public class DefaultEdge
implements Edge {
    private Object userObject;
    private Node tailNode;
    private Node headNode;
    private Point labelPos;
    private GeneralPath path;
    private static final int ARROWHEAD_HALF_BASE_WIDTH = 4;
    private int direction;

    public DefaultEdge(Node tailNode, Node headNode, Object userObject, int direction) {
        this.tailNode = tailNode;
        this.headNode = headNode;
        this.userObject = userObject;
        this.labelPos = new Point();
        this.path = new GeneralPath();
        if (direction == 1 || direction == 2 || direction == 3 || direction == 4) {
            this.direction = direction;
        }
    }

    public Node getHeadNode() {
        return this.headNode;
    }

    public Node getTailNode() {
        return this.tailNode;
    }

    public void setUserObject(Object o) {
        this.userObject = o;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void resetPath() {
        this.path.reset();
    }

    public void setPathOrigin(int x, int y) {
        this.path.reset();
        this.path.moveTo(x, y);
    }

    public void pathTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        if (y1 == y2 && y2 == y3) {
            this.path.lineTo(x3, y3);
        } else {
            this.path.curveTo(x1, y1, x2, y2, x3, y3);
        }
    }

    public void pathTo(int x, int y) {
        this.path.lineTo(x, y);
    }

    public Point getLabelPosition() {
        return this.labelPos;
    }

    public void setLabelPosition(int x, int y) {
        this.labelPos.x = x;
        this.labelPos.y = y;
    }

    public void setArrowHead(int baseX, int baseY, int tipX, int tipY) {
        int deltaX = tipX - baseX;
        int deltaY = tipY - baseY;
        double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double vecX = (double)deltaX / length * 4.0;
        double vecY = (double)deltaY / length * 4.0;
        int x1 = (int)((double)baseX - vecY);
        int y1 = (int)((double)baseY + vecX);
        int x2 = (int)((double)baseX + vecY);
        int y2 = (int)((double)baseY - vecX);
        this.path.moveTo(tipX, tipY);
        this.path.lineTo(x1, y1);
        this.path.lineTo(x2, y2);
        this.path.lineTo(tipX, tipY);
    }

    public void setArrowTail(int baseX, int baseY, int tipX, int tipY) {
        int deltaX = tipX - baseX;
        int deltaY = tipY - baseY;
        double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double vecX = (double)deltaX / length * 4.0;
        double vecY = (double)deltaY / length * 4.0;
        int x1 = (int)((double)baseX - vecY);
        int y1 = (int)((double)baseY + vecX);
        int x2 = (int)((double)baseX + vecY);
        int y2 = (int)((double)baseY - vecX);
        this.path.moveTo(tipX, tipY);
        this.path.lineTo(x1, y1);
        this.path.lineTo(x2, y2);
        this.path.lineTo(tipX, tipY);
    }

    public Shape getShape() {
        return this.path;
    }

    public int getDirection() {
        return this.direction;
    }

    public int hashCode() {
        return this.tailNode.hashCode() * 13 + this.headNode.hashCode() * 37;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            if (obj == this) {
                return true;
            }
            Edge edge = (Edge)obj;
            return edge.getTailNode().equals(this.tailNode) && edge.getHeadNode().equals(this.headNode);
        }
        return false;
    }
}

