/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class DotLayoutEngineProperties {
    public static final String PREFERENCES_SET_KEY = "uk.ac.man.cs.mig.coode.owlviz";
    public static final String PREFERENCES_KEY = "OWLVizPrefs";
    public static final String PROCESS_PATH_KEY = "ProcessPath";
    public static final String RANK_SPACING_KEY = "RankSpacing";
    public static final String SIBLING_SPACING_KEY = "SiblingSpacing";
    private static DotLayoutEngineProperties instance;
    public static final String DEFAULT_MAC_PATH = "/usr/local/graphviz-2.14/bin/dot";
    public static final String DEFAULT_WINDOWS_PATH = "C:\\Program Files\\GraphViz\\bin\\Dot";
    public static final String DEFAULT_LINUX_PATH = "/usr/bin/dot";
    private static final double DEFAULT_SIBLING_SPACING = 0.2;
    public static final double DEFAULT_RANK_SPACING = 0.5;
    private static String FILE_NAME;
    private double rankSpacing;
    private double siblingSpacing;
    private String processPath;

    protected DotLayoutEngineProperties() {
        this.loadFromPrefs();
    }

    private static String getDefaultPath() {
        String platform = System.getProperty("os.name");
        if (platform.indexOf("OS X") != -1) {
            return DEFAULT_MAC_PATH;
        }
        if (platform.indexOf("Windows") != -1) {
            return DEFAULT_WINDOWS_PATH;
        }
        return DEFAULT_LINUX_PATH;
    }

    public static synchronized DotLayoutEngineProperties getInstance() {
        if (instance == null) {
            instance = new DotLayoutEngineProperties();
        }
        return instance;
    }

    private static Preferences getPreferences() {
        return PreferencesManager.getInstance().getPreferencesForSet(PREFERENCES_SET_KEY, PREFERENCES_KEY);
    }

    private void loadFromPrefs() {
        this.processPath = DotLayoutEngineProperties.getPreferences().getString(PROCESS_PATH_KEY, DotLayoutEngineProperties.getDefaultPath());
        this.rankSpacing = DotLayoutEngineProperties.getPreferences().getDouble(RANK_SPACING_KEY, 0.5);
        this.siblingSpacing = DotLayoutEngineProperties.getPreferences().getDouble(SIBLING_SPACING_KEY, 0.2);
    }

    private void savePrefs() {
        DotLayoutEngineProperties.getPreferences().putString(PROCESS_PATH_KEY, this.processPath);
        DotLayoutEngineProperties.getPreferences().putDouble(RANK_SPACING_KEY, this.rankSpacing);
        DotLayoutEngineProperties.getPreferences().putDouble(SIBLING_SPACING_KEY, this.siblingSpacing);
    }

    public String getDotProcessPath() {
        return this.processPath;
    }

    public void setDotProcessPath(String path) {
        if (System.getProperty("os.name").indexOf("OS X") != -1 && path.endsWith(".app")) {
            path = path + "/Contents/MacOS/dot";
        }
        this.processPath = path;
        this.savePrefs();
    }

    public double getRankSpacing() {
        return this.rankSpacing;
    }

    public void setRankSpacing(double rankSpacing) {
        this.rankSpacing = rankSpacing;
        this.savePrefs();
    }

    public double getSiblingSpacing() {
        return this.siblingSpacing;
    }

    public void setSiblingSpacing(double siblingSpacing) {
        this.siblingSpacing = siblingSpacing;
        this.savePrefs();
    }

    static {
        FILE_NAME = "DotScratch";
    }
}

