/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine;

import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.layout.dotlayoutengine.DotLayoutEngineProperties;

public class DotProcess {
    private static Logger log = Logger.getLogger(DotProcess.class);
    private Process process;

    public boolean startProcess(String fileName) {
        if (this.process != null) {
            this.killProcess();
        }
        Runtime r = Runtime.getRuntime();
        DotLayoutEngineProperties properties = DotLayoutEngineProperties.getInstance();
        try {
            this.process = r.exec(properties.getDotProcessPath() + " " + fileName + " -q -o " + fileName);
            try {
                this.process.waitFor();
                return true;
            }
            catch (InterruptedException irEx) {
                irEx.printStackTrace();
                return false;
            }
        }
        catch (IOException ioEx) {
            String errMsg = "An error related to DOT has occurred. This error was probably because OWLViz could not find the DOT application.  Please ensure that the path to the DOT application is set properly";
            String dlgErrMsg = "<html><body>A DOT error has occurred.<br>This is probably because OWLViz could not find the DOT application.<br>OWLViz requires that Graphviz (http://www.graphviz.org/) is installed<br> and the path to the DOT application is set properly (in options).</body></html>";
            JOptionPane.showMessageDialog(null, dlgErrMsg, "DOT Error", 0);
            log.error((Object)"DOT Process Error:");
            log.error((Object)ioEx.getMessage());
            log.error((Object)errMsg);
            return false;
        }
    }

    protected void killProcess() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }
}

