/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.outputrenderer.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.graph.impl.DefaultNode;
import uk.ac.man.cs.mig.util.graph.graph.impl.EllipticalNode;
import uk.ac.man.cs.mig.util.graph.outputrenderer.GraphOutputRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;

public class DotOutputGraphRenderer
implements GraphOutputRenderer {
    private static Logger log = Logger.getLogger(DotOutputGraphRenderer.class);
    private static HashMap shapeMap;
    protected BufferedWriter writer;
    private NodeLabelRenderer labelRen;
    private EdgeLabelRenderer edgeLabelRen;
    private HashMap attributeMap;
    public static final String LAYOUT_DIRECTION = "rankdir";
    public static final String RANK_SPACING = "ranksep";
    public static final String SIBLING_SPACING = "nodesep";

    public DotOutputGraphRenderer(NodeLabelRenderer labelRen, EdgeLabelRenderer edgeLabelRen) {
        this.labelRen = labelRen;
        this.edgeLabelRen = edgeLabelRen;
        shapeMap = new HashMap();
        DotOutputGraphRenderer.registerShapeMapping(DefaultNode.class, "box");
        DotOutputGraphRenderer.registerShapeMapping(EllipticalNode.class, "ellipse");
        this.attributeMap = new HashMap();
        this.attributeMap.put(LAYOUT_DIRECTION, "LR");
        this.attributeMap.put(RANK_SPACING, "1.0");
        this.attributeMap.put(SIBLING_SPACING, "0.2");
    }

    public static void registerShapeMapping(Class nodeClass, String dotShapeName) {
        shapeMap.put(nodeClass, dotShapeName);
    }

    public void setRendererOption(String attribute, String value) {
        this.attributeMap.remove(attribute);
        this.attributeMap.put(attribute, value);
    }

    public synchronized void renderGraph(Graph graph, OutputStream os) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            this.writer = new BufferedWriter(osw);
            this.writeHeader(graph);
            Node[] nodes = graph.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                this.renderNode(nodes[i]);
            }
            Edge[] edges = graph.getEdges();
            for (int i = 0; i < edges.length; ++i) {
                this.renderEdge(edges[i]);
            }
            this.closeGraph();
            this.writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected void renderNode(Node node) throws IOException {
        this.writer.write(34);
        this.writer.write(this.labelRen.getLabel(node));
        this.writer.write(34);
        String shape = (String)shapeMap.get(node.getClass());
        if (shape != null) {
            this.writer.write(" [shape=");
            this.writer.write(shape);
            this.writer.write(", fixedsize=true, width=\"");
            this.writer.write(Double.toString((double)node.getSize().width / 72.0));
            this.writer.write("\", height=\"");
            this.writer.write(Double.toString((double)node.getSize().height / 72.0));
            this.writer.write("\"]");
        }
        this.writer.write(59);
        this.writer.newLine();
    }

    protected void renderEdge(Edge edge) throws IOException {
        this.writer.write(34);
        this.writer.write(this.labelRen.getLabel(edge.getTailNode()));
        this.writer.write(34);
        this.writer.write("->");
        this.writer.write(34);
        this.writer.write(this.labelRen.getLabel(edge.getHeadNode()));
        this.writer.write(34);
        String direction = "forward";
        int edgeDirection = edge.getDirection();
        if (edgeDirection == 1) {
            direction = "none";
        } else if (edgeDirection == 2) {
            direction = "forward";
        } else if (edgeDirection == 3) {
            direction = "back";
        } else if (edgeDirection == 4) {
            direction = "both";
        }
        this.writer.write(" [dir=");
        this.writer.write(direction);
        String label = this.edgeLabelRen.getEdgeLabel(edge);
        if (label != null) {
            this.writer.write(", fontsize=\"10\", floatlabel=true, label=\"" + label + "\"");
        }
        this.writer.write("];");
        this.writer.newLine();
    }

    protected void writeHeader(Graph graph) throws IOException {
        this.writer.write("digraph g");
        this.writer.newLine();
        this.writer.write("{");
        Iterator it = this.attributeMap.keySet().iterator();
        if (it.hasNext()) {
            this.writer.newLine();
            this.writer.write("graph [");
            while (it.hasNext()) {
                Object key = it.next();
                this.writer.write(key.toString());
                this.writer.write(61);
                Object value = this.attributeMap.get(key);
                this.writer.write(value.toString());
                this.writer.write(" ");
            }
            this.writer.write("]");
        }
        this.writer.newLine();
    }

    protected void closeGraph() throws IOException {
        this.writer.write("}");
        this.writer.newLine();
    }
}

