/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.renderer.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JPanel;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.graph.Edge;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeRenderer;

public class DefaultEdgeRenderer
implements EdgeRenderer {
    private Controller controller;
    private static Color edgeColor;
    private Color parentEdgeColor;
    private Color childEdgeColor;
    private Stroke selEdgeStroke;
    private Stroke edgeStroke;
    private static double edgeBrightness;
    private Font labelFont;

    public DefaultEdgeRenderer(Controller controller) {
        this.controller = controller;
        DefaultEdgeRenderer.updateEdgeColor();
        this.parentEdgeColor = new Color(125, 0, 125);
        this.childEdgeColor = new Color(0, 125, 0);
        this.selEdgeStroke = new BasicStroke(2.0f, 1, 1);
        this.edgeStroke = new BasicStroke(1.0f, 1, 1);
        JPanel pan = new JPanel();
        Font font = pan.getFont();
        this.labelFont = font.deriveFont(10.0f);
    }

    public static double getEdgeBrightness() {
        return edgeBrightness;
    }

    public static void setEdgeBrightness(double brightness) {
        if (brightness < 0.0) {
            brightness = 0.0;
        }
        if (brightness > 1.0) {
            brightness = 1.0;
        }
        edgeBrightness = brightness;
        DefaultEdgeRenderer.updateEdgeColor();
    }

    protected static void updateEdgeColor() {
        int brightness = (int)(edgeBrightness * 255.0);
        edgeColor = new Color(brightness, brightness, brightness);
    }

    public void renderEdge(Graphics2D g2, Edge edge, boolean forPrinting, boolean drawDetail) {
        Shape sh = edge.getShape();
        if (sh.intersects(g2.getClipBounds())) {
            String label;
            g2.setColor(this.getEdgeColor(edge, forPrinting));
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.getEdgeStroke(edge, forPrinting));
            g2.draw(sh);
            g2.setStroke(oldStroke);
            if (drawDetail && (label = this.controller.getEdgeLabelRenderer().getEdgeLabel(edge)) != null) {
                Font oldFont = g2.getFont();
                g2.setFont(this.labelFont);
                int halfFontWidth = g2.getFontMetrics().stringWidth(label) / 2;
                int fudge = g2.getFontMetrics().getHeight() / 2;
                g2.drawString(label, edge.getLabelPosition().x - halfFontWidth, edge.getLabelPosition().y + fudge);
                g2.setFont(oldFont);
            }
        }
    }

    protected Color getEdgeColor(Edge edge, boolean forPrinting) {
        Object selObj = this.controller.getGraphSelectionModel().getSelectedObject();
        Color color = Color.DARK_GRAY;
        color = !forPrinting && selObj != null ? (selObj == edge.getHeadNode().getUserObject() ? this.childEdgeColor : (selObj == edge.getTailNode().getUserObject() ? this.parentEdgeColor : edgeColor)) : edgeColor;
        return color;
    }

    protected Stroke getEdgeStroke(Edge edge, boolean forPrinting) {
        Stroke stroke = this.edgeStroke;
        Object selObj = this.controller.getGraphSelectionModel().getSelectedObject();
        stroke = !forPrinting && selObj != null ? (selObj == edge.getHeadNode().getUserObject() ? this.selEdgeStroke : (selObj == edge.getTailNode().getUserObject() ? this.selEdgeStroke : this.edgeStroke)) : this.edgeStroke;
        return stroke;
    }

    static {
        edgeBrightness = 0.4;
    }
}

