/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.renderer.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.VisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;

public class DefaultNodeRenderer
implements NodeRenderer {
    private static Logger log = Logger.getLogger(DefaultNodeRenderer.class);
    private static Color fillColor;
    private static Color lineColor;
    private VisualisedObjectManager visualisedObjectManager;
    private Polygon leftArrow = new Polygon();
    private Polygon rightArrow = new Polygon();
    private FontMetrics fontMetrics;
    private static final int ARROW_SIZE = 5;
    private static final int HORIZONTAL_PADDING = 20;
    private static final int VERTICAL_PADDING = 15;
    private Font labelFont;
    private Controller controller;
    private int layoutDirection = 0;
    private static Stroke lineStroke;

    public DefaultNodeRenderer(Controller controller) {
        this.controller = controller;
        if (controller.getVisualisedObjectManager() == null) {
            throw new NullPointerException("VisualisedObjectManager (in controller) must not be null");
        }
        this.visualisedObjectManager = controller.getVisualisedObjectManager();
        JPanel pan = new JPanel();
        Font font = pan.getFont();
        this.labelFont = font.deriveFont(10.0f);
        if (this.labelFont == null) {
            log.error((Object)"Font is NULL!");
        }
        this.fontMetrics = pan.getFontMetrics(this.labelFont);
        if (this.fontMetrics == null) {
            log.error((Object)"Font metrics is NULL!");
        }
        if (this.visualisedObjectManager == null) {
            throw new NullPointerException("DefaultNode renderer constructed beforeVisualisedObjectManager");
        }
        fillColor = Color.YELLOW;
        lineColor = Color.BLACK;
        this.setupArrows();
    }

    protected Color getFillColor(Node node) {
        return fillColor;
    }

    protected Color getLineColor(Node node) {
        return lineColor;
    }

    protected Stroke getLineStroke() {
        return lineStroke;
    }

    public void renderNode(Graphics2D g2, Node node, boolean forPrinting, boolean drawDetail) {
        Shape sh = node.getShape();
        if (sh.intersects(g2.getClipBounds())) {
            g2.setColor(this.getFillColor(node));
            g2.fill(sh);
            g2.setColor(this.getLineColor(node));
            g2.setStroke(this.getLineStroke());
            g2.draw(sh);
            Object obj = node.getUserObject();
            Point pos = node.getPosition();
            if (drawDetail) {
                String label = this.controller.getNodeLabelRenderer().getLabel(node);
                this.drawArrows(g2, sh, node.getUserObject());
                Font f = g2.getFont();
                g2.setFont(this.labelFont);
                Rectangle2D labelBounds2D = g2.getFontMetrics().getStringBounds(label, g2);
                Rectangle labelBounds = labelBounds2D.getBounds();
                g2.drawString(label, pos.x - labelBounds.width / 2, pos.y + labelBounds.height / 3);
                g2.setFont(f);
            }
        }
    }

    public Dimension getPreferredSize(Node node, Dimension size) {
        String label = this.controller.getNodeLabelRenderer().getLabel(node);
        int width = SwingUtilities.computeStringWidth(this.fontMetrics, label);
        int height = this.fontMetrics.getHeight();
        if (size != null) {
            size.width = width + 20;
            size.height = height + 15;
            return size;
        }
        return new Dimension(width, height);
    }

    protected void drawArrows(Graphics2D g2, Shape nodeShape, Object userObject) {
        if (this.controller.getGraphLayoutEngine().getLayoutDirection() != this.layoutDirection) {
            this.layoutDirection = this.controller.getGraphLayoutEngine().getLayoutDirection();
            this.setupArrows();
        }
        if (this.layoutDirection == 0) {
            Rectangle rect;
            if (this.visualisedObjectManager.getChildrenHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x + rect.width, rect.y + rect.height / 2);
                g2.fill(this.rightArrow);
                g2.translate(-rect.x - rect.width, -rect.y - rect.height / 2);
            }
            if (this.visualisedObjectManager.getParentsHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x, rect.y + rect.height / 2);
                g2.fill(this.leftArrow);
                g2.translate(-rect.x, -rect.y - rect.height / 2);
            }
        } else {
            Rectangle rect;
            if (this.visualisedObjectManager.getChildrenHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x + rect.width / 2, rect.y + rect.height);
                g2.fill(this.rightArrow);
                g2.translate(-rect.x - rect.width / 2, -rect.y - rect.height);
            }
            if (this.visualisedObjectManager.getParentsHiddenCount(userObject) > 0) {
                rect = nodeShape.getBounds();
                g2.translate(rect.x + rect.width / 2, rect.y);
                g2.fill(this.leftArrow);
                g2.translate(-rect.x - rect.width / 2, -rect.y);
            }
        }
    }

    protected void setupArrows() {
        if (this.controller.getGraphLayoutEngine().getLayoutDirection() == 0) {
            this.leftArrow.reset();
            this.leftArrow.addPoint(5, -5);
            this.leftArrow.addPoint(0, 0);
            this.leftArrow.addPoint(5, 5);
            this.rightArrow.reset();
            this.rightArrow.addPoint(-5, -5);
            this.rightArrow.addPoint(0, 0);
            this.rightArrow.addPoint(-5, 5);
        } else {
            this.leftArrow.reset();
            this.leftArrow.addPoint(-5, 5);
            this.leftArrow.addPoint(0, 0);
            this.leftArrow.addPoint(5, 5);
            this.rightArrow.reset();
            this.rightArrow.addPoint(-5, -5);
            this.rightArrow.addPoint(0, 0);
            this.rightArrow.addPoint(5, -5);
        }
    }

    static {
        lineStroke = new BasicStroke(2.0f);
    }
}

