/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.controller.GraphSelectionModel;
import uk.ac.man.cs.mig.util.graph.controller.VisualisedObjectManager;
import uk.ac.man.cs.mig.util.graph.controller.impl.DefaultController;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorListener;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelListener;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedListener;
import uk.ac.man.cs.mig.util.graph.event.ThumbnailViewSourceEvent;
import uk.ac.man.cs.mig.util.graph.event.ThumbnailViewSourceListener;
import uk.ac.man.cs.mig.util.graph.factory.EdgeFactory;
import uk.ac.man.cs.mig.util.graph.factory.GraphFactory;
import uk.ac.man.cs.mig.util.graph.factory.NodeFactory;
import uk.ac.man.cs.mig.util.graph.model.GraphModel;
import uk.ac.man.cs.mig.util.graph.model.impl.DefaultGraphModel;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeLabelRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;
import uk.ac.man.cs.mig.util.graph.ui.GraphView;
import uk.ac.man.cs.mig.util.graph.ui.PopupProvider;
import uk.ac.man.cs.mig.util.graph.ui.ThumbnailViewSource;

public class GraphComponent
extends JComponent
implements ThumbnailViewSource {
    private static final long serialVersionUID = 5765860310008732145L;
    private Controller controller;
    private JScrollPane scrollPane;
    private static final int THUMBNAIL_EVENT_BOUNDS_CHANGED = 1;
    private static final int THUMBNAIL_EVENT_VISIBLE_RECT_CHANGED = 2;
    private static final int THUMBNAIL_EVENT_CONTENT_CHANGED = 3;
    private ArrayList<ThumbnailViewSourceListener> thumbnailViewSourceListeners;
    private String name;

    public GraphComponent() {
        this("Unnamed");
    }

    public GraphComponent(String name) {
        this.name = name;
        this.controller = new DefaultController(new DefaultGraphModel());
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.controller.getGraphView());
        this.add(this.scrollPane);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.setFocusable(true);
        this.thumbnailViewSourceListeners = new ArrayList();
        this.setupThumbnailListeners();
    }

    public Dimension getPreferredSize() {
        return this.controller.getGraphView().getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.controller.getGraphView().getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.controller.getGraphView().getMinimumSize();
    }

    public GraphView getGraphView() {
        return this.controller.getGraphView();
    }

    public String getName() {
        return this.name;
    }

    public Object getSelectedObject() {
        return this.controller.getGraphSelectionModel().getSelectedObject();
    }

    public Object[] getSelectedObjects() {
        return this.controller.getGraphSelectionModel().getSelectedObjects();
    }

    public void selectObject(Object obj) {
        this.controller.getGraphSelectionModel().setSelectedObject(obj);
    }

    public void addGraphSelectionModelListener(GraphSelectionModelListener lsnr) {
        this.controller.getGraphSelectionModel().addGraphSelectionModelListener(lsnr);
    }

    public void removeGraphSelectionModelListener(GraphSelectionModelListener lsnr) {
        this.controller.getGraphSelectionModel().removeGraphSelectionModelListener(lsnr);
    }

    public GraphSelectionModel getGraphSelectionModel() {
        return this.controller.getGraphSelectionModel();
    }

    public void setGraphSelectionModel(GraphSelectionModel model) {
        this.controller.setGraphSelectionModel(model);
    }

    public void setNodeRenderer(NodeRenderer renderer) {
        this.controller.setNodeRenderer(renderer);
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.controller.setNodeFactory(nodeFactory);
    }

    public NodeFactory getNodeFactory(NodeFactory nodeFactory) {
        return this.controller.getNodeFactory();
    }

    public void setEdgeFactory(EdgeFactory edgeFactory) {
        this.controller.setEdgeFactory(edgeFactory);
    }

    public EdgeFactory getEdgeFactory(EdgeFactory edgeFactory) {
        return this.controller.getEdgeFactory();
    }

    public void setGraphFactory(GraphFactory graphFactory) {
        this.controller.setGraphFactory(graphFactory);
    }

    public GraphFactory getGraphFactory() {
        return this.controller.getGraphFactory();
    }

    public void setEdgeRenderer(EdgeRenderer renderer) {
        this.controller.setEdgeRenderer(renderer);
    }

    public void setNodeLabelRenderer(NodeLabelRenderer renderer) {
        this.controller.setNodeLabelRenderer(renderer);
    }

    public void setGraphModel(GraphModel model) {
        this.controller.setGraphModel(model);
    }

    public GraphModel getGraphModel() {
        return this.controller.getGraphModel();
    }

    public VisualisedObjectManager getVisualisedObjectManager() {
        return this.controller.getVisualisedObjectManager();
    }

    public Controller getController() {
        return this.controller;
    }

    public void addNodeClickedListener(NodeClickedListener nodeClickedListener) {
        this.controller.getGraphView().addNodeClickedListener(nodeClickedListener);
    }

    public void removeNodeClickedListener(NodeClickedListener nodeClickedListener) {
        this.controller.getGraphView().removeNodeClickedListener(nodeClickedListener);
    }

    public void setPopupProvider(PopupProvider popupProvider) {
        this.controller.getGraphView().setPopupProvider(popupProvider);
    }

    public void scrollObjectToVisible(Object obj) {
        this.controller.getGraphView().scrollObjectToVisible(obj);
    }

    public void drawThumbnail(Graphics2D g2) {
        this.controller.getGraphView().draw(g2, false, false, false, false);
    }

    public Dimension getViewBounds() {
        Dimension viewBounds = this.controller.getGraphView().getBounds().getSize();
        return this.controller.getGraphView().dimensionFromZoomedDimension(viewBounds);
    }

    public Rectangle getViewVisibleRect() {
        Rectangle visibleRect = this.controller.getGraphView().getVisibleRect();
        return this.controller.getGraphView().rectangleFromZoomedRectangle(visibleRect);
    }

    public void scrollView(int deltaX, int deltaY) {
        int zoomLevel = this.controller.getGraphView().getZoomLevel();
        deltaX = (int)((double)(deltaX * zoomLevel) / 100.0);
        deltaY = (int)((double)(deltaY * zoomLevel) / 100.0);
        Rectangle rect = this.controller.getGraphView().getVisibleRect();
        rect.translate(deltaX, deltaY);
        this.controller.getGraphView().scrollRectToVisible(rect);
    }

    public void addThumbnailViewSourceListener(ThumbnailViewSourceListener lsnr) {
        this.thumbnailViewSourceListeners.add(lsnr);
    }

    public void removeThumbnailViewSourceListener(ThumbnailViewSourceListener lsnr) {
        this.thumbnailViewSourceListeners.remove(lsnr);
    }

    protected void setupThumbnailListeners() {
        this.controller.getGraphView().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                GraphComponent.this.fireThumbnailViewSourceEvent(new ThumbnailViewSourceEvent(GraphComponent.this), 1);
            }
        });
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GraphComponent.this.fireThumbnailViewSourceEvent(new ThumbnailViewSourceEvent(GraphComponent.this), 2);
            }
        });
        this.controller.getGraphGenerator().addGraphGeneratorListener(new GraphGeneratorListener(){

            public void graphChanged(GraphGeneratorEvent evt) {
                GraphComponent.this.fireThumbnailViewSourceEvent(new ThumbnailViewSourceEvent(GraphComponent.this), 3);
            }
        });
    }

    protected void fireThumbnailViewSourceEvent(ThumbnailViewSourceEvent evt, int type) {
        for (ThumbnailViewSourceListener obj : this.thumbnailViewSourceListeners) {
            if (type == 1) {
                obj.sourceViewBoundsChanged(evt);
                continue;
            }
            if (type == 3) {
                obj.sourceViewContentsChanged(evt);
                continue;
            }
            if (type != 2) continue;
            obj.sourceViewVisibleRectChanged(evt);
        }
    }
}

