/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.graph.ui;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import uk.ac.man.cs.mig.util.graph.controller.Controller;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphGeneratorListener;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelEvent;
import uk.ac.man.cs.mig.util.graph.event.GraphSelectionModelListener;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedEvent;
import uk.ac.man.cs.mig.util.graph.event.NodeClickedListener;
import uk.ac.man.cs.mig.util.graph.graph.Graph;
import uk.ac.man.cs.mig.util.graph.graph.Node;
import uk.ac.man.cs.mig.util.graph.renderer.EdgeRenderer;
import uk.ac.man.cs.mig.util.graph.renderer.NodeRenderer;
import uk.ac.man.cs.mig.util.graph.ui.PopupProvider;
import uk.ac.man.cs.mig.util.graph.ui.Zoomable;

public abstract class GraphView
extends JPanel
implements Zoomable,
PropertyChangeListener {
    private static final long serialVersionUID = 2481341666664953350L;
    protected Controller controller;
    protected MouseListener graphViewListener;
    protected GraphSelectionModelListener selectionListener;
    protected GraphGeneratorListener graphGenListener;
    protected ArrayList<NodeClickedListener> nodeClickedListeners;
    private Graph graph;
    private Object prevSelObj = null;
    private boolean updateGraph = true;

    public GraphView(Controller controller) {
        this.controller = controller;
        if (controller.getGraphGenerator() == null) {
            throw new NullPointerException("GraphGenerator must not be null");
        }
        if (controller.getGraphLayoutEngine() == null) {
            throw new NullPointerException("GraphLayoutEngine must not be null");
        }
        controller.addPropertyChangeListener(this);
        this.nodeClickedListeners = new ArrayList();
        this.setupGraphViewListeners();
    }

    private void setupGraphViewListeners() {
        this.graphViewListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Graph g = GraphView.this.controller.getGraphGenerator().getGraph();
                Node[] nodes = g.getNodes();
                int zoomLevel = GraphView.this.getZoomLevel();
                for (int i = 0; i < nodes.length; ++i) {
                    int xPos = (int)((double)e.getPoint().x * 100.0 / (double)zoomLevel);
                    int yPos = (int)((double)e.getPoint().y * 100.0 / (double)zoomLevel);
                    if (!nodes[i].getShape().contains(xPos, yPos)) continue;
                    GraphView.this.prevSelObj = nodes[i].getUserObject();
                    GraphView.this.controller.getGraphSelectionModel().setSelectedObject(GraphView.this.prevSelObj);
                    break;
                }
            }

            public void mouseClicked(MouseEvent e) {
                Graph g = GraphView.this.controller.getGraphGenerator().getGraph();
                Node[] nodes = g.getNodes();
                int zoomLevel = GraphView.this.getZoomLevel();
                for (int i = 0; i < nodes.length; ++i) {
                    int xPos = (int)((double)e.getPoint().x * 100.0 / (double)zoomLevel);
                    int yPos = (int)((double)e.getPoint().y * 100.0 / (double)zoomLevel);
                    if (!nodes[i].getShape().contains(xPos, yPos)) continue;
                    GraphView.this.fireNodeClickedEvent(nodes[i], e);
                    break;
                }
            }
        };
        this.addMouseListener(this.graphViewListener);
        this.selectionListener = new GraphSelectionModelListener(){

            public void selectionChanged(GraphSelectionModelEvent event) {
                GraphView.this.repaint();
                if (GraphView.this.controller.getGraphSelectionModel().getSelectedObject() != GraphView.this.prevSelObj) {
                    GraphView.this.prevSelObj = GraphView.this.controller.getGraphSelectionModel().getSelectedObject();
                    GraphView.this.scrollObjectToVisible(GraphView.this.prevSelObj);
                }
            }
        };
        this.controller.getGraphSelectionModel().addGraphSelectionModelListener(this.selectionListener);
        this.graphGenListener = new GraphGeneratorListener(){

            public void graphChanged(GraphGeneratorEvent evt) {
                GraphView.this.updateGraph = true;
                if (GraphView.this.isShowing() && GraphView.this.updateGraph) {
                    GraphView.this.revalidateGraph();
                }
            }
        };
        this.controller.getGraphGenerator().addGraphGeneratorListener(this.graphGenListener);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (GraphView.this.updateGraph) {
                    GraphView.this.revalidateGraph();
                }
            }
        });
    }

    public void addNodeClickedListener(NodeClickedListener lsnr) {
        this.nodeClickedListeners.add(lsnr);
    }

    public void removeNodeClickedListener(NodeClickedListener lsnr) {
        this.nodeClickedListeners.remove(lsnr);
    }

    protected void fireNodeClickedEvent(Node node, MouseEvent evt) {
        NodeClickedEvent nce = new NodeClickedEvent(node, evt);
        for (int i = 0; i < this.nodeClickedListeners.size(); ++i) {
            this.nodeClickedListeners.get(i).nodeClicked(nce);
        }
    }

    protected void setGraph() {
        this.graph = this.controller.getGraphGenerator().getGraph();
        this.repaint();
    }

    protected Graph getGraph() {
        return this.graph;
    }

    protected Iterator getNodes() {
        return this.graph.getNodeIterator();
    }

    protected Iterator getEdges() {
        return this.graph.getEdgeIterator();
    }

    public void scrollObjectToVisible(Object obj) {
        Node node = this.controller.getGraphGenerator().getNodeForObject(obj);
        if (node != null) {
            Rectangle rect = node.getShape().getBounds();
            rect.grow(20, 20);
            this.scrollRectToVisible(rect);
        }
    }

    public abstract void setNodeRenderer(NodeRenderer var1);

    public abstract void setEdgeRenderer(EdgeRenderer var1);

    public abstract void setPopupProvider(PopupProvider var1);

    public abstract void draw(Graphics2D var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public void revalidateGraph() {
        this.setGraph();
        this.controller.getGraphLayoutEngine().layoutGraph(this.graph);
        this.revalidate();
        this.updateGraph = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("graphGenerator")) {
            // empty if block
        }
    }
}

