/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import uk.ac.man.cs.mig.util.popup.PopupComponentEvent;
import uk.ac.man.cs.mig.util.popup.PopupComponentListener;

public class PopupComponent
extends JComponent {
    private static final long serialVersionUID = 3620321891933114176L;
    private boolean POPUP_IS_MODAL = true;
    private boolean HIDE_ON_CLICK = true;
    private boolean HIDE_ON_TIMER = false;
    private int HIDE_TIMER_DELAY = 0;
    private boolean FORWARD_MOUSE_MOTION_EVENTS = true;
    private Timer timer;
    private JComponent content;
    private JComponent glassPane = new JPanel(null);
    private ArrayList<PopupComponentListener> listeners;
    private boolean mouseOverGlassPane;

    public PopupComponent(JComponent content) {
        this(content, true, 0, false);
    }

    public PopupComponent(JComponent content, boolean hideOnClick, int timerDelay, boolean isModal) {
        this.glassPane.setLayout(null);
        this.glassPane.add(content);
        this.glassPane.setOpaque(false);
        this.listeners = new ArrayList();
        this.setupListeners();
        this.setContent(content);
        this.HIDE_ON_CLICK = hideOnClick;
        this.POPUP_IS_MODAL = isModal;
        if (timerDelay > 0) {
            this.HIDE_ON_TIMER = true;
            this.HIDE_TIMER_DELAY = timerDelay;
            this.timer = new Timer(this.HIDE_TIMER_DELAY, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PopupComponent.this.mouseOverGlassPane) {
                        PopupComponent.this.hidePopup();
                        PopupComponent.this.timer.stop();
                    } else {
                        PopupComponent.this.timer.stop();
                        PopupComponent.this.timer.start();
                    }
                }
            });
        }
    }

    public void showPopup(JComponent component, int x, int y) {
        int deltaY;
        Component rootComp = SwingUtilities.getRoot(component);
        int componentMaxX = rootComp.getSize().width;
        int componentMaxY = rootComp.getSize().height;
        int xPosOnRoot = SwingUtilities.convertPoint((Component)component, (int)x, (int)y, (Component)rootComp).x;
        int yPosOnRoot = SwingUtilities.convertPoint((Component)component, (int)x, (int)y, (Component)rootComp).y;
        int deltaX = xPosOnRoot + this.content.getWidth() - componentMaxX;
        if (deltaX > 0 && (xPosOnRoot -= deltaX) < 0) {
            xPosOnRoot = 0;
        }
        if ((deltaY = yPosOnRoot + this.content.getHeight() - componentMaxY) > 0 && (yPosOnRoot -= deltaY) < 0) {
            yPosOnRoot = 0;
        }
        int xPos = SwingUtilities.convertPoint((Component)rootComp, (int)xPosOnRoot, (int)yPosOnRoot, (Component)component).x;
        int yPos = SwingUtilities.convertPoint((Component)rootComp, (int)xPosOnRoot, (int)yPosOnRoot, (Component)component).y;
        JRootPane rootPane = component.getRootPane();
        rootPane.setGlassPane(this.glassPane);
        Point pt = SwingUtilities.convertPoint(component, xPos, yPos, this.glassPane);
        this.content.setLocation(pt);
        this.glassPane.setVisible(true);
        if (this.HIDE_ON_TIMER) {
            this.timer.stop();
            this.timer.start();
        }
    }

    public void hidePopup() {
        if (this.glassPane.isVisible()) {
            this.glassPane.setVisible(false);
            this.firePopupClosedEvent();
        }
    }

    public void setContent(JComponent content) {
        if (content == null) {
            throw new NullPointerException("Popup content must not be null");
        }
        if (this.content != null) {
            this.glassPane.remove(this.content);
        }
        this.content = content;
        this.content.setSize(this.content.getPreferredSize());
        this.glassPane.add(this.content);
    }

    public void addPopupComponentListener(PopupComponentListener lsnr) {
        this.listeners.add(lsnr);
    }

    public void removePopupComponentListener(PopupComponentListener lsnr) {
        this.listeners.remove(lsnr);
    }

    protected void setupListeners() {
        this.glassPane.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                PopupComponent.this.propagateMouseListenerEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                this.handleHidePopup(e);
                PopupComponent.this.propagateMouseListenerEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                PopupComponent.this.propagateMouseListenerEvent(e);
            }

            public void mouseEntered(MouseEvent e) {
                PopupComponent.this.mouseOverGlassPane = true;
            }

            public void mouseExited(MouseEvent e) {
                PopupComponent.this.mouseOverGlassPane = false;
            }

            private void handleHidePopup(MouseEvent e) {
                if (PopupComponent.this.HIDE_ON_CLICK) {
                    PopupComponent.this.hidePopup();
                }
            }
        });
        this.glassPane.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                PopupComponent.this.propagateMouseMotionListenerEvents(e);
            }

            public void mouseMoved(MouseEvent e) {
                PopupComponent.this.propagateMouseMotionListenerEvents(e);
            }
        });
    }

    protected void firePopupClosedEvent() {
        PopupComponentEvent evt = new PopupComponentEvent(this);
        Iterator<PopupComponentListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().popupClosed(evt);
        }
    }

    protected Component getDeepestComponent(Point pt) {
        SwingUtilities.getRoot(this.glassPane);
        Container contentPane = this.glassPane.getRootPane().getContentPane();
        Point contentPanePt = SwingUtilities.convertPoint(this.glassPane, pt, contentPane);
        Component deepestComponent = SwingUtilities.getDeepestComponentAt(contentPane, contentPanePt.x, contentPanePt.y);
        return deepestComponent;
    }

    protected void propagateMouseListenerEvent(MouseEvent e) {
        Component deepestComponent;
        if (!this.POPUP_IS_MODAL && (deepestComponent = this.getDeepestComponent(e.getPoint())) != null) {
            MouseListener[] mouseListeners = deepestComponent.getMouseListeners();
            int eventID = e.getID();
            Point pt = e.getPoint();
            Point convertedPt = SwingUtilities.convertPoint(this.glassPane, e.getPoint(), deepestComponent);
            MouseEvent evt = new MouseEvent(deepestComponent, e.getID(), System.currentTimeMillis(), e.getModifiers(), convertedPt.x, convertedPt.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < mouseListeners.length; ++i) {
                if (eventID == 501) {
                    mouseListeners[i].mousePressed(evt);
                    continue;
                }
                if (eventID == 502) {
                    mouseListeners[i].mouseReleased(evt);
                    continue;
                }
                if (eventID != 500) continue;
                mouseListeners[i].mouseClicked(evt);
            }
        }
    }

    protected void propagateMouseMotionListenerEvents(MouseEvent e) {
        Component deepestComponent;
        if (this.FORWARD_MOUSE_MOTION_EVENTS && (deepestComponent = this.getDeepestComponent(e.getPoint())) != null) {
            MouseMotionListener[] mouseMotionListeners = deepestComponent.getMouseMotionListeners();
            int eventID = e.getID();
            Point pt = e.getPoint();
            Point convertedPt = SwingUtilities.convertPoint(this.glassPane, e.getPoint(), deepestComponent);
            MouseEvent evt = new MouseEvent(deepestComponent, e.getID(), System.currentTimeMillis(), e.getModifiers(), convertedPt.x, convertedPt.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < mouseMotionListeners.length; ++i) {
                if (eventID == 503) {
                    mouseMotionListeners[i].mouseMoved(e);
                    continue;
                }
                if (eventID != 506) continue;
                mouseMotionListeners[i].mouseDragged(e);
            }
        }
    }

    public boolean popupIsDisplayed() {
        return this.glassPane.isVisible();
    }
}

