/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.mig.util.popup.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import uk.ac.man.cs.mig.util.popup.PopupComponent;
import uk.ac.man.cs.mig.util.popup.PopupComponentEvent;
import uk.ac.man.cs.mig.util.popup.PopupComponentListener;

public class PopupComponentTest
extends JFrame {
    private static final long serialVersionUID = 3963717704220489047L;
    private static Logger log = Logger.getLogger(PopupComponentTest.class);
    private PopupComponent popup;
    private JComponent comp;
    private JList list;
    private JPanel panl;
    private JButton button;

    public PopupComponentTest() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Popup Test");
        this.setSize(800, 600);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel pan = new JPanel();
        this.getContentPane().add(pan);
        this.list = new JList<Object>(new Object[]{"One", "Two", "Three", "Four"});
        this.panl = new JPanel(new BorderLayout());
        this.panl.add(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    log.info((Object)"TRACE(PopupComonentTest): Setting list ");
                    PopupComponentTest.this.list.setListData(new Object[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight"});
                }
            }
        });
        this.list.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.button = new JButton();
        this.popup = new PopupComponent(this.panl, false, 5000, false);
        this.popup.addPopupComponentListener(new PopupComponentListener(){

            public void popupClosed(PopupComponentEvent e) {
                log.info((Object)"Popup Closed");
            }
        });
        pan.setLayout(new BorderLayout());
        this.comp = new JButton("Test button 1.......");
        pan.add((Component)this.comp, "West");
        pan.add((Component)new JButton("Test button 2......."), "East");
        pan.add((Component)new JButton("Test button 3"), "North");
        pan.add((Component)new JButton("Test button 4"), "South");
        pan.add(new JPanel());
        this.comp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    log.info((Object)("TRACE(PopupComponentTest): Show popup at " + e.getPoint()));
                    PopupComponentTest.this.popup.showPopup(PopupComponentTest.this.comp, e.getPoint().x, e.getPoint().y);
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        menu.add(new AbstractAction("Set button component"){
            private static final long serialVersionUID = -999335719559335568L;

            public void actionPerformed(ActionEvent e) {
                PopupComponentTest.this.popup.setContent(PopupComponentTest.this.button);
            }
        });
        menu.add(new AbstractAction("Set list component"){
            private static final long serialVersionUID = 1573045829861729839L;

            public void actionPerformed(ActionEvent e) {
                PopupComponentTest.this.popup.setContent(PopupComponentTest.this.panl);
            }
        });
        this.setVisible(true);
    }

    public static void main(String[] args) {
        PopupComponentTest t = new PopupComponentTest();
    }
}

