/*
 * Decompiled with CFR 0.152.
 */
package org.coode.dlquery;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.coode.dlquery.ResultsList;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.cache.OWLExpressionUserCache;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.ReasonerUtilities;
import org.protege.editor.owl.ui.CreateDefinedClassPanel;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;

public class OWLClassExpressionEditorViewComponent
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = 8268241587271333587L;
    Logger log = Logger.getLogger(OWLClassExpressionEditorViewComponent.class);
    private ExpressionEditor<OWLClassExpression> owlDescriptionEditor;
    private ResultsList resultsList;
    private JCheckBox showSuperClassesCheckBox;
    private JCheckBox showAncestorClassesCheckBox;
    private JCheckBox showEquivalentClassesCheckBox;
    private JCheckBox showSubClassesCheckBox;
    private JCheckBox showDescendantClassesCheckBox;
    private JCheckBox showIndividualsCheckBox;
    private JButton executeButton;
    private JButton addButton;
    private OWLModelManagerListener listener;
    private boolean requiresRefresh = false;

    protected void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout(10, 10));
        JComponent editorPanel = this.createQueryPanel();
        JComponent resultsPanel = this.createResultsPanel();
        JComponent optionsBox = this.createOptionsBox();
        resultsPanel.add((Component)optionsBox, "East");
        JSplitPane splitter = new JSplitPane(0, editorPanel, resultsPanel);
        splitter.setDividerLocation(0.3);
        this.add(splitter, "Center");
        this.updateGUI();
        this.listener = new OWLModelManagerListener(){

            public void handleChange(OWLModelManagerChangeEvent event) {
                if (event.isType(EventType.ONTOLOGY_CLASSIFIED)) {
                    OWLClassExpressionEditorViewComponent.this.doQuery();
                }
            }
        };
        this.getOWLModelManager().addListener(this.listener);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent event) {
                if (OWLClassExpressionEditorViewComponent.this.requiresRefresh && OWLClassExpressionEditorViewComponent.this.isShowing()) {
                    OWLClassExpressionEditorViewComponent.this.doQuery();
                }
            }
        });
    }

    private JComponent createQueryPanel() {
        JPanel editorPanel = new JPanel(new BorderLayout());
        OWLExpressionChecker checker = this.getOWLModelManager().getOWLExpressionCheckerFactory().getOWLClassExpressionChecker();
        this.owlDescriptionEditor = new ExpressionEditor(this.getOWLEditorKit(), checker);
        this.owlDescriptionEditor.addStatusChangedListener(new InputVerificationStatusChangedListener(){

            public void verifiedStatusChanged(boolean newState) {
                OWLClassExpressionEditorViewComponent.this.executeButton.setEnabled(newState);
                OWLClassExpressionEditorViewComponent.this.addButton.setEnabled(newState);
            }
        });
        this.owlDescriptionEditor.setPreferredSize(new Dimension(100, 50));
        editorPanel.add((Component)ComponentFactory.createScrollPane(this.owlDescriptionEditor), "Center");
        JPanel buttonHolder = new JPanel(new FlowLayout(0));
        this.executeButton = new JButton(new AbstractAction("Execute"){
            private static final long serialVersionUID = -1833321282125901561L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        this.addButton = new JButton(new AbstractAction("Add to ontology"){
            private static final long serialVersionUID = -6050625862820344594L;

            public void actionPerformed(ActionEvent event) {
                OWLClassExpressionEditorViewComponent.this.doAdd();
            }
        });
        buttonHolder.add(this.executeButton);
        buttonHolder.add(this.addButton);
        editorPanel.add((Component)buttonHolder, "South");
        editorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), "Query (class expression)"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        return editorPanel;
    }

    private JComponent createResultsPanel() {
        JPanel resultsPanel = new JPanel(new BorderLayout(10, 10));
        resultsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), "Query results"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.resultsList = new ResultsList(this.getOWLEditorKit());
        this.resultsList.setShowSubClasses(true);
        resultsPanel.add(ComponentFactory.createScrollPane((JComponent)((Object)this.resultsList)));
        return resultsPanel;
    }

    private JComponent createOptionsBox() {
        Box optionsBox = new Box(1);
        this.showSuperClassesCheckBox = new JCheckBox(new AbstractAction("Super classes"){
            private static final long serialVersionUID = 1531417504526875891L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.resultsList.setShowSuperClasses(OWLClassExpressionEditorViewComponent.this.showSuperClassesCheckBox.isSelected());
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        optionsBox.add(this.showSuperClassesCheckBox);
        optionsBox.add(Box.createVerticalStrut(3));
        this.showAncestorClassesCheckBox = new JCheckBox(new AbstractAction("Ancestor classes"){
            private static final long serialVersionUID = 4603049796331219219L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.resultsList.setShowAncestorClasses(OWLClassExpressionEditorViewComponent.this.showAncestorClassesCheckBox.isSelected());
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        this.showAncestorClassesCheckBox.setSelected(false);
        optionsBox.add(this.showAncestorClassesCheckBox);
        optionsBox.add(Box.createVerticalStrut(3));
        this.showEquivalentClassesCheckBox = new JCheckBox(new AbstractAction("Equivalent classes"){
            private static final long serialVersionUID = -3766966095409342054L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.resultsList.setShowEquivalentClasses(OWLClassExpressionEditorViewComponent.this.showEquivalentClassesCheckBox.isSelected());
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        optionsBox.add(this.showEquivalentClassesCheckBox);
        optionsBox.add(Box.createVerticalStrut(3));
        this.showSubClassesCheckBox = new JCheckBox(new AbstractAction("Subclasses"){
            private static final long serialVersionUID = 696913194074753412L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.resultsList.setShowSubClasses(OWLClassExpressionEditorViewComponent.this.showSubClassesCheckBox.isSelected());
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        optionsBox.add(this.showSubClassesCheckBox);
        optionsBox.add(Box.createVerticalStrut(3));
        this.showDescendantClassesCheckBox = new JCheckBox(new AbstractAction("Descendant classes"){
            private static final long serialVersionUID = -3418802363566640471L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.resultsList.setShowDescendantClasses(OWLClassExpressionEditorViewComponent.this.showDescendantClassesCheckBox.isSelected());
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        this.showDescendantClassesCheckBox.setSelected(false);
        optionsBox.add(this.showDescendantClassesCheckBox);
        optionsBox.add(Box.createVerticalStrut(3));
        this.showIndividualsCheckBox = new JCheckBox(new AbstractAction("Individuals"){
            private static final long serialVersionUID = -7727032635999833150L;

            public void actionPerformed(ActionEvent e) {
                OWLClassExpressionEditorViewComponent.this.resultsList.setShowInstances(OWLClassExpressionEditorViewComponent.this.showIndividualsCheckBox.isSelected());
                OWLClassExpressionEditorViewComponent.this.doQuery();
            }
        });
        optionsBox.add(this.showIndividualsCheckBox);
        return optionsBox;
    }

    protected void disposeOWLView() {
        this.getOWLModelManager().removeListener(this.listener);
    }

    private void updateGUI() {
        this.showSuperClassesCheckBox.setSelected(this.resultsList.isShowSuperClasses());
        this.showAncestorClassesCheckBox.setSelected(this.resultsList.isShowAncestorClasses());
        this.showEquivalentClassesCheckBox.setSelected(this.resultsList.isShowEquivalentClasses());
        this.showSubClassesCheckBox.setSelected(this.resultsList.isShowSubClasses());
        this.showDescendantClassesCheckBox.setSelected(this.resultsList.isShowDescendantClasses());
        this.showIndividualsCheckBox.setSelected(this.resultsList.isShowInstances());
    }

    private void doQuery() {
        if (this.isShowing()) {
            block5: {
                try {
                    OWLReasonerManager reasonerManager = this.getOWLModelManager().getOWLReasonerManager();
                    ReasonerUtilities.warnUserIfReasonerIsNotConfigured((Component)((Object)this), (OWLReasonerManager)reasonerManager);
                    OWLClassExpression desc = (OWLClassExpression)this.owlDescriptionEditor.createObject();
                    if (desc != null) {
                        OWLExpressionUserCache.getInstance((OWLModelManager)this.getOWLModelManager()).add(desc, this.owlDescriptionEditor.getText());
                        this.resultsList.setOWLClassExpression(desc);
                    }
                }
                catch (OWLException e) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug((Object)"Exception caught trying to do the query", (Throwable)e);
                }
            }
            this.requiresRefresh = false;
        } else {
            this.requiresRefresh = true;
        }
    }

    private void doAdd() {
        block4: {
            try {
                OWLClassExpression desc = (OWLClassExpression)this.owlDescriptionEditor.createObject();
                OWLEntityCreationSet creationSet = CreateDefinedClassPanel.showDialog((OWLClassExpression)desc, (OWLEditorKit)this.getOWLEditorKit());
                if (creationSet != null) {
                    this.getOWLModelManager().applyChanges(creationSet.getOntologyChanges());
                    if (this.isSynchronizing()) {
                        this.getOWLEditorKit().getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(creationSet.getOWLEntity());
                    }
                }
            }
            catch (OWLException e) {
                if (!this.log.isDebugEnabled()) break block4;
                this.log.debug((Object)"Exception caught trying to parse DL query", (Throwable)e);
            }
        }
    }
}

