/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.cli;

import gnu.getopt.Getopt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.EntailmentChecker;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.HermiT.cli.Option;
import org.semanticweb.HermiT.monitor.Timer;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.util.AutoIRIMapper;

public class CommandLine {
    protected static final int kTime = 1000;
    protected static final int kDumpClauses = 1001;
    protected static final int kDumpRoleBox = 1002;
    protected static final int kDirectBlock = 1003;
    protected static final int kBlockStrategy = 1004;
    protected static final int kBlockCache = 1005;
    protected static final int kExpansion = 1006;
    protected static final int kBase = 1007;
    protected static final int kParser = 1008;
    protected static final int kDefaultPrefix = 1009;
    protected static final int kDumpPrefixes = 1010;
    protected static final int kTaxonomy = 1011;
    protected static final int kIgnoreUnsupportedDatatypes = 1012;
    protected static final int kPremise = 1013;
    protected static final int kConclusion = 1014;
    protected static final String versionString;
    protected static final String usageString = "Usage: hermit [OPTION]... IRI...";
    protected static final String[] helpHeader;
    protected static final String[] footer;
    protected static final String kMisc = "Miscellaneous";
    protected static final String kActions = "Actions";
    protected static final String kParsing = "Parsing and loading";
    protected static final String kPrefixes = "Prefix name and IRI";
    protected static final String kAlgorithm = "Algorithm settings (expert users only!)";
    protected static final String kInternals = "Internals and debugging (unstable)";
    protected static final Option[] options;

    public static void main(String[] stringArray) {
        try {
            int n;
            URI uRI;
            int n2 = 1;
            boolean bl = false;
            PrintWriter printWriter = new PrintWriter(System.out);
            String[] stringArray2 = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            LinkedList<Action> linkedList = new LinkedList<Action>();
            IRI iRI = null;
            Configuration configuration = new Configuration();
            boolean bl6 = true;
            try {
                uRI = new URI("file", System.getProperty("user.dir") + "/", null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("unable to create default IRI base");
            }
            LinkedList<IRI> linkedList2 = new LinkedList<IRI>();
            boolean bl7 = false;
            Object object = new Getopt("java-jar Hermit.jar", stringArray, Option.formatOptionsString(options), Option.createLongOpts(options));
            ((Getopt)object).setOpterr(false);
            block54: while ((n = ((Getopt)object).getopt()) != -1) {
                switch (n) {
                    case 104: {
                        System.out.println(usageString);
                        for (String string2 : helpHeader) {
                            System.out.println(string2);
                        }
                        System.out.println(Option.formatOptionHelp(options));
                        for (String string3 : footer) {
                            System.out.println(string3);
                        }
                        System.exit(0);
                        bl7 = true;
                        continue block54;
                    }
                    case 86: {
                        System.out.println(versionString);
                        for (String string4 : footer) {
                            System.out.println(string4);
                        }
                        System.exit(0);
                        bl7 = true;
                        continue block54;
                    }
                    case 118: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (object3 == null) {
                            ++n2;
                            continue block54;
                        }
                        try {
                            n2 += Integer.parseInt((String)object3, 10);
                            continue block54;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new UsageException("argument to --verbose must be a number");
                        }
                    }
                    case 113: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (object3 == null) {
                            --n2;
                            continue block54;
                        }
                        try {
                            n2 -= Integer.parseInt((String)object3, 10);
                            continue block54;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new UsageException("argument to --quiet must be a number");
                        }
                    }
                    case 111: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (object3 == null) {
                            throw new UsageException("--output requires an argument");
                        }
                        if (((String)object3).equals("-")) {
                            printWriter = new PrintWriter(System.out);
                            continue block54;
                        }
                        try {
                            File file = new File((String)object3);
                            if (!file.exists()) {
                                file.createNewFile();
                            }
                            file = file.getAbsoluteFile();
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            printWriter = new PrintWriter(bufferedOutputStream, true);
                            string = file.getAbsolutePath();
                            continue block54;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new IllegalArgumentException("unable to open " + (String)object3 + " for writing");
                        }
                        catch (SecurityException securityException) {
                            throw new IllegalArgumentException("unable to write to " + (String)object3);
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException("unable to write to " + (String)object3 + ": " + iOException.getMessage());
                        }
                    }
                    case 1013: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (object3 == null) {
                            throw new UsageException("--premise requires a IRI as argument");
                        }
                        linkedList2.add(IRI.create((String)object3));
                        continue block54;
                    }
                    case 1014: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (object3 == null) {
                            throw new UsageException("--conclusion requires a IRI as argument");
                        }
                        iRI = IRI.create((String)object3);
                        continue block54;
                    }
                    case 108: {
                        continue block54;
                    }
                    case 99: {
                        bl2 = true;
                        continue block54;
                    }
                    case 79: {
                        bl3 = true;
                        continue block54;
                    }
                    case 68: {
                        bl4 = true;
                        continue block54;
                    }
                    case 80: {
                        bl5 = true;
                        continue block54;
                    }
                    case 107: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (object3 == null) {
                            object3 = "<http://www.w3.org/2002/07/owl#Thing>";
                        }
                        linkedList.add(new SatisfiabilityAction((String)object3));
                        continue block54;
                    }
                    case 100: {
                        bl6 = false;
                        continue block54;
                    }
                    case 115: {
                        Object object3 = ((Getopt)object).getOptarg();
                        linkedList.add(new SubsAction((String)object3, bl6));
                        bl6 = true;
                        continue block54;
                    }
                    case 83: {
                        Object object3 = ((Getopt)object).getOptarg();
                        linkedList.add(new SupersAction((String)object3, bl6));
                        bl6 = true;
                        continue block54;
                    }
                    case 101: {
                        Object object3 = ((Getopt)object).getOptarg();
                        linkedList.add(new EquivalentsAction((String)object3));
                        continue block54;
                    }
                    case 85: {
                        linkedList.add(new EquivalentsAction("<http://www.w3.org/2002/07/owl#Nothing>"));
                        continue block54;
                    }
                    case 69: {
                        if (iRI == null) continue block54;
                        linkedList.add(new EntailsAction(configuration, iRI));
                        continue block54;
                    }
                    case 1010: {
                        linkedList.add(new DumpPrefixesAction());
                        continue block54;
                    }
                    case 78: {
                        bl = true;
                        continue block54;
                    }
                    case 112: {
                        Object object3 = ((Getopt)object).getOptarg();
                        int n3 = ((String)object3).indexOf(61);
                        if (n3 == -1) {
                            throw new IllegalArgumentException("the prefix declaration '" + (String)object3 + "' is not of the form PN=IRI.");
                        }
                        hashMap.put(((String)object3).substring(0, n3), ((String)object3).substring(n3 + 1));
                        continue block54;
                    }
                    case 1009: {
                        Object object3 = ((Getopt)object).getOptarg();
                        stringArray2 = object3;
                        continue block54;
                    }
                    case 1007: {
                        Object object3 = ((Getopt)object).getOptarg();
                        try {
                            uRI = new URI((String)object3);
                            continue block54;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new IllegalArgumentException("'" + (String)object3 + "' is not a valid base URI.");
                        }
                    }
                    case 1003: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (((String)object3).toLowerCase().equals("pairwise")) {
                            configuration.directBlockingType = Configuration.DirectBlockingType.PAIR_WISE;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("single")) {
                            configuration.directBlockingType = Configuration.DirectBlockingType.SINGLE;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("optimal")) {
                            configuration.directBlockingType = Configuration.DirectBlockingType.OPTIMAL;
                            continue block54;
                        }
                        throw new UsageException("unknown direct blocking type '" + (String)object3 + "'; supported values are 'pairwise', 'single', and 'optimal'");
                    }
                    case 1004: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (((String)object3).toLowerCase().equals("anywhere")) {
                            configuration.blockingStrategyType = Configuration.BlockingStrategyType.ANYWHERE;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("ancestor")) {
                            configuration.blockingStrategyType = Configuration.BlockingStrategyType.ANCESTOR;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("core")) {
                            configuration.blockingStrategyType = Configuration.BlockingStrategyType.SIMPLE_CORE;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("optimal")) {
                            configuration.blockingStrategyType = Configuration.BlockingStrategyType.OPTIMAL;
                            continue block54;
                        }
                        throw new UsageException("unknown blocking strategy type '" + (String)object3 + "'; supported values are 'ancestor' and 'anywhere'");
                    }
                    case 1005: {
                        configuration.blockingSignatureCacheType = Configuration.BlockingSignatureCacheType.CACHED;
                        continue block54;
                    }
                    case 1006: {
                        Object object3 = ((Getopt)object).getOptarg();
                        if (((String)object3).toLowerCase().equals("creation")) {
                            configuration.existentialStrategyType = Configuration.ExistentialStrategyType.CREATION_ORDER;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("el")) {
                            configuration.existentialStrategyType = Configuration.ExistentialStrategyType.EL;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("reuse")) {
                            configuration.existentialStrategyType = Configuration.ExistentialStrategyType.INDIVIDUAL_REUSE;
                            continue block54;
                        }
                        if (((String)object3).toLowerCase().equals("optimal")) {
                            configuration.existentialStrategyType = Configuration.ExistentialStrategyType.OPTIMAL;
                            continue block54;
                        }
                        throw new UsageException("unknown existential strategy type '" + (String)object3 + "'; supported values are 'creation', 'el', and 'reuse'");
                    }
                    case 1012: {
                        configuration.ignoreUnsupportedDatatypes = true;
                        continue block54;
                    }
                    case 1001: {
                        linkedList.add(new DumpClausesAction(((Getopt)object).getOptarg()));
                        continue block54;
                    }
                }
                if (((Getopt)object).getOptopt() != 0) {
                    throw new UsageException("invalid option -- " + (char)((Getopt)object).getOptopt());
                }
                throw new UsageException("invalid option");
            }
            for (int i = ((Getopt)object).getOptind(); i < stringArray.length; ++i) {
                try {
                    linkedList2.add(IRI.create((URI)uRI.resolve(stringArray[i])));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new UsageException(stringArray[i] + " is not a valid ontology name");
                }
            }
            object = new StatusOutput(n2);
            if (n2 > 3) {
                configuration.monitor = new Timer(new PrintWriter(System.err));
            }
            if (bl2 || bl3 || bl4) {
                linkedList.add(new ClassifyAction(bl2, bl3, bl4, bl5, string));
            }
            for (IRI iRI2 : linkedList2) {
                bl7 = true;
                ((StatusOutput)object).log(2, "Processing " + iRI2.toString());
                ((StatusOutput)object).log(2, String.valueOf(linkedList.size()) + " actions");
                try {
                    Object object2;
                    File file;
                    URI uRI2;
                    String string5;
                    long l = System.currentTimeMillis();
                    OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
                    if (iRI2.isAbsolute() && (string5 = (uRI2 = URI.create(iRI2.getStart())).getScheme()) != null && string5.equalsIgnoreCase("file") && (file = new File(URI.create(iRI2.getStart()))).isDirectory()) {
                        object2 = new AutoIRIMapper(file, false);
                        oWLOntologyManager.addIRIMapper((OWLOntologyIRIMapper)object2);
                    }
                    uRI2 = oWLOntologyManager.loadOntology(iRI2);
                    long l2 = System.currentTimeMillis() - l;
                    ((StatusOutput)object).log(2, "Ontology parsed in " + String.valueOf(l2) + " msec.");
                    l = System.currentTimeMillis();
                    object2 = new Reasoner(configuration, (OWLOntology)uRI2);
                    Prefixes prefixes = ((Reasoner)object2).getPrefixes();
                    if (stringArray2 != null) {
                        try {
                            prefixes.declareDefaultPrefix((String)stringArray2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ((StatusOutput)object).log(2, "Default prefix " + (String)stringArray2 + " could not be registered because there is already a registered default prefix. ");
                        }
                    }
                    for (String string6 : hashMap.keySet()) {
                        try {
                            prefixes.declarePrefix(string6, (String)hashMap.get(string6));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ((StatusOutput)object).log(2, "Prefixname " + string6 + " could not be set to " + (String)hashMap.get(string6) + " because there is already a registered prefix name for the IRI. ");
                        }
                    }
                    long l3 = System.currentTimeMillis() - l;
                    ((StatusOutput)object).log(2, "Reasoner created in " + String.valueOf(l3) + " msec.");
                    for (Action action : linkedList) {
                        ((StatusOutput)object).log(2, "Doing action...");
                        l = System.currentTimeMillis();
                        action.run((Reasoner)object2, (StatusOutput)object, printWriter, bl);
                        long l4 = System.currentTimeMillis() - l;
                        ((StatusOutput)object).log(2, "...action completed in " + String.valueOf(l4) + " msec.");
                    }
                }
                catch (OWLException oWLException) {
                    System.err.println("It all went pear-shaped: " + oWLException.getMessage());
                    oWLException.printStackTrace(System.err);
                }
            }
            if (!bl7) {
                throw new UsageException("No ontologies given.");
            }
        }
        catch (UsageException usageException) {
            System.err.println(usageException.getMessage());
            System.err.println(usageString);
            System.err.println("Try 'hermit --help' for more information.");
        }
    }

    static {
        String string = CommandLine.class.getPackage().getImplementationVersion();
        if (string == null) {
            string = "<no version set>";
        }
        versionString = string;
        helpHeader = new String[]{"Perform reasoning on each OWL ontology IRI.", "Example: java -jar Hermit.jar -dsowl:Thing http://www.co-ode.org/ontologies/pizza/2005/05/16/pizza.owl", "    (prints direct subclasses of owl:Thing within the pizza ontology)", "Example: java -jar Hermit.jar --premise=http://km.aifb.uni-karlsruhe.de/projects/owltests/index.php/Special:GetOntology/New-Feature-DisjointObjectProperties-002?m=p --conclusion=http://km.aifb.uni-karlsruhe.de/projects/owltests/index.php/Special:GetOntology/New-Feature-DisjointObjectProperties-002?m=c --checkEntailment", "    (checks whether the conclusion ontology is entailed by the premise ontology)", "", "Both relative and absolute ontology IRIs can be used. Relative IRIs", "are resolved with respect to the current directory (i.e. local file", "names are valid IRIs); this behavior can be changed with the '--base'", "option.", "", "Classes and properties are identified using functional-syntax-style", "identifiers: names not containing a colon are resolved against the", "ontology's default prefix; otherwise the portion of the name", "preceding the colon is treated as a prefix prefix. Use of", "prefixes can be controlled using the -p, -N, and --prefix", "options. Alternatively, classes and properties can be identified with", "full IRIs by enclosing the IRI in <angle brackets>.", "", "By default, ontologies are simply retrieved and parsed. For more", "interesting reasoning, set one of the -c/-k/-s/-S/-e/-U options."};
        footer = new String[]{"HermiT is a product of Oxford University.", "Visit <http://hermit-reasoner.org/> for details."};
        options = new Option[]{new Option(104, "help", kMisc, "display this help and exit"), new Option(86, "version", kMisc, "display version information and exit"), new Option(118, "verbose", kMisc, false, "AMOUNT", "increase verbosity by AMOUNT levels (default 1)"), new Option(113, "quiet", kMisc, false, "AMOUNT", "decrease verbosity by AMOUNT levels (default 1)"), new Option(111, "output", kMisc, true, "FILE", "write output to FILE"), new Option(1013, "premise", kMisc, true, "PREMISE", "set the premise ontology to PREMISE"), new Option(1014, "conclusion", kMisc, true, "CONCLUSION", "set the conclusion ontology to CONCLUSION"), new Option(108, "load", kActions, "parse and preprocess ontologies (default action)"), new Option(99, "classify", kActions, "classify the classes of the ontology, optionally writing taxonomy to a file if -o (--output) is used"), new Option(79, "classifyOPs", kActions, "classify the object properties of the ontology, optionally writing taxonomy to a file if -o (--output) is used"), new Option(68, "classifyDPs", kActions, "classify the data properties of the ontology, optionally writing taxonomy to a file if -o (--output) is used"), new Option(80, "prettyPrint", kActions, "when writing the classified hierarchy to a file, create a proper ontology and nicely indent the axioms according to their leven in the hierarchy"), new Option(107, "consistency", kActions, false, "CLASS", "check satisfiability of CLASS (default owl:Thing)"), new Option(100, "direct", kActions, "restrict next subs/supers call to only direct sub/superclasses"), new Option(115, "subs", kActions, true, "CLASS", "output classes subsumed by CLASS (or only direct subs if following --direct)"), new Option(83, "supers", kActions, true, "CLASS", "output classes subsuming CLASS (or only direct supers if following --direct)"), new Option(101, "equivalents", kActions, true, "CLASS", "output classes equivalent to CLASS"), new Option(85, "unsatisfiable", kActions, "output unsatisfiable classes (equivalent to --equivalents=owl:Nothing)"), new Option(1010, "print-prefixes", kActions, "output prefix names available for use in identifiers"), new Option(69, "checkEntailment", kActions, "check whether the premise (option premise) ontology entails the conclusion ontology (option conclusion)"), new Option(78, "no-prefixes", kPrefixes, "do not abbreviate or expand identifiers using prefixes defined in input ontology"), new Option(112, "prefix", kPrefixes, true, "PN=IRI", "use PN as an abbreviation for IRI in identifiers"), new Option(1009, "prefix", kPrefixes, true, "IRI", "use IRI as the default identifier prefix"), new Option(1003, "block-match", kAlgorithm, true, "TYPE", "identify blocked nodes with TYPE blocking; supported values are 'single', 'pairwise', and 'optimal' (default 'optimal')"), new Option(1004, "block-strategy", kAlgorithm, true, "TYPE", "use TYPE as blocking strategy; supported values are 'ancestor', 'anywhere', 'core', and 'optimal' (default 'optimal')"), new Option(1005, "blockersCache", kAlgorithm, "cache blocking nodes for use in later tests; not possible with nominals or core blocking"), new Option(1012, "ignoreUnsupportedDatatypes", kAlgorithm, "ignore unsupported datatypes"), new Option(1006, "expansion-strategy", kAlgorithm, true, "TYPE", "use TYPE as existential expansion strategy; supported values are 'el', 'creation', 'reuse', and 'optimal' (default 'optimal')"), new Option(1001, "dump-clauses", kInternals, false, "FILE", "output DL-clauses to FILE (default stdout)")};
    }

    protected static class EntailsAction
    implements Action {
        final IRI conclusionIRI;

        public EntailsAction(Configuration configuration, IRI iRI) {
            this.conclusionIRI = iRI;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            statusOutput.log(2, "Checking whether the loaded ontology entails the conclusion ontology");
            OWLOntologyManager oWLOntologyManager = OWLManager.createOWLOntologyManager();
            try {
                OWLOntology oWLOntology = oWLOntologyManager.loadOntology(this.conclusionIRI);
                statusOutput.log(2, "Conclusion ontology loaded.");
                EntailmentChecker entailmentChecker = new EntailmentChecker(reasoner, oWLOntologyManager.getOWLDataFactory());
                boolean bl2 = entailmentChecker.entails(oWLOntology.getLogicalAxioms());
                statusOutput.log(2, "Conclusion ontology is " + (bl2 ? "" : "not ") + "entailed.");
                printWriter.println(bl2);
            }
            catch (OWLOntologyCreationException oWLOntologyCreationException) {
                oWLOntologyCreationException.printStackTrace();
            }
            printWriter.flush();
        }
    }

    protected static class EquivalentsAction
    implements Action {
        final String conceptName;

        public EquivalentsAction(String string) {
            this.conceptName = string;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            statusOutput.log(2, "Finding equivalents of '" + this.conceptName + "'");
            Prefixes prefixes = reasoner.getPrefixes();
            String string = prefixes.canBeExpanded(this.conceptName) ? prefixes.expandAbbreviatedIRI(this.conceptName) : this.conceptName;
            OWLClass oWLClass = OWLManager.createOWLOntologyManager().getOWLDataFactory().getOWLClass(IRI.create((String)string));
            if (!reasoner.isDefined(oWLClass)) {
                statusOutput.log(0, "Warning: class '" + this.conceptName + "' was not declared in the ontology.");
            }
            Node<OWLClass> node = reasoner.getEquivalentClasses((OWLClassExpression)oWLClass);
            if (bl) {
                printWriter.println("Classes equivalent to '" + this.conceptName + "':");
            } else {
                printWriter.println("Classes equivalent to '" + prefixes.abbreviateIRI(this.conceptName) + "':");
            }
            for (OWLClass oWLClass2 : node) {
                if (bl) {
                    String string2 = oWLClass2.getIRI().toString();
                    if (prefixes.canBeExpanded(string2)) {
                        printWriter.println("\t" + prefixes.expandAbbreviatedIRI(string2));
                        continue;
                    }
                    printWriter.println("\t" + string2);
                    continue;
                }
                printWriter.println("\t" + prefixes.abbreviateIRI(oWLClass2.getIRI().toString()));
            }
            printWriter.flush();
        }
    }

    protected static class SubsAction
    implements Action {
        final String conceptName;
        final boolean all;

        public SubsAction(String string, boolean bl) {
            this.conceptName = string;
            this.all = bl;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            NodeSet<OWLClass> nodeSet;
            statusOutput.log(2, "Finding subs of '" + this.conceptName + "'");
            Prefixes prefixes = reasoner.getPrefixes();
            String string = prefixes.canBeExpanded(this.conceptName) ? prefixes.expandAbbreviatedIRI(this.conceptName) : this.conceptName;
            OWLClass oWLClass = OWLManager.createOWLOntologyManager().getOWLDataFactory().getOWLClass(IRI.create((String)string));
            if (!reasoner.isDefined(oWLClass)) {
                statusOutput.log(0, "Warning: class '" + string + "' was not declared in the ontology.");
            }
            if (this.all) {
                nodeSet = reasoner.getSubClasses((OWLClassExpression)oWLClass, false);
                printWriter.println("All sub-classes of '" + this.conceptName + "':");
            } else {
                nodeSet = reasoner.getSubClasses((OWLClassExpression)oWLClass, true);
                printWriter.println("Direct sub-classes of '" + this.conceptName + "':");
            }
            for (Node node : nodeSet) {
                for (OWLClass oWLClass2 : node) {
                    if (bl) {
                        String string2 = oWLClass2.getIRI().toString();
                        if (prefixes.canBeExpanded(string2)) {
                            printWriter.println("\t" + prefixes.expandAbbreviatedIRI(string2));
                            continue;
                        }
                        printWriter.println("\t" + string2);
                        continue;
                    }
                    printWriter.println("\t" + prefixes.abbreviateIRI(oWLClass2.getIRI().toString()));
                }
            }
            printWriter.flush();
        }
    }

    protected static class SupersAction
    implements Action {
        final String conceptName;
        final boolean all;

        public SupersAction(String string, boolean bl) {
            this.conceptName = string;
            this.all = bl;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            NodeSet<OWLClass> nodeSet;
            statusOutput.log(2, "Finding supers of '" + this.conceptName + "'");
            Prefixes prefixes = reasoner.getPrefixes();
            String string = prefixes.canBeExpanded(this.conceptName) ? prefixes.expandAbbreviatedIRI(this.conceptName) : this.conceptName;
            OWLClass oWLClass = OWLManager.createOWLOntologyManager().getOWLDataFactory().getOWLClass(IRI.create((String)string));
            if (!reasoner.isDefined(oWLClass)) {
                statusOutput.log(0, "Warning: class '" + string + "' was not declared in the ontology.");
            }
            if (this.all) {
                nodeSet = reasoner.getSuperClasses((OWLClassExpression)oWLClass, false);
                printWriter.println("All super-classes of '" + this.conceptName + "':");
            } else {
                nodeSet = reasoner.getSuperClasses((OWLClassExpression)oWLClass, false);
                printWriter.println("Direct super-classes of '" + this.conceptName + "':");
            }
            for (Node node : nodeSet) {
                for (OWLClass oWLClass2 : node) {
                    if (bl) {
                        String string2 = oWLClass2.getIRI().toString();
                        if (prefixes.canBeExpanded(string2)) {
                            printWriter.println("\t" + prefixes.expandAbbreviatedIRI(string2));
                            continue;
                        }
                        printWriter.println("\t" + string2);
                        continue;
                    }
                    printWriter.println("\t" + prefixes.abbreviateIRI(oWLClass2.getIRI().toString()));
                }
            }
            printWriter.flush();
        }
    }

    protected static class SatisfiabilityAction
    implements Action {
        final String conceptName;

        public SatisfiabilityAction(String string) {
            this.conceptName = string;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            statusOutput.log(2, "Checking satisfiability of '" + this.conceptName + "'");
            Prefixes prefixes = reasoner.getPrefixes();
            String string = prefixes.canBeExpanded(this.conceptName) ? prefixes.expandAbbreviatedIRI(this.conceptName) : this.conceptName;
            OWLClass oWLClass = OWLManager.createOWLOntologyManager().getOWLDataFactory().getOWLClass(IRI.create((String)string));
            if (!reasoner.isDefined(oWLClass)) {
                statusOutput.log(0, "Warning: class '" + string + "' was not declared in the ontology.");
            }
            boolean bl2 = reasoner.isSatisfiable((OWLClassExpression)oWLClass);
            printWriter.println(this.conceptName + (bl2 ? " is satisfiable." : " is not satisfiable."));
            printWriter.flush();
        }
    }

    protected static class ClassifyAction
    implements Action {
        final boolean classifyClasses;
        final boolean classifyOPs;
        final boolean classifyDPs;
        final boolean prettyPrint;
        final String outputLocation;

        public ClassifyAction(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
            this.classifyClasses = bl;
            this.classifyOPs = bl2;
            this.classifyDPs = bl3;
            this.prettyPrint = bl4;
            this.outputLocation = string;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            HashSet<InferenceType> hashSet = new HashSet<InferenceType>();
            if (this.classifyClasses) {
                hashSet.add(InferenceType.CLASS_HIERARCHY);
            }
            if (this.classifyOPs) {
                hashSet.add(InferenceType.OBJECT_PROPERTY_HIERARCHY);
            }
            if (this.classifyDPs) {
                hashSet.add(InferenceType.DATA_PROPERTY_HIERARCHY);
            }
            statusOutput.log(2, "Classifying...");
            reasoner.precomputeInferences(hashSet.toArray(new InferenceType[0]));
            if (printWriter != null) {
                if (this.outputLocation != null) {
                    statusOutput.log(2, "Writing results to " + this.outputLocation);
                } else {
                    statusOutput.log(2, "Writing results...");
                }
                if (this.prettyPrint) {
                    reasoner.printHierarchies(printWriter, this.classifyClasses, this.classifyOPs, this.classifyDPs);
                } else {
                    reasoner.dumpHierarchies(printWriter, this.classifyClasses, this.classifyOPs, this.classifyDPs);
                }
                printWriter.flush();
            }
        }
    }

    protected static class DumpClausesAction
    implements Action {
        final String file;

        public DumpClausesAction(String string) {
            this.file = string;
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            if (this.file != null) {
                if (this.file.equals("-")) {
                    printWriter = new PrintWriter(System.out);
                } else {
                    FileOutputStream fileOutputStream;
                    try {
                        fileOutputStream = new FileOutputStream(this.file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new IllegalArgumentException("unable to open " + this.file + " for writing");
                    }
                    catch (SecurityException securityException) {
                        throw new IllegalArgumentException("unable to write to " + this.file);
                    }
                    printWriter = new PrintWriter(fileOutputStream);
                }
            }
            if (bl) {
                printWriter.println(reasoner.getDLOntology().toString(new Prefixes()));
            } else {
                printWriter.println(reasoner.getDLOntology().toString(reasoner.getPrefixes()));
            }
            printWriter.flush();
        }
    }

    protected static class DumpPrefixesAction
    implements Action {
        protected DumpPrefixesAction() {
        }

        public void run(Reasoner reasoner, StatusOutput statusOutput, PrintWriter printWriter, boolean bl) {
            printWriter.println("Prefixes:");
            for (Map.Entry<String, String> entry : reasoner.getPrefixes().getPrefixIRIsByPrefixName().entrySet()) {
                printWriter.println("\t" + entry.getKey() + "\t" + entry.getValue());
            }
            printWriter.flush();
        }
    }

    protected static interface Action {
        public void run(Reasoner var1, StatusOutput var2, PrintWriter var3, boolean var4);
    }

    protected static class StatusOutput {
        protected int level;
        public static final int ALWAYS = 0;
        public static final int STATUS = 1;
        public static final int DETAIL = 2;
        public static final int DEBUG = 3;

        public StatusOutput(int n) {
            this.level = n;
        }

        public void log(int n, String string) {
            if (n <= this.level) {
                System.err.println(string);
            }
        }
    }

    protected static class UsageException
    extends IllegalArgumentException {
        public UsageException(String string) {
            super(string);
        }
    }
}

