/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.datetime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.datetime.DateTime;
import org.semanticweb.HermiT.datatypes.datetime.DateTimeInterval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeValueSpaceSubset
implements ValueSpaceSubset {
    protected final List<DateTimeInterval> m_intervals;

    public DateTimeValueSpaceSubset() {
        this.m_intervals = Collections.emptyList();
    }

    public DateTimeValueSpaceSubset(DateTimeInterval dateTimeInterval, DateTimeInterval dateTimeInterval2) {
        this.m_intervals = new ArrayList<DateTimeInterval>(2);
        if (dateTimeInterval != null) {
            this.m_intervals.add(dateTimeInterval);
        }
        if (dateTimeInterval2 != null) {
            this.m_intervals.add(dateTimeInterval2);
        }
    }

    public DateTimeValueSpaceSubset(List<DateTimeInterval> list) {
        this.m_intervals = list;
    }

    @Override
    public boolean hasCardinalityAtLeast(int n) {
        int n2 = n;
        for (int i = this.m_intervals.size() - 1; n2 > 0 && i >= 0; --i) {
            n2 = this.m_intervals.get(i).subtractSizeFrom(n2);
        }
        return n2 == 0;
    }

    @Override
    public boolean containsDataValue(Object object) {
        if (object instanceof DateTime) {
            DateTime dateTime = (DateTime)object;
            for (int i = this.m_intervals.size() - 1; i >= 0; --i) {
                if (!this.m_intervals.get(i).containsDateTime(dateTime)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void enumerateDataValues(Collection<Object> collection) {
        for (int i = this.m_intervals.size() - 1; i >= 0; --i) {
            this.m_intervals.get(i).enumerateDateTimes(collection);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("xsd:dateTime{");
        for (int i = 0; i < this.m_intervals.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(" + ");
            }
            stringBuffer.append(this.m_intervals.get(i).toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

