/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.rdfplainliteral;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.Datatypes;
import dk.brics.automaton.RegExp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralDataValue;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralDatatypeHandler;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralLengthInterval;
import org.semanticweb.HermiT.datatypes.rdfplainliteral.RDFPlainLiteralLengthValueSpaceSubset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFPlainLiteralPatternValueSpaceSubset
implements ValueSpaceSubset {
    public static final char SEPARATOR = '\u0001';
    protected static final Automaton s_separator;
    protected static final Automaton s_languagePatternEnd;
    protected static final Automaton s_languageTag;
    protected static final Automaton s_languageTagOrEmpty;
    protected static final Automaton s_emptyLangTag;
    protected static final Automaton s_nonemptyLangTag;
    protected static final Automaton s_anyLangTag;
    protected static final Automaton s_xsdString;
    protected static final Map<String, Automaton> s_anyDatatype;
    protected static final Automaton s_anyString;
    protected static final Automaton s_anyChar;
    protected static final Automaton s_anyStringWithNonemptyLangTag;
    protected final Automaton m_automaton;

    protected static Automaton languageTagAutomaton() {
        return new RegExp("(([a-zA-Z]{2,3}((-[a-zA-Z]{3}){0,3})?)|[a-zA-Z]{4}|[a-zA-Z]{5,8})(-[a-zA-Z]{4})?(-([a-zA-Z]{2}|[0-9]{3}))?(-([a-zA-Z0-9]{5,8}|([0-9][a-z0-9]{3})))*(-([a-wy-zA-WY-Z0-9](-[a-zA-Z0-9]{2,8})+))*(-x(-[a-zA-Z0-9]{1,8})+)?").toAutomaton();
    }

    protected static Automaton normalizedStringAutomaton() {
        return new RegExp("([ -\u007f\u00a0-\ud7ff\ue000-\ufffd])*").toAutomaton();
    }

    protected static Automaton tokenAutomaton() {
        return new RegExp("([!-\ud7ff\ue000-\ufffd]+( [!-\ud7ff\ue000-\ufffd]+)*)?").toAutomaton();
    }

    public RDFPlainLiteralPatternValueSpaceSubset(Automaton automaton) {
        this.m_automaton = automaton;
    }

    @Override
    public boolean hasCardinalityAtLeast(int n) {
        Set<String> set = this.m_automaton.getFiniteStrings(n);
        if (set == null) {
            return true;
        }
        return set.size() >= n;
    }

    @Override
    public boolean containsDataValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return this.m_automaton.run(string + '\u0001');
        }
        if (object instanceof RDFPlainLiteralDataValue) {
            RDFPlainLiteralDataValue rDFPlainLiteralDataValue = (RDFPlainLiteralDataValue)object;
            String string = rDFPlainLiteralDataValue.getString();
            String string2 = rDFPlainLiteralDataValue.getLanguageTag().toLowerCase();
            return this.m_automaton.run(string + '\u0001' + string2);
        }
        return false;
    }

    @Override
    public void enumerateDataValues(Collection<Object> collection) {
        Set<String> set = this.m_automaton.getFiniteStrings();
        if (set == null) {
            throw new IllegalStateException("The value space range is infinite.");
        }
        for (String string : set) {
            int n = string.lastIndexOf(1);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string3.length() == 0) {
                collection.add(string2);
                continue;
            }
            collection.add(new RDFPlainLiteralDataValue(string2, string3));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rdf:PlainLiteral{");
        stringBuffer.append(this.m_automaton.toString());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static Automaton toAutomaton(RDFPlainLiteralLengthValueSpaceSubset rDFPlainLiteralLengthValueSpaceSubset) {
        List<RDFPlainLiteralLengthInterval> list = rDFPlainLiteralLengthValueSpaceSubset.m_intervals;
        Automaton automaton = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            RDFPlainLiteralLengthInterval rDFPlainLiteralLengthInterval = list.get(i);
            Automaton automaton2 = rDFPlainLiteralLengthInterval.m_maxLength == Integer.MAX_VALUE ? (rDFPlainLiteralLengthInterval.m_minLength == 0 ? s_anyString : s_anyString.intersection(BasicOperations.repeat(s_anyChar, rDFPlainLiteralLengthInterval.m_minLength))) : s_anyString.intersection(BasicOperations.repeat(s_anyChar, rDFPlainLiteralLengthInterval.m_minLength, rDFPlainLiteralLengthInterval.m_maxLength));
            Automaton automaton3 = rDFPlainLiteralLengthInterval.m_languageTagMode == RDFPlainLiteralLengthInterval.LanguageTagMode.ABSENT ? automaton2.concatenate(s_emptyLangTag) : automaton2.concatenate(s_nonemptyLangTag);
            automaton = automaton == null ? automaton3 : automaton.intersection(automaton3);
        }
        return automaton;
    }

    public static Automaton toAutomaton(int n, int n2) {
        assert (n <= n2);
        Automaton automaton = n2 == Integer.MAX_VALUE ? (n == 0 ? s_anyString : s_anyString.intersection(BasicOperations.repeat(s_anyChar, n))) : s_anyString.intersection(BasicOperations.repeat(s_anyChar, n, n2));
        return automaton.concatenate(s_anyLangTag);
    }

    public static boolean isValidPattern(String string) {
        try {
            new RegExp(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static Automaton getPatternAutomaton(String string) {
        Automaton automaton = new RegExp(string).toAutomaton();
        return automaton.concatenate(s_anyLangTag);
    }

    public static Automaton getLanguageRangeAutomaton(String string) {
        if ("*".equals(string)) {
            return s_anyStringWithNonemptyLangTag;
        }
        Automaton automaton = BasicAutomata.makeString(string.toLowerCase()).concatenate(s_languagePatternEnd);
        return s_anyString.concatenate(s_separator).concatenate(automaton);
    }

    public static Automaton getDatatypeAutomaton(String string) {
        return s_anyDatatype.get(string);
    }

    static {
        s_anyDatatype = new HashMap<String, Automaton>();
        s_separator = BasicAutomata.makeChar('\u0001');
        s_languagePatternEnd = BasicOperations.optional(BasicAutomata.makeChar('-').concatenate(BasicAutomata.makeAnyString()));
        s_languageTag = RDFPlainLiteralPatternValueSpaceSubset.languageTagAutomaton();
        s_languageTagOrEmpty = s_languageTag.union(BasicAutomata.makeEmptyString());
        s_emptyLangTag = s_separator;
        s_nonemptyLangTag = s_separator.concatenate(s_languageTag);
        s_anyLangTag = s_separator.concatenate(s_languageTagOrEmpty);
        s_xsdString = Datatypes.get("string");
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "string", s_xsdString.concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "normalizedString", RDFPlainLiteralPatternValueSpaceSubset.normalizedStringAutomaton().concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "token", RDFPlainLiteralPatternValueSpaceSubset.tokenAutomaton().concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "Name", Datatypes.get("Name2").concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "NCName", Datatypes.get("NCName").concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "NMTOKEN", Datatypes.get("Nmtoken2").concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.XSD_NS + "language", Datatypes.get("language").concatenate(s_emptyLangTag));
        s_anyDatatype.put(RDFPlainLiteralDatatypeHandler.RDF_NS + "PlainLiteral", s_xsdString.concatenate(s_anyLangTag));
        s_anyChar = BasicAutomata.makeAnyChar();
        s_anyString = BasicAutomata.makeAnyString();
        s_anyStringWithNonemptyLangTag = s_anyString.concatenate(s_nonemptyLangTag);
    }
}

