/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.hierarchy.ClassificationProgressMonitor;
import org.semanticweb.HermiT.hierarchy.QuasiOrderClassification;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuasiOrderClassificationForRoles
extends QuasiOrderClassification {
    protected final boolean m_hasInverses;
    protected final Map<Role, AtomicConcept> m_conceptsForRoles;
    protected final Map<AtomicConcept, Role> m_rolesForConcepts;

    public QuasiOrderClassificationForRoles(Tableau tableau, ClassificationProgressMonitor classificationProgressMonitor, AtomicConcept atomicConcept, AtomicConcept atomicConcept2, Set<AtomicConcept> set, boolean bl, Map<Role, AtomicConcept> map, Map<AtomicConcept, Role> map2) {
        super(tableau, classificationProgressMonitor, atomicConcept, atomicConcept2, set);
        this.m_hasInverses = bl;
        this.m_conceptsForRoles = map;
        this.m_rolesForConcepts = map2;
    }

    @Override
    protected void initialiseKnownSubsumptionsUsingToldSubsumers(Set<DLClause> set) {
        for (DLClause dLClause : set) {
            if (dLClause.getHeadLength() != 1 || dLClause.getBodyLength() != 1) continue;
            DLPredicate dLPredicate = dLClause.getHeadAtom(0).getDLPredicate();
            DLPredicate dLPredicate2 = dLClause.getBodyAtom(0).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !this.m_conceptsForRoles.containsKey(dLPredicate) || !(dLPredicate2 instanceof AtomicRole) || !this.m_conceptsForRoles.containsKey(dLPredicate2)) continue;
            AtomicRole atomicRole = (AtomicRole)dLPredicate;
            AtomicRole atomicRole2 = (AtomicRole)dLPredicate2;
            AtomicConcept atomicConcept = this.m_conceptsForRoles.get(atomicRole);
            AtomicConcept atomicConcept2 = this.m_conceptsForRoles.get(atomicRole2);
            assert (atomicConcept2 != null);
            assert (atomicConcept != null);
            if (dLClause.getBodyAtom(0).getArgument(0) != dLClause.getHeadAtom(0).getArgument(0)) {
                AtomicConcept atomicConcept3 = this.m_conceptsForRoles.get(atomicRole2.getInverse());
                this.addKnownSubsumption(atomicConcept3, atomicConcept);
                continue;
            }
            this.addKnownSubsumption(atomicConcept2, atomicConcept);
        }
    }

    @Override
    protected void addKnownSubsumption(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        super.addKnownSubsumption(atomicConcept, atomicConcept2);
        if (this.m_hasInverses) {
            AtomicConcept atomicConcept3 = this.m_conceptsForRoles.get(this.m_rolesForConcepts.get(atomicConcept).getInverse());
            AtomicConcept atomicConcept4 = this.m_conceptsForRoles.get(this.m_rolesForConcepts.get(atomicConcept2).getInverse());
            super.addKnownSubsumption(atomicConcept3, atomicConcept4);
        }
    }

    @Override
    protected void addPossibleSubsumption(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        super.addPossibleSubsumption(atomicConcept, atomicConcept2);
        if (this.m_hasInverses) {
            AtomicConcept atomicConcept3 = this.m_conceptsForRoles.get(this.m_rolesForConcepts.get(atomicConcept).getInverse());
            AtomicConcept atomicConcept4 = this.m_conceptsForRoles.get(this.m_rolesForConcepts.get(atomicConcept2).getInverse());
            super.addPossibleSubsumption(atomicConcept3, atomicConcept4);
        }
    }

    @Override
    protected ReasoningTaskDescription getSatTestDescription(AtomicConcept atomicConcept) {
        return ReasoningTaskDescription.isRoleSatisfiable(this.m_rolesForConcepts.get(atomicConcept), true);
    }

    @Override
    protected ReasoningTaskDescription getSubsumptionTestDescription(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        return ReasoningTaskDescription.isRoleSubsumedBy(this.m_rolesForConcepts.get(atomicConcept), this.m_rolesForConcepts.get(atomicConcept2), true);
    }

    @Override
    protected ReasoningTaskDescription getSubsumedByListTestDescription(AtomicConcept atomicConcept, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            assert (objectArray[i] instanceof AtomicConcept);
            objectArray2[i] = this.m_rolesForConcepts.get(objectArray[i]);
        }
        return ReasoningTaskDescription.isRoleSubsumedByList(this.m_rolesForConcepts.get(atomicConcept), objectArray2, true);
    }
}

