/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.monitor;

import org.semanticweb.HermiT.monitor.CountingMonitor;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;

public class MemoryConsumptionMonitor
extends CountingMonitor {
    private static final long serialVersionUID = -483824095933491230L;
    protected int m_binaryTableMem = 0;
    protected int m_ternaryTableMem = 0;
    protected int m_dependencySetsMem = 0;
    protected int m_sumBinaryTableMem = 0;
    protected int m_sumTernaryTableMem = 0;
    protected int m_sumDependencySetsMem = 0;
    protected int m_maxMem = 0;
    protected int m_testNumber = 0;

    public void isSatisfiableStarted(ReasoningTaskDescription reasoningTaskDescription) {
        super.isSatisfiableStarted(reasoningTaskDescription);
        ++this.m_testNumber;
    }

    public void isSatisfiableFinished(ReasoningTaskDescription reasoningTaskDescription, boolean bl) {
        super.isSatisfiableFinished(reasoningTaskDescription, bl);
        this.m_binaryTableMem = this.m_tableau.getExtensionManager().getBinaryExtensionTable().sizeInMemory() / 1024;
        this.m_ternaryTableMem = this.m_tableau.getExtensionManager().getTernaryExtensionTable().sizeInMemory() / 1024;
        this.m_dependencySetsMem = this.m_tableau.getDependencySetFactory().sizeInMemory() / 1024;
        this.m_sumBinaryTableMem += this.m_binaryTableMem;
        this.m_sumTernaryTableMem += this.m_ternaryTableMem;
        this.m_sumDependencySetsMem += this.m_dependencySetsMem;
        int n = this.m_binaryTableMem + this.m_ternaryTableMem + this.m_dependencySetsMem;
        if (n > this.m_maxMem) {
            this.m_maxMem = n;
        }
    }

    public void reset() {
        super.reset();
        this.m_binaryTableMem = 0;
        this.m_ternaryTableMem = 0;
        this.m_dependencySetsMem = 0;
        this.m_sumBinaryTableMem = 0;
        this.m_sumTernaryTableMem = 0;
        this.m_sumDependencySetsMem = 0;
        this.m_maxMem = 0;
        this.m_testNumber = 0;
    }

    public long getCurrentTableauExpansionMemoryUse() {
        return this.m_binaryTableMem + this.m_ternaryTableMem + this.m_dependencySetsMem;
    }

    public long getCurrentTableauExpansionBinaryTableSize() {
        return this.m_binaryTableMem;
    }

    public long getCurrentTableauExpansionTernaryTableSize() {
        return this.m_ternaryTableMem;
    }

    public long getCurrentTableauExpansionDependencySetsSize() {
        return this.m_dependencySetsMem;
    }

    public long getAverageTableauExpansionMemoryUse() {
        if (this.m_testNumber == 0) {
            return 0L;
        }
        return (this.m_sumBinaryTableMem + this.m_sumTernaryTableMem + this.m_sumDependencySetsMem) / this.m_testNumber;
    }

    public long getAverageTableauExpansionBinaryTableSize() {
        if (this.m_testNumber == 0) {
            return 0L;
        }
        return this.m_sumBinaryTableMem / this.m_testNumber;
    }

    public long getAverageTableauExpansionTernaryTableSize() {
        if (this.m_testNumber == 0) {
            return 0L;
        }
        return this.m_sumTernaryTableMem / this.m_testNumber;
    }

    public long getAverageTableauExpansionDependencySetsSize() {
        if (this.m_testNumber == 0) {
            return 0L;
        }
        return this.m_sumDependencySetsMem / this.m_testNumber;
    }

    public long getMaxTableauExpansionMemoryUse() {
        return this.m_maxMem;
    }
}

