/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class BuiltInPropertyManager {
    protected final OWLDataFactory m_factory;
    protected final OWLObjectProperty m_topObjectProperty;
    protected final OWLObjectProperty m_bottomObjectProperty;
    protected final OWLDataProperty m_topDataProperty;
    protected final OWLDataProperty m_bottomDataProperty;

    public BuiltInPropertyManager(OWLDataFactory oWLDataFactory) {
        this.m_factory = oWLDataFactory;
        this.m_topObjectProperty = this.m_factory.getOWLObjectProperty(IRI.create((String)AtomicRole.TOP_OBJECT_ROLE.getIRI()));
        this.m_bottomObjectProperty = this.m_factory.getOWLObjectProperty(IRI.create((String)AtomicRole.BOTTOM_OBJECT_ROLE.getIRI()));
        this.m_topDataProperty = this.m_factory.getOWLDataProperty(IRI.create((String)AtomicRole.TOP_DATA_ROLE.getIRI()));
        this.m_bottomDataProperty = this.m_factory.getOWLDataProperty(IRI.create((String)AtomicRole.BOTTOM_DATA_ROLE.getIRI()));
    }

    public void axiomatizeBuiltInPropertiesAsNeeded(OWLAxioms oWLAxioms, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Checker checker = new Checker(oWLAxioms);
        if (checker.m_usesTopObjectProperty && !bl) {
            this.axiomatizeTopObjectProperty(oWLAxioms);
        }
        if (checker.m_usesBottomObjectProperty && !bl2) {
            this.axiomatizeBottomObjectProperty(oWLAxioms);
        }
        if (checker.m_usesTopDataProperty && !bl3) {
            this.axiomatizeTopDataProperty(oWLAxioms);
        }
        if (checker.m_usesBottomDataProperty && !bl4) {
            this.axiomatizeBottomDataProperty(oWLAxioms);
        }
    }

    public void axiomatizeBuiltInPropertiesAsNeeded(OWLAxioms oWLAxioms) {
        this.axiomatizeBuiltInPropertiesAsNeeded(oWLAxioms, false, false, false, false);
    }

    protected void axiomatizeTopObjectProperty(OWLAxioms oWLAxioms) {
        oWLAxioms.m_complexObjectPropertyInclusions.add(new OWLAxioms.ComplexObjectPropertyInclusion((OWLObjectPropertyExpression)this.m_topObjectProperty));
        oWLAxioms.m_simpleObjectPropertyInclusions.add(new OWLObjectPropertyExpression[]{this.m_topObjectProperty, this.m_topObjectProperty.getInverseProperty()});
        OWLNamedIndividual oWLNamedIndividual = this.m_factory.getOWLNamedIndividual(IRI.create((String)"internal:nam#topIndividual"));
        OWLObjectOneOf oWLObjectOneOf = this.m_factory.getOWLObjectOneOf(new OWLIndividual[]{oWLNamedIndividual});
        OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom = this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.m_topObjectProperty, (OWLClassExpression)oWLObjectOneOf);
        oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLObjectSomeValuesFrom});
    }

    protected void axiomatizeBottomObjectProperty(OWLAxioms oWLAxioms) {
        oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.m_bottomObjectProperty, (OWLClassExpression)this.m_factory.getOWLNothing())});
    }

    protected void axiomatizeTopDataProperty(OWLAxioms oWLAxioms) {
        OWLDatatype oWLDatatype = this.m_factory.getOWLDatatype(IRI.create((String)"internal:anonymous-constants"));
        OWLLiteral oWLLiteral = this.m_factory.getOWLLiteral("internal:constant", oWLDatatype);
        OWLDataOneOf oWLDataOneOf = this.m_factory.getOWLDataOneOf(new OWLLiteral[]{oWLLiteral});
        OWLDataSomeValuesFrom oWLDataSomeValuesFrom = this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.m_topDataProperty, (OWLDataRange)oWLDataOneOf);
        oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLDataSomeValuesFrom});
    }

    protected void axiomatizeBottomDataProperty(OWLAxioms oWLAxioms) {
        oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.m_bottomDataProperty, (OWLDataRange)this.m_factory.getOWLDataComplementOf((OWLDataRange)this.m_factory.getTopDatatype()))});
    }

    protected class Checker
    implements OWLClassExpressionVisitor {
        public boolean m_usesTopObjectProperty;
        public boolean m_usesBottomObjectProperty;
        public boolean m_usesTopDataProperty;
        public boolean m_usesBottomDataProperty;

        public Checker(OWLAxioms oWLAxioms) {
            for (OWLClassExpression[] object : oWLAxioms.m_conceptInclusions) {
                for (OWLClassExpression oWLClassExpression : object) {
                    oWLClassExpression.accept((OWLClassExpressionVisitor)this);
                }
            }
            for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : oWLAxioms.m_simpleObjectPropertyInclusions) {
                this.visitProperty(oWLObjectPropertyExpressionArray[0]);
                this.visitProperty(oWLObjectPropertyExpressionArray[1]);
            }
            for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : oWLAxioms.m_complexObjectPropertyInclusions) {
                for (OWLClassExpression oWLClassExpression : complexObjectPropertyInclusion.m_subObjectProperties) {
                    this.visitProperty((OWLObjectPropertyExpression)oWLClassExpression);
                }
                this.visitProperty(complexObjectPropertyInclusion.m_superObjectProperty);
            }
            for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : oWLAxioms.m_disjointObjectProperties) {
                for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                    this.visitProperty(oWLObjectPropertyExpressionArray[i]);
                }
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_reflexiveObjectProperties) {
                this.visitProperty(oWLObjectPropertyExpression);
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_irreflexiveObjectProperties) {
                this.visitProperty(oWLObjectPropertyExpression);
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_asymmetricObjectProperties) {
                this.visitProperty(oWLObjectPropertyExpression);
            }
            for (OWLDataPropertyExpression[] oWLDataPropertyExpressionArray : oWLAxioms.m_dataPropertyInclusions) {
                this.visitProperty(oWLDataPropertyExpressionArray[0]);
                this.visitProperty(oWLDataPropertyExpressionArray[1]);
            }
            for (OWLDataPropertyExpression[] oWLDataPropertyExpressionArray : oWLAxioms.m_disjointDataProperties) {
                for (int i = 0; i < oWLDataPropertyExpressionArray.length; ++i) {
                    this.visitProperty(oWLDataPropertyExpressionArray[i]);
                }
            }
            Object object = new FactVisitor();
            for (OWLIndividualAxiom oWLIndividualAxiom : oWLAxioms.m_facts) {
                oWLIndividualAxiom.accept(object);
            }
        }

        protected void visitProperty(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
            if (oWLObjectPropertyExpression.getNamedProperty().equals(BuiltInPropertyManager.this.m_topObjectProperty)) {
                this.m_usesTopObjectProperty = true;
            } else if (oWLObjectPropertyExpression.getNamedProperty().equals(BuiltInPropertyManager.this.m_bottomObjectProperty)) {
                this.m_usesBottomObjectProperty = true;
            }
        }

        protected void visitProperty(OWLDataPropertyExpression oWLDataPropertyExpression) {
            if (oWLDataPropertyExpression.asOWLDataProperty().equals(BuiltInPropertyManager.this.m_topDataProperty)) {
                this.m_usesTopDataProperty = true;
            } else if (oWLDataPropertyExpression.asOWLDataProperty().equals(BuiltInPropertyManager.this.m_bottomDataProperty)) {
                this.m_usesBottomDataProperty = true;
            }
        }

        public void visit(OWLClass oWLClass) {
        }

        public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
            oWLObjectComplementOf.getOperand().accept((OWLClassExpressionVisitor)this);
        }

        public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            for (OWLClassExpression oWLClassExpression : oWLObjectIntersectionOf.getOperands()) {
                oWLClassExpression.accept((OWLClassExpressionVisitor)this);
            }
        }

        public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
            for (OWLClassExpression oWLClassExpression : oWLObjectUnionOf.getOperands()) {
                oWLClassExpression.accept((OWLClassExpressionVisitor)this);
            }
        }

        public void visit(OWLObjectOneOf oWLObjectOneOf) {
        }

        public void visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty());
            ((OWLClassExpression)oWLObjectSomeValuesFrom.getFiller()).accept((OWLClassExpressionVisitor)this);
        }

        public void visit(OWLObjectHasValue oWLObjectHasValue) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectHasValue.getProperty());
        }

        public void visit(OWLObjectHasSelf oWLObjectHasSelf) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty());
        }

        public void visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty());
            ((OWLClassExpression)oWLObjectAllValuesFrom.getFiller()).accept((OWLClassExpressionVisitor)this);
        }

        public void visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty());
            ((OWLClassExpression)oWLObjectMinCardinality.getFiller()).accept((OWLClassExpressionVisitor)this);
        }

        public void visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty());
            ((OWLClassExpression)oWLObjectMaxCardinality.getFiller()).accept((OWLClassExpressionVisitor)this);
        }

        public void visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            this.visitProperty((OWLObjectPropertyExpression)oWLObjectExactCardinality.getProperty());
            ((OWLClassExpression)oWLObjectExactCardinality.getFiller()).accept((OWLClassExpressionVisitor)this);
        }

        public void visit(OWLDataHasValue oWLDataHasValue) {
            this.visitProperty((OWLDataPropertyExpression)oWLDataHasValue.getProperty());
        }

        public void visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            this.visitProperty((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty());
        }

        public void visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            this.visitProperty((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty());
        }

        public void visit(OWLDataMinCardinality oWLDataMinCardinality) {
            this.visitProperty((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty());
        }

        public void visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            this.visitProperty((OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty());
        }

        public void visit(OWLDataExactCardinality oWLDataExactCardinality) {
            this.visitProperty((OWLDataPropertyExpression)oWLDataExactCardinality.getProperty());
        }

        protected class FactVisitor
        extends OWLAxiomVisitorAdapter {
            protected FactVisitor() {
            }

            public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            }

            public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            }

            public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
                oWLClassAssertionAxiom.getClassExpression().accept((OWLClassExpressionVisitor)Checker.this);
            }

            public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
                Checker.this.visitProperty((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty());
            }

            public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
                Checker.this.visitProperty((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty());
            }

            public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
                Checker.this.visitProperty((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty());
            }

            public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
                Checker.this.visitProperty((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty());
            }
        }
    }
}

