/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeRegistry;
import org.semanticweb.HermiT.datatypes.UnsupportedDatatypeException;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtLeastDataRange;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.ConstantEnumeration;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.model.LiteralConcept;
import org.semanticweb.HermiT.model.LiteralDataRange;
import org.semanticweb.HermiT.model.NodeIDLessEqualThan;
import org.semanticweb.HermiT.model.NodeIDsAscendingOrEqual;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.structural.BuiltInPropertyManager;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.HermiT.structural.OWLAxiomsExpressivity;
import org.semanticweb.HermiT.structural.OWLNormalization;
import org.semanticweb.HermiT.structural.ObjectPropertyInclusionManager;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClausification {
    protected static final Variable X = Variable.create("X");
    protected static final Variable Y = Variable.create("Y");
    protected static final Variable Z = Variable.create("Z");
    protected final Configuration m_configuration;

    public OWLClausification(Configuration configuration) {
        this.m_configuration = configuration;
    }

    public Object[] preprocessAndClausify(OWLOntology oWLOntology, Collection<DescriptionGraph> collection) {
        Object object2;
        OWLDataFactory oWLDataFactory = oWLOntology.getOWLOntologyManager().getOWLDataFactory();
        String string = oWLOntology.getOntologyID().getDefaultDocumentIRI() == null ? "urn:hermit:kb" : oWLOntology.getOntologyID().getDefaultDocumentIRI().toString();
        Set set = oWLOntology.getImportsClosure();
        OWLAxioms oWLAxioms = new OWLAxioms();
        OWLNormalization oWLNormalization = new OWLNormalization(oWLDataFactory, oWLAxioms, 0);
        for (Object object2 : set) {
            oWLNormalization.processOntology((OWLOntology)object2);
        }
        BuiltInPropertyManager builtInPropertyManager = new BuiltInPropertyManager(oWLDataFactory);
        builtInPropertyManager.axiomatizeBuiltInPropertiesAsNeeded(oWLAxioms);
        object2 = new ObjectPropertyInclusionManager(oWLAxioms);
        ((ObjectPropertyInclusionManager)object2).rewriteNegativeObjectPropertyAssertions(oWLDataFactory, oWLAxioms, oWLNormalization.m_definitions.size());
        ((ObjectPropertyInclusionManager)object2).rewriteAxioms(oWLDataFactory, oWLAxioms, 0);
        if (collection == null) {
            collection = Collections.emptySet();
        }
        OWLAxiomsExpressivity oWLAxiomsExpressivity = new OWLAxiomsExpressivity(oWLAxioms);
        DLOntology dLOntology = this.clausify(oWLDataFactory, string, oWLAxioms, oWLAxiomsExpressivity, collection);
        return new Object[]{object2, dLOntology};
    }

    /*
     * WARNING - void declaration
     */
    public DLOntology clausify(OWLDataFactory oWLDataFactory, String string, OWLAxioms oWLAxioms, OWLAxiomsExpressivity oWLAxiomsExpressivity, Collection<DescriptionGraph> collection) {
        Object object5;
        Object object2;
        Serializable serializable;
        Atom atom;
        Object object3;
        Object object4;
        LinkedHashSet<DLClause> linkedHashSet = new LinkedHashSet<DLClause>();
        HashSet<Atom> hashSet = new HashSet<Atom>();
        HashSet<Atom> hashSet2 = new HashSet<Atom>();
        HashSet<DatatypeRestriction> hashSet3 = new HashSet<DatatypeRestriction>();
        for (OWLObjectPropertyExpression[] object72 : oWLAxioms.m_simpleObjectPropertyInclusions) {
            void var14_34;
            object4 = object72[0];
            object3 = object72[1];
            if (object4.isAnonymous() != object3.isAnonymous()) {
                DLClause.ClauseType clauseType = DLClause.ClauseType.INVERSE_OBJECT_PROPERTY_INCLUSION;
            } else {
                DLClause.ClauseType clauseType = DLClause.ClauseType.OBJECT_PROPERTY_INCLUSION;
            }
            atom = OWLClausification.getRoleAtom(object72[0], (Term)X, (Term)Y);
            serializable = OWLClausification.getRoleAtom(object72[1], (Term)X, (Term)Y);
            DLClause dLClause = DLClause.create(new Atom[]{serializable}, new Atom[]{atom}, (DLClause.ClauseType)var14_34);
            linkedHashSet.add(dLClause);
        }
        for (OWLDataPropertyExpression[] oWLDataPropertyExpressionArray : oWLAxioms.m_dataPropertyInclusions) {
            object4 = OWLClausification.getRoleAtom(oWLDataPropertyExpressionArray[0], (Term)X, (Term)Y);
            object3 = OWLClausification.getRoleAtom(oWLDataPropertyExpressionArray[1], (Term)X, (Term)Y);
            DLClause dLClause = DLClause.create(new Atom[]{object3}, new Atom[]{object4}, DLClause.ClauseType.DATA_PROPERTY_INCLUSION);
            linkedHashSet.add(dLClause);
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_asymmetricObjectProperties) {
            object4 = OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)X, (Term)Y);
            object3 = OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)Y, (Term)X);
            DLClause dLClause = DLClause.create(new Atom[0], new Atom[]{object4, object3}, DLClause.ClauseType.ASYMMETRY);
            linkedHashSet.add(dLClause.getSafeVersion());
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_reflexiveObjectProperties) {
            object4 = OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)X, (Term)X);
            object3 = DLClause.create(new Atom[]{object4}, new Atom[0], DLClause.ClauseType.REFLEXIVITY);
            linkedHashSet.add(((DLClause)object3).getSafeVersion());
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_irreflexiveObjectProperties) {
            object4 = OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)X, (Term)X);
            object3 = DLClause.create(new Atom[0], new Atom[]{object4}, DLClause.ClauseType.IRREFLEXIVITY);
            linkedHashSet.add(((DLClause)object3).getSafeVersion());
        }
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : oWLAxioms.m_disjointObjectProperties) {
            for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                for (int j = i + 1; j < oWLObjectPropertyExpressionArray.length; ++j) {
                    Atom atom2 = OWLClausification.getRoleAtom(oWLObjectPropertyExpressionArray[i], (Term)X, (Term)Y);
                    atom = OWLClausification.getRoleAtom(oWLObjectPropertyExpressionArray[j], (Term)X, (Term)Y);
                    serializable = DLClause.create(new Atom[0], new Atom[]{atom2, atom}, DLClause.ClauseType.DISJOINT_OBJECT_PROPERTIES);
                    linkedHashSet.add(((DLClause)serializable).getSafeVersion());
                }
            }
        }
        if (oWLAxioms.m_dataPropertyInclusions.contains(oWLDataFactory.getOWLDataProperty(IRI.create((String)AtomicRole.BOTTOM_DATA_ROLE.getIRI())))) {
            object2 = Atom.create(AtomicRole.BOTTOM_DATA_ROLE, X, Y);
            linkedHashSet.add(DLClause.create(new Atom[0], new Atom[]{object2}, DLClause.ClauseType.OTHER).getSafeVersion());
        }
        for (OWLDataPropertyExpression[] oWLDataPropertyExpressionArray : oWLAxioms.m_disjointDataProperties) {
            for (int i = 0; i < oWLDataPropertyExpressionArray.length; ++i) {
                for (int j = i + 1; j < oWLDataPropertyExpressionArray.length; ++j) {
                    Atom atom3 = OWLClausification.getRoleAtom(oWLDataPropertyExpressionArray[i], (Term)X, (Term)Y);
                    atom = OWLClausification.getRoleAtom(oWLDataPropertyExpressionArray[j], (Term)X, (Term)Z);
                    serializable = Atom.create(Inequality.create(), Y, Z);
                    DLClause dLClause = DLClause.create(new Atom[]{serializable}, new Atom[]{atom3, atom}, DLClause.ClauseType.DISJOINT_DATA_PROPERTIES);
                    linkedHashSet.add(dLClause.getSafeVersion());
                }
            }
        }
        object2 = new DataRangeConverter(this.m_configuration.warningMonitor, oWLAxioms.m_definedDatatypesIRIs, hashSet3, this.m_configuration.ignoreUnsupportedDatatypes);
        NormalizedAxiomClausifier normalizedAxiomClausifier = new NormalizedAxiomClausifier((DataRangeConverter)object2, hashSet, oWLDataFactory, oWLAxioms.m_dps2ranges);
        for (OWLClassExpression[] oWLClassExpressionArray : oWLAxioms.m_conceptInclusions) {
            for (OWLClassExpression oWLClassExpression : oWLClassExpressionArray) {
                oWLClassExpression.accept((OWLClassExpressionVisitor)normalizedAxiomClausifier);
            }
            DLClause dLClause = normalizedAxiomClausifier.getDLClause();
            linkedHashSet.add(dLClause.getSafeVersion());
        }
        NormalizedDataRangeAxiomClausifier normalizedDataRangeAxiomClausifier = new NormalizedDataRangeAxiomClausifier((DataRangeConverter)object2, oWLDataFactory, oWLAxioms.m_definedDatatypesIRIs);
        for (OWLDataRange[] oWLDataRangeArray : oWLAxioms.m_dataRangeInclusions) {
            for (Object object5 : oWLDataRangeArray) {
                object5.accept((OWLDataVisitor)normalizedDataRangeAxiomClausifier);
            }
            DLClause dLClause = normalizedDataRangeAxiomClausifier.getDLClause();
            linkedHashSet.add(dLClause.getSafeVersion());
        }
        for (OWLHasKeyAxiom oWLHasKeyAxiom : oWLAxioms.m_hasKeys) {
            linkedHashSet.add(this.clausifyKey(oWLHasKeyAxiom).getSafeVersion());
        }
        Object object6 = new FactClausifier((DataRangeConverter)object2, hashSet, hashSet2);
        for (OWLIndividualAxiom oWLIndividualAxiom : oWLAxioms.m_facts) {
            oWLIndividualAxiom.accept(object6);
        }
        for (DescriptionGraph descriptionGraph : collection) {
            descriptionGraph.produceStartDLClauses(linkedHashSet);
        }
        HashSet<AtomicConcept> hashSet4 = new HashSet<AtomicConcept>();
        HashSet<AtomicRole> hashSet5 = new HashSet<AtomicRole>();
        HashSet<Role> hashSet6 = new HashSet<Role>();
        HashSet<AtomicRole> hashSet7 = new HashSet<AtomicRole>();
        for (OWLClass oWLClass : oWLAxioms.m_classes) {
            hashSet4.add(AtomicConcept.create(oWLClass.getIRI().toString()));
        }
        object5 = new HashSet();
        for (OWLNamedIndividual oWLNamedIndividual : oWLAxioms.m_namedIndividuals) {
            Individual individual = Individual.create(oWLNamedIndividual.getIRI().toString());
            object5.add(individual);
            if (oWLAxioms.m_hasKeys.isEmpty() && oWLAxioms.m_rules.isEmpty()) continue;
            hashSet.add(Atom.create(AtomicConcept.INTERNAL_NAMED, individual));
        }
        for (OWLObjectProperty oWLObjectProperty : oWLAxioms.m_objectProperties) {
            hashSet5.add(AtomicRole.create(oWLObjectProperty.getIRI().toString()));
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_complexObjectPropertyExpressions) {
            hashSet6.add(OWLClausification.getRole(oWLObjectPropertyExpression));
        }
        for (OWLDataProperty oWLDataProperty : oWLAxioms.m_dataProperties) {
            hashSet7.add(AtomicRole.create(oWLDataProperty.getIRI().toString()));
        }
        if (!oWLAxioms.m_rules.isEmpty()) {
            this.m_configuration.checkClauses = false;
            NormalizedRuleClausifier normalizedRuleClausifier = new NormalizedRuleClausifier(hashSet, hashSet2, collection, oWLAxioms.m_objectPropertiesUsedInAxioms, (DataRangeConverter)object2);
            for (SWRLRule sWRLRule : oWLAxioms.m_rules) {
                sWRLRule.accept((SWRLObjectVisitor)normalizedRuleClausifier);
            }
            HashSet hashSet8 = new HashSet();
            boolean bl = false;
            for (int i = 0; i < normalizedRuleClausifier.m_bodies.size(); ++i) {
                boolean bl2;
                List<Atom> list = normalizedRuleClausifier.m_bodies.get(i);
                List<Atom> list2 = normalizedRuleClausifier.m_heads.get(i);
                for (Atom atom4 : list) {
                    if (atom4.getDLPredicate() instanceof AtomicRole && normalizedRuleClausifier.m_graphRoles.contains(oWLDataFactory.getOWLObjectProperty(IRI.create((String)((AtomicRole)atom4.getDLPredicate()).getIRI())))) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    break;
                }
                if (!bl2) {
                    for (Atom atom5 : list2) {
                        if (!(atom5.getDLPredicate() instanceof AtomicRole) || !normalizedRuleClausifier.m_graphRoles.contains(oWLDataFactory.getOWLObjectProperty(IRI.create((String)((AtomicRole)atom5.getDLPredicate()).getIRI())))) continue;
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    for (Variable variable : normalizedRuleClausifier.m_DLSafeVarSets.get(i)) {
                        list.add(Atom.create(AtomicConcept.INTERNAL_NAMED, variable));
                    }
                }
                Atom[] atomArray = new Atom[list2.size()];
                list2.toArray(atomArray);
                Atom[] atomArray2 = new Atom[list.size()];
                list.toArray(atomArray2);
                linkedHashSet.add(DLClause.create(atomArray, atomArray2, bl2 ? DLClause.ClauseType.GRAPH_RULE : DLClause.ClauseType.SWRL_RULE));
                bl2 = false;
                hashSet8.clear();
            }
        }
        return new DLOntology(string, linkedHashSet, hashSet, hashSet2, hashSet4, hashSet5, hashSet6, hashSet7, hashSet3, oWLAxioms.m_definedDatatypesIRIs, (Set<Individual>)object5, oWLAxiomsExpressivity.m_hasInverseRoles, oWLAxiomsExpressivity.m_hasAtMostRestrictions, oWLAxiomsExpressivity.m_hasNominals, oWLAxiomsExpressivity.m_hasDatatypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DLClause clausifyKey(OWLHasKeyAxiom oWLHasKeyAxiom) {
        Atom[] atomArray2;
        Object object;
        OWLClass oWLClass;
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        ArrayList<Atom> arrayList2 = new ArrayList<Atom>();
        Variable variable = Variable.create("X2");
        Variable variable2 = Variable.create("X1");
        arrayList.add(Atom.create(Equality.INSTANCE, variable2, variable));
        arrayList2.add(Atom.create(AtomicConcept.INTERNAL_NAMED, variable2));
        arrayList2.add(Atom.create(AtomicConcept.INTERNAL_NAMED, variable));
        OWLClassExpression oWLClassExpression = oWLHasKeyAxiom.getClassExpression();
        if (oWLClassExpression instanceof OWLClass) {
            oWLClass = (OWLClass)oWLClassExpression;
            if (!oWLClass.isOWLThing()) {
                arrayList2.add(Atom.create(AtomicConcept.create(oWLClass.getIRI().toString()), variable2));
                arrayList2.add(Atom.create(AtomicConcept.create(oWLClass.getIRI().toString()), variable));
            }
        } else {
            if (!(oWLClassExpression instanceof OWLObjectComplementOf)) throw new IllegalStateException("Internal error: invalid normal form.");
            oWLClass = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
            if (!(oWLClass instanceof OWLClass)) throw new IllegalStateException("Internal error: invalid normal form.");
            object = oWLClass;
            arrayList2.add(Atom.create(AtomicConcept.create(object.getIRI().toString()), variable2));
            arrayList2.add(Atom.create(AtomicConcept.create(object.getIRI().toString()), variable));
        }
        int n = 1;
        for (Atom[] atomArray2 : oWLHasKeyAxiom.getObjectPropertyExpressions()) {
            Variable variable3 = Variable.create("Y" + n);
            ++n;
            arrayList2.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)atomArray2, (Term)variable2, (Term)variable3));
            arrayList2.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)atomArray2, (Term)variable, (Term)variable3));
            arrayList2.add(Atom.create(AtomicConcept.INTERNAL_NAMED, variable3));
        }
        for (Atom[] atomArray2 : oWLHasKeyAxiom.getDataPropertyExpressions()) {
            Variable variable4 = Variable.create("Y" + n);
            arrayList2.add(OWLClausification.getRoleAtom((OWLDataPropertyExpression)atomArray2, (Term)variable2, (Term)variable4));
            Variable variable5 = Variable.create("Y" + ++n);
            ++n;
            arrayList2.add(OWLClausification.getRoleAtom((OWLDataPropertyExpression)atomArray2, (Term)variable, (Term)variable5));
            arrayList.add(Atom.create(Inequality.INSTANCE, variable4, variable5));
        }
        object = new Atom[arrayList.size()];
        arrayList.toArray((T[])object);
        atomArray2 = new Atom[arrayList2.size()];
        arrayList2.toArray(atomArray2);
        return DLClause.createEx(true, (Atom[])object, atomArray2, DLClause.ClauseType.HAS_KEY);
    }

    protected static LiteralConcept getLiteralConcept(OWLClassExpression oWLClassExpression) {
        if (oWLClassExpression instanceof OWLClass) {
            return AtomicConcept.create(((OWLClass)oWLClassExpression).getIRI().toString());
        }
        if (oWLClassExpression instanceof OWLObjectComplementOf) {
            OWLClassExpression oWLClassExpression2 = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
            if (!(oWLClassExpression2 instanceof OWLClass)) {
                throw new IllegalStateException("Internal error: invalid normal form.");
            }
            return AtomicConcept.create(((OWLClass)oWLClassExpression2).getIRI().toString()).getNegation();
        }
        throw new IllegalStateException("Internal error: invalid normal form.");
    }

    protected static Role getRole(OWLObjectPropertyExpression oWLObjectPropertyExpression) {
        if ((oWLObjectPropertyExpression = oWLObjectPropertyExpression.getSimplified()) instanceof OWLObjectProperty) {
            return AtomicRole.create(((OWLObjectProperty)oWLObjectPropertyExpression).getIRI().toString());
        }
        if (oWLObjectPropertyExpression instanceof OWLObjectInverseOf) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression2 = ((OWLObjectInverseOf)oWLObjectPropertyExpression).getInverse();
            if (!(oWLObjectPropertyExpression2 instanceof OWLObjectProperty)) {
                throw new IllegalStateException("Internal error: invalid normal form.");
            }
            return AtomicRole.create(((OWLObjectProperty)oWLObjectPropertyExpression2).getIRI().toString()).getInverse();
        }
        throw new IllegalStateException("Internal error: invalid normal form.");
    }

    protected static AtomicRole getAtomicRole(OWLDataPropertyExpression oWLDataPropertyExpression) {
        return AtomicRole.create(((OWLDataProperty)oWLDataPropertyExpression).getIRI().toString());
    }

    protected static Atom getRoleAtom(OWLObjectPropertyExpression oWLObjectPropertyExpression, Term term, Term term2) {
        if (!(oWLObjectPropertyExpression = oWLObjectPropertyExpression.getSimplified()).isAnonymous()) {
            AtomicRole atomicRole = AtomicRole.create(oWLObjectPropertyExpression.asOWLObjectProperty().getIRI().toString());
            return Atom.create(atomicRole, term, term2);
        }
        if (oWLObjectPropertyExpression.isAnonymous()) {
            OWLObjectProperty oWLObjectProperty = oWLObjectPropertyExpression.getNamedProperty();
            AtomicRole atomicRole = AtomicRole.create(oWLObjectProperty.getIRI().toString());
            return Atom.create(atomicRole, term2, term);
        }
        throw new IllegalStateException("Internal error: unsupported type of object property!");
    }

    protected static Atom getRoleAtom(OWLDataPropertyExpression oWLDataPropertyExpression, Term term, Term term2) {
        if (oWLDataPropertyExpression instanceof OWLDataProperty) {
            AtomicRole atomicRole = AtomicRole.create(((OWLDataProperty)oWLDataPropertyExpression).getIRI().toString());
            return Atom.create(atomicRole, term, term2);
        }
        throw new IllegalStateException("Internal error: unsupported type of data property!");
    }

    protected static Individual getIndividual(OWLIndividual oWLIndividual) {
        if (oWLIndividual.isAnonymous()) {
            return Individual.createAnonymous(oWLIndividual.asOWLAnonymousIndividual().getID().toString());
        }
        return Individual.create(oWLIndividual.asOWLNamedIndividual().getIRI().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NormalizedRuleClausifier
    implements SWRLObjectVisitor {
        protected final DataRangeConverter m_dataRangeConverter;
        protected final Set<OWLObjectProperty> m_objectPropertiesUsedInAxioms;
        protected final List<Atom> m_headAtoms;
        protected final List<Atom> m_bodyAtoms;
        protected final Set<Variable> m_DLSafeVars;
        public final List<List<Atom>> m_heads = new ArrayList<List<Atom>>();
        public final List<List<Atom>> m_bodies = new ArrayList<List<Atom>>();
        public final List<Set<Variable>> m_DLSafeVarSets = new ArrayList<Set<Variable>>();
        protected final Set<Atom> m_positiveFacts;
        protected final Set<Atom> m_negativeFacts;
        protected Variable m_lastVariable;
        protected Atom m_lastAtom;
        protected final Set<SWRLVariable> m_headVars = new HashSet<SWRLVariable>();
        protected final Set<SWRLVariable> m_bodyVars = new HashSet<SWRLVariable>();
        protected final Set<SWRLVariable> m_varsOfLastAtom = new HashSet<SWRLVariable>();
        protected boolean m_containsIndividuals = false;
        protected boolean m_containsVariables = false;
        public final Set<OWLObjectProperty> m_graphRoles = new HashSet<OWLObjectProperty>();
        protected final Map<OWLObjectProperty, Set<SWRLRule>> unknownRoleInRule = new HashMap<OWLObjectProperty, Set<SWRLRule>>();
        protected int freshVarIndex = 0;
        protected final Map<OWLNamedIndividual, Variable> constantToVar = new HashMap<OWLNamedIndividual, Variable>();

        public NormalizedRuleClausifier(Set<Atom> set, Set<Atom> set2, Collection<DescriptionGraph> collection, Set<OWLObjectProperty> set3, DataRangeConverter dataRangeConverter) {
            this.m_dataRangeConverter = dataRangeConverter;
            this.m_headAtoms = new ArrayList<Atom>();
            this.m_bodyAtoms = new ArrayList<Atom>();
            this.m_DLSafeVars = new HashSet<Variable>();
            this.m_positiveFacts = set;
            this.m_negativeFacts = set2;
            this.m_objectPropertiesUsedInAxioms = set3;
            OWLDataFactory oWLDataFactory = OWLManager.createOWLOntologyManager().getOWLDataFactory();
            for (DescriptionGraph descriptionGraph : collection) {
                for (int i = 0; i < descriptionGraph.getNumberOfEdges(); ++i) {
                    this.m_graphRoles.add(oWLDataFactory.getOWLObjectProperty(IRI.create((String)descriptionGraph.getEdge(i).getAtomicRole().getIRI())));
                }
            }
        }

        protected void checkStrictSeparation(SWRLRule sWRLRule) {
            boolean bl = false;
            boolean bl2 = false;
            HashSet<OWLObjectProperty> hashSet = new HashSet<OWLObjectProperty>();
            for (OWLObjectProperty oWLObjectProperty : sWRLRule.getObjectPropertiesInSignature()) {
                if (this.m_objectPropertiesUsedInAxioms.contains(oWLObjectProperty)) {
                    bl2 = true;
                }
                if (this.m_graphRoles.contains(oWLObjectProperty)) {
                    bl = true;
                }
                if (this.m_objectPropertiesUsedInAxioms.contains(oWLObjectProperty) || this.m_graphRoles.contains(oWLObjectProperty)) continue;
                hashSet.add(oWLObjectProperty);
            }
            if (bl && bl2) {
                throw new IllegalArgumentException("Internal error: It seems rules mix graph and non-graph rules, which violates the strict separation condition. ");
            }
            if (bl) {
                this.m_graphRoles.addAll(sWRLRule.getObjectPropertiesInSignature());
                for (OWLObjectProperty oWLObjectProperty : hashSet) {
                    if (!this.unknownRoleInRule.containsKey(oWLObjectProperty)) continue;
                    for (SWRLRule sWRLRule2 : this.unknownRoleInRule.get(oWLObjectProperty)) {
                        this.checkStrictSeparation(sWRLRule2);
                    }
                }
                hashSet.removeAll(sWRLRule.getObjectPropertiesInSignature());
            } else if (!bl && !hashSet.isEmpty()) {
                for (OWLObjectProperty oWLObjectProperty : hashSet) {
                    Set<Object> set;
                    if (this.unknownRoleInRule.containsKey(oWLObjectProperty)) {
                        set = this.unknownRoleInRule.get(oWLObjectProperty);
                        set.add(sWRLRule);
                        continue;
                    }
                    set = new HashSet<SWRLRule>();
                    set.add(sWRLRule);
                    this.unknownRoleInRule.put(oWLObjectProperty, set);
                }
            }
        }

        public void visit(SWRLRule sWRLRule) {
            this.checkStrictSeparation(sWRLRule);
            this.freshVarIndex = 0;
            for (SWRLAtom sWRLAtom : sWRLRule.getBody()) {
                sWRLAtom.accept((SWRLObjectVisitor)this);
                this.m_bodyAtoms.add(this.m_lastAtom);
                this.m_bodyVars.addAll(this.m_varsOfLastAtom);
                this.m_varsOfLastAtom.clear();
            }
            for (SWRLAtom sWRLAtom : sWRLRule.getHead()) {
                sWRLAtom.accept((SWRLObjectVisitor)this);
                this.m_headAtoms.add(this.m_lastAtom);
                this.m_headVars.addAll(this.m_varsOfLastAtom);
                this.m_varsOfLastAtom.clear();
            }
            if (!this.m_bodyVars.containsAll(this.m_headVars)) {
                throw new IllegalArgumentException("Error: The rule " + sWRLRule + " contains head variables that do not occur in the body, which violates the safety restrictions. ");
            }
            if (this.m_headAtoms.isEmpty() && !this.m_containsVariables) {
                this.m_negativeFacts.add(this.m_bodyAtoms.get(0));
            } else {
                this.m_heads.add(new ArrayList<Atom>(this.m_headAtoms));
                this.m_bodies.add(new ArrayList<Atom>(this.m_bodyAtoms));
                this.m_DLSafeVarSets.add(new HashSet<Variable>(this.m_DLSafeVars));
                this.m_headAtoms.clear();
                this.m_bodyAtoms.clear();
                this.m_DLSafeVars.clear();
                this.constantToVar.clear();
            }
        }

        public void visit(SWRLClassAtom sWRLClassAtom) {
            if (sWRLClassAtom.getPredicate().isAnonymous()) {
                throw new IllegalStateException("Internal error: SWRL rule class atoms should be normalized to contain only named classes, but this class atom has a complex concept: " + sWRLClassAtom.getPredicate());
            }
            ((SWRLIArgument)sWRLClassAtom.getArgument()).accept((SWRLObjectVisitor)this);
            Variable variable = this.m_lastVariable;
            this.m_DLSafeVars.add(variable);
            this.m_lastAtom = Atom.create(AtomicConcept.create(sWRLClassAtom.getPredicate().asOWLClass().getIRI().toString()), this.m_lastVariable);
        }

        public void visit(SWRLDataRangeAtom sWRLDataRangeAtom) {
            if (!(sWRLDataRangeAtom.getPredicate() instanceof OWLDatatype)) {
                throw new IllegalStateException("Internal error: SWRL rule data range atoms should be normalized to contain only datatypes, but this atom has a (complex) data range: " + sWRLDataRangeAtom.getPredicate());
            }
            LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)sWRLDataRangeAtom.getPredicate().asOWLDatatype());
            ((SWRLDArgument)sWRLDataRangeAtom.getArgument()).accept((SWRLObjectVisitor)this);
            this.m_lastAtom = Atom.create(literalDataRange, this.m_lastVariable);
        }

        public void visit(SWRLObjectPropertyAtom sWRLObjectPropertyAtom) {
            if (sWRLObjectPropertyAtom.getPredicate().isAnonymous()) {
                throw new IllegalStateException("Internal error: object properties in SWRL rule object property atoms should be normalized to contain only named properties, but this atom has an (anonymous) object property expression: " + sWRLObjectPropertyAtom.getPredicate());
            }
            ((SWRLIArgument)sWRLObjectPropertyAtom.getFirstArgument()).accept((SWRLObjectVisitor)this);
            Variable variable = this.m_lastVariable;
            this.m_DLSafeVars.add(variable);
            ((SWRLIArgument)sWRLObjectPropertyAtom.getSecondArgument()).accept((SWRLObjectVisitor)this);
            Variable variable2 = this.m_lastVariable;
            this.m_DLSafeVars.add(variable2);
            this.m_lastAtom = OWLClausification.getRoleAtom((OWLObjectPropertyExpression)sWRLObjectPropertyAtom.getPredicate().asOWLObjectProperty(), (Term)variable, (Term)variable2);
        }

        public void visit(SWRLDataPropertyAtom sWRLDataPropertyAtom) {
            ((SWRLIArgument)sWRLDataPropertyAtom.getFirstArgument()).accept((SWRLObjectVisitor)this);
            Variable variable = this.m_lastVariable;
            this.m_DLSafeVars.add(variable);
            ((SWRLDArgument)sWRLDataPropertyAtom.getSecondArgument()).accept((SWRLObjectVisitor)this);
            Variable variable2 = this.m_lastVariable;
            this.m_lastAtom = OWLClausification.getRoleAtom((OWLDataPropertyExpression)sWRLDataPropertyAtom.getPredicate().asOWLDataProperty(), (Term)variable, (Term)variable2);
        }

        public void visit(SWRLBuiltInAtom sWRLBuiltInAtom) {
            throw new UnsupportedOperationException("Rules with SWRL built-in atoms are not yet supported. ");
        }

        public void visit(SWRLVariable sWRLVariable) {
            this.m_lastVariable = Variable.create(sWRLVariable.getIRI().toString());
            this.m_varsOfLastAtom.add(sWRLVariable);
            this.m_containsVariables = true;
        }

        public void visit(SWRLIndividualArgument sWRLIndividualArgument) {
            throw new IllegalStateException("Internal error: individual arguments in rules should have been normalized away.");
        }

        public void visit(SWRLLiteralArgument sWRLLiteralArgument) {
            throw new IllegalStateException("Internal error: Data constants in rules should have been normalized away. ");
        }

        public void visit(SWRLSameIndividualAtom sWRLSameIndividualAtom) {
            ((SWRLIArgument)sWRLSameIndividualAtom.getFirstArgument()).accept((SWRLObjectVisitor)this);
            Variable variable = this.m_lastVariable;
            ((SWRLIArgument)sWRLSameIndividualAtom.getSecondArgument()).accept((SWRLObjectVisitor)this);
            Variable variable2 = this.m_lastVariable;
            this.m_lastAtom = Atom.create(Equality.INSTANCE, variable, variable2);
        }

        public void visit(SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom) {
            ((SWRLIArgument)sWRLDifferentIndividualsAtom.getFirstArgument()).accept((SWRLObjectVisitor)this);
            Variable variable = this.m_lastVariable;
            ((SWRLIArgument)sWRLDifferentIndividualsAtom.getSecondArgument()).accept((SWRLObjectVisitor)this);
            Variable variable2 = this.m_lastVariable;
            this.m_lastAtom = Atom.create(Inequality.INSTANCE, variable, variable2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FactClausifier
    extends OWLAxiomVisitorAdapter {
        protected final DataRangeConverter m_dataRangeConverter;
        protected final Set<Atom> m_positiveFacts;
        protected final Set<Atom> m_negativeFacts;

        public FactClausifier(DataRangeConverter dataRangeConverter, Set<Atom> set, Set<Atom> set2) {
            this.m_dataRangeConverter = dataRangeConverter;
            this.m_positiveFacts = set;
            this.m_negativeFacts = set2;
        }

        public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
            OWLIndividual[] oWLIndividualArray = new OWLIndividual[oWLSameIndividualAxiom.getIndividuals().size()];
            oWLSameIndividualAxiom.getIndividuals().toArray(oWLIndividualArray);
            for (int i = 0; i < oWLIndividualArray.length - 1; ++i) {
                this.m_positiveFacts.add(Atom.create(Equality.create(), OWLClausification.getIndividual(oWLIndividualArray[i]), OWLClausification.getIndividual(oWLIndividualArray[i + 1])));
            }
        }

        public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
            OWLIndividual[] oWLIndividualArray = new OWLIndividual[oWLDifferentIndividualsAxiom.getIndividuals().size()];
            oWLDifferentIndividualsAxiom.getIndividuals().toArray(oWLIndividualArray);
            for (int i = 0; i < oWLIndividualArray.length; ++i) {
                for (int j = i + 1; j < oWLIndividualArray.length; ++j) {
                    this.m_positiveFacts.add(Atom.create(Inequality.create(), OWLClausification.getIndividual(oWLIndividualArray[i]), OWLClausification.getIndividual(oWLIndividualArray[j])));
                }
            }
        }

        public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
            OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
            if (oWLClassExpression instanceof OWLClass) {
                AtomicConcept atomicConcept = AtomicConcept.create(((OWLClass)oWLClassExpression).getIRI().toString());
                this.m_positiveFacts.add(Atom.create(atomicConcept, OWLClausification.getIndividual(oWLClassAssertionAxiom.getIndividual())));
            } else if (oWLClassExpression instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)oWLClassExpression).getOperand() instanceof OWLClass) {
                AtomicConcept atomicConcept = AtomicConcept.create(((OWLClass)((OWLObjectComplementOf)oWLClassExpression).getOperand()).getIRI().toString());
                this.m_negativeFacts.add(Atom.create(atomicConcept, OWLClausification.getIndividual(oWLClassAssertionAxiom.getIndividual())));
            } else if (oWLClassExpression instanceof OWLObjectHasSelf) {
                OWLObjectHasSelf oWLObjectHasSelf = (OWLObjectHasSelf)oWLClassExpression;
                this.m_positiveFacts.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty(), (Term)OWLClausification.getIndividual(oWLClassAssertionAxiom.getIndividual()), (Term)OWLClausification.getIndividual(oWLClassAssertionAxiom.getIndividual())));
            } else if (oWLClassExpression instanceof OWLObjectComplementOf && ((OWLObjectComplementOf)oWLClassExpression).getOperand() instanceof OWLObjectHasSelf) {
                OWLObjectHasSelf oWLObjectHasSelf = (OWLObjectHasSelf)((OWLObjectComplementOf)oWLClassExpression).getOperand();
                this.m_negativeFacts.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty(), (Term)OWLClausification.getIndividual(oWLClassAssertionAxiom.getIndividual()), (Term)OWLClausification.getIndividual(oWLClassAssertionAxiom.getIndividual())));
            } else {
                throw new IllegalStateException("Internal error: invalid normal form.");
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
            this.m_positiveFacts.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty(), (Term)OWLClausification.getIndividual(oWLObjectPropertyAssertionAxiom.getSubject()), (Term)OWLClausification.getIndividual((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject())));
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
            this.m_negativeFacts.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty(), (Term)OWLClausification.getIndividual(oWLNegativeObjectPropertyAssertionAxiom.getSubject()), (Term)OWLClausification.getIndividual((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject())));
        }

        public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
            Constant constant = (Constant)((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject()).accept((OWLDataVisitorEx)this.m_dataRangeConverter);
            this.m_positiveFacts.add(OWLClausification.getRoleAtom((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty(), (Term)OWLClausification.getIndividual(oWLDataPropertyAssertionAxiom.getSubject()), (Term)constant));
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
            Constant constant = (Constant)((OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject()).accept((OWLDataVisitorEx)this.m_dataRangeConverter);
            this.m_negativeFacts.add(OWLClausification.getRoleAtom((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty(), (Term)OWLClausification.getIndividual(oWLNegativeDataPropertyAssertionAxiom.getSubject()), (Term)constant));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DataRangeConverter
    implements OWLDataVisitorEx<Object> {
        protected final Configuration.WarningMonitor m_warningMonitor;
        protected final boolean m_ignoreUnsupportedDatatypes;
        protected final Set<String> m_definedDatatypeIRIs;
        protected final Set<DatatypeRestriction> m_allUnknownDatatypeRestrictions;

        public DataRangeConverter(Configuration.WarningMonitor warningMonitor, Set<String> set, Set<DatatypeRestriction> set2, boolean bl) {
            this.m_warningMonitor = warningMonitor;
            this.m_definedDatatypeIRIs = set;
            this.m_ignoreUnsupportedDatatypes = bl;
            this.m_allUnknownDatatypeRestrictions = set2;
        }

        public LiteralDataRange convertDataRange(OWLDataRange oWLDataRange) {
            return (LiteralDataRange)oWLDataRange.accept((OWLDataVisitorEx)this);
        }

        public Object visit(OWLDatatype oWLDatatype) {
            String string = oWLDatatype.getIRI().toString();
            if (InternalDatatype.RDFS_LITERAL.getIRI().equals(string)) {
                return InternalDatatype.RDFS_LITERAL;
            }
            if (string.startsWith("internal:defdata#") || this.m_definedDatatypeIRIs.contains(oWLDatatype.getIRI().toString())) {
                return InternalDatatype.create(string);
            }
            DatatypeRestriction datatypeRestriction = DatatypeRestriction.create(string, DatatypeRestriction.NO_FACET_URIs, DatatypeRestriction.NO_FACET_VALUES);
            if (string.startsWith("internal:unknown-datatype#")) {
                this.m_allUnknownDatatypeRestrictions.add(datatypeRestriction);
            } else {
                try {
                    DatatypeRegistry.validateDatatypeRestriction(datatypeRestriction);
                }
                catch (UnsupportedDatatypeException unsupportedDatatypeException) {
                    if (this.m_ignoreUnsupportedDatatypes) {
                        if (this.m_warningMonitor != null) {
                            this.m_warningMonitor.warning("Ignoring unsupported datatype '" + oWLDatatype.getIRI().toString() + "'.");
                        }
                        this.m_allUnknownDatatypeRestrictions.add(datatypeRestriction);
                    }
                    throw unsupportedDatatypeException;
                }
            }
            return datatypeRestriction;
        }

        public Object visit(OWLDataComplementOf oWLDataComplementOf) {
            return this.convertDataRange(oWLDataComplementOf.getDataRange()).getNegation();
        }

        public Object visit(OWLDataOneOf oWLDataOneOf) {
            HashSet<Constant> hashSet = new HashSet<Constant>();
            for (OWLLiteral oWLLiteral : oWLDataOneOf.getValues()) {
                hashSet.add((Constant)oWLLiteral.accept((OWLDataVisitorEx)this));
            }
            Constant[] constantArray = new Constant[hashSet.size()];
            hashSet.toArray(constantArray);
            return ConstantEnumeration.create(constantArray);
        }

        public Object visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            if (!oWLDatatypeRestriction.getDatatype().isOWLDatatype()) {
                throw new IllegalArgumentException("Datatype restrictions are supported only on OWL datatypes.");
            }
            String string = oWLDatatypeRestriction.getDatatype().getIRI().toString();
            if (InternalDatatype.RDFS_LITERAL.getIRI().equals(string)) {
                if (!oWLDatatypeRestriction.getFacetRestrictions().isEmpty()) {
                    throw new IllegalArgumentException("rdfs:Literal does not support any facets.");
                }
                return InternalDatatype.RDFS_LITERAL;
            }
            String[] stringArray = new String[oWLDatatypeRestriction.getFacetRestrictions().size()];
            Constant[] constantArray = new Constant[oWLDatatypeRestriction.getFacetRestrictions().size()];
            int n = 0;
            for (OWLFacetRestriction oWLFacetRestriction : oWLDatatypeRestriction.getFacetRestrictions()) {
                stringArray[n] = oWLFacetRestriction.getFacet().getIRI().toURI().toString();
                constantArray[n] = (Constant)oWLFacetRestriction.getFacetValue().accept((OWLDataVisitorEx)this);
                ++n;
            }
            DatatypeRestriction datatypeRestriction = DatatypeRestriction.create(string, stringArray, constantArray);
            DatatypeRegistry.validateDatatypeRestriction(datatypeRestriction);
            return datatypeRestriction;
        }

        public Object visit(OWLFacetRestriction oWLFacetRestriction) {
            throw new IllegalStateException("Internal error: should not get in here.");
        }

        public Object visit(OWLLiteral oWLLiteral) {
            try {
                if (oWLLiteral.isRDFPlainLiteral()) {
                    if (oWLLiteral.hasLang()) {
                        return Constant.create(oWLLiteral.getLiteral() + "@" + oWLLiteral.getLang(), Prefixes.s_semanticWebPrefixes.get("rdf") + "PlainLiteral");
                    }
                    return Constant.create(oWLLiteral.getLiteral() + "@", Prefixes.s_semanticWebPrefixes.get("rdf") + "PlainLiteral");
                }
                return Constant.create(oWLLiteral.getLiteral(), oWLLiteral.getDatatype().getIRI().toString());
            }
            catch (UnsupportedDatatypeException unsupportedDatatypeException) {
                if (this.m_ignoreUnsupportedDatatypes) {
                    if (this.m_warningMonitor != null) {
                        this.m_warningMonitor.warning("Ignoring unsupported datatype '" + oWLLiteral.toString() + "'.");
                    }
                    return Constant.createAnonymous(oWLLiteral.getLiteral());
                }
                throw unsupportedDatatypeException;
            }
        }

        public Object visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public Object visit(OWLDataUnionOf oWLDataUnionOf) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NormalizedDataRangeAxiomClausifier
    implements OWLDataVisitor {
        protected final DataRangeConverter m_dataRangeConverter;
        protected final Set<String> m_definedDatatypeIRIs;
        protected final List<Atom> m_headAtoms;
        protected final List<Atom> m_bodyAtoms;
        protected final OWLDataFactory m_factory;
        protected int m_yIndex;

        public NormalizedDataRangeAxiomClausifier(DataRangeConverter dataRangeConverter, OWLDataFactory oWLDataFactory, Set<String> set) {
            this.m_dataRangeConverter = dataRangeConverter;
            this.m_definedDatatypeIRIs = set;
            this.m_headAtoms = new ArrayList<Atom>();
            this.m_bodyAtoms = new ArrayList<Atom>();
            this.m_factory = oWLDataFactory;
        }

        protected DLClause getDLClause() {
            Atom[] atomArray = new Atom[this.m_headAtoms.size()];
            this.m_headAtoms.toArray(atomArray);
            Atom[] atomArray2 = new Atom[this.m_bodyAtoms.size()];
            this.m_bodyAtoms.toArray(atomArray2);
            DLClause dLClause = DLClause.create(atomArray, atomArray2, DLClause.ClauseType.DATA_RANGE_INCLUSION);
            this.m_headAtoms.clear();
            this.m_bodyAtoms.clear();
            this.m_yIndex = 0;
            return dLClause;
        }

        protected void ensureYNotZero() {
            if (this.m_yIndex == 0) {
                ++this.m_yIndex;
            }
        }

        protected Variable nextY() {
            Variable variable = this.m_yIndex == 0 ? Y : Variable.create("Y" + this.m_yIndex);
            ++this.m_yIndex;
            return variable;
        }

        public void visit(OWLDatatype oWLDatatype) {
            LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDatatype);
            this.m_headAtoms.add(Atom.create(literalDataRange, X));
        }

        public void visit(OWLDataIntersectionOf oWLDataIntersectionOf) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public void visit(OWLDataUnionOf oWLDataUnionOf) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public void visit(OWLDataComplementOf oWLDataComplementOf) {
            OWLDataRange oWLDataRange = oWLDataComplementOf.getDataRange();
            if (oWLDataRange.isDatatype() && (Prefixes.isInternalIRI(oWLDataRange.asOWLDatatype().getIRI().toString()) || this.m_definedDatatypeIRIs.contains(oWLDataRange.asOWLDatatype()))) {
                this.m_bodyAtoms.add(Atom.create(InternalDatatype.create(oWLDataRange.asOWLDatatype().getIRI().toString()), X));
            } else {
                LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDataComplementOf);
                if (literalDataRange.isNegatedInternalDatatype()) {
                    InternalDatatype internalDatatype = (InternalDatatype)literalDataRange.getNegation();
                    if (!internalDatatype.isAlwaysTrue()) {
                        this.m_bodyAtoms.add(Atom.create(internalDatatype, X));
                    }
                } else if (!literalDataRange.isAlwaysFalse()) {
                    this.m_headAtoms.add(Atom.create(literalDataRange, X));
                }
            }
        }

        public void visit(OWLDataOneOf oWLDataOneOf) {
            LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDataOneOf);
            this.m_headAtoms.add(Atom.create(literalDataRange, X));
        }

        public void visit(OWLFacetRestriction oWLFacetRestriction) {
            throw new IllegalStateException("Internal error: Invalid normal form. ");
        }

        public void visit(OWLDatatypeRestriction oWLDatatypeRestriction) {
            LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDatatypeRestriction);
            this.m_headAtoms.add(Atom.create(literalDataRange, X));
        }

        public void visit(OWLLiteral oWLLiteral) {
            throw new IllegalStateException("Internal error: Invalid normal form. ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NormalizedAxiomClausifier
    implements OWLClassExpressionVisitor {
        public static Map<String, Long> dt2maxRangeCardinality = new HashMap<String, Long>();
        protected final DataRangeConverter m_dataRangeConverter;
        protected final List<Atom> m_headAtoms;
        protected final List<Atom> m_bodyAtoms;
        protected final Set<Atom> m_positiveFacts;
        protected final OWLDataFactory m_factory;
        protected final Map<OWLDataProperty, OWLDatatype> m_dps2ranges;
        protected int m_yIndex;
        protected int m_zIndex;

        public NormalizedAxiomClausifier(DataRangeConverter dataRangeConverter, Set<Atom> set, OWLDataFactory oWLDataFactory, Map<OWLDataProperty, OWLDatatype> map) {
            this.m_dataRangeConverter = dataRangeConverter;
            this.m_headAtoms = new ArrayList<Atom>();
            this.m_bodyAtoms = new ArrayList<Atom>();
            this.m_positiveFacts = set;
            this.m_dps2ranges = map;
            this.m_factory = oWLDataFactory;
        }

        protected DLClause getDLClause() {
            Atom[] atomArray = new Atom[this.m_headAtoms.size()];
            this.m_headAtoms.toArray(atomArray);
            Atom[] atomArray2 = new Atom[this.m_bodyAtoms.size()];
            this.m_bodyAtoms.toArray(atomArray2);
            DLClause dLClause = DLClause.create(atomArray, atomArray2, DLClause.ClauseType.CONCEPT_INCLUSION);
            this.m_headAtoms.clear();
            this.m_bodyAtoms.clear();
            this.m_yIndex = 0;
            this.m_zIndex = 0;
            return dLClause;
        }

        protected void ensureYNotZero() {
            if (this.m_yIndex == 0) {
                ++this.m_yIndex;
            }
        }

        protected Variable nextY() {
            Variable variable = this.m_yIndex == 0 ? Y : Variable.create("Y" + this.m_yIndex);
            ++this.m_yIndex;
            return variable;
        }

        protected Variable nextZ() {
            Variable variable = this.m_zIndex == 0 ? Z : Variable.create("Z" + this.m_zIndex);
            ++this.m_zIndex;
            return variable;
        }

        protected AtomicConcept getConceptForNominal(OWLIndividual oWLIndividual) {
            AtomicConcept atomicConcept = oWLIndividual.isAnonymous() ? AtomicConcept.create("internal:anon#" + oWLIndividual.asOWLAnonymousIndividual().getID().toString()) : AtomicConcept.create("internal:nom#" + oWLIndividual.asOWLNamedIndividual().getIRI().toString());
            this.m_positiveFacts.add(Atom.create(atomicConcept, OWLClausification.getIndividual(oWLIndividual)));
            return atomicConcept;
        }

        public void visit(OWLClass oWLClass) {
            this.m_headAtoms.add(Atom.create(AtomicConcept.create(oWLClass.getIRI().toString()), X));
        }

        public void visit(OWLObjectIntersectionOf oWLObjectIntersectionOf) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public void visit(OWLObjectUnionOf oWLObjectUnionOf) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public void visit(OWLObjectComplementOf oWLObjectComplementOf) {
            OWLClassExpression oWLClassExpression = oWLObjectComplementOf.getOperand();
            if (oWLClassExpression instanceof OWLObjectHasSelf) {
                OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)((OWLObjectHasSelf)oWLClassExpression).getProperty();
                Atom atom = OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)X, (Term)X);
                this.m_bodyAtoms.add(atom);
            } else if (oWLClassExpression instanceof OWLObjectOneOf && ((OWLObjectOneOf)oWLClassExpression).getIndividuals().size() == 1) {
                OWLIndividual oWLIndividual = (OWLIndividual)((OWLObjectOneOf)oWLClassExpression).getIndividuals().iterator().next();
                this.m_bodyAtoms.add(Atom.create(this.getConceptForNominal(oWLIndividual), X));
            } else {
                if (!(oWLClassExpression instanceof OWLClass)) {
                    throw new IllegalStateException("Internal error: invalid normal form.");
                }
                this.m_bodyAtoms.add(Atom.create(AtomicConcept.create(((OWLClass)oWLClassExpression).getIRI().toString()), X));
            }
        }

        public void visit(OWLObjectOneOf oWLObjectOneOf) {
            for (OWLIndividual oWLIndividual : oWLObjectOneOf.getIndividuals()) {
                Variable variable = this.nextZ();
                AtomicConcept atomicConcept = this.getConceptForNominal(oWLIndividual);
                this.m_headAtoms.add(Atom.create(Equality.INSTANCE, X, variable));
                this.m_bodyAtoms.add(Atom.create(atomicConcept, variable));
            }
        }

        public void visit(OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom) {
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectSomeValuesFrom.getFiller();
            if (oWLClassExpression instanceof OWLObjectOneOf) {
                for (OWLIndividual oWLIndividual : ((OWLObjectOneOf)oWLClassExpression).getIndividuals()) {
                    Variable variable = this.nextZ();
                    this.m_bodyAtoms.add(Atom.create(this.getConceptForNominal(oWLIndividual), variable));
                    this.m_headAtoms.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty(), (Term)X, (Term)variable));
                }
            } else {
                LiteralConcept literalConcept = OWLClausification.getLiteralConcept(oWLClassExpression);
                Role role = OWLClausification.getRole((OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty());
                AtLeastConcept atLeastConcept = AtLeastConcept.create(1, role, literalConcept);
                if (!atLeastConcept.isAlwaysFalse()) {
                    this.m_headAtoms.add(Atom.create(atLeastConcept, X));
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visit(OWLObjectAllValuesFrom oWLObjectAllValuesFrom) {
            Variable variable = this.nextY();
            this.m_bodyAtoms.add(OWLClausification.getRoleAtom((OWLObjectPropertyExpression)oWLObjectAllValuesFrom.getProperty(), (Term)X, (Term)variable));
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectAllValuesFrom.getFiller();
            if (oWLClassExpression instanceof OWLClass) {
                AtomicConcept atomicConcept = AtomicConcept.create(((OWLClass)oWLClassExpression).getIRI().toString());
                if (atomicConcept.isAlwaysFalse()) return;
                this.m_headAtoms.add(Atom.create(atomicConcept, variable));
                return;
            } else if (oWLClassExpression instanceof OWLObjectOneOf) {
                for (OWLIndividual oWLIndividual : ((OWLObjectOneOf)oWLClassExpression).getIndividuals()) {
                    Variable variable2 = this.nextZ();
                    this.m_bodyAtoms.add(Atom.create(this.getConceptForNominal(oWLIndividual), variable2));
                    this.m_headAtoms.add(Atom.create(Equality.INSTANCE, variable, variable2));
                }
                return;
            } else {
                if (!(oWLClassExpression instanceof OWLObjectComplementOf)) throw new IllegalStateException("Internal error: invalid normal form.");
                OWLClassExpression oWLClassExpression2 = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
                if (oWLClassExpression2 instanceof OWLClass) {
                    AtomicConcept atomicConcept = AtomicConcept.create(((OWLClass)oWLClassExpression2).getIRI().toString());
                    if (atomicConcept.isAlwaysTrue()) return;
                    this.m_bodyAtoms.add(Atom.create(atomicConcept, variable));
                    return;
                } else {
                    if (!(oWLClassExpression2 instanceof OWLObjectOneOf) || ((OWLObjectOneOf)oWLClassExpression2).getIndividuals().size() != 1) throw new IllegalStateException("Internal error: invalid normal form.");
                    OWLIndividual oWLIndividual = (OWLIndividual)((OWLObjectOneOf)oWLClassExpression2).getIndividuals().iterator().next();
                    this.m_bodyAtoms.add(Atom.create(this.getConceptForNominal(oWLIndividual), variable));
                }
            }
        }

        public void visit(OWLObjectHasValue oWLObjectHasValue) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public void visit(OWLObjectHasSelf oWLObjectHasSelf) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)oWLObjectHasSelf.getProperty();
            Atom atom = OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)X, (Term)X);
            this.m_headAtoms.add(atom);
        }

        public void visit(OWLObjectMinCardinality oWLObjectMinCardinality) {
            LiteralConcept literalConcept = OWLClausification.getLiteralConcept((OWLClassExpression)oWLObjectMinCardinality.getFiller());
            Role role = OWLClausification.getRole((OWLObjectPropertyExpression)oWLObjectMinCardinality.getProperty());
            AtLeastConcept atLeastConcept = AtLeastConcept.create(oWLObjectMinCardinality.getCardinality(), role, literalConcept);
            if (!atLeastConcept.isAlwaysFalse()) {
                this.m_headAtoms.add(Atom.create(atLeastConcept, X));
            }
        }

        public void visit(OWLObjectMaxCardinality oWLObjectMaxCardinality) {
            int n;
            Object object;
            AtomicConcept atomicConcept;
            boolean bl;
            int n2 = oWLObjectMaxCardinality.getCardinality();
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)oWLObjectMaxCardinality.getProperty();
            OWLClassExpression oWLClassExpression = (OWLClassExpression)oWLObjectMaxCardinality.getFiller();
            this.ensureYNotZero();
            if (oWLClassExpression instanceof OWLClass) {
                bl = true;
                atomicConcept = AtomicConcept.create(((OWLClass)oWLClassExpression).getIRI().toString());
                if (atomicConcept.isAlwaysTrue()) {
                    atomicConcept = null;
                }
            } else if (oWLClassExpression instanceof OWLObjectComplementOf) {
                object = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
                if (!(object instanceof OWLClass)) {
                    throw new IllegalStateException("Internal error: Invalid ontology normal form.");
                }
                bl = false;
                atomicConcept = AtomicConcept.create(((OWLClass)object).getIRI().toString());
                if (atomicConcept.isAlwaysFalse()) {
                    atomicConcept = null;
                }
            } else {
                throw new IllegalStateException("Internal error: Invalid ontology normal form.");
            }
            object = OWLClausification.getRole(oWLObjectPropertyExpression);
            LiteralConcept literalConcept = OWLClausification.getLiteralConcept(oWLClassExpression);
            AnnotatedEquality annotatedEquality = AnnotatedEquality.create(n2, (Role)object, literalConcept);
            Term[] termArray = new Variable[n2 + 1];
            for (n = 0; n < termArray.length; ++n) {
                termArray[n] = this.nextY();
                this.m_bodyAtoms.add(OWLClausification.getRoleAtom(oWLObjectPropertyExpression, (Term)X, (Term)termArray[n]));
                if (atomicConcept == null) continue;
                Atom atom = Atom.create(atomicConcept, termArray[n]);
                if (bl) {
                    this.m_bodyAtoms.add(atom);
                    continue;
                }
                this.m_headAtoms.add(atom);
            }
            if (termArray.length > 2) {
                for (n = 0; n < termArray.length - 1; ++n) {
                    this.m_bodyAtoms.add(Atom.create(NodeIDLessEqualThan.INSTANCE, termArray[n], termArray[n + 1]));
                }
                this.m_bodyAtoms.add(Atom.create(NodeIDsAscendingOrEqual.create(termArray.length), termArray));
            }
            for (n = 0; n < termArray.length; ++n) {
                for (int i = n + 1; i < termArray.length; ++i) {
                    this.m_headAtoms.add(Atom.create(annotatedEquality, termArray[n], termArray[i], X));
                }
            }
        }

        public void visit(OWLObjectExactCardinality oWLObjectExactCardinality) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        public void visit(OWLDataSomeValuesFrom oWLDataSomeValuesFrom) {
            LiteralDataRange literalDataRange;
            AtomicRole atomicRole;
            AtLeastDataRange atLeastDataRange;
            if (!((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty()).isOWLBottomDataProperty() && !(atLeastDataRange = AtLeastDataRange.create(1, atomicRole = OWLClausification.getAtomicRole((OWLDataPropertyExpression)oWLDataSomeValuesFrom.getProperty()), literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDataSomeValuesFrom.getFiller()))).isAlwaysFalse()) {
                this.m_headAtoms.add(Atom.create(atLeastDataRange, X));
            }
        }

        public void visit(OWLDataAllValuesFrom oWLDataAllValuesFrom) {
            LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDataAllValuesFrom.getFiller());
            if (((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty()).isOWLTopDataProperty() && literalDataRange.isAlwaysFalse()) {
                return;
            }
            Variable variable = this.nextY();
            this.m_bodyAtoms.add(OWLClausification.getRoleAtom((OWLDataPropertyExpression)oWLDataAllValuesFrom.getProperty(), (Term)X, (Term)variable));
            if (literalDataRange.isNegatedInternalDatatype()) {
                InternalDatatype internalDatatype = (InternalDatatype)literalDataRange.getNegation();
                if (!internalDatatype.isAlwaysTrue()) {
                    this.m_bodyAtoms.add(Atom.create(internalDatatype, variable));
                }
            } else if (!literalDataRange.isAlwaysFalse()) {
                this.m_headAtoms.add(Atom.create(literalDataRange, variable));
            }
        }

        public void visit(OWLDataHasValue oWLDataHasValue) {
            throw new IllegalStateException("Internal error: Invalid normal form.");
        }

        public void visit(OWLDataMinCardinality oWLDataMinCardinality) {
            if (!((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty()).isOWLBottomDataProperty() || oWLDataMinCardinality.getCardinality() == 0) {
                Object object;
                OWLDataProperty oWLDataProperty = ((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty()).asOWLDataProperty();
                OWLDataRange oWLDataRange = (OWLDataRange)oWLDataMinCardinality.getFiller();
                int n = oWLDataMinCardinality.getCardinality();
                if (this.m_dps2ranges.containsKey(oWLDataProperty) && dt2maxRangeCardinality.containsKey(object = this.m_dps2ranges.get(oWLDataProperty).getIRI().toString()) && (long)n > dt2maxRangeCardinality.get(object)) {
                    return;
                }
                if (oWLDataRange.isDatatype() && dt2maxRangeCardinality.containsKey(object = oWLDataRange.asOWLDatatype().getIRI().toString()) && (long)n > dt2maxRangeCardinality.get(object)) {
                    return;
                }
                object = OWLClausification.getAtomicRole((OWLDataPropertyExpression)oWLDataMinCardinality.getProperty());
                LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDataMinCardinality.getFiller());
                AtLeastDataRange atLeastDataRange = AtLeastDataRange.create(oWLDataMinCardinality.getCardinality(), (Role)object, literalDataRange);
                if (!atLeastDataRange.isAlwaysFalse()) {
                    this.m_headAtoms.add(Atom.create(atLeastDataRange, X));
                }
            }
        }

        public void visit(OWLDataMaxCardinality oWLDataMaxCardinality) {
            int n;
            int n2 = oWLDataMaxCardinality.getCardinality();
            LiteralDataRange literalDataRange = this.m_dataRangeConverter.convertDataRange((OWLDataRange)oWLDataMaxCardinality.getFiller()).getNegation();
            this.ensureYNotZero();
            Variable[] variableArray = new Variable[n2 + 1];
            for (n = 0; n < variableArray.length; ++n) {
                variableArray[n] = this.nextY();
                this.m_bodyAtoms.add(OWLClausification.getRoleAtom((OWLDataPropertyExpression)oWLDataMaxCardinality.getProperty(), (Term)X, (Term)variableArray[n]));
                if (literalDataRange.isNegatedInternalDatatype()) {
                    InternalDatatype internalDatatype = (InternalDatatype)literalDataRange.getNegation();
                    if (internalDatatype.isAlwaysTrue()) continue;
                    this.m_bodyAtoms.add(Atom.create(internalDatatype, variableArray[n]));
                    continue;
                }
                if (literalDataRange.isAlwaysFalse()) continue;
                this.m_headAtoms.add(Atom.create(literalDataRange, variableArray[n]));
            }
            for (n = 0; n < variableArray.length; ++n) {
                for (int i = n + 1; i < variableArray.length; ++i) {
                    this.m_headAtoms.add(Atom.create(Equality.INSTANCE, variableArray[n], variableArray[i]));
                }
            }
        }

        public void visit(OWLDataExactCardinality oWLDataExactCardinality) {
            throw new IllegalStateException("Internal error: invalid normal form.");
        }

        static {
            dt2maxRangeCardinality.put(Prefixes.s_semanticWebPrefixes.get("xsd") + "int", 0xFFFFFFFFL);
            dt2maxRangeCardinality.put(Prefixes.s_semanticWebPrefixes.get("xsd") + "short", 65535L);
            dt2maxRangeCardinality.put(Prefixes.s_semanticWebPrefixes.get("xsd") + "byte", 256L);
            dt2maxRangeCardinality.put(Prefixes.s_semanticWebPrefixes.get("xsd") + "unsignedInt", new Long("4294967296"));
            dt2maxRangeCardinality.put(Prefixes.s_semanticWebPrefixes.get("xsd") + "unsignedShort", new Long("65536"));
            dt2maxRangeCardinality.put(Prefixes.s_semanticWebPrefixes.get("xsd") + "unsignedByte", new Long("256"));
        }
    }
}

