/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.transformations.Normalizer;
import rationals.transformations.Reducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPropertyInclusionManager {
    protected final Map<OWLObjectPropertyExpression, Automaton> m_automataByProperty = new HashMap<OWLObjectPropertyExpression, Automaton>();

    public ObjectPropertyInclusionManager(OWLAxioms oWLAxioms) {
        this.createAutomata(this.m_automataByProperty, oWLAxioms.m_complexObjectPropertyExpressions, oWLAxioms.m_simpleObjectPropertyInclusions, oWLAxioms.m_complexObjectPropertyInclusions);
    }

    public int rewriteNegativeObjectPropertyAssertions(OWLDataFactory oWLDataFactory, OWLAxioms oWLAxioms, int n) {
        HashSet<OWLNegativeObjectPropertyAssertionAxiom> hashSet = new HashSet<OWLNegativeObjectPropertyAssertionAxiom>();
        HashSet<OWLClassAssertionAxiom> hashSet2 = new HashSet<OWLClassAssertionAxiom>();
        for (OWLIndividualAxiom oWLIndividualAxiom : oWLAxioms.m_facts) {
            OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom;
            OWLObjectPropertyExpression oWLObjectPropertyExpression;
            if (!(oWLIndividualAxiom instanceof OWLNegativeObjectPropertyAssertionAxiom) || !oWLAxioms.m_complexObjectPropertyExpressions.contains(oWLObjectPropertyExpression = ((OWLObjectPropertyExpression)(oWLNegativeObjectPropertyAssertionAxiom = (OWLNegativeObjectPropertyAssertionAxiom)oWLIndividualAxiom).getProperty()).getSimplified())) continue;
            OWLIndividual oWLIndividual = (OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject();
            OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create((String)("internal:nom#" + oWLIndividual.asOWLNamedIndividual().getIRI().toString())));
            OWLObjectComplementOf oWLObjectComplementOf = oWLDataFactory.getOWLObjectComplementOf((OWLClassExpression)oWLClass);
            OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, (OWLClassExpression)oWLObjectComplementOf);
            OWLClass oWLClass2 = oWLDataFactory.getOWLClass(IRI.create((String)("internal:def#" + n++)));
            oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLDataFactory.getOWLObjectComplementOf((OWLClassExpression)oWLClass2), oWLObjectAllValuesFrom});
            hashSet2.add(oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLClass2, oWLNegativeObjectPropertyAssertionAxiom.getSubject()));
            hashSet2.add(oWLDataFactory.getOWLClassAssertionAxiom((OWLClassExpression)oWLClass, oWLIndividual));
            hashSet.add(oWLNegativeObjectPropertyAssertionAxiom);
        }
        oWLAxioms.m_facts.addAll(hashSet2);
        oWLAxioms.m_facts.removeAll(hashSet);
        return n;
    }

    public void rewriteAxioms(OWLDataFactory oWLDataFactory, OWLAxioms oWLAxioms, int n) {
        Object object5;
        Object object2;
        Object object3;
        for (OWLObjectPropertyExpression object4 : oWLAxioms.m_asymmetricObjectProperties) {
            if (!oWLAxioms.m_complexObjectPropertyExpressions.contains(object4)) continue;
            throw new IllegalArgumentException("Non-simple property '" + object4 + "' or its inverse appears in asymmetric object property axiom.");
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_irreflexiveObjectProperties) {
            if (!oWLAxioms.m_complexObjectPropertyExpressions.contains(oWLObjectPropertyExpression)) continue;
            throw new IllegalArgumentException("Non-simple property '" + oWLObjectPropertyExpression + "' or its inverse appears in irreflexive object property axiom.");
        }
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : oWLAxioms.m_disjointObjectProperties) {
            for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                if (!oWLAxioms.m_complexObjectPropertyExpressions.contains(oWLObjectPropertyExpressionArray[i])) continue;
                throw new IllegalArgumentException("Non-simple property '" + oWLObjectPropertyExpressionArray[i] + "' or its inverse appears in disjoint properties axiom.");
            }
        }
        HashMap hashMap = new HashMap();
        for (OWLClassExpression[] oWLClassExpressionArray : oWLAxioms.m_conceptInclusions) {
            for (int i = 0; i < oWLClassExpressionArray.length; ++i) {
                OWLClassExpression oWLClassExpression = oWLClassExpressionArray[i];
                if (oWLClassExpression instanceof OWLObjectCardinalityRestriction) {
                    object3 = (OWLObjectCardinalityRestriction)oWLClassExpression;
                    object2 = (OWLObjectPropertyExpression)object3.getProperty();
                    if (oWLAxioms.m_complexObjectPropertyExpressions.contains(object2)) {
                        throw new IllegalArgumentException("Non-simple property '" + object2 + "' or its inverse appears in the cardinality restriction '" + object3 + "'.");
                    }
                } else if (oWLClassExpression instanceof OWLObjectHasSelf && oWLAxioms.m_complexObjectPropertyExpressions.contains((object3 = (OWLObjectHasSelf)oWLClassExpression).getProperty())) {
                    throw new IllegalArgumentException("Non-simple property '" + object3.getProperty() + "' or its inverse appears in the Self restriction '" + object3 + "'.");
                }
                if (!(oWLClassExpression instanceof OWLObjectAllValuesFrom) || ((OWLClassExpression)(object3 = (OWLObjectAllValuesFrom)oWLClassExpression).getFiller()).equals(oWLDataFactory.getOWLThing()) || !this.m_automataByProperty.containsKey(object2 = (OWLObjectPropertyExpression)object3.getProperty())) continue;
                object5 = (OWLClassExpression)hashMap.get(object3);
                if (object5 == null) {
                    object5 = oWLDataFactory.getOWLClass(IRI.create((String)("internal:all#" + n++)));
                    if (object3.getFiller() instanceof OWLObjectComplementOf || ((OWLClassExpression)object3.getFiller()).equals(oWLDataFactory.getOWLNothing())) {
                        object5 = object5.getComplementNNF();
                    }
                    hashMap.put(object3, object5);
                }
                oWLClassExpressionArray[i] = object5;
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            OWLClassExpression oWLClassExpression;
            Object object4;
            Automaton automaton = this.m_automataByProperty.get(((OWLObjectAllValuesFrom)entry.getKey()).getProperty());
            boolean bl = entry.getValue() instanceof OWLObjectComplementOf;
            object3 = new HashMap();
            for (Object object5 : automaton.states()) {
                object4 = (State)object5;
                if (object4.isInitial()) {
                    object3.put(object4, entry.getValue());
                    continue;
                }
                oWLClassExpression = oWLDataFactory.getOWLClass(IRI.create((String)("internal:all#" + n++)));
                if (bl) {
                    oWLClassExpression = oWLClassExpression.getComplementNNF();
                }
                object3.put(object4, oWLClassExpression);
            }
            for (Object object5 : automaton.delta()) {
                object4 = (Transition)object5;
                oWLClassExpression = ((OWLClassExpression)object3.get(((Transition)object4).start())).getComplementNNF();
                OWLClassExpression oWLClassExpression2 = (OWLClassExpression)object3.get(((Transition)object4).end());
                if (((Transition)object4).label() == null) {
                    oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression, oWLClassExpression2});
                    continue;
                }
                OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)((Transition)object4).label(), oWLClassExpression2);
                oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression, oWLObjectAllValuesFrom});
            }
            object2 = (OWLClassExpression)((OWLObjectAllValuesFrom)entry.getKey()).getFiller();
            object5 = automaton.terminals().iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                oWLClassExpression = ((OWLClassExpression)object3.get(object4)).getComplementNNF();
                if (object2.isOWLNothing()) {
                    oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression});
                    continue;
                }
                oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression, object2});
            }
        }
    }

    protected void createAutomata(Map<OWLObjectPropertyExpression, Automaton> map, Set<OWLObjectPropertyExpression> set, Collection<OWLObjectPropertyExpression[]> collection, Collection<OWLAxioms.ComplexObjectPropertyInclusion> collection2) {
        Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2 = this.findEquivalentProperties(collection);
        Set<OWLObjectPropertyExpression> set2 = this.findSymmetricProperties(collection);
        Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map3 = this.buildInversePropertiesMap(collection);
        Graph<OWLObjectPropertyExpression> graph = this.buildPropertyOrdering(collection, collection2, map2);
        this.checkForRegularity(graph, map2);
        Object object = graph.clone();
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        Map<OWLObjectPropertyExpression, Automaton> map4 = this.buildIndividualAutomata((Graph<OWLObjectPropertyExpression>)object, collection, collection2, map2, hashSet);
        Set<OWLObjectPropertyExpression> set3 = this.findSimpleProperties((Graph<OWLObjectPropertyExpression>)object, map4);
        graph.removeElements(set3);
        ((Graph)object).removeElements(set3);
        set.addAll(((Graph)object).getElements());
        HashSet<OWLObjectPropertyExpression> hashSet2 = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : set) {
            hashSet2.add(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
        }
        set.addAll(hashSet2);
        this.connectAllAutomata(map, graph, map3, map4, collection, set2, hashSet);
    }

    private Set<OWLObjectPropertyExpression> findSymmetricProperties(Collection<OWLObjectPropertyExpression[]> collection) {
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : collection) {
            if (!oWLObjectPropertyExpressionArray[1].getInverseProperty().getSimplified().equals(oWLObjectPropertyExpressionArray[0]) && !oWLObjectPropertyExpressionArray[1].equals(oWLObjectPropertyExpressionArray[0].getInverseProperty().getSimplified())) continue;
            hashSet.add(oWLObjectPropertyExpressionArray[0]);
            hashSet.add(oWLObjectPropertyExpressionArray[0].getInverseProperty().getSimplified());
        }
        return hashSet;
    }

    protected Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> buildInversePropertiesMap(Collection<OWLObjectPropertyExpression[]> collection) {
        HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hashMap = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : collection) {
            if (!(oWLObjectPropertyExpressionArray[1] instanceof OWLObjectInverseOf)) continue;
            HashSet<OWLObjectPropertyExpression> hashSet = (HashSet<OWLObjectPropertyExpression>)hashMap.get(oWLObjectPropertyExpressionArray[0]);
            if (hashSet == null) {
                hashSet = new HashSet<OWLObjectPropertyExpression>();
            }
            hashSet.add(oWLObjectPropertyExpressionArray[1].getInverseProperty().getSimplified());
            hashMap.put(oWLObjectPropertyExpressionArray[0], hashSet);
        }
        return hashMap;
    }

    protected Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> findEquivalentProperties(Collection<OWLObjectPropertyExpression[]> collection) {
        Graph<OWLObjectPropertyExpression> graph = new Graph<OWLObjectPropertyExpression>();
        HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hashMap = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpression : collection) {
            if (oWLObjectPropertyExpression[0].equals(oWLObjectPropertyExpression[1]) || oWLObjectPropertyExpression[0].equals(oWLObjectPropertyExpression[1].getInverseProperty().getSimplified())) continue;
            graph.addEdge(oWLObjectPropertyExpression[0], oWLObjectPropertyExpression[1]);
        }
        graph.transitivelyClose();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : graph.getElements()) {
            if (!graph.getSuccessors(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression) && !graph.getSuccessors(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : graph.getSuccessors(oWLObjectPropertyExpression)) {
                if (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression) || !graph.getSuccessors(oWLObjectPropertyExpression2).contains(oWLObjectPropertyExpression) && !graph.getSuccessors(oWLObjectPropertyExpression2).contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
                hashSet.add(oWLObjectPropertyExpression2);
            }
            hashMap.put(oWLObjectPropertyExpression, hashSet);
        }
        return hashMap;
    }

    protected Set<OWLObjectPropertyExpression> findSimpleProperties(Graph<OWLObjectPropertyExpression> graph, Map<OWLObjectPropertyExpression, Automaton> map) {
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        Object object = graph.clone();
        for (OWLObjectPropertyExpression object2 : graph.getElements()) {
            for (OWLObjectPropertyExpression bl : graph.getSuccessors(object2)) {
                ((Graph)object).addEdge(object2.getInverseProperty().getSimplified(), bl.getInverseProperty().getSimplified());
            }
        }
        Graph graph2 = ((Graph)object).getInverse();
        graph2.transitivelyClose();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : graph2.getElements()) {
            boolean bl = false;
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : graph2.getSuccessors(oWLObjectPropertyExpression)) {
                if (!map.containsKey(oWLObjectPropertyExpression2) && !map.containsKey(oWLObjectPropertyExpression2.getInverseProperty().getSimplified())) continue;
                bl = true;
                break;
            }
            if (bl || map.containsKey(oWLObjectPropertyExpression) || map.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            hashSet.add(oWLObjectPropertyExpression);
        }
        return hashSet;
    }

    protected void connectAllAutomata(Map<OWLObjectPropertyExpression, Automaton> map, Graph<OWLObjectPropertyExpression> graph, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2, Map<OWLObjectPropertyExpression, Automaton> map3, Collection<OWLObjectPropertyExpression[]> collection, Set<OWLObjectPropertyExpression> set, Set<OWLObjectPropertyExpression> set2) {
        Object object32;
        Object object2 = graph.clone();
        ((Graph)object2).transitivelyClose();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object32 : ((Graph)object2).getElements()) {
            if (!((Graph)object2).getSuccessors(object32).isEmpty()) continue;
            hashSet.add(object32);
        }
        Graph<OWLObjectPropertyExpression> graph2 = graph.getInverse();
        for (OWLObjectPropertyExpression object4 : hashSet) {
            this.buildCompleteAutomataForProperties(object4, map2, map3, map, graph2, set, set2);
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map3.keySet()) {
            if (map.containsKey(oWLObjectPropertyExpression)) continue;
            Automaton automaton = map3.get(oWLObjectPropertyExpression);
            if (map.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified()) && graph2.getElements().contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified()) || map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                Automaton automaton2 = map.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
                if (automaton2 == null) {
                    automaton2 = map3.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
                }
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, automaton2);
            }
            map.put(oWLObjectPropertyExpression, automaton);
        }
        object32 = new HashMap();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map.keySet()) {
            if (map.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            object32.put(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), this.getMirroredCopy(map.get(oWLObjectPropertyExpression)));
        }
        map.putAll((Map<OWLObjectPropertyExpression, Automaton>)object32);
        object32.clear();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map.keySet()) {
            if (!map.containsKey(oWLObjectPropertyExpression) || map.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            object32.put(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), this.getMirroredCopy(map.get(oWLObjectPropertyExpression)));
        }
        map.putAll((Map<OWLObjectPropertyExpression, Automaton>)object32);
        object32.clear();
    }

    protected void increaseAutomatonWithInversePropertyAutomaton(Automaton automaton, Automaton automaton2) {
        State state = (State)automaton.initials().iterator().next();
        State state2 = (State)automaton.terminals().iterator().next();
        Transition transition = (Transition)automaton.deltaFrom(state, state2).iterator().next();
        this.automataConnector(automaton, this.getMirroredCopy(automaton2), transition);
    }

    protected Automaton buildCompleteAutomataForProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, Map<OWLObjectPropertyExpression, Automaton> map2, Map<OWLObjectPropertyExpression, Automaton> map3, Graph<OWLObjectPropertyExpression> graph, Set<OWLObjectPropertyExpression> set, Set<OWLObjectPropertyExpression> set2) {
        Object object;
        if (map3.containsKey(oWLObjectPropertyExpression)) {
            return map3.get(oWLObjectPropertyExpression);
        }
        if (map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified()) && !map2.containsKey(oWLObjectPropertyExpression)) {
            Automaton automaton = this.getMirroredCopy(map3.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified()));
            map3.put(oWLObjectPropertyExpression, automaton);
            return automaton;
        }
        if (graph.getSuccessors(oWLObjectPropertyExpression).isEmpty()) {
            Automaton automaton = map2.get(oWLObjectPropertyExpression);
            if (automaton == null) {
                Set<OWLObjectPropertyExpression> set3 = map.get(oWLObjectPropertyExpression);
                boolean bl = true;
                if (set3 != null) {
                    for (Object object2 : set3) {
                        if (!map2.containsKey(object2) || object2.equals(oWLObjectPropertyExpression)) continue;
                        automaton = this.getMirroredCopy(this.buildCompleteAutomataForProperties((OWLObjectPropertyExpression)object2, map, map2, map3, graph, set, set2));
                        automaton = this.minimizeAndNormalizeAutomaton(automaton);
                        map3.put(oWLObjectPropertyExpression, automaton);
                        bl = false;
                        break;
                    }
                } else if (map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                    automaton = this.getMirroredCopy(this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map, map2, map3, graph, set, set2));
                    if (!map3.containsKey(oWLObjectPropertyExpression)) {
                        automaton = this.minimizeAndNormalizeAutomaton(automaton);
                        map3.put(oWLObjectPropertyExpression, automaton);
                    } else {
                        automaton = map3.get(oWLObjectPropertyExpression);
                    }
                    bl = false;
                }
                if (bl) {
                    Object object2;
                    automaton = new Automaton();
                    State state = automaton.addState(true, false);
                    object2 = automaton.addState(false, true);
                    try {
                        automaton.addTransition(new Transition(state, oWLObjectPropertyExpression, (State)object2));
                    }
                    catch (NoSuchStateException noSuchStateException) {
                        throw new IllegalArgumentException("Could not create automaton for property at the bottom of hierarchy (simple property).");
                    }
                    this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
                }
            } else if (oWLObjectPropertyExpression.getInverseProperty().getSimplified().isAnonymous() && map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                Automaton automaton2 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map, map2, map3, graph, set, set2);
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, this.getMirroredCopy(automaton2));
                if (!map3.containsKey(oWLObjectPropertyExpression)) {
                    this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
                } else {
                    automaton = map3.get(oWLObjectPropertyExpression);
                }
            } else {
                this.increaseWithDefinedInverseIfNecessary(oWLObjectPropertyExpression, automaton, map, map2);
                this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
            }
            return automaton;
        }
        Automaton automaton = map2.get(oWLObjectPropertyExpression);
        if (automaton == null) {
            automaton = new Automaton();
            object = automaton.addState(true, false);
            State state = automaton.addState(false, true);
            Transition transition = new Transition((State)object, oWLObjectPropertyExpression, state);
            try {
                automaton.addTransition(transition);
            }
            catch (NoSuchStateException noSuchStateException) {
                throw new IllegalArgumentException("Could not create automaton");
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : graph.getSuccessors(oWLObjectPropertyExpression)) {
                Automaton automaton3 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression2, map, map2, map3, graph, set, set2);
                this.automataConnector(automaton, automaton3, transition);
                try {
                    automaton.addTransition(new Transition((State)object, oWLObjectPropertyExpression2, state));
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            if (oWLObjectPropertyExpression.getInverseProperty().getSimplified().isAnonymous() && map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                Automaton automaton4 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map, map2, map3, graph, set, set2);
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, this.getMirroredCopy(automaton4));
                if (!map3.containsKey(oWLObjectPropertyExpression)) {
                    this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
                } else {
                    automaton = map3.get(oWLObjectPropertyExpression);
                }
            } else {
                this.increaseWithDefinedInverseIfNecessary(oWLObjectPropertyExpression, automaton, map, map2);
                if (!map3.containsKey(oWLObjectPropertyExpression)) {
                    this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
                } else {
                    automaton = map3.get(oWLObjectPropertyExpression);
                }
            }
        } else {
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression3 : graph.getSuccessors(oWLObjectPropertyExpression)) {
                Object object32;
                boolean bl = false;
                for (Object object32 : automaton.delta()) {
                    Transition transition = (Transition)object32;
                    if (transition.label() == null || !transition.label().equals(oWLObjectPropertyExpression3)) continue;
                    Automaton automaton5 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression3, map, map2, map3, graph, set, set2);
                    if (automaton5.delta().size() != 1) {
                        this.automataConnector(automaton, automaton5, transition);
                    }
                    bl = true;
                }
                if (bl) continue;
                Automaton automaton6 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression3, map, map2, map3, graph, set, set2);
                object32 = (Transition)automaton.deltaFrom((State)automaton.initials().iterator().next(), (State)automaton.terminals().iterator().next()).iterator().next();
                this.automataConnector(automaton, automaton6, (Transition)object32);
            }
        }
        if (oWLObjectPropertyExpression.getInverseProperty().getSimplified().isAnonymous() && map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
            object = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map, map2, map3, graph, set, set2);
            this.increaseAutomatonWithInversePropertyAutomaton(automaton, this.getMirroredCopy((Automaton)object));
            if (!map3.containsKey(oWLObjectPropertyExpression)) {
                this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
            } else {
                automaton = map3.get(oWLObjectPropertyExpression);
            }
        } else {
            this.increaseWithDefinedInverseIfNecessary(oWLObjectPropertyExpression, automaton, map, map2);
            if (!map3.containsKey(oWLObjectPropertyExpression)) {
                this.finalizeConstruction(map3, oWLObjectPropertyExpression, automaton, set, set2);
            } else {
                automaton = map3.get(oWLObjectPropertyExpression);
            }
        }
        return automaton;
    }

    private void finalizeConstruction(Map<OWLObjectPropertyExpression, Automaton> map, OWLObjectPropertyExpression oWLObjectPropertyExpression, Automaton automaton, Set<OWLObjectPropertyExpression> set, Set<OWLObjectPropertyExpression> set2) {
        try {
            if (set2.contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                automaton.addTransition(new Transition((State)automaton.terminals().iterator().next(), null, (State)automaton.initials().iterator().next()));
            }
        }
        catch (NoSuchStateException noSuchStateException) {
            throw new IllegalArgumentException("Could not create automaton for symmetric property: " + oWLObjectPropertyExpression);
        }
        if (set.contains(oWLObjectPropertyExpression)) {
            Transition transition = new Transition((State)automaton.initials().iterator().next(), oWLObjectPropertyExpression.getInverseProperty().getSimplified(), (State)automaton.terminals().iterator().next());
            this.automataConnector(automaton, this.getMirroredCopy(automaton), transition);
        }
        automaton = this.minimizeAndNormalizeAutomaton(automaton);
        map.put(oWLObjectPropertyExpression, automaton);
        map.put(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), this.getMirroredCopy(automaton));
    }

    protected void increaseWithDefinedInverseIfNecessary(OWLObjectPropertyExpression oWLObjectPropertyExpression, Automaton automaton, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, Map<OWLObjectPropertyExpression, Automaton> map2) {
        Set<OWLObjectPropertyExpression> set = map.get(oWLObjectPropertyExpression);
        if (set != null) {
            Automaton automaton2 = null;
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : set) {
                if (!map2.containsKey(oWLObjectPropertyExpression2) || oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression)) continue;
                automaton2 = map2.get(oWLObjectPropertyExpression2);
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, automaton2);
            }
        } else if (map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
            Automaton automaton3 = map2.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
            this.increaseAutomatonWithInversePropertyAutomaton(automaton, automaton3);
        }
    }

    protected Automaton minimizeAndNormalizeAutomaton(Automaton automaton) {
        Reducer reducer = new Reducer();
        if (automaton.delta().size() > 300) {
            return automaton;
        }
        Normalizer normalizer = new Normalizer();
        Automaton automaton2 = reducer.transform(automaton);
        if (automaton2.delta().size() >= automaton.delta().size()) {
            return automaton;
        }
        if (automaton2.initials().size() != 1 || automaton2.terminals().size() != 1) {
            automaton2 = normalizer.transform(automaton2);
        }
        if (automaton2.delta().size() > automaton.delta().size()) {
            return automaton;
        }
        return automaton2;
    }

    protected void useStandardAutomataConnector(Automaton automaton, Automaton automaton2, Transition transition) {
        Map<State, State> map = this.getDisjointUnion(automaton, automaton2);
        State state = transition.start();
        State state2 = transition.end();
        State state3 = map.get(automaton2.initials().iterator().next());
        State state4 = map.get(automaton2.terminals().iterator().next());
        try {
            automaton.addTransition(new Transition(state, null, state3));
            automaton.addTransition(new Transition(state4, null, state2));
        }
        catch (NoSuchStateException noSuchStateException) {
            throw new IllegalArgumentException("Could not build the Complete Automata of non-Simple Properties");
        }
    }

    protected void automataConnector(Automaton automaton, Automaton automaton2, Transition transition) {
        this.useStandardAutomataConnector(automaton, automaton2, transition);
    }

    protected Set<Transition> deltaToState(Automaton automaton, State state) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (Object e : automaton.delta()) {
            Transition transition = (Transition)e;
            if (!transition.end().equals(state)) continue;
            hashSet.add(transition);
        }
        return hashSet;
    }

    protected Graph<OWLObjectPropertyExpression> buildPropertyOrdering(Collection<OWLObjectPropertyExpression[]> collection, Collection<OWLAxioms.ComplexObjectPropertyInclusion> collection2, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map) {
        Graph<OWLObjectPropertyExpression> graph = new Graph<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression[] object : collection) {
            if (object[0].equals(object[1]) || object[0].equals(object[1].getInverseProperty().getSimplified()) || map.get(object[0]) != null && map.get(object[0]).contains(object[1])) continue;
            graph.addEdge(object[0], object[1]);
        }
        for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : collection2) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = complexObjectPropertyInclusion.m_superObjectProperty;
            OWLObjectPropertyExpression oWLObjectPropertyExpression2 = null;
            OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = complexObjectPropertyInclusion.m_subObjectProperties;
            if (oWLObjectPropertyExpressionArray.length != 2 && oWLObjectPropertyExpression.equals(oWLObjectPropertyExpressionArray[0]) && oWLObjectPropertyExpression.equals(oWLObjectPropertyExpressionArray[oWLObjectPropertyExpressionArray.length - 1])) {
                throw new IllegalArgumentException("The given property hierarchy is not regular.");
            }
            for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                oWLObjectPropertyExpression2 = oWLObjectPropertyExpressionArray[i];
                if (oWLObjectPropertyExpressionArray.length != 2 && i > 0 && i < oWLObjectPropertyExpressionArray.length - 1 && (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression) || map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression2))) {
                    throw new IllegalArgumentException("The given property hierarchy is not regular.");
                }
                if (oWLObjectPropertyExpression2.getInverseProperty().getSimplified().equals(oWLObjectPropertyExpression)) {
                    throw new IllegalArgumentException("The given property hierarchy is not regular.");
                }
                if (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression)) continue;
                graph.addEdge(oWLObjectPropertyExpression2, oWLObjectPropertyExpression);
            }
        }
        return graph;
    }

    protected void checkForRegularity(Graph<OWLObjectPropertyExpression> graph, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map) {
        Object object = graph.clone();
        boolean bl = false;
        do {
            bl = false;
            Object object2 = ((Graph)object).clone();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : ((Graph)object2).getElements()) {
                for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : ((Graph)object2).getSuccessors(oWLObjectPropertyExpression)) {
                    if (!map.containsKey(oWLObjectPropertyExpression) || !map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression2)) continue;
                    for (OWLObjectPropertyExpression oWLObjectPropertyExpression3 : ((Graph)object2).getSuccessors(oWLObjectPropertyExpression2)) {
                        if (oWLObjectPropertyExpression.equals(oWLObjectPropertyExpression3)) continue;
                        ((Graph)object).addEdge(oWLObjectPropertyExpression, oWLObjectPropertyExpression3);
                    }
                    bl = true;
                    ((Graph)object).getSuccessors(oWLObjectPropertyExpression).remove(oWLObjectPropertyExpression2);
                }
            }
        } while (bl);
        ((Graph)object).transitivelyClose();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : ((Graph)object).getElements()) {
            Set<OWLObjectPropertyExpression> set = ((Graph)object).getSuccessors(oWLObjectPropertyExpression);
            if (!set.contains(oWLObjectPropertyExpression) && !set.contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            throw new IllegalArgumentException("The given property hierarchy is not regular.\nThere is a cyclic dependency involving property " + oWLObjectPropertyExpression);
        }
    }

    protected Map<OWLObjectPropertyExpression, Automaton> buildIndividualAutomata(Graph<OWLObjectPropertyExpression> graph, Collection<OWLObjectPropertyExpression[]> collection, Collection<OWLAxioms.ComplexObjectPropertyInclusion> collection2, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map, Set<OWLObjectPropertyExpression> set) {
        Automaton automaton;
        OWLObjectPropertyExpression oWLObjectPropertyExpression;
        OWLObjectPropertyExpression oWLObjectPropertyExpression2;
        HashMap<OWLObjectPropertyExpression, Automaton> hashMap = new HashMap<OWLObjectPropertyExpression, Automaton>();
        for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : collection2) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression3;
            int n;
            State state;
            oWLObjectPropertyExpression2 = complexObjectPropertyInclusion.m_subObjectProperties;
            oWLObjectPropertyExpression = complexObjectPropertyInclusion.m_superObjectProperty;
            automaton = null;
            State state2 = null;
            State state3 = null;
            if (!hashMap.containsKey(oWLObjectPropertyExpression)) {
                automaton = new Automaton();
                state2 = automaton.addState(true, false);
                state3 = automaton.addState(false, true);
                try {
                    automaton.addTransition(new Transition(state2, oWLObjectPropertyExpression, state3));
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            } else {
                automaton = (Automaton)hashMap.get(oWLObjectPropertyExpression);
                state2 = (State)automaton.initials().iterator().next();
                state3 = (State)automaton.terminals().iterator().next();
            }
            if (((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length == 2 && oWLObjectPropertyExpression2[0].equals(oWLObjectPropertyExpression) && oWLObjectPropertyExpression2[1].equals(oWLObjectPropertyExpression)) {
                try {
                    automaton.addTransition(new Transition(state3, null, state2));
                    set.add(oWLObjectPropertyExpression);
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            if (oWLObjectPropertyExpression2[0].equals(oWLObjectPropertyExpression)) {
                state = state3;
                for (n = 1; n < ((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 1; ++n) {
                    oWLObjectPropertyExpression3 = oWLObjectPropertyExpression2[n];
                    if (map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression3)) {
                        oWLObjectPropertyExpression3 = oWLObjectPropertyExpression;
                    }
                    try {
                        state = this.addNewTransition(automaton, state, oWLObjectPropertyExpression3);
                        continue;
                    }
                    catch (NoSuchStateException noSuchStateException) {
                        throw new IllegalArgumentException("Could not create automaton");
                    }
                }
                try {
                    oWLObjectPropertyExpression3 = oWLObjectPropertyExpression2[((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 1];
                    if (map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression3)) {
                        oWLObjectPropertyExpression3 = oWLObjectPropertyExpression;
                    }
                    automaton.addTransition(new Transition(state, oWLObjectPropertyExpression3, state3));
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            if (oWLObjectPropertyExpression2[((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 1].equals(oWLObjectPropertyExpression)) {
                state = state2;
                for (n = 0; n < ((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 2; ++n) {
                    oWLObjectPropertyExpression3 = oWLObjectPropertyExpression2[n];
                    if (map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression3)) {
                        oWLObjectPropertyExpression3 = oWLObjectPropertyExpression;
                    }
                    try {
                        state = this.addNewTransition(automaton, state, oWLObjectPropertyExpression3);
                        continue;
                    }
                    catch (NoSuchStateException noSuchStateException) {
                        throw new IllegalArgumentException("Could not create automaton");
                    }
                }
                try {
                    oWLObjectPropertyExpression3 = oWLObjectPropertyExpression2[((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 2];
                    if (map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression3)) {
                        oWLObjectPropertyExpression3 = oWLObjectPropertyExpression;
                    }
                    automaton.addTransition(new Transition(state, oWLObjectPropertyExpression3, state2));
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            state = state2;
            for (n = 0; n < ((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 1; ++n) {
                oWLObjectPropertyExpression3 = oWLObjectPropertyExpression2[n];
                if (map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression3)) {
                    oWLObjectPropertyExpression3 = oWLObjectPropertyExpression;
                }
                try {
                    state = this.addNewTransition(automaton, state, oWLObjectPropertyExpression3);
                    continue;
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            try {
                oWLObjectPropertyExpression3 = oWLObjectPropertyExpression2[((OWLObjectPropertyExpression)oWLObjectPropertyExpression2).length - 1];
                if (map.containsKey(oWLObjectPropertyExpression) && map.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression3)) {
                    oWLObjectPropertyExpression3 = oWLObjectPropertyExpression;
                }
                automaton.addTransition(new Transition(state, oWLObjectPropertyExpression3, state3));
            }
            catch (NoSuchStateException noSuchStateException) {
                throw new IllegalArgumentException("Could not create automaton");
            }
            hashMap.put(oWLObjectPropertyExpression, automaton);
        }
        for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : collection2) {
            oWLObjectPropertyExpression2 = complexObjectPropertyInclusion.m_superObjectProperty;
            oWLObjectPropertyExpression = complexObjectPropertyInclusion.m_subObjectProperties;
            if (((OWLObjectPropertyExpression[])oWLObjectPropertyExpression).length != 2 || !oWLObjectPropertyExpression[0].equals(oWLObjectPropertyExpression2) || !oWLObjectPropertyExpression[1].equals(oWLObjectPropertyExpression2) || graph.getElements().contains(oWLObjectPropertyExpression2) || hashMap.containsKey(oWLObjectPropertyExpression2.getInverseProperty().getSimplified())) continue;
            graph.addEdge(oWLObjectPropertyExpression2, oWLObjectPropertyExpression2);
            automaton = (Automaton)hashMap.get(oWLObjectPropertyExpression2);
            hashMap.put(oWLObjectPropertyExpression2.getInverseProperty().getSimplified(), this.getMirroredCopy(automaton));
        }
        return hashMap;
    }

    protected Map<State, State> getDisjointUnion(Automaton automaton, Automaton automaton2) {
        HashMap<State, State> hashMap = new HashMap<State, State>();
        for (Object e : automaton2.states()) {
            hashMap.put((State)e, automaton.addState(false, false));
        }
        for (Object e : automaton2.delta()) {
            Transition transition = (Transition)e;
            try {
                automaton.addTransition(new Transition((State)hashMap.get(transition.start()), transition.label(), (State)hashMap.get(transition.end())));
            }
            catch (NoSuchStateException noSuchStateException) {
                throw new IllegalArgumentException("Could not create disjoint union of automata");
            }
        }
        return hashMap;
    }

    protected Automaton getMirroredCopy(Automaton automaton) {
        Object object;
        Automaton automaton2 = new Automaton();
        HashMap<State, State> hashMap = new HashMap<State, State>();
        for (Object e : automaton.states()) {
            object = (State)e;
            hashMap.put((State)object, automaton2.addState(object.isTerminal(), object.isInitial()));
        }
        for (Object e : automaton.delta()) {
            object = (Transition)e;
            try {
                if (((Transition)object).label() instanceof OWLObjectPropertyExpression) {
                    automaton2.addTransition(new Transition((State)hashMap.get(((Transition)object).end()), ((OWLObjectPropertyExpression)((Transition)object).label()).getInverseProperty().getSimplified(), (State)hashMap.get(((Transition)object).start())));
                    continue;
                }
                automaton2.addTransition(new Transition((State)hashMap.get(((Transition)object).end()), ((Transition)object).label(), (State)hashMap.get(((Transition)object).start())));
            }
            catch (NoSuchStateException noSuchStateException) {}
        }
        return automaton2;
    }

    protected State addNewTransition(Automaton automaton, State state, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws NoSuchStateException {
        OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLObjectPropertyExpression;
        State state2 = automaton.addState(false, false);
        automaton.addTransition(new Transition(state, oWLObjectPropertyExpression2, state2));
        return state2;
    }
}

