/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.coode.owlapi.rdf.model.RDFLiteralNode;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTranslator;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.AxiomSubjectProvider;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RDFRendererBase {
    protected OWLOntologyManager manager;
    protected OWLOntology ontology;
    private RDFGraph graph;
    protected Set<IRI> prettyPrintedTypes;
    private OWLOntologyFormat format;

    public RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager) {
        this(ontology, manager, manager.getOntologyFormat(ontology));
    }

    protected RDFRendererBase(OWLOntology ontology, OWLOntologyManager manager, OWLOntologyFormat format) {
        this.ontology = ontology;
        this.manager = manager;
        this.format = format;
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    protected abstract void beginDocument() throws IOException;

    public void render() throws IOException {
        Set<OWLNamedIndividual> individuals;
        Set<OWLClass> clses;
        Set<OWLDataProperty> dataProperties;
        boolean first;
        Set<OWLObjectProperty> objectProperties;
        Set<OWLDatatype> datatypes;
        this.beginDocument();
        this.renderOntologyHeader();
        ArrayList<OWLAnnotationProperty> annotationProperties = new ArrayList<OWLAnnotationProperty>(this.ontology.getAnnotationPropertiesInSignature());
        if (!annotationProperties.isEmpty()) {
            this.writeBanner("Annotation properties");
            for (OWLAnnotationProperty prop : annotationProperties) {
                if (!this.createGraph(prop)) continue;
                this.beginObject();
                this.render(new RDFResourceNode(prop.getIRI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(datatypes = this.ontology.getDatatypesInSignature()).isEmpty()) {
            this.writeBanner("Datatypes");
            for (OWLDatatype datatype : RDFRendererBase.toSortedSet(datatypes)) {
                if (!this.createGraph(datatype)) continue;
                this.beginObject();
                this.writeDatatypeComment(datatype);
                this.render(new RDFResourceNode(datatype.getIRI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(objectProperties = this.ontology.getObjectPropertiesInSignature()).isEmpty()) {
            first = true;
            for (OWLObjectProperty prop : RDFRendererBase.toSortedSet(objectProperties)) {
                if (!this.createGraph(prop)) continue;
                if (first) {
                    this.writeBanner("Object Properties");
                    first = false;
                }
                this.beginObject();
                this.writeObjectPropertyComment(prop);
                this.render(new RDFResourceNode(prop.getIRI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(dataProperties = this.ontology.getDataPropertiesInSignature()).isEmpty()) {
            first = true;
            for (OWLDataProperty prop : RDFRendererBase.toSortedSet(this.ontology.getDataPropertiesInSignature())) {
                if (!this.createGraph(prop)) continue;
                if (first) {
                    first = false;
                    this.writeBanner("Data properties");
                }
                this.beginObject();
                this.writeDataPropertyComment(prop);
                this.render(new RDFResourceNode(prop.getIRI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(clses = this.ontology.getClassesInSignature()).isEmpty()) {
            first = true;
            for (OWLClass cls : RDFRendererBase.toSortedSet(clses)) {
                if (!this.createGraph(cls)) continue;
                if (first) {
                    first = false;
                    this.writeBanner("Classes");
                }
                this.beginObject();
                this.writeClassComment(cls);
                this.render(new RDFResourceNode(cls.getIRI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        if (!(individuals = this.ontology.getIndividualsInSignature()).isEmpty()) {
            first = true;
            for (OWLNamedIndividual ind : RDFRendererBase.toSortedSet(this.ontology.getIndividualsInSignature())) {
                if (!this.createGraph(ind)) continue;
                if (first) {
                    this.writeBanner("Individuals");
                    first = false;
                }
                this.beginObject();
                this.writeIndividualComments(ind);
                this.render(new RDFResourceNode(ind.getIRI()));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        for (OWLAnonymousIndividual anonInd : this.ontology.getReferencedAnonymousIndividuals()) {
            boolean anonRoot = true;
            HashSet<OWLAxiom> hashSet = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : this.ontology.getReferencingAxioms(anonInd)) {
                if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                AxiomSubjectProvider subjectProvider = new AxiomSubjectProvider();
                OWLObject obj = subjectProvider.getSubject(ax);
                if (!obj.equals(anonInd)) {
                    anonRoot = false;
                    break;
                }
                hashSet.add(ax);
            }
            if (!anonRoot) continue;
            this.createGraph(hashSet);
            this.renderAnonRoots();
        }
        HashSet<IRI> annotatedIRIs = new HashSet<IRI>();
        for (OWLAnnotationAssertionAxiom ax : this.ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            IRI iri;
            OWLAnnotationSubject oWLAnnotationSubject = ax.getSubject();
            if (!(oWLAnnotationSubject instanceof IRI) || this.ontology.containsEntityInSignature(iri = (IRI)oWLAnnotationSubject)) continue;
            annotatedIRIs.add(iri);
        }
        if (!annotatedIRIs.isEmpty()) {
            this.writeBanner("Annotations");
            for (IRI iri : annotatedIRIs) {
                this.beginObject();
                this.createGraph(this.ontology.getAnnotationAssertionAxioms(iri));
                this.render(new RDFResourceNode(iri));
                this.renderAnonRoots();
                this.endObject();
            }
        }
        HashSet<OWLLogicalAxiom> generalAxioms = new HashSet<OWLLogicalAxiom>();
        generalAxioms.addAll(this.ontology.getGeneralClassAxioms());
        generalAxioms.addAll(this.ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS));
        for (OWLDisjointClassesAxiom oWLDisjointClassesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
            if (oWLDisjointClassesAxiom.getClassExpressions().size() <= 2) continue;
            generalAxioms.add(oWLDisjointClassesAxiom);
        }
        for (OWLDisjointObjectPropertiesAxiom oWLDisjointObjectPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            if (oWLDisjointObjectPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointObjectPropertiesAxiom);
        }
        for (OWLDisjointDataPropertiesAxiom oWLDisjointDataPropertiesAxiom : this.ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            if (oWLDisjointDataPropertiesAxiom.getProperties().size() <= 2) continue;
            generalAxioms.add(oWLDisjointDataPropertiesAxiom);
        }
        for (OWLHasKeyAxiom oWLHasKeyAxiom : this.ontology.getAxioms(AxiomType.HAS_KEY)) {
            if (!oWLHasKeyAxiom.getClassExpression().isAnonymous()) continue;
            generalAxioms.add(oWLHasKeyAxiom);
        }
        this.createGraph(generalAxioms);
        Set<RDFResourceNode> rootNodes = this.graph.getRootAnonymousNodes();
        if (!rootNodes.isEmpty()) {
            this.writeBanner("General axioms");
            this.beginObject();
            this.renderAnonRoots();
            this.endObject();
        }
        Set<SWRLRule> set = this.ontology.getAxioms(AxiomType.SWRL_RULE);
        this.createGraph(set);
        if (!set.isEmpty()) {
            this.writeBanner("Rules");
            SWRLVariableExtractor variableExtractor = new SWRLVariableExtractor();
            for (SWRLRule rule : set) {
                rule.accept(variableExtractor);
            }
            for (SWRLVariable var : variableExtractor.getVariables()) {
                this.render(new RDFResourceNode(var.getIRI()));
            }
            this.renderAnonRoots();
        }
        this.endDocument();
    }

    private void renderOntologyHeader() throws IOException {
        this.graph = new RDFGraph();
        OWLOntologyID ontID = this.ontology.getOntologyID();
        RDFResourceNode ontologyNode = null;
        int count = 0;
        if (ontID.getOntologyIRI() != null) {
            ontologyNode = new RDFResourceNode(ontID.getOntologyIRI());
            ++count;
            if (ontID.getVersionIRI() != null) {
                this.graph.addTriple(new RDFTriple(ontologyNode, new RDFResourceNode(OWLRDFVocabulary.OWL_VERSION_IRI.getIRI()), new RDFResourceNode(ontID.getVersionIRI())));
                ++count;
            }
        } else {
            ontologyNode = new RDFResourceNode(System.identityHashCode(this.ontology));
        }
        this.graph.addTriple(new RDFTriple(ontologyNode, new RDFResourceNode(OWLRDFVocabulary.RDF_TYPE.getIRI()), new RDFResourceNode(OWLRDFVocabulary.OWL_ONTOLOGY.getIRI())));
        for (OWLImportsDeclaration decl : this.ontology.getImportsDeclarations()) {
            this.graph.addTriple(new RDFTriple(ontologyNode, new RDFResourceNode(OWLRDFVocabulary.OWL_IMPORTS.getIRI()), new RDFResourceNode(decl.getIRI())));
            ++count;
        }
        for (OWLAnnotation anno : this.ontology.getAnnotations()) {
            OWLAnnotationValueVisitorEx<RDFNode> valVisitor = new OWLAnnotationValueVisitorEx<RDFNode>(){

                @Override
                public RDFNode visit(IRI iri) {
                    return new RDFResourceNode(iri);
                }

                @Override
                public RDFNode visit(OWLAnonymousIndividual individual) {
                    return new RDFResourceNode(System.identityHashCode(individual));
                }

                @Override
                public RDFNode visit(OWLLiteral literal) {
                    return RDFTranslator.translateLiteralNode(literal);
                }
            };
            RDFNode node = anno.getValue().accept(valVisitor);
            this.graph.addTriple(new RDFTriple(ontologyNode, new RDFResourceNode(anno.getProperty().getIRI()), node));
            ++count;
        }
        if (count > 0) {
            this.render(ontologyNode);
        }
    }

    protected abstract void endDocument() throws IOException;

    protected abstract void writeIndividualComments(OWLNamedIndividual var1) throws IOException;

    protected abstract void writeClassComment(OWLClass var1) throws IOException;

    protected abstract void writeDataPropertyComment(OWLDataProperty var1) throws IOException;

    protected abstract void writeObjectPropertyComment(OWLObjectProperty var1) throws IOException;

    protected abstract void writeDatatypeComment(OWLDatatype var1) throws IOException;

    protected abstract void writeAnnotationPropertyComment(OWLAnnotationProperty var1) throws IOException;

    protected void beginObject() throws IOException {
    }

    protected void endObject() throws IOException {
    }

    private boolean createGraph(OWLEntity entity) {
        final HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(entity.getAnnotationAssertionAxioms(this.ontology));
        axioms.addAll(this.ontology.getDeclarationAxioms(entity));
        entity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass cls) {
                for (OWLClassAxiom oWLClassAxiom : RDFRendererBase.this.ontology.getAxioms(cls)) {
                    OWLDisjointClassesAxiom disjAx;
                    if (oWLClassAxiom instanceof OWLDisjointClassesAxiom && (disjAx = (OWLDisjointClassesAxiom)oWLClassAxiom).getClassExpressions().size() > 2) continue;
                    axioms.add(oWLClassAxiom);
                }
                for (OWLHasKeyAxiom oWLHasKeyAxiom : RDFRendererBase.this.ontology.getAxioms(AxiomType.HAS_KEY)) {
                    if (!oWLHasKeyAxiom.getClassExpression().equals(cls)) continue;
                    axioms.add(oWLHasKeyAxiom);
                }
            }

            public void visit(OWLDatatype datatype) {
                axioms.addAll(RDFRendererBase.this.ontology.getDatatypeDefinitions(datatype));
                RDFRendererBase.this.createGraph(axioms);
            }

            public void visit(OWLNamedIndividual individual) {
                for (OWLIndividualAxiom ax : RDFRendererBase.this.ontology.getAxioms(individual)) {
                    if (ax instanceof OWLDifferentIndividualsAxiom) continue;
                    axioms.add(ax);
                }
            }

            public void visit(OWLDataProperty property) {
                for (OWLDataPropertyAxiom ax : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (ax instanceof OWLDisjointDataPropertiesAxiom && ((OWLDisjointDataPropertiesAxiom)ax).getProperties().size() > 2) continue;
                    axioms.add(ax);
                }
            }

            public void visit(OWLObjectProperty property) {
                for (OWLObjectPropertyAxiom oWLObjectPropertyAxiom : RDFRendererBase.this.ontology.getAxioms(property)) {
                    if (oWLObjectPropertyAxiom instanceof OWLDisjointObjectPropertiesAxiom && ((OWLDisjointObjectPropertiesAxiom)oWLObjectPropertyAxiom).getProperties().size() > 2) continue;
                    axioms.add(oWLObjectPropertyAxiom);
                }
                for (OWLSubPropertyChainOfAxiom oWLSubPropertyChainOfAxiom : RDFRendererBase.this.ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
                    if (!oWLSubPropertyChainOfAxiom.getSuperProperty().equals(property)) continue;
                    axioms.add(oWLSubPropertyChainOfAxiom);
                }
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms(RDFRendererBase.this.manager.getOWLDataFactory().getOWLObjectInverseOf(property)));
            }

            public void visit(OWLAnnotationProperty property) {
                axioms.addAll(RDFRendererBase.this.ontology.getAxioms(property));
            }
        });
        if (axioms.isEmpty() && this.shouldInsertDeclarations() && RDFOntologyFormat.isMissingType(entity, this.ontology)) {
            axioms.add(this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(entity));
        }
        this.createGraph(axioms);
        return !axioms.isEmpty();
    }

    protected boolean shouldInsertDeclarations() {
        return !(this.format instanceof RDFOntologyFormat) || ((RDFOntologyFormat)this.format).isAddMissingTypes();
    }

    protected void createGraph(Set<? extends OWLObject> objects) {
        RDFTranslator translator = new RDFTranslator(this.manager, this.ontology, this.shouldInsertDeclarations());
        for (OWLObject oWLObject : objects) {
            oWLObject.accept(translator);
        }
        this.graph = translator.getGraph();
    }

    protected abstract void writeBanner(String var1) throws IOException;

    private static <N extends OWLEntity> Set<N> toSortedSet(Set<N> entities) {
        TreeSet<OWLEntity> results = new TreeSet<OWLEntity>(new OWLEntityIRIComparator());
        results.addAll(entities);
        return results;
    }

    public void renderAnonRoots() throws IOException {
        for (RDFResourceNode node : this.graph.getRootAnonymousNodes()) {
            this.render(node);
        }
    }

    public abstract void render(RDFResourceNode var1) throws IOException;

    protected boolean isObjectList(RDFResourceNode node) {
        for (RDFTriple triple : this.graph.getTriplesForSubject(node)) {
            if (!triple.getProperty().getIRI().equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous() || !triple.getObject().getIRI().equals(OWLRDFVocabulary.RDF_LIST.getIRI())) continue;
            ArrayList<RDFNode> items = new ArrayList<RDFNode>();
            this.toJavaList(node, items);
            for (RDFNode n : items) {
                if (!n.isLiteral()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void toJavaList(RDFNode n, List<RDFNode> list) {
        RDFNode currentNode = n;
        while (currentNode != null) {
            for (RDFTriple triple : this.graph.getTriplesForSubject(currentNode)) {
                if (!triple.getProperty().getIRI().equals(OWLRDFVocabulary.RDF_FIRST.getIRI())) continue;
                list.add(triple.getObject());
            }
            for (RDFTriple triple : this.graph.getTriplesForSubject(currentNode)) {
                if (!triple.getProperty().getIRI().equals(OWLRDFVocabulary.RDF_REST.getIRI())) continue;
                if (!triple.getObject().isAnonymous()) {
                    if (!triple.getObject().getIRI().equals(OWLRDFVocabulary.RDF_NIL.getIRI())) continue;
                    currentNode = null;
                    continue;
                }
                currentNode = triple.getObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TripleComparator
    implements Comparator<RDFTriple> {
        private List<IRI> orderedURIs = new ArrayList<IRI>();

        public TripleComparator() {
            this.orderedURIs.add(OWLRDFVocabulary.RDF_TYPE.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.RDFS_LABEL.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_DATA_RANGE.getIRI());
            this.orderedURIs.add(OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        }

        private int getIndex(IRI iri) {
            int index = this.orderedURIs.indexOf(iri);
            if (index == -1) {
                index = this.orderedURIs.size();
            }
            return index;
        }

        @Override
        public int compare(RDFTriple o1, RDFTriple o2) {
            int diff = this.getIndex(o1.getProperty().getIRI()) - this.getIndex(o2.getProperty().getIRI());
            if (diff == 0) {
                diff = !o1.getSubject().isAnonymous() ? (!o2.getSubject().isAnonymous() ? o1.getSubject().getIRI().compareTo(o2.getSubject().getIRI()) : -1) : (!o2.getSubject().isAnonymous() ? 1 : 0);
                if (diff == 0 && (diff = o2.getProperty().getIRI().compareTo(o2.getProperty().getIRI())) == 0) {
                    if (!o1.getObject().isLiteral()) {
                        diff = !o2.getObject().isLiteral() ? (!o1.getObject().isAnonymous() ? (!o2.getObject().isAnonymous() ? o1.getObject().getIRI().compareTo(o2.getObject().getIRI()) : -1) : (!o2.getObject().isAnonymous() ? 1 : -1)) : 1;
                    } else if (!o2.getObject().isLiteral()) {
                        diff = -1;
                    } else {
                        RDFLiteralNode lit1 = (RDFLiteralNode)o1.getObject();
                        RDFLiteralNode lit2 = (RDFLiteralNode)o2.getObject();
                        if (lit1.isTyped()) {
                            if (lit2.isTyped()) {
                                diff = lit1.getLiteral().compareTo(lit2.getLiteral());
                                if (diff == 0) {
                                    diff = lit1.getDatatype().compareTo(lit2.getDatatype());
                                }
                            } else {
                                diff = -1;
                            }
                        } else if (lit2.isTyped()) {
                            diff = 1;
                        } else {
                            if (lit1.getLang() != null) {
                                if (lit2.getLang() != null) {
                                    diff = lit1.getLang().compareTo(lit2.getLang());
                                }
                            } else {
                                diff = -1;
                            }
                            if (diff == 0) {
                                diff = lit1.getLiteral().compareTo(lit2.getLiteral());
                            }
                        }
                    }
                }
            }
            if (diff == 0) {
                diff = 1;
            }
            return diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OWLEntityIRIComparator
    implements Comparator<OWLEntity> {
        private OWLEntityIRIComparator() {
        }

        @Override
        public int compare(OWLEntity o1, OWLEntity o2) {
            return o1.getIRI().compareTo(o2.getIRI());
        }
    }
}

