/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.protege.editor.core.ProtegeApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManager {
    private Logger logger = Logger.getLogger(BundleManager.class);
    public static final String BUNDLE_WITHOUT_PLUGIN_XML = "No-Plugin-XML";
    public static final String BUNDLE_DIR_PROP = "org.protege.plugin.dir";
    public static final String BUNDLE_EXTRA_PROP = "org.protege.plugin.extra";
    public static final char BUNDLE_EXTRA_SEPARATOR = ':';
    public static final String OSGI_READS_DIRECTORIES = "org.protege.allow.directory.bundles";
    private BundleContext context;
    private List<Bundle> plugins = new ArrayList<Bundle>();

    public BundleManager(BundleContext context) {
        this.context = context;
    }

    public void loadPlugins() {
        this.installPlugins();
        this.startPlugins();
    }

    public void uninstallPlugins() {
        for (Bundle bundle : this.plugins) {
            try {
                bundle.uninstall();
            }
            catch (Throwable t) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)"Exception caught uninstalling the bundle", t);
            }
        }
    }

    private Map<String, Bundle> makeBundleMap() {
        HashMap<String, Bundle> bundleMap = new HashMap<String, Bundle>();
        for (Bundle b : this.context.getBundles()) {
            String location = b.getLocation();
            if (location == null) continue;
            bundleMap.put(location, b);
        }
        return bundleMap;
    }

    private void installPlugins() {
        Map<String, Bundle> bundleMap = this.makeBundleMap();
        ArrayList<File> locations = new ArrayList<File>();
        locations.addAll(this.getPluginBundles());
        locations.addAll(this.getExtraBundles());
        locations.addAll(this.getNewExtraBundles());
        if (locations.isEmpty()) {
            this.logger.warn((Object)"No plugins found");
        }
        for (File plugin : locations) {
            Bundle b = null;
            try {
                String location = "file:" + plugin.getPath();
                Bundle alreadyInstalled = bundleMap.get(location);
                if (alreadyInstalled == null) {
                    b = this.context.installBundle(location);
                    this.logger.info((Object)("Installed plugin " + BundleManager.getNiceBundleName(b)));
                } else {
                    b = alreadyInstalled;
                    this.logger.info((Object)("Loading plugin " + BundleManager.getNiceBundleName(b)));
                }
                this.plugins.add(b);
            }
            catch (Throwable t) {
                if (this.isTrivialBundleLoadException(plugin, t)) {
                    this.logger.error((Object)("Could not install plugin in file/directory named " + plugin + ".  See the logs for more info."));
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"Exception caught", t);
                    continue;
                }
                this.logger.error((Object)("Could not install plugin in file/directory named " + plugin), t);
            }
        }
    }

    private void startPlugins() {
        for (Bundle b : this.plugins) {
            if (b.getState() == 32) continue;
            try {
                b.start();
                this.pluginSanityCheck(b);
            }
            catch (BundleException be) {
                ProtegeApplication.getErrorLog().logError(be);
                this.logger.warn((Object)("Problem starting plugin " + BundleManager.getNiceBundleName(b)));
            }
        }
    }

    private List<File> getPluginBundles() {
        ArrayList<File> pluginBundles = new ArrayList<File>();
        String dir_name = System.getProperty(BUNDLE_DIR_PROP);
        if (dir_name != null) {
            File dir = new File(dir_name);
            if (dir.exists() && dir.isDirectory()) {
                for (File f : dir.listFiles()) {
                    pluginBundles.add(f);
                }
            } else {
                this.logger.error((Object)("Plugin directory " + dir_name + " is invalid"));
            }
        }
        return pluginBundles;
    }

    private List<File> getExtraBundles() {
        int index;
        ArrayList<File> extra_bundles = new ArrayList<File>();
        for (String remaining = System.getProperty(BUNDLE_EXTRA_PROP); remaining != null && remaining.length() != 0; remaining = remaining.substring(index + 1)) {
            index = remaining.indexOf(File.pathSeparator);
            if (index < 0) {
                extra_bundles.add(new File(remaining));
                return extra_bundles;
            }
            extra_bundles.add(new File(remaining.substring(0, index)));
        }
        return extra_bundles;
    }

    private List<File> getNewExtraBundles() {
        String location;
        ArrayList<File> pluginLocations = new ArrayList<File>();
        int i = 0;
        while ((location = System.getProperty("org.protege.plugin.extra." + i)) != null) {
            pluginLocations.add(new File(location));
            ++i;
        }
        return pluginLocations;
    }

    private boolean isTrivialBundleLoadException(File plugin, Throwable t) {
        return plugin.getName().equals(".DS_Store");
    }

    private void pluginSanityCheck(Bundle b) {
        boolean hasPluginXml;
        boolean bl = hasPluginXml = b.getResource("/plugin.xml") != null;
        if (b.getHeaders().get(BUNDLE_WITHOUT_PLUGIN_XML) == null && !hasPluginXml) {
            this.logger.info((Object)("\t" + BundleManager.getNiceBundleName(b) + " Plugin has no plugin.xml resource"));
        }
        if (hasPluginXml && !BundleManager.isSingleton(b)) {
            this.logger.warn((Object)("\t" + BundleManager.getNiceBundleName(b) + " plugin is not a singleton so its plugin.xml will not be seen by the registry."));
        }
    }

    public static boolean isSingleton(Bundle b) {
        StringBuffer singleton = new StringBuffer("singleton");
        singleton.append(":=true");
        return ((String)b.getHeaders().get("Bundle-SymbolicName")).contains(singleton.toString());
    }

    public static String getNiceBundleName(Bundle b) {
        String name = (String)b.getHeaders().get("Bundle-Name");
        if (name == null) {
            name = b.getSymbolicName();
        }
        return name;
    }

    public List<Bundle> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }
}

