/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.protege.editor.core.OntologyBuilder;
import org.protege.editor.core.OntologyBuilderPlugin;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;
import org.protege.editor.core.OntologyRepositoryFactory;
import org.protege.editor.core.OntologyRepositoryFactoryPlugin;
import org.protege.editor.core.OntologyRepositoryFactoryPluginLoader;
import org.protege.editor.core.OntologyRepositoryManager;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;
import org.protege.editor.core.editorkit.EditorKitFactoryPluginLoader;
import org.protege.editor.core.editorkit.EditorKitManager;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtegeManager {
    public static final Logger logger = Logger.getLogger(ProtegeManager.class);
    private static ProtegeManager instance;
    private EditorKitManager editorKitManager;
    private Map<EditorKitFactoryPlugin, EditorKitFactory> editorKitFactoriesMap = new HashMap<EditorKitFactoryPlugin, EditorKitFactory>();
    private ProtegeApplication application;

    private ProtegeManager() {
        EditorKitFactoryPluginLoader loader = new EditorKitFactoryPluginLoader();
        for (EditorKitFactoryPlugin plugin : loader.getPlugins()) {
            this.editorKitFactoriesMap.put(plugin, null);
        }
        this.setupRepositories();
    }

    public static synchronized ProtegeManager getInstance() {
        if (instance == null) {
            instance = new ProtegeManager();
        }
        return instance;
    }

    public void dispose() {
        for (OntologyRepository repository : OntologyRepositoryManager.getManager().getOntologyRepositories()) {
            try {
                repository.dispose();
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
        instance = null;
    }

    protected void initialise(ProtegeApplication application) {
        this.application = application;
    }

    public ProtegeApplication getApplication() {
        return this.application;
    }

    public EditorKitManager getEditorKitManager() {
        if (this.editorKitManager == null) {
            this.editorKitManager = new EditorKitManager();
        }
        return this.editorKitManager;
    }

    public WorkspaceFrame getFrame(Workspace workspace) {
        return this.getEditorKitManager().getWorkspaceManager().getFrame(workspace);
    }

    public List<EditorKitFactoryPlugin> getEditorKitFactoryPlugins() {
        return new ArrayList<EditorKitFactoryPlugin>(this.editorKitFactoriesMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAndSetupNewEditorKit(EditorKitFactoryPlugin plugin) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleNewRequest()) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openAndSetupEditorKit(EditorKitFactoryPlugin plugin) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleLoadRequest()) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAndSetupEditorKitFromURI(EditorKitFactoryPlugin plugin, URI uri) throws Exception {
        EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
        if (editorKitFactory != null) {
            boolean success = false;
            EditorKit editorKit = editorKitFactory.createEditorKit();
            try {
                if (editorKit.handleLoadFrom(uri)) {
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!success) {
                    editorKit.dispose();
                }
            }
        }
        return false;
    }

    public boolean openAndSetupRecentEditorKit(EditorKitDescriptor editorKitDescriptor) throws Exception {
        for (EditorKitFactoryPlugin plugin : this.getEditorKitFactoryPlugins()) {
            EditorKitFactory editorKitFactory;
            EditorKit editorKit;
            if (!plugin.getId().equals(editorKitDescriptor.getEditorKitFactoryID()) || !(editorKit = (editorKitFactory = this.getEditorKitFactory(plugin)).createEditorKit()).handleLoadRecentRequest(editorKitDescriptor)) continue;
            this.getEditorKitManager().addEditorKit(editorKit);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAndSetupEditorKitFromRepository(OntologyRepository repository, OntologyRepositoryEntry entry) throws Exception {
        for (EditorKitFactoryPlugin plugin : this.getEditorKitFactoryPlugins()) {
            String id = plugin.getId();
            if (!id.equals(entry.getEditorKitId())) continue;
            boolean success = false;
            EditorKitFactory editorKitFactory = this.getEditorKitFactory(plugin);
            if (editorKitFactory != null) {
                EditorKit editorKit = editorKitFactory.createEditorKit();
                try {
                    entry.configureEditorKit(editorKit);
                    if (editorKit.handleLoadFrom(entry.getPhysicalURI())) {
                        this.getEditorKitManager().addEditorKit(editorKit);
                        success = true;
                    }
                }
                finally {
                    entry.restoreEditorKit(editorKit);
                    if (!success) {
                        editorKit.dispose();
                    }
                }
            }
            return success;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleOpenFromBuilder(OntologyBuilderPlugin builder) {
        try {
            Iterator<EditorKitFactoryPlugin> i$ = this.getEditorKitFactoryPlugins().iterator();
            while (i$.hasNext()) {
                EditorKitFactory editorKitFactory;
                EditorKitFactoryPlugin plugin = i$.next();
                String id = plugin.getId();
                if (!id.equals(builder.getEditorKitId()) || (editorKitFactory = this.getEditorKitFactory(plugin)) == null) continue;
                EditorKit editorKit = editorKitFactory.createEditorKit();
                boolean success = false;
                try {
                    if (!((OntologyBuilder)builder.newInstance()).loadOntology(editorKit)) continue;
                    this.getEditorKitManager().addEditorKit(editorKit);
                    success = true;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (success) continue;
                    editorKit.dispose();
                }
            }
            return false;
        }
        catch (Throwable t) {
            ProtegeApplication.getErrorLog().logError(t);
        }
        return false;
    }

    public void saveEditorKit(EditorKit editorKit) throws Exception {
        editorKit.handleSave();
    }

    public void saveEditorKitAs(EditorKit editorKit) throws Exception {
        editorKit.handleSaveAs();
        this.getFrame(editorKit.getWorkspace()).updateTitle();
    }

    public void disposeOfEditorKit(EditorKit editorKit) {
        ProtegeManager.getInstance().getEditorKitManager().removeEditorKit(editorKit);
        try {
            editorKit.getWorkspace().dispose();
            editorKit.getModelManager().dispose();
            editorKit.dispose();
        }
        catch (Exception e) {
            ProtegeApplication.getErrorLog().logError(e);
        }
        System.gc();
        this.application.handleClose();
    }

    public EditorKitFactory getEditorKitFactory(EditorKitFactoryPlugin plugin) {
        EditorKitFactory editorKitFactory = this.editorKitFactoriesMap.get(plugin);
        if (editorKitFactory != null) {
            return editorKitFactory;
        }
        EditorKitFactory editorKitFactory1 = plugin.newInstance();
        this.editorKitFactoriesMap.put(plugin, editorKitFactory1);
        return editorKitFactory1;
    }

    private void setupRepositories() {
        OntologyRepositoryFactoryPluginLoader loader = new OntologyRepositoryFactoryPluginLoader();
        for (OntologyRepositoryFactoryPlugin plugin : loader.getPlugins()) {
            try {
                OntologyRepositoryFactory factory = (OntologyRepositoryFactory)plugin.newInstance();
                OntologyRepositoryManager.getManager().addRepository(factory.createRepository());
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }
}

