/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.protege.editor.core.OntologyBuilderPlugin;
import org.protege.editor.core.OntologyBuilderPluginLoader;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;
import org.protege.editor.core.OntologyRepositoryManager;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactoryPlugin;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.ui.OpenFromRepositoryPanel;
import org.protege.editor.core.ui.OpenFromURLPanel;
import org.protege.editor.core.ui.action.start.AltStartupAction;
import org.protege.editor.core.ui.action.start.AltStartupActionPlugin;
import org.protege.editor.core.ui.action.start.AltStartupActionPluginLoader;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.util.LinkLabel;

public class ProtegeWelcomeFrame
extends JFrame {
    private static final long serialVersionUID = 3174444631540765155L;
    private ProtegeWelcomePanel welcomePanel;

    public ProtegeWelcomeFrame() {
        this.setDefaultCloseOperation(2);
        this.setName("ProtegeWelcome");
        this.welcomePanel = new ProtegeWelcomePanel();
        this.setContentPane(this.welcomePanel);
        this.pack();
        this.centre();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.welcomePanel.refresh();
            this.pack();
            this.centre();
        }
        super.setVisible(b);
    }

    private void centre() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    private class ProtegeWelcomePanel
    extends JPanel {
        private static final long serialVersionUID = 6744371623503619618L;
        private Icon background;
        private Box box;
        private Box recentLinkBox;

        public ProtegeWelcomePanel() {
            this.setBackground(Color.WHITE);
            this.background = Icons.getIcon("logo.wizard.png");
            ProtegeManager manager = ProtegeManager.getInstance();
            int strutHeight = 10;
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(false);
            this.add(panel);
            JLabel label = new JLabel("Welcome to Prot\u00e9g\u00e9");
            label.setFont(this.getFont().deriveFont(1, 35.0f));
            label.setBorder(BorderFactory.createEmptyBorder(30, 0, 50, 0));
            label.setForeground(Color.LIGHT_GRAY);
            panel.add((Component)label, "North");
            this.box = new Box(1);
            this.box.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 0));
            panel.add((Component)this.box, "Center");
            panel.add((Component)this.createOtherActions(), "South");
            for (final EditorKitFactoryPlugin plugin : manager.getEditorKitFactoryPlugins()) {
                LinkLabel createLink = new LinkLabel("Create new " + plugin.getLabel(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (ProtegeManager.getInstance().createAndSetupNewEditorKit(plugin)) {
                                ProtegeWelcomeFrame.this.dispose();
                            }
                        }
                        catch (Throwable e1) {
                            ErrorLogPanel.showErrorDialog(e1);
                        }
                    }
                });
                createLink.setName("Create new " + plugin.getId());
                this.box.add(createLink);
                this.box.add(Box.createVerticalStrut(strutHeight));
                LinkLabel openLink = new LinkLabel("Open " + plugin.getLabel(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (ProtegeManager.getInstance().openAndSetupEditorKit(plugin)) {
                                ProtegeWelcomeFrame.this.dispose();
                            }
                        }
                        catch (Throwable e1) {
                            ErrorLogPanel.showErrorDialog(e1);
                        }
                    }
                });
                openLink.setName("Open " + plugin.getId());
                this.box.add(openLink);
                this.box.add(Box.createVerticalStrut(strutHeight));
                LinkLabel openFromURILink = new LinkLabel("Open " + plugin.getLabel() + " from URI", new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ProtegeWelcomePanel.this.handleOpenFromURI(plugin);
                    }
                });
                openFromURILink.setName("OpenfromURI " + plugin.getId());
                this.box.add(openFromURILink);
                this.box.add(Box.createVerticalStrut(strutHeight));
            }
            OntologyBuilderPluginLoader ontologyBuilderManager = new OntologyBuilderPluginLoader();
            for (final OntologyBuilderPlugin builder : ontologyBuilderManager.getPlugins()) {
                this.box.add(new LinkLabel(builder.getLabel(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (ProtegeManager.getInstance().handleOpenFromBuilder(builder)) {
                            ProtegeWelcomeFrame.this.dispose();
                        }
                    }
                }));
            }
            OntologyRepositoryManager repMan = OntologyRepositoryManager.getManager();
            for (final OntologyRepository repository : repMan.getOntologyRepositories()) {
                this.box.add(new LinkLabel("Open from the " + repository.getName() + " repository", new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ProtegeWelcomePanel.this.handleOpenFromRepository(repository);
                    }
                }));
            }
            this.box.add(Box.createVerticalStrut(2 * strutHeight));
            this.refresh();
        }

        private JComponent createOtherActions() {
            Color fontColor = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.propertycolor"), Color.GRAY);
            JPanel otherActionsPanel = new JPanel(new FlowLayout(0));
            otherActionsPanel.setBackground(Color.WHITE);
            JMenuBar littleMenuBar = new JMenuBar();
            littleMenuBar.setOpaque(false);
            JMenu dropDownMenu = new JMenu("More actions");
            dropDownMenu.setFont(this.getFont().deriveFont(1, 10.0f));
            dropDownMenu.setForeground(fontColor);
            dropDownMenu.setBackground(Color.WHITE);
            littleMenuBar.add(dropDownMenu);
            for (AltStartupActionPlugin plugin : new AltStartupActionPluginLoader(ProtegeWelcomeFrame.this).getPlugins()) {
                try {
                    AltStartupAction a = plugin.newInstance();
                    JMenuItem subMenu = new JMenuItem(a);
                    dropDownMenu.add(subMenu);
                }
                catch (Exception e) {
                    ProtegeApplication.getErrorLog().logError(e);
                }
            }
            otherActionsPanel.add(littleMenuBar);
            Box southBox = new Box(1);
            southBox.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 0));
            southBox.add(otherActionsPanel);
            return southBox;
        }

        private void handleOpenFromURI(EditorKitFactoryPlugin plugin) {
            try {
                URI uri = OpenFromURLPanel.showDialog();
                if (uri != null && ProtegeManager.getInstance().loadAndSetupEditorKitFromURI(plugin, uri)) {
                    ProtegeWelcomeFrame.this.dispose();
                }
            }
            catch (Exception e1) {
                ErrorLogPanel.showErrorDialog(e1);
            }
        }

        private void handleOpenFromRepository(OntologyRepository repository) {
            try {
                OntologyRepositoryEntry entry = OpenFromRepositoryPanel.showDialog(repository);
                if (entry == null) {
                    return;
                }
                if (ProtegeManager.getInstance().loadAndSetupEditorKitFromRepository(repository, entry)) {
                    ProtegeWelcomeFrame.this.dispose();
                }
            }
            catch (Exception e) {
                ErrorLogPanel.showErrorDialog(e);
            }
        }

        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            prefSize.width += 30;
            prefSize.height += 30;
            return prefSize;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            this.background.paintIcon(this, g2, 0, 0);
            Color oldColor = g2.getColor();
            g2.setColor(new Color(255, 255, 255, 240));
            g2.fillRect(0, 0, this.background.getIconWidth(), this.background.getIconHeight());
            g2.setColor(oldColor);
        }

        public void refresh() {
            if (this.recentLinkBox != null) {
                this.box.remove(this.recentLinkBox);
                this.recentLinkBox = null;
            }
            if (RecentEditorKitManager.getInstance().getDescriptors().size() > 0) {
                this.recentLinkBox = new Box(1);
                Color color = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.propertycolor"), Color.GRAY);
                Color classColor = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.classcolor"), Color.GRAY);
                this.recentLinkBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, classColor), " Open recent ", 0, 0, this.getFont().deriveFont(1), color), BorderFactory.createEmptyBorder(20, 20, 20, 20)));
                for (final EditorKitDescriptor desc : RecentEditorKitManager.getInstance().getDescriptors()) {
                    this.recentLinkBox.add(new LinkLabel(desc.getLabel(), new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                if (ProtegeManager.getInstance().openAndSetupRecentEditorKit(desc)) {
                                    ProtegeWelcomeFrame.this.dispose();
                                }
                            }
                            catch (Exception e1) {
                                ErrorLogPanel.showErrorDialog(e1);
                            }
                        }
                    }));
                }
                this.box.add(this.recentLinkBox);
            }
            this.revalidate();
        }
    }
}

